/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import tim.prune.config.Config;
import tim.prune.gui.map.CacheFailure;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.MapTile;
import tim.prune.gui.map.MemTileCacher;
import tim.prune.gui.map.TileConsumer;
import tim.prune.gui.map.tile.DiskCache;
import tim.prune.gui.map.tile.TileBytes;
import tim.prune.gui.map.tile.TileDef;
import tim.prune.gui.map.tile.TileDownloader;
import tim.prune.gui.map.tile.TileManager;
import tim.prune.gui.map.tile.TileWorkerCoordinator;

public class MapTileManager
implements TileManager {
    private final TileConsumer _consumer;
    private MapSource _mapSource = null;
    private final MemTileCacher[] _tempCaches;
    private final DiskCache _diskCache = new DiskCache();
    private final TileWorkerCoordinator _coordinator = new TileWorkerCoordinator(this, TileDownloader::new);
    private boolean _downloadTiles = true;
    private int _numLayers = -1;
    private int _zoom = 0;
    private int _numTileIndices = 1;

    public MapTileManager(TileConsumer tileConsumer) {
        this._consumer = tileConsumer;
        this._tempCaches = new MemTileCacher[2];
        int n = 0;
        while (n < 2) {
            this._tempCaches[n] = new MemTileCacher();
            ++n;
        }
    }

    public void centreMap(int n, int n2, int n3) {
        this.setZoom(n);
        MemTileCacher[] memTileCacherArray = this._tempCaches;
        int n4 = this._tempCaches.length;
        int n5 = 0;
        while (n5 < n4) {
            MemTileCacher memTileCacher = memTileCacherArray[n5];
            memTileCacher.centreMap(n, n2, n3);
            ++n5;
        }
    }

    public void setZoom(int n) {
        this._zoom = n;
        this._numTileIndices = 1 << this._zoom;
    }

    public boolean isOverzoomed() {
        int n;
        int n2 = n = this._mapSource == null ? 0 : this._mapSource.getMaxZoomLevel();
        return this._zoom > n;
    }

    public void enableTileDownloading(boolean bl) {
        this._downloadTiles = bl;
    }

    public void clearMemoryCaches() {
        MemTileCacher[] memTileCacherArray = this._tempCaches;
        int n = this._tempCaches.length;
        int n2 = 0;
        while (n2 < n) {
            MemTileCacher memTileCacher = memTileCacherArray[n2];
            memTileCacher.clearAll();
            ++n2;
        }
    }

    public void setMapSource(int n) {
        this.setMapSource(MapSourceLibrary.getSource(n));
    }

    public void setMapSource(MapSource mapSource) {
        this._mapSource = mapSource;
        if (this._mapSource == null) {
            this._mapSource = MapSourceLibrary.getSource(0);
        }
        this.clearMemoryCaches();
        this._numLayers = this._mapSource.getNumLayers();
    }

    public int getNumLayers() {
        return this._numLayers;
    }

    public Image getTile(int n6, int n7, int n8, boolean bl) {
        if (n8 < 0 || n8 >= this._numTileIndices) {
            return null;
        }
        if (n6 < 0 || n6 >= this._mapSource.getNumLayers()) {
            return null;
        }
        MemTileCacher memTileCacher = this._tempCaches[n6];
        Image image2 = memTileCacher.getTile(n7 = (n7 % this._numTileIndices + this._numTileIndices) % this._numTileIndices, n8);
        if (image2 != null) {
            return image2;
        }
        TileDef tileDef = new TileDef(this._mapSource, n6, n7, n8, this._zoom);
        String string = Config.getConfigString("prune.diskcache");
        this._diskCache.setBasePath(string);
        MapTile mapTile = this._diskCache.getTile(tileDef);
        if (mapTile != null && mapTile.getImage() != null) {
            image2 = mapTile.getImage();
            memTileCacher.setTile(image2, n7, n8, this._zoom);
            image2.getWidth((image, n, n2, n3, n4, n5) -> this.tileUpdate(n));
        }
        boolean bl2 = image2 == null || mapTile.isExpired();
        boolean bl3 = Config.getConfigBoolean("prune.onlinemode");
        if (bl3 && this._downloadTiles && bl && bl2) {
            this._coordinator.triggerDownload(this._mapSource.isDoubleRes(n6) ? tileDef.zoomOut() : tileDef);
        }
        return image2;
    }

    public boolean tileUpdate(int n) {
        boolean bl;
        boolean bl2 = (n & 0x20) > 0;
        boolean bl3 = bl = (n & 0x40) > 0;
        if ((bl2 || bl) && this._consumer != null) {
            this._consumer.tilesUpdated(bl2);
        }
        return !bl2;
    }

    @Override
    public void returnTile(TileDef tileDef, TileBytes tileBytes) {
        if (tileDef == null || tileDef._mapSource == null || tileBytes == null || tileBytes.isEmpty()) {
            return;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(tileBytes.getData());
        image.getWidth((image2, n, n2, n3, n4, n5) -> this.processReturnedTile(tileDef, tileBytes, image, n));
    }

    private boolean processReturnedTile(TileDef tileDef, TileBytes tileBytes, Image image, int n) {
        boolean bl;
        boolean bl2 = (n & 0x20) > 0;
        boolean bl3 = bl = (n & 0xC0) > 0;
        if (!bl2 || bl) {
            return !bl2;
        }
        try {
            int n2 = image.getWidth(null);
            if (n2 == 512) {
                this._mapSource.setDoubleRes(tileDef._layerIdx);
                int n3 = 0;
                while (n3 < 4) {
                    BufferedImage bufferedImage = this.createSubtile(image, n3);
                    this.processDownloadedTile(bufferedImage, tileDef.zoomIn(n3));
                    ++n3;
                }
            } else {
                this.processDownloadedTile(image, tileBytes, tileDef);
            }
        }
        catch (CacheFailure cacheFailure) {
            System.err.println("Cache failure - report to consumer?");
        }
        if (this._consumer != null) {
            this._consumer.tilesUpdated(true);
        }
        return false;
    }

    private BufferedImage createSubtile(Image image, int n) {
        BufferedImage bufferedImage = new BufferedImage(256, 256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n2 = n % 2 * 256;
        int n3 = n / 2 * 256;
        graphics2D.drawImage(image, -n2, -n3, null);
        return bufferedImage;
    }

    private void processDownloadedTile(Image image, TileBytes tileBytes, TileDef tileDef) throws CacheFailure {
        this._tempCaches[tileDef._layerIdx].setTile(image, tileDef._x, tileDef._y, tileDef._zoom);
        this._diskCache.saveTileBytes(tileBytes, tileDef);
    }

    private void processDownloadedTile(BufferedImage bufferedImage, TileDef tileDef) throws CacheFailure {
        this._tempCaches[tileDef._layerIdx].setTile(bufferedImage, tileDef._x, tileDef._y, tileDef._zoom);
        this._diskCache.saveTileImage(bufferedImage, tileDef);
    }
}

