/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import naga.NIOService;
import naga.NIOUtils;

class SocketReader {
    private final NIOService m_nioService;
    private ByteBuffer m_previousBytes;
    private long m_bytesRead;

    SocketReader(NIOService nIOService) {
        this.m_nioService = nIOService;
        this.m_bytesRead = 0L;
    }

    public int read(SocketChannel socketChannel) throws IOException {
        int n;
        ByteBuffer byteBuffer = this.getBuffer();
        byteBuffer.clear();
        if (this.m_previousBytes != null) {
            byteBuffer.position(this.m_previousBytes.remaining());
        }
        if ((n = socketChannel.read(byteBuffer)) < 0) {
            throw new EOFException("Buffer read -1");
        }
        if (!byteBuffer.hasRemaining()) {
            throw new BufferOverflowException();
        }
        this.m_bytesRead += (long)n;
        if (n == 0) {
            return 0;
        }
        if (this.m_previousBytes != null) {
            int n2 = byteBuffer.position();
            byteBuffer.position(0);
            byteBuffer.put(this.m_previousBytes);
            byteBuffer.position(n2);
            this.m_previousBytes = null;
        }
        byteBuffer.flip();
        return n;
    }

    public void compact() {
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer.remaining() > 0) {
            this.m_previousBytes = NIOUtils.copy(byteBuffer);
        }
    }

    public long getBytesRead() {
        return this.m_bytesRead;
    }

    public ByteBuffer getBuffer() {
        return this.m_nioService.getSharedBuffer();
    }
}

