/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AmdSevSnpSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateCpuOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateCpuOptions> {
    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CoreCount").getter(LaunchTemplateCpuOptions.getter(LaunchTemplateCpuOptions::coreCount)).setter(LaunchTemplateCpuOptions.setter(Builder::coreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount").unmarshallLocationName("coreCount").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(LaunchTemplateCpuOptions.getter(LaunchTemplateCpuOptions::threadsPerCore)).setter(LaunchTemplateCpuOptions.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").unmarshallLocationName("threadsPerCore").build()}).build();
    private static final SdkField<String> AMD_SEV_SNP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmdSevSnp").getter(LaunchTemplateCpuOptions.getter(LaunchTemplateCpuOptions::amdSevSnpAsString)).setter(LaunchTemplateCpuOptions.setter(Builder::amdSevSnp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmdSevSnp").unmarshallLocationName("amdSevSnp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_COUNT_FIELD, THREADS_PER_CORE_FIELD, AMD_SEV_SNP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplateCpuOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer coreCount;
    private final Integer threadsPerCore;
    private final String amdSevSnp;

    private LaunchTemplateCpuOptions(BuilderImpl builder) {
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
        this.amdSevSnp = builder.amdSevSnp;
    }

    public final Integer coreCount() {
        return this.coreCount;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public final AmdSevSnpSpecification amdSevSnp() {
        return AmdSevSnpSpecification.fromValue(this.amdSevSnp);
    }

    public final String amdSevSnpAsString() {
        return this.amdSevSnp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.amdSevSnpAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateCpuOptions)) {
            return false;
        }
        LaunchTemplateCpuOptions other = (LaunchTemplateCpuOptions)obj;
        return Objects.equals(this.coreCount(), other.coreCount()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore()) && Objects.equals(this.amdSevSnpAsString(), other.amdSevSnpAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateCpuOptions").add("CoreCount", (Object)this.coreCount()).add("ThreadsPerCore", (Object)this.threadsPerCore()).add("AmdSevSnp", (Object)this.amdSevSnpAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreCount": {
                return Optional.ofNullable(clazz.cast(this.coreCount()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
            case "AmdSevSnp": {
                return Optional.ofNullable(clazz.cast(this.amdSevSnpAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CoreCount", CORE_COUNT_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        map.put("AmdSevSnp", AMD_SEV_SNP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateCpuOptions, T> g) {
        return obj -> g.apply((LaunchTemplateCpuOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer coreCount;
        private Integer threadsPerCore;
        private String amdSevSnp;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateCpuOptions model) {
            this.coreCount(model.coreCount);
            this.threadsPerCore(model.threadsPerCore);
            this.amdSevSnp(model.amdSevSnp);
        }

        public final Integer getCoreCount() {
            return this.coreCount;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final String getAmdSevSnp() {
            return this.amdSevSnp;
        }

        public final void setAmdSevSnp(String amdSevSnp) {
            this.amdSevSnp = amdSevSnp;
        }

        @Override
        public final Builder amdSevSnp(String amdSevSnp) {
            this.amdSevSnp = amdSevSnp;
            return this;
        }

        @Override
        public final Builder amdSevSnp(AmdSevSnpSpecification amdSevSnp) {
            this.amdSevSnp(amdSevSnp == null ? null : amdSevSnp.toString());
            return this;
        }

        public LaunchTemplateCpuOptions build() {
            return new LaunchTemplateCpuOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateCpuOptions> {
        public Builder coreCount(Integer var1);

        public Builder threadsPerCore(Integer var1);

        public Builder amdSevSnp(String var1);

        public Builder amdSevSnp(AmdSevSnpSpecification var1);
    }
}

