/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class IntegerParam
extends Param<Integer, Domain> {
    IntegerParam(Domain domain, Integer value, Integer min, Integer max) {
        super(domain, value);
        this.checkRange(min, max);
    }

    private void checkRange(Integer min, Integer max) {
        if (this.value == null) {
            return;
        }
        if (min != null && (Integer)this.value < min) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Integer)this.value) + " < " + ((Domain)this.domain).toString(min));
        }
        if (max != null && (Integer)this.value > max) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Integer)this.value) + " > " + ((Domain)this.domain).toString(max));
        }
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Integer)this.getValue());
    }

    @Override
    public String getValueString() {
        return ((Domain)this.domain).toString((Integer)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Integer> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | int in radix " + this.radix + ">";
        }

        @Override
        Integer parse(String str) {
            try {
                return "null".equals(str) || str == null ? null : Integer.valueOf(Integer.parseInt(str, this.radix));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as a radix-" + this.radix + " integer.", e);
            }
        }

        String toString(Integer n) {
            return n == null ? "null" : Integer.toString(n, this.radix);
        }
    }
}

