"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAccount = void 0;
const electron_1 = require("electron");
const fs = __importStar(require("fs-extra"));
const lodash_1 = require("lodash");
const path = __importStar(require("path"));
const commons_1 = require("@wireapp/commons");
const getLogger_1 = require("../logging/getLogger");
const USER_DATA_DIR = electron_1.app.getPath('userData');
const LOG_DIR = path.join(USER_DATA_DIR, 'logs');
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
const clearStorage = (session) => __awaiter(void 0, void 0, void 0, function* () {
    yield session.clearStorageData();
    yield session.clearCache();
    session.flushStorageData();
});
function deleteAccount(id, accountId, partitionId) {
    return __awaiter(this, void 0, void 0, function* () {
        const truncatedId = (0, lodash_1.truncate)(accountId, { length: 5 });
        try {
            const webviewWebContent = electron_1.webContents.fromId(id);
            if (!webviewWebContent) {
                throw new Error(`Unable to find webview content id "${id}"`);
            }
            if (!webviewWebContent.hostWebContents) {
                throw new Error('Only a webview can have its storage wiped');
            }
            logger.log(`Deleting session data for account "${truncatedId}"...`);
            yield clearStorage(webviewWebContent.session);
            logger.log(`Deleted session data for account "${truncatedId}".`);
        }
        catch (error) {
            logger.error(`Failed to delete session data for account "${truncatedId}", reason: "${error.message}".`);
        }
        if (partitionId) {
            try {
                if (!commons_1.ValidationUtil.isUUIDv4(partitionId)) {
                    throw new Error('Partition is not an UUID');
                }
                const partitionDir = path.join(USER_DATA_DIR, 'Partitions', partitionId);
                yield fs.remove(partitionDir);
                logger.log(`Deleted partition "${partitionId}" for account "${truncatedId}".`);
            }
            catch (error) {
                logger.log(`Unable to delete partition "${partitionId}" for account "${truncatedId}", reason: "${error.message}".`);
            }
        }
        try {
            if (!commons_1.ValidationUtil.isUUIDv4(accountId)) {
                throw new Error('Account is not an UUID');
            }
            const sessionFolder = path.join(LOG_DIR, accountId);
            yield fs.remove(sessionFolder);
            logger.log(`Deleted logs folder for account "${truncatedId}".`);
        }
        catch (error) {
            logger.error(`Failed to delete logs folder for account "${truncatedId}", reason: "${error.message}".`);
        }
    });
}
exports.deleteAccount = deleteAccount;
//# sourceMappingURL=LocalAccountDeletion.js.map