import QtQuick 2.15
import org.manjaro.calamares.desktop 1.0

Row {
    id: sponsoredBy

    spacing: 5

    Text {
        height: 30
        font.family: "Montserrat"
        color: "white"
        text: qsTr("Brought to you by")
        verticalAlignment: Text.AlignVCenter
    }

    Image {
        source: "sponsor.svg"
        onStatusChanged: {
            if ((status == Image.Error))
                sponsoredBy.visible = false;

        }

        sourceSize {
            height: 30
        }

        MouseArea {
            anchors.fill: parent
            cursorShape: Qt.PointingHandCursor
            onClicked: {
                DesktopUtils.openUrl("https://www.shells.com/l/en-US/manjaro");
            }
        }

    }

}
