/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.time.Instant;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.soap.wssecurity.AttributedDateTime;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObject;

public class AttributedDateTimeImpl
extends AbstractWSSecurityObject
implements AttributedDateTime {
    private Instant dateTimeValue;
    private String stringValue;
    private String id;
    private AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);

    public AttributedDateTimeImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public Instant getDateTime() {
        return this.dateTimeValue;
    }

    public void setDateTime(Instant newDateTime) {
        this.dateTimeValue = newDateTime;
        this.stringValue = this.prepareForAssignment(this.stringValue, DOMTypeSupport.instantToString((Instant)this.dateTimeValue));
    }

    public String getValue() {
        return this.stringValue;
    }

    public void setValue(String newValue) {
        this.dateTimeValue = DOMTypeSupport.stringToInstant((String)newValue);
        this.stringValue = this.prepareForAssignment(this.stringValue, newValue);
    }

    public String getWSUId() {
        return this.id;
    }

    public void setWSUId(String newId) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newId);
        this.registerOwnID(oldID, this.id);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.id != null);
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }
}

