import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DescribeStackResourcesInput,
  DescribeStackResourcesOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DescribeStackResourcesCommandInput
  extends DescribeStackResourcesInput {}
export interface DescribeStackResourcesCommandOutput
  extends DescribeStackResourcesOutput,
    __MetadataBearer {}
export declare class DescribeStackResourcesCommand extends $Command<
  DescribeStackResourcesCommandInput,
  DescribeStackResourcesCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DescribeStackResourcesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStackResourcesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStackResourcesCommandInput,
    DescribeStackResourcesCommandOutput
  >;
  private serialize;
  private deserialize;
}
