/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.db;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.utils.CommonUtils;

public class InternalProxyConnection
implements Connection {
    @NotNull
    private final Connection connection;
    @NotNull
    private final InternalDatabaseConfig config;

    public InternalProxyConnection(@NotNull Connection connection, @NotNull InternalDatabaseConfig config) {
        this.connection = connection;
        this.config = config;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new StatementProxy(this.connection.createStatement());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(this.normalizeTableNames(sql));
    }

    private String normalizeTableNames(@NotNull String sql) {
        return CommonUtils.normalizeTableNames((String)sql, (String)this.config.getSchema());
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(this.normalizeTableNames(sql));
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(this.normalizeTableNames(sql));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatementProxy(this.connection.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(this.normalizeTableNames(sql), resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(this.normalizeTableNames(sql), resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatementProxy(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(this.normalizeTableNames(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(this.normalizeTableNames(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(this.normalizeTableNames(sql), autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(this.normalizeTableNames(sql), columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(this.normalizeTableNames(sql), columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    private class StatementProxy
    implements Statement {
        @NotNull
        private final Statement statement;

        public StatementProxy(Statement statement) {
            this.statement = statement;
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            return this.statement.executeQuery(InternalProxyConnection.this.normalizeTableNames(sql));
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            return this.statement.executeUpdate(InternalProxyConnection.this.normalizeTableNames(sql));
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            return this.statement.execute(InternalProxyConnection.this.normalizeTableNames(sql));
        }

        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            return this.statement.executeUpdate(InternalProxyConnection.this.normalizeTableNames(sql), autoGeneratedKeys);
        }

        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            return this.statement.executeUpdate(InternalProxyConnection.this.normalizeTableNames(sql), columnIndexes);
        }

        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            return this.statement.executeUpdate(InternalProxyConnection.this.normalizeTableNames(sql), columnNames);
        }

        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            return this.statement.execute(InternalProxyConnection.this.normalizeTableNames(sql), autoGeneratedKeys);
        }

        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            return this.statement.execute(InternalProxyConnection.this.normalizeTableNames(sql), columnIndexes);
        }

        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            return this.statement.execute(InternalProxyConnection.this.normalizeTableNames(sql), columnNames);
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            this.statement.addBatch(InternalProxyConnection.this.normalizeTableNames(sql));
        }

        @Override
        public int[] executeBatch() throws SQLException {
            return this.statement.executeBatch();
        }

        @Override
        public void close() throws SQLException {
            this.statement.close();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.statement.getMaxFieldSize();
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            this.statement.setMaxFieldSize(max);
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.statement.getMaxRows();
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            this.statement.setMaxRows(max);
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.statement.setEscapeProcessing(enable);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.statement.getQueryTimeout();
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            this.statement.setQueryTimeout(seconds);
        }

        @Override
        public void cancel() throws SQLException {
            this.statement.cancel();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.statement.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.statement.clearWarnings();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            this.statement.setCursorName(name);
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.statement.getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.statement.getUpdateCount();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.statement.getMoreResults();
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.statement.setFetchDirection(direction);
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.statement.getFetchDirection();
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.statement.setFetchSize(rows);
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.statement.getFetchSize();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.statement.getResultSetConcurrency();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.statement.getResultSetType();
        }

        @Override
        public void clearBatch() throws SQLException {
            this.statement.clearBatch();
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.statement.getConnection();
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return this.statement.getMoreResults(current);
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.statement.getGeneratedKeys();
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.statement.getResultSetHoldability();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.statement.isClosed();
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            this.statement.setPoolable(poolable);
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.statement.isPoolable();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            this.statement.closeOnCompletion();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return this.statement.isCloseOnCompletion();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.statement.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.statement.isWrapperFor(iface);
        }
    }
}

