﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ds/DirectoryServiceRequest.h>
#include <aws/ds/DirectoryService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DirectoryService {
namespace Model {

/**
 */
class CancelSchemaExtensionRequest : public DirectoryServiceRequest {
 public:
  AWS_DIRECTORYSERVICE_API CancelSchemaExtensionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CancelSchemaExtension"; }

  AWS_DIRECTORYSERVICE_API Aws::String SerializePayload() const override;

  AWS_DIRECTORYSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the directory whose schema extension will be canceled.</p>
   */
  inline const Aws::String& GetDirectoryId() const { return m_directoryId; }
  inline bool DirectoryIdHasBeenSet() const { return m_directoryIdHasBeenSet; }
  template <typename DirectoryIdT = Aws::String>
  void SetDirectoryId(DirectoryIdT&& value) {
    m_directoryIdHasBeenSet = true;
    m_directoryId = std::forward<DirectoryIdT>(value);
  }
  template <typename DirectoryIdT = Aws::String>
  CancelSchemaExtensionRequest& WithDirectoryId(DirectoryIdT&& value) {
    SetDirectoryId(std::forward<DirectoryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the schema extension that will be canceled.</p>
   */
  inline const Aws::String& GetSchemaExtensionId() const { return m_schemaExtensionId; }
  inline bool SchemaExtensionIdHasBeenSet() const { return m_schemaExtensionIdHasBeenSet; }
  template <typename SchemaExtensionIdT = Aws::String>
  void SetSchemaExtensionId(SchemaExtensionIdT&& value) {
    m_schemaExtensionIdHasBeenSet = true;
    m_schemaExtensionId = std::forward<SchemaExtensionIdT>(value);
  }
  template <typename SchemaExtensionIdT = Aws::String>
  CancelSchemaExtensionRequest& WithSchemaExtensionId(SchemaExtensionIdT&& value) {
    SetSchemaExtensionId(std::forward<SchemaExtensionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_directoryId;
  bool m_directoryIdHasBeenSet = false;

  Aws::String m_schemaExtensionId;
  bool m_schemaExtensionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectoryService
}  // namespace Aws
