/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.ui.editors.text.handlers.AbstractTextHandler;

public abstract class AbstractCommentHandler
extends AbstractTextHandler {
    protected static final Log log = Log.getLog(AbstractCommentHandler.class);

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        BaseTextEditor textEditor = BaseTextEditor.getTextEditor(HandlerUtil.getActiveEditor((ExecutionEvent)event));
        if (textEditor != null) {
            ITextSelection textSelection;
            ISelection selection;
            ISelectionProvider provider;
            ICommentsSupport commentsSupport = textEditor.getCommentsSupport();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            if (document != null && commentsSupport != null && (provider = textEditor.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof ITextSelection && !(textSelection = (ITextSelection)selection).isEmpty()) {
                try {
                    this.processAction(textEditor.getSelectionProvider(), commentsSupport, document, textSelection);
                }
                catch (BadLocationException e) {
                    log.warn((Object)e);
                }
            }
        }
        return null;
    }

    protected abstract void processAction(ISelectionProvider var1, ICommentsSupport var2, IDocument var3, ITextSelection var4) throws BadLocationException;
}

