/*
 * Decompiled with CFR 0.152.
 */
package javax.smartcardio;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class ATR
implements Serializable {
    private static final long serialVersionUID = 6695383790847736493L;
    private byte[] atr;
    private transient int startHistorical;
    private transient int nHistorical;

    public ATR(byte[] byArray) {
        this.atr = (byte[])byArray.clone();
        this.parse();
    }

    private void parse() {
        if (this.atr.length < 2) {
            return;
        }
        if (this.atr[0] != 59 && this.atr[0] != 63) {
            return;
        }
        int n = (this.atr[1] & 0xF0) >> 4;
        int n2 = this.atr[1] & 0xF;
        int n3 = 2;
        while (n != 0 && n3 < this.atr.length) {
            if ((n & 1) != 0) {
                ++n3;
            }
            if ((n & 2) != 0) {
                ++n3;
            }
            if ((n & 4) != 0) {
                ++n3;
            }
            if ((n & 8) != 0) {
                if (n3 >= this.atr.length) {
                    return;
                }
                n = (this.atr[n3++] & 0xF0) >> 4;
                continue;
            }
            n = 0;
        }
        int n4 = n3 + n2;
        if (n4 == this.atr.length || n4 == this.atr.length - 1) {
            this.startHistorical = n3;
            this.nHistorical = n2;
        }
    }

    public byte[] getBytes() {
        return (byte[])this.atr.clone();
    }

    public byte[] getHistoricalBytes() {
        byte[] byArray = new byte[this.nHistorical];
        System.arraycopy(this.atr, this.startHistorical, byArray, 0, this.nHistorical);
        return byArray;
    }

    public String toString() {
        return "ATR: " + this.atr.length + " bytes";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ATR)) {
            return false;
        }
        ATR aTR = (ATR)object;
        return Arrays.equals(this.atr, aTR.atr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atr);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.atr = (byte[])objectInputStream.readUnshared();
        this.parse();
    }
}

