/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import net.sf.juife.InformationDialog;
import net.sf.juife.JuifeUtils;
import net.sf.juife.NavigationPage;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.event.MidiDeviceEvent;
import org.jsampler.event.MidiDeviceListener;
import org.jsampler.event.ParameterEvent;
import org.jsampler.event.ParameterListener;
import org.jsampler.view.NumberCellEditor;
import org.jsampler.view.ParameterTable;
import org.jsampler.view.classic.A4n;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.MidiDevicesTableModel;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.Parameter;

public class MidiDevicesPage
extends NavigationPage {
    private final Action duplicateMidiDevice = new DuplicateMidiDevice();
    private final Action removeMidiDevice = new RemoveMidiDevice();
    private final Action midiDeviceProps = new MidiDeviceProps();
    private final ToolbarButton btnNewDevice = new ToolbarButton(A4n.addMidiDevice);
    private final ToolbarButton btnDuplicateDevice = new ToolbarButton(this.duplicateMidiDevice);
    private final ToolbarButton btnRemoveDevice = new ToolbarButton(this.removeMidiDevice);
    private final ToolbarButton btnDeviceProps = new ToolbarButton(this.midiDeviceProps);
    private final JTable devicesTable = new JTable(new MidiDevicesTableModel());
    private final JLabel lPorts = new JLabel(ClassicI18n.i18n.getLabel("MidiDevicesPage.lPorts"));
    private final JComboBox cbPorts = new JComboBox();
    ParameterTable portParamTable = new ParameterTable();
    private final Handler handler = new Handler();

    public MidiDevicesPage() {
        this.setTitle(ClassicI18n.i18n.getLabel("MidiDevicesPage.title"));
        this.cbPorts.setEnabled(false);
        TableColumn tableColumn = this.devicesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(tableColumn.getMinWidth());
        NumberCellEditor numberCellEditor = new NumberCellEditor();
        numberCellEditor.setMinimum(Integer.valueOf(0));
        numberCellEditor.setMaximum(Integer.valueOf(255));
        tableColumn = this.devicesTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(numberCellEditor);
        this.setLayout(new BoxLayout(this, 1));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMaximumSize(new Dimension(Short.MAX_VALUE, jToolBar.getPreferredSize().height));
        jToolBar.setFloatable(false);
        jToolBar.setAlignmentX(1.0f);
        jToolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        jToolBar.add(new JLabel(Res.iconMidi24));
        jToolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        jToolBar.add(this.btnNewDevice);
        jToolBar.add(this.btnDuplicateDevice);
        jToolBar.add(this.btnRemoveDevice);
        jToolBar.addSeparator();
        jToolBar.add(this.btnDeviceProps);
        this.add(jToolBar);
        JSplitPane jSplitPane = new JSplitPane(0);
        this.devicesTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.devicesTable);
        Dimension dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        jSplitPane.setTopComponent(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lPorts);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.cbPorts);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jScrollPane = new JScrollPane(this.portParamTable);
        dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
        jScrollPane.setPreferredSize(dimension);
        jPanel.add(jScrollPane);
        jPanel2.add(jPanel);
        jPanel2.setBorder(BorderFactory.createTitledBorder(ClassicI18n.i18n.getLabel("MidiDevicesPage.ports")));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jPanel2);
        jSplitPane.setBottomComponent(jPanel);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jSplitPane.setAlignmentX(1.0f);
        jSplitPane.setDividerSize(3);
        jSplitPane.setContinuousLayout(true);
        this.add(jSplitPane);
        jSplitPane.setDividerLocation(150);
        this.cbPorts.addActionListener(this.getHandler());
        this.devicesTable.getSelectionModel().addListSelectionListener(this.getHandler());
        this.portParamTable.getModel().addParameterListener(this.getHandler());
    }

    private MidiDeviceModel getSelectedMidiDeviceModel() {
        ListSelectionModel listSelectionModel = this.devicesTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return ((MidiDevicesTableModel)this.devicesTable.getModel()).getMidiDeviceModel(listSelectionModel.getMinSelectionIndex());
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class DevicePropsDlg
    extends InformationDialog {
        DevicePropsDlg() {
            super((Frame)CC.getMainFrame(), ClassicI18n.i18n.getLabel("MidiDevicesPage.DevicePropsDlg"));
            MidiDeviceModel midiDeviceModel = MidiDevicesPage.this.getSelectedMidiDeviceModel();
            ParameterTable parameterTable = new ParameterTable();
            parameterTable.getModel().setParameters(midiDeviceModel.getDeviceInfo().getAdditionalParameters());
            JScrollPane jScrollPane = new JScrollPane(parameterTable);
            jScrollPane.setPreferredSize(JuifeUtils.getUnionSize(jScrollPane.getMinimumSize(), new Dimension(200, 200)));
            this.setMainPane(jScrollPane);
        }
    }

    private class MidiDeviceProps
    extends AbstractAction {
        MidiDeviceProps() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttMidiDeviceProps"));
            this.putValue("SmallIcon", Res.iconProps16);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new DevicePropsDlg().setVisible(true);
        }
    }

    private class RemoveMidiDevice
    extends AbstractAction {
        RemoveMidiDevice() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttRemoveMidiDevice"));
            this.putValue("SmallIcon", Res.iconDelete16);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiDeviceModel midiDeviceModel = MidiDevicesPage.this.getSelectedMidiDeviceModel();
            if (midiDeviceModel == null) {
                CC.getLogger().warning("No selected MIDI device to remove!");
                return;
            }
            CC.getSamplerModel().removeBackendMidiDevice(midiDeviceModel.getDeviceId());
        }
    }

    private class DuplicateMidiDevice
    extends AbstractAction {
        DuplicateMidiDevice() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttDuplicateMidiDevice"));
            this.putValue("SmallIcon", Res.iconCopy16);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MidiDevicesPage.this.devicesTable.getSelectedRow();
            if (n < 0) {
                CC.getLogger().info("There's no selected MIDI device to duplicate");
                return;
            }
            MidiDeviceModel midiDeviceModel = ((MidiDevicesTableModel)MidiDevicesPage.this.devicesTable.getModel()).getMidiDeviceModel(n);
            String string = midiDeviceModel.getDeviceInfo().getDriverName();
            Parameter[] parameterArray = midiDeviceModel.getDeviceInfo().getAdditionalParameters();
            CC.getSamplerModel().addBackendMidiDevice(string, parameterArray);
        }
    }

    private class Handler
    implements ActionListener,
    ListSelectionListener,
    MidiDeviceListener,
    ParameterListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = MidiDevicesPage.this.cbPorts.getSelectedItem();
            if (object == null) {
                MidiDevicesPage.this.portParamTable.getModel().setParameters(new Parameter[0]);
                return;
            }
            MidiPort midiPort = (MidiPort)object;
            MidiDevicesPage.this.portParamTable.getModel().setParameters(midiPort.getAllParameters());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            for (MidiDeviceModel midiDeviceModel : CC.getSamplerModel().getMidiDevices()) {
                midiDeviceModel.removeMidiDeviceListener(this);
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                MidiDevicesPage.this.duplicateMidiDevice.setEnabled(false);
                MidiDevicesPage.this.removeMidiDevice.setEnabled(false);
                MidiDevicesPage.this.midiDeviceProps.setEnabled(false);
                MidiDevicesPage.this.cbPorts.removeAllItems();
                MidiDevicesPage.this.cbPorts.setEnabled(false);
                return;
            }
            MidiDevicesPage.this.duplicateMidiDevice.setEnabled(true);
            MidiDevicesPage.this.removeMidiDevice.setEnabled(true);
            MidiDevicesPage.this.midiDeviceProps.setEnabled(true);
            MidiDeviceModel midiDeviceModel = ((MidiDevicesTableModel)MidiDevicesPage.this.devicesTable.getModel()).getMidiDeviceModel(listSelectionModel.getMinSelectionIndex());
            MidiDevicesPage.this.cbPorts.removeAllItems();
            for (MidiPort midiPort : midiDeviceModel.getDeviceInfo().getMidiPorts()) {
                MidiDevicesPage.this.cbPorts.addItem(midiPort);
            }
            MidiDevicesPage.this.cbPorts.setEnabled(true);
            midiDeviceModel.addMidiDeviceListener(this);
        }

        @Override
        public void settingsChanged(MidiDeviceEvent midiDeviceEvent) {
            MidiInputDevice midiInputDevice = midiDeviceEvent.getMidiDeviceModel().getDeviceInfo();
            int n = MidiDevicesPage.this.cbPorts.getSelectedIndex();
            MidiDevicesPage.this.cbPorts.removeAllItems();
            for (MidiPort midiPort : midiInputDevice.getMidiPorts()) {
                MidiDevicesPage.this.cbPorts.addItem(midiPort);
            }
            if (n >= MidiDevicesPage.this.cbPorts.getModel().getSize()) {
                n = 0;
            }
            if (MidiDevicesPage.this.cbPorts.getModel().getSize() > 0) {
                MidiDevicesPage.this.cbPorts.setSelectedIndex(n);
            }
        }

        @Override
        public void parameterChanged(ParameterEvent parameterEvent) {
            MidiDeviceModel midiDeviceModel = MidiDevicesPage.this.getSelectedMidiDeviceModel();
            if (midiDeviceModel == null) {
                CC.getLogger().warning("Unexpected null MidiDeviceModel!");
                return;
            }
            int n = MidiDevicesPage.this.cbPorts.getSelectedIndex();
            if (n == -1) {
                CC.getLogger().warning("There is no MIDI port selected!");
                return;
            }
            midiDeviceModel.setBackendPortParameter(n, parameterEvent.getParameter());
        }
    }
}

