/*
 * Decompiled with CFR 0.152.
 */
package es.blackleg.jlibnotify.core;

import com.sun.jna.Pointer;
import es.blackleg.jlibnotify.JLibnotify;
import es.blackleg.jlibnotify.JLibnotifyNotification;
import es.blackleg.jlibnotify.ServerInfo;
import es.blackleg.jlibnotify.core.BasicServerInfo;
import es.blackleg.jlibnotify.core.DefaultJLibnotifyNotification;
import es.blackleg.jlibnotify.core.ServerCapabilitiesReader;
import es.blackleg.jlibnotify.exception.JLibnotifyInitException;
import es.blackleg.jlibnotify.jna.GBoolean;
import es.blackleg.jlibnotify.jna.NativeLibnotify;
import java.util.Collection;

public class DefaultJLibnotify
implements JLibnotify {
    private final NativeLibnotify nativeLibnotify;
    private final ServerCapabilitiesReader serverCapabilitiesReader;

    public DefaultJLibnotify(NativeLibnotify libnotify, ServerCapabilitiesReader serverCapabilitiesReader) {
        this.nativeLibnotify = libnotify;
        this.serverCapabilitiesReader = serverCapabilitiesReader;
    }

    @Override
    public void init(String appName) throws JLibnotifyInitException {
        if (this.nativeLibnotify.notify_init(appName) == GBoolean.FALSE) {
            throw new JLibnotifyInitException(String.format("Unable to init %s app", appName));
        }
    }

    @Override
    public boolean isInitted() {
        return this.nativeLibnotify.notify_is_initted() == GBoolean.TRUE;
    }

    @Override
    public void unInit() {
        this.nativeLibnotify.notify_uninit();
    }

    @Override
    public String getAppName() {
        return this.nativeLibnotify.notify_get_app_name();
    }

    @Override
    public void setAppName(String appName) {
        this.nativeLibnotify.notify_set_app_name(appName);
    }

    @Override
    public ServerInfo getServerInfo() {
        String[] name = new String[1];
        String[] vendor = new String[1];
        String[] version = new String[1];
        String[] specVersion = new String[1];
        if (this.nativeLibnotify.notify_get_server_info(name, vendor, version, specVersion) == GBoolean.FALSE) {
            throw new RuntimeException("Error when get server info");
        }
        return new BasicServerInfo(name[0], vendor[0], version[0], specVersion[0]);
    }

    @Override
    public Collection<String> getServerCapabilities() {
        return this.serverCapabilitiesReader.getServerCapabilitiesFromPointer(this.nativeLibnotify.notify_get_server_caps());
    }

    @Override
    public JLibnotifyNotification createNotification(String summary, String body, String icon) {
        Pointer pointer = this.nativeLibnotify.notify_notification_new(summary, body, icon);
        return new DefaultJLibnotifyNotification(pointer, this.nativeLibnotify);
    }
}

