/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public class TrustedNamesCriterion
implements Criterion {
    @Nonnull
    private Set<String> trustedNames;

    public TrustedNamesCriterion(@Nullable Set<String> names) {
        this.trustedNames = this.processNames(names);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getTrustedNames() {
        return this.trustedNames;
    }

    public void setTrustedNames(@Nullable Set<String> names) {
        this.trustedNames = this.processNames(names);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TrustedNamesCriterion [names=");
        builder.append(this.trustedNames);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.trustedNames.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TrustedNamesCriterion) {
            TrustedNamesCriterion other = (TrustedNamesCriterion)obj;
            return this.trustedNames.equals(other.trustedNames);
        }
        return false;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    private Set<String> processNames(@Nullable Set<String> names) {
        if (names != null) {
            return CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(names));
        }
        return CollectionSupport.emptySet();
    }
}

