﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/model/FunctionConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppSync {
namespace Model {
class ListFunctionsResult {
 public:
  AWS_APPSYNC_API ListFunctionsResult() = default;
  AWS_APPSYNC_API ListFunctionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPSYNC_API ListFunctionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of <code>Function</code> objects.</p>
   */
  inline const Aws::Vector<FunctionConfiguration>& GetFunctions() const { return m_functions; }
  template <typename FunctionsT = Aws::Vector<FunctionConfiguration>>
  void SetFunctions(FunctionsT&& value) {
    m_functionsHasBeenSet = true;
    m_functions = std::forward<FunctionsT>(value);
  }
  template <typename FunctionsT = Aws::Vector<FunctionConfiguration>>
  ListFunctionsResult& WithFunctions(FunctionsT&& value) {
    SetFunctions(std::forward<FunctionsT>(value));
    return *this;
  }
  template <typename FunctionsT = FunctionConfiguration>
  ListFunctionsResult& AddFunctions(FunctionsT&& value) {
    m_functionsHasBeenSet = true;
    m_functions.emplace_back(std::forward<FunctionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An identifier that was returned from the previous call to this operation,
   * which you can use to return the next set of items in the list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListFunctionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListFunctionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<FunctionConfiguration> m_functions;
  bool m_functionsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppSync
}  // namespace Aws
