/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

public enum DataExporterArrayFormat {
    SQUARE_BRACKETS('[', ']'),
    CURLY_BRACKETS('{', '}'),
    BRACKETS('(', ')');

    private char prefix;
    private char suffix;

    private DataExporterArrayFormat(char prefix, char suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static DataExporterArrayFormat getArrayFormat(String bracketPair) {
        DataExporterArrayFormat[] dataExporterArrayFormatArray = DataExporterArrayFormat.values();
        int n = dataExporterArrayFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataExporterArrayFormat df = dataExporterArrayFormatArray[n2];
            if ((bracketPair = bracketPair.trim()).charAt(0) == df.prefix && bracketPair.charAt(bracketPair.length() - 1) == df.suffix) {
                return df;
            }
            ++n2;
        }
        throw new IllegalStateException("No suitable DataExporterArrayFormat found");
    }

    public static DataExporterArrayFormat getArrayFormatOnPrefix(char prefix) {
        DataExporterArrayFormat[] dataExporterArrayFormatArray = DataExporterArrayFormat.values();
        int n = dataExporterArrayFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataExporterArrayFormat df = dataExporterArrayFormatArray[n2];
            if (prefix == df.prefix) {
                return df;
            }
            ++n2;
        }
        return CURLY_BRACKETS;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public char getSuffix() {
        return this.suffix;
    }
}

