require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_EXT2FS_EXT2FS_H)) {
    eval 'sub _EXT2FS_EXT2FS_H () {1;}' unless defined(&_EXT2FS_EXT2FS_H);
    if(defined(&__GNUC__)) {
	eval 'sub EXT2FS_ATTR {
	    my($x) = @_;
    	    eval q( &__attribute__($x));
	}' unless defined(&EXT2FS_ATTR);
    } else {
	eval 'sub EXT2FS_ATTR {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&EXT2FS_ATTR);
    }
    if(defined(&__cplusplus)) {
    }
    if((!defined( &__GNUC__)  && !defined( &__WATCOMC__))) {
	eval 'sub NO_INLINE_FUNCS () {1;}' unless defined(&NO_INLINE_FUNCS);
    }
    if(defined( &ENABLE_SWAPFS) || defined( &WORDS_BIGENDIAN)) {
	eval 'sub EXT2FS_ENABLE_SWAPFS () {1;}' unless defined(&EXT2FS_ENABLE_SWAPFS);
    }
    eval 'sub SUPERBLOCK_OFFSET () {1024;}' unless defined(&SUPERBLOCK_OFFSET);
    eval 'sub SUPERBLOCK_SIZE () {1024;}' unless defined(&SUPERBLOCK_SIZE);
    eval 'sub EXT2_LIB_CURRENT_REV () { &EXT2_DYNAMIC_REV;}' unless defined(&EXT2_LIB_CURRENT_REV);
    if(defined(&HAVE_SYS_TYPES_H)) {
	require 'sys/types.ph';
    }
    require 'stdio.ph';
    require 'stdlib.ph';
    if((defined(&EXT2_FLAT_INCLUDES) ? &EXT2_FLAT_INCLUDES : undef)) {
	require 'e2_types.ph';
	require 'ext2_fs.ph';
    } else {
	require 'ext2fs/ext2_types.ph';
	require 'ext2fs/ext2_fs.ph';
    }
    if((defined(&EXT2_FLAT_INCLUDES) ? &EXT2_FLAT_INCLUDES : undef)) {
	require 'com_err.ph';
	require 'ext2_io.ph';
	require 'ext2_err.ph';
    } else {
	require 'et/com_err.ph';
	require 'ext2fs/ext2_io.ph';
	require 'ext2fs/ext2_err.ph';
    }
    if(defined(&_MSC_VER)) {
	eval 'sub EXT2_QSORT_TYPE () {\'int\'  &__cdecl;}' unless defined(&EXT2_QSORT_TYPE);
    } else {
	eval 'sub EXT2_QSORT_TYPE () {\'int\';}' unless defined(&EXT2_QSORT_TYPE);
    }
    eval 'sub EXT2FS_MARK_ERROR () {0;}' unless defined(&EXT2FS_MARK_ERROR);
    eval 'sub EXT2FS_UNMARK_ERROR () {1;}' unless defined(&EXT2FS_UNMARK_ERROR);
    eval 'sub EXT2FS_TEST_ERROR () {2;}' unless defined(&EXT2FS_TEST_ERROR);
    if(defined(&EXT2_DYNAMIC_REV)) {
	eval 'sub EXT2_FIRST_INODE {
	    my($s) = @_;
    	    eval q( &EXT2_FIRST_INO($s));
	}' unless defined(&EXT2_FIRST_INODE);
    } else {
	eval 'sub EXT2_FIRST_INODE {
	    my($s) = @_;
    	    eval q( &EXT2_FIRST_INO);
	}' unless defined(&EXT2_FIRST_INODE);
	eval 'sub EXT2_INODE_SIZE {
	    my($s) = @_;
    	    eval q($sizeof{\'struct ext2_inode\'});
	}' unless defined(&EXT2_INODE_SIZE);
    }
    eval 'sub BADBLOCKS_FLAG_DIRTY () {1;}' unless defined(&BADBLOCKS_FLAG_DIRTY);
    eval 'sub DBLIST_ABORT () {1;}' unless defined(&DBLIST_ABORT);
    eval 'sub EXT2_FILE_WRITE () {0x1;}' unless defined(&EXT2_FILE_WRITE);
    eval 'sub EXT2_FILE_CREATE () {0x2;}' unless defined(&EXT2_FILE_CREATE);
    eval 'sub EXT2_FILE_MASK () {0xff;}' unless defined(&EXT2_FILE_MASK);
    eval 'sub EXT2_FILE_BUF_DIRTY () {0x4000;}' unless defined(&EXT2_FILE_BUF_DIRTY);
    eval 'sub EXT2_FILE_BUF_VALID () {0x2000;}' unless defined(&EXT2_FILE_BUF_VALID);
    eval 'sub EXT2_SEEK_SET () {0;}' unless defined(&EXT2_SEEK_SET);
    eval 'sub EXT2_SEEK_CUR () {1;}' unless defined(&EXT2_SEEK_CUR);
    eval 'sub EXT2_SEEK_END () {2;}' unless defined(&EXT2_SEEK_END);
    eval 'sub EXT2_FLAG_RW () {0x1;}' unless defined(&EXT2_FLAG_RW);
    eval 'sub EXT2_FLAG_CHANGED () {0x2;}' unless defined(&EXT2_FLAG_CHANGED);
    eval 'sub EXT2_FLAG_DIRTY () {0x4;}' unless defined(&EXT2_FLAG_DIRTY);
    eval 'sub EXT2_FLAG_VALID () {0x8;}' unless defined(&EXT2_FLAG_VALID);
    eval 'sub EXT2_FLAG_IB_DIRTY () {0x10;}' unless defined(&EXT2_FLAG_IB_DIRTY);
    eval 'sub EXT2_FLAG_BB_DIRTY () {0x20;}' unless defined(&EXT2_FLAG_BB_DIRTY);
    eval 'sub EXT2_FLAG_SWAP_BYTES () {0x40;}' unless defined(&EXT2_FLAG_SWAP_BYTES);
    eval 'sub EXT2_FLAG_SWAP_BYTES_READ () {0x80;}' unless defined(&EXT2_FLAG_SWAP_BYTES_READ);
    eval 'sub EXT2_FLAG_SWAP_BYTES_WRITE () {0x100;}' unless defined(&EXT2_FLAG_SWAP_BYTES_WRITE);
    eval 'sub EXT2_FLAG_MASTER_SB_ONLY () {0x200;}' unless defined(&EXT2_FLAG_MASTER_SB_ONLY);
    eval 'sub EXT2_FLAG_FORCE () {0x400;}' unless defined(&EXT2_FLAG_FORCE);
    eval 'sub EXT2_FLAG_SUPER_ONLY () {0x800;}' unless defined(&EXT2_FLAG_SUPER_ONLY);
    eval 'sub EXT2_FLAG_JOURNAL_DEV_OK () {0x1000;}' unless defined(&EXT2_FLAG_JOURNAL_DEV_OK);
    eval 'sub EXT2_FLAG_IMAGE_FILE () {0x2000;}' unless defined(&EXT2_FLAG_IMAGE_FILE);
    eval 'sub EXT2_NEW_INODE_FL () {0x80000000;}' unless defined(&EXT2_NEW_INODE_FL);
    eval 'sub EXT2_MKJOURNAL_V1_SUPER () {0x1;}' unless defined(&EXT2_MKJOURNAL_V1_SUPER);
    if((defined(&EXT2_FLAT_INCLUDES) ? &EXT2_FLAT_INCLUDES : undef)) {
	require 'e2_bitops.ph';
    } else {
	require 'ext2fs/bitops.ph';
    }
    eval 'sub BLOCK_CHANGED () {1;}' unless defined(&BLOCK_CHANGED);
    eval 'sub BLOCK_ABORT () {2;}' unless defined(&BLOCK_ABORT);
    eval 'sub BLOCK_ERROR () {4;}' unless defined(&BLOCK_ERROR);
    eval 'sub BLOCK_FLAG_APPEND () {1;}' unless defined(&BLOCK_FLAG_APPEND);
    eval 'sub BLOCK_FLAG_HOLE () {1;}' unless defined(&BLOCK_FLAG_HOLE);
    eval 'sub BLOCK_FLAG_DEPTH_TRAVERSE () {2;}' unless defined(&BLOCK_FLAG_DEPTH_TRAVERSE);
    eval 'sub BLOCK_FLAG_DATA_ONLY () {4;}' unless defined(&BLOCK_FLAG_DATA_ONLY);
    eval 'sub BLOCK_FLAG_NO_LARGE () {0x1000;}' unless defined(&BLOCK_FLAG_NO_LARGE);
    eval 'sub BLOCK_COUNT_IND () {(-1);}' unless defined(&BLOCK_COUNT_IND);
    eval 'sub BLOCK_COUNT_DIND () {(-2);}' unless defined(&BLOCK_COUNT_DIND);
    eval 'sub BLOCK_COUNT_TIND () {(-3);}' unless defined(&BLOCK_COUNT_TIND);
    eval 'sub BLOCK_COUNT_TRANSLATOR () {(-4);}' unless defined(&BLOCK_COUNT_TRANSLATOR);
    if(0) {
	eval 'sub EXT2_BMOVE_GET_DBLIST () {0x1;}' unless defined(&EXT2_BMOVE_GET_DBLIST);
	eval 'sub EXT2_BMOVE_DEBUG () {0x2;}' unless defined(&EXT2_BMOVE_DEBUG);
    }
    eval 'sub EXT2_DIRBLOCK_V2_STRUCT () {0x1;}' unless defined(&EXT2_DIRBLOCK_V2_STRUCT);
    eval 'sub DIRENT_CHANGED () {1;}' unless defined(&DIRENT_CHANGED);
    eval 'sub DIRENT_ABORT () {2;}' unless defined(&DIRENT_ABORT);
    eval 'sub DIRENT_ERROR () {3;}' unless defined(&DIRENT_ERROR);
    eval 'sub DIRENT_FLAG_INCLUDE_EMPTY () {1;}' unless defined(&DIRENT_FLAG_INCLUDE_EMPTY);
    eval 'sub DIRENT_FLAG_INCLUDE_REMOVED () {2;}' unless defined(&DIRENT_FLAG_INCLUDE_REMOVED);
    eval 'sub DIRENT_DOT_FILE () {1;}' unless defined(&DIRENT_DOT_FILE);
    eval 'sub DIRENT_DOT_DOT_FILE () {2;}' unless defined(&DIRENT_DOT_DOT_FILE);
    eval 'sub DIRENT_OTHER_FILE () {3;}' unless defined(&DIRENT_OTHER_FILE);
    eval 'sub DIRENT_DELETED_FILE () {4;}' unless defined(&DIRENT_DELETED_FILE);
    eval 'sub EXT2_SF_CHK_BADBLOCKS () {0x1;}' unless defined(&EXT2_SF_CHK_BADBLOCKS);
    eval 'sub EXT2_SF_BAD_INODE_BLK () {0x2;}' unless defined(&EXT2_SF_BAD_INODE_BLK);
    eval 'sub EXT2_SF_BAD_EXTRA_BYTES () {0x4;}' unless defined(&EXT2_SF_BAD_EXTRA_BYTES);
    eval 'sub EXT2_SF_SKIP_MISSING_ITABLE () {0x8;}' unless defined(&EXT2_SF_SKIP_MISSING_ITABLE);
    eval 'sub EXT2_MF_MOUNTED () {1;}' unless defined(&EXT2_MF_MOUNTED);
    eval 'sub EXT2_MF_ISROOT () {2;}' unless defined(&EXT2_MF_ISROOT);
    eval 'sub EXT2_MF_READONLY () {4;}' unless defined(&EXT2_MF_READONLY);
    eval 'sub EXT2_MF_SWAP () {8;}' unless defined(&EXT2_MF_SWAP);
    eval 'sub LINUX_S_IFMT () {00170000;}' unless defined(&LINUX_S_IFMT);
    eval 'sub LINUX_S_IFSOCK () {0140000;}' unless defined(&LINUX_S_IFSOCK);
    eval 'sub LINUX_S_IFLNK () {0120000;}' unless defined(&LINUX_S_IFLNK);
    eval 'sub LINUX_S_IFREG () {0100000;}' unless defined(&LINUX_S_IFREG);
    eval 'sub LINUX_S_IFBLK () {0060000;}' unless defined(&LINUX_S_IFBLK);
    eval 'sub LINUX_S_IFDIR () {0040000;}' unless defined(&LINUX_S_IFDIR);
    eval 'sub LINUX_S_IFCHR () {0020000;}' unless defined(&LINUX_S_IFCHR);
    eval 'sub LINUX_S_IFIFO () {0010000;}' unless defined(&LINUX_S_IFIFO);
    eval 'sub LINUX_S_ISUID () {0004000;}' unless defined(&LINUX_S_ISUID);
    eval 'sub LINUX_S_ISGID () {0002000;}' unless defined(&LINUX_S_ISGID);
    eval 'sub LINUX_S_ISVTX () {0001000;}' unless defined(&LINUX_S_ISVTX);
    eval 'sub LINUX_S_IRWXU () {00700;}' unless defined(&LINUX_S_IRWXU);
    eval 'sub LINUX_S_IRUSR () {00400;}' unless defined(&LINUX_S_IRUSR);
    eval 'sub LINUX_S_IWUSR () {00200;}' unless defined(&LINUX_S_IWUSR);
    eval 'sub LINUX_S_IXUSR () {00100;}' unless defined(&LINUX_S_IXUSR);
    eval 'sub LINUX_S_IRWXG () {00070;}' unless defined(&LINUX_S_IRWXG);
    eval 'sub LINUX_S_IRGRP () {00040;}' unless defined(&LINUX_S_IRGRP);
    eval 'sub LINUX_S_IWGRP () {00020;}' unless defined(&LINUX_S_IWGRP);
    eval 'sub LINUX_S_IXGRP () {00010;}' unless defined(&LINUX_S_IXGRP);
    eval 'sub LINUX_S_IRWXO () {00007;}' unless defined(&LINUX_S_IRWXO);
    eval 'sub LINUX_S_IROTH () {00004;}' unless defined(&LINUX_S_IROTH);
    eval 'sub LINUX_S_IWOTH () {00002;}' unless defined(&LINUX_S_IWOTH);
    eval 'sub LINUX_S_IXOTH () {00001;}' unless defined(&LINUX_S_IXOTH);
    eval 'sub LINUX_S_ISLNK {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFLNK));
    }' unless defined(&LINUX_S_ISLNK);
    eval 'sub LINUX_S_ISREG {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFREG));
    }' unless defined(&LINUX_S_ISREG);
    eval 'sub LINUX_S_ISDIR {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFDIR));
    }' unless defined(&LINUX_S_ISDIR);
    eval 'sub LINUX_S_ISCHR {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFCHR));
    }' unless defined(&LINUX_S_ISCHR);
    eval 'sub LINUX_S_ISBLK {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFBLK));
    }' unless defined(&LINUX_S_ISBLK);
    eval 'sub LINUX_S_ISFIFO {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFIFO));
    }' unless defined(&LINUX_S_ISFIFO);
    eval 'sub LINUX_S_ISSOCK {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFSOCK));
    }' unless defined(&LINUX_S_ISSOCK);
    eval 'sub EXT2_I_SIZE {
        my($i) = @_;
	    eval q((($i)-> &i_size | (( &__u64) ($i)-> &i_size_high << 32)));
    }' unless defined(&EXT2_I_SIZE);
    eval 'sub EXT2_ICOUNT_OPT_INCREMENT () {0x1;}' unless defined(&EXT2_ICOUNT_OPT_INCREMENT);
    eval 'sub BMAP_ALLOC () {1;}' unless defined(&BMAP_ALLOC);
    eval 'sub IMAGER_FLAG_INODEMAP () {1;}' unless defined(&IMAGER_FLAG_INODEMAP);
    eval 'sub IMAGER_FLAG_SPARSEWRITE () {2;}' unless defined(&IMAGER_FLAG_SPARSEWRITE);
    eval 'sub EXT2_CHECK_MAGIC {
        my($struct, $code) = @_;
	    eval q( &if (-> &magic != ($code))  &return ($code));
    }' unless defined(&EXT2_CHECK_MAGIC);
    eval 'sub EXT2FS_COMPRESSED_BLKADDR () {(( &blk_t) 0xffffffff);}' unless defined(&EXT2FS_COMPRESSED_BLKADDR);
    eval 'sub HOLE_BLKADDR {
        my($_b) = @_;
	    eval q((($_b) == 0|| ($_b) ==  &EXT2FS_COMPRESSED_BLKADDR));
    }' unless defined(&HOLE_BLKADDR);
    eval 'sub EXT2_LIB_FEATURE_COMPAT_SUPP () {( &EXT2_FEATURE_COMPAT_DIR_PREALLOC|  &EXT2_FEATURE_COMPAT_IMAGIC_INODES|  &EXT3_FEATURE_COMPAT_HAS_JOURNAL|  &EXT2_FEATURE_COMPAT_RESIZE_INODE|  &EXT2_FEATURE_COMPAT_DIR_INDEX|  &EXT2_FEATURE_COMPAT_EXT_ATTR);}' unless defined(&EXT2_LIB_FEATURE_COMPAT_SUPP);
    if(defined(&ENABLE_COMPRESSION)) {
	unless(defined(&I_KNOW_THAT_COMPRESSION_IS_EXPERIMENTAL)) {
	    warn("\"Compression\ support\ is\ experimental\"");
	}
	eval 'sub EXT2_LIB_FEATURE_INCOMPAT_SUPP () {( &EXT2_FEATURE_INCOMPAT_FILETYPE|  &EXT2_FEATURE_INCOMPAT_COMPRESSION|  &EXT3_FEATURE_INCOMPAT_JOURNAL_DEV|  &EXT2_FEATURE_INCOMPAT_META_BG|  &EXT3_FEATURE_INCOMPAT_RECOVER);}' unless defined(&EXT2_LIB_FEATURE_INCOMPAT_SUPP);
    } else {
	eval 'sub EXT2_LIB_FEATURE_INCOMPAT_SUPP () {( &EXT2_FEATURE_INCOMPAT_FILETYPE|  &EXT3_FEATURE_INCOMPAT_JOURNAL_DEV|  &EXT2_FEATURE_INCOMPAT_META_BG|  &EXT3_FEATURE_INCOMPAT_RECOVER);}' unless defined(&EXT2_LIB_FEATURE_INCOMPAT_SUPP);
    }
    eval 'sub EXT2_LIB_FEATURE_RO_COMPAT_SUPP () {( &EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER|  &EXT2_FEATURE_RO_COMPAT_LARGE_FILE);}' unless defined(&EXT2_LIB_FEATURE_RO_COMPAT_SUPP);
    if(0) {
    }
    if((defined( &INCLUDE_INLINE_FUNCS) || !defined( &NO_INLINE_FUNCS))) {
	if(defined(&INCLUDE_INLINE_FUNCS)) {
	    eval 'sub _INLINE_ () { &extern;}' unless defined(&_INLINE_);
	} else {
	    if(defined(&__GNUC__)) {
		eval 'sub _INLINE_ () { &extern  &__inline__;}' unless defined(&_INLINE_);
	    } else {
		eval 'sub _INLINE_ () { &extern  &inline;}' unless defined(&_INLINE_);
	    }
	}
	unless(defined(&EXT2_CUSTOM_MEMORY_ROUTINES)) {
	}
	undef(&_INLINE_) if defined(&_INLINE_);
    }
    if(defined(&__cplusplus)) {
    }
}
1;
