## Copyright (C) 2001-2005 Red Hat, Inc.
## Copyright (C) 2001, 2002 Than Ngo <than@redhat.com>
## Copyright (C) 2001-2005 Harald Hoyer <harald@redhat.com>
## Copyright (C) 2001, 2002 Philipp Knirsch <pknirsch@redhat.com>

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys
import os
import string
from rhpl import ethtool
import NCisdnhardware

from netconfpkg import HardwareList_base
from netconfpkg.NCHardware import *
from NC_functions import *

from netconfpkg.conf.Conf import *
from rhpl.ConfSMB import ConfSMB
from rhpl.executil import *

ModInfo = None
isdnmodulelist = []
try:
    msg =  execWithCapture("/bin/sh", [ "/bin/sh", "-c", "find /lib/modules/$(uname -r)/{kernel,unsupported}/drivers/isdn -name '*.?o' -printf '%f ' 2>/dev/null" ])
    isdnmodulelist = string.split(msg)
except:
    pass

wirelessmodulelist = []
try:
    msg =  execWithCapture("/bin/sh", [ "/bin/sh", "-c", "find /lib/modules/$(uname -r)/{kernel,unsupported}/drivers/net/wireless -name '*.?o' -printf '%f ' 2>/dev/null" ])
    wirelessmodulelist = string.split(msg)
except:
    pass

def getModInfo():
    global ModInfo
    if ModInfo == None:
        for path in [ '/boot/module-info',
                      NETCONFDIR + '/module-info',
                      './module-info' ]:
            try:
                ModInfo = ConfModInfo(filename = path)
            except (VersionMismatch, FileMissing):
                continue
            break
    
    return ModInfo

class MyConfModules(ConfModules):
    def __init__(self, filename = None):
        # if we put netconfpkg.ROOT in the default parameter it will
        # have the value at parsing time
        if filename == None:
            filename = netconfpkg.ROOT + MODULESCONF
        # FIXME: [187640] Support aliases in /etc/modprobe.d/
        ConfModules.__init__(self, filename)
        
    def __delitem__(self, varname):
        # delete *every* instance...
        place=self.tell()
        for key in self.vars[varname].keys():
            self.rewind()

            # workaround for broken regexp implementation
            restr = '^[\\t ]*' + key + '[\\t ]+' + varname
            while self.findnextline(restr):
                #print "1) Deleting %s" % self.line
                self.deleteline()

            restr = '^[\\t ]*' + key + '[\\t ]+\\-k[\\t ]+' + varname
            while self.findnextline(restr):
                #print "2) Deleting %s" % self.line
                self.deleteline()

        del self.vars[varname]
        log.ldel(2, self.filename, varname)
        self.seek(place)


    def splitopt(self, opt):
	eq = find(opt, '=')
	if eq > 0:
	    return (opt[:eq], opt[eq+1:])
	else:
	    return (opt, None)

    def joinoptlist(self, dict):
	optstring = ''
	for key in dict.keys():
            if dict[key] != None:
                optstring = optstring + key + '=' + dict[key] + ' '
            else:
                optstring = optstring + key + ' '
                
	return optstring


        
_MyConfModules = None
_MyConfModules_root = netconfpkg.ROOT

def getMyConfModules(refresh = None):
    global _MyConfModules
    global _MyConfModules_root
    
    if _MyConfModules == None or refresh or \
           _MyConfModules_root != netconfpkg.ROOT :
        _MyConfModules = MyConfModules()
        _MyConfModules_root = netconfpkg.ROOT
    return _MyConfModules

_MyWvDial = None
_MyWvDial_root = netconfpkg.ROOT

def getMyWvDial(create_if_missing = None):
    global _MyWvDial
    global _MyWvDial_root
    
    if _MyWvDial == None or _MyWvDial_root != netconfpkg.ROOT:
        _MyWvDial = ConfSMB(netconfpkg.ROOT + WVDIALCONF,
                           create_if_missing = create_if_missing)
        _MyWvDial_root = netconfpkg.ROOT

    return _MyWvDial

class ConfHWConf(Conf):    

    def __init__(self):
        Conf.__init__(self, netconfpkg.ROOT + HWCONF)

    def read(self):
        Conf.read(self)
        self.initvars()

    def initvars(self):
        self.vars = {}

        if not os.access(netconfpkg.ROOT + HWCONF, os.R_OK):
            return

        fp = open(netconfpkg.ROOT + HWCONF, 'r')
        hwlist = fp.read()
        hwlist = string.split(hwlist, "-\n")
        pos = 0
        for hw in hwlist:
            if not len(hw):
                continue
            items = string.split(hw, '\n')
            hwdict = {}
            for item in items:
                if not len(item):
                    continue
                vals = string.split(item, ":")
                if len(vals) <= 1:
                    # skip over bad/malformed lines
                    continue
                # Some of the first words are used as dict keys server side
                # so this just helps make that easier
                strippedstring = string.strip(vals[1])
                vals[1] = strippedstring
                hwdict[vals[0]] = string.join(vals[1:])
            self.vars[pos] = hwdict
            pos = pos + 1

    def __getitem__(self, varname):
        if self.vars.has_key(varname):
            return self.vars[varname]
        else:
            return None

    def keys(self):
        return self.vars.keys()

class HardwareList(HardwareList_base):
    s390devs = { 
                 "lcs" : "lcs" ,
                 "osad" : "",
                 "eth" : "qeth",
                 "hsi" : "qeth",
                 "tr" : "qeth",
                 }

    def __init__(self, list = None, parent = None):
        HardwareList_base.__init__(self, list, parent)
        # FIXME: [198070] use modinfo to determine options
        self.keydict = { 'IoPort' : 'io',
                         'IRQ' : 'irq',
                         'Mem' : 'mem',
                         'DMA0' : 'dma',
        }


    def addHardware(self, type = None):
        from netconfpkg.NCHardwareFactory import getHardwareFactory
        i = HardwareList_base.addHardware(self)
        hwf = getHardwareFactory()
        hwc = hwf.getHardwareClass(type)
        if hwc:
            newhw = hwc()
            self[i] = newhw
        return i

    def updateFromHal(self, hdellist):
        from netconfpkg import NCBackendHal
        hal = NCBackendHal()
        cards = hal.probeCards()
        for hw in cards:
            # if it is already in our HW list do not delete it.
            for h in hdellist:
                if (h.Name == hw.Name
                    and h.Card.ModuleName == hw.Card.ModuleName):
                    log.log(5,
                    "Found %s:%s, which is already in our list!"
                    % (hw.Name, hw.Card.ModuleName))
                    hdellist.remove(h)
                    break
                else:
                    log.log(5, "%s != %s and %s != %s"
                            % (h.Name, hw.Name,
                               h.Card.ModuleName,
                               hw.Card.ModuleName))
            else:
                for h in self:
                    if(h.Name == hw.Name
                       and h.Card.ModuleName == hw.Card.ModuleName):
                        break
                    else:
                        log.log(5, "%s != %s and %s != %s"
                                % (h.Name, hw.Name,
                                   h.Card.ModuleName,
                                   hw.Card.ModuleName))
                else:
                    hw.Status = HW_SYSTEM
                    self.append(hw)
                    hw.setChanged(False)

        return hdellist


    def updateFromSystem(self):
        modules = getMyConfModules()
        modinfo = getModInfo()            

        hdellist = []
        
        for h in self:
            if h.Status == HW_SYSTEM:
                hdellist.append(h)

        log.log(5, "updateFromHal")
        try:
            hdellist = self.updateFromHal(hdellist)
        except:
            pass
        log.log(5, str(self))

        for h in hdellist:
            log.log(5, "Removing %s from HWList" % h.Name)
            self.remove(h)

        del hdellist


    def updateFromModules(self):
        modules = getMyConfModules()
        modinfo = getModInfo()
        #
        # Read /etc/modprobe.conf
        #
        for mod in modules.keys():
            if modules[mod].has_key('alias'):
                module = modules[mod]['alias']
            else: module = None                       

            type = getDeviceType(mod, module)

            if type == _('Unknown'):
                continue            

            h = None
            for h in self:
                if h.Name == mod:
                    break
            
            if h and h.Name == mod:
                continue
             
            i = self.addHardware(type)
            hw = self[i]
            hw.Name = mod
            hw.Description = module
            hw.Type = type
            hw.createCard()
            hw.Card.ModuleName = module
            hw.Status = HW_CONF
            if module and modinfo:
                for info in modinfo.keys():
                    if info == module:
                        if modinfo[info].has_key('description'):
                            hw.Description = modinfo[info]['description']
                            
            for selfkey in self.keydict.keys():
                confkey = self.keydict[selfkey]
                if modules[hw.Card.ModuleName] and \
                       modules[hw.Card.ModuleName]['options'].has_key(confkey):
                    hw.Card.__dict__[selfkey] = modules[hw.Card.ModuleName]\
                                                ['options'][confkey]


    def _objToStr(self, parentStr = None):
        #return DeviceList_base._objToStr(self, obj, parentStr)
        retstr = ""
        for dev in self:
            retstr += dev._objToStr("HardwareList.%s.%s" % (dev.Type,
                                                            dev.Name))

        return retstr


    def _parseLine(self, vals, value):
        if len(vals) <= 1:
            return
        if vals[0] == "HardwareList":
            del vals[0]
        else:
            return
        for dev in self:
            if dev.Name == vals[1]:
                if dev.Type != vals[0]:
                    self.remove(dev)
                    log.log(1, "Deleting device %s" % vals[1] )
                    break
                dev._parseLine(vals[2:], value)
                return
        log.log(4, "Type = %s, Name = %s" % (vals[0], vals[1]))
        i = self.addHardware(vals[0])
        dev = self[i]
        dev.Name = vals[1]
        dev._parseLine(vals[2:], value)


    def load(self):
        hwconf = ConfHWConf()          

	    # first clear the list
        self.__delslice__(0, len(self))
        
        # FIXME: move HW detection to NCDev*
        self.updateFromSystem()        
        self.updateFromModules()
        
        for hw in self:
            if hw.Name == "ISDN Card 0":
                break
        else:
            #
            # XXX FIXME... this is not OO
            #
            isdncard = NCisdnhardware.ConfISDN()
            if isdncard.load() > 0:
                i = self.addHardware(ISDN)
                hw = self[i]
                hw.Name = "ISDN Card 0"
                hw.Description = isdncard.Description
                hw.Type = ISDN
                hw.Status = HW_CONF
                hw.createCard()
                hw.Card.ModuleName = isdncard.ModuleName
                hw.Card.Type = isdncard.Type
                hw.Card.IoPort = isdncard.IoPort
                hw.Card.IoPort1 = isdncard.IoPort1
                hw.Card.IoPort2 = isdncard.IoPort2
                hw.Card.Mem = isdncard.Mem
                hw.Card.IRQ = isdncard.IRQ
                hw.Card.ChannelProtocol = isdncard.ChannelProtocol
                hw.Card.Firmware = isdncard.Firmware
                hw.Card.DriverId = isdncard.DriverId
                hw.Card.VendorId = isdncard.VendorId
                hw.Card.DeviceId = isdncard.DeviceId
            
        #
        # FIXME: This is not OO!
        #
        try:
            wvdial = ConfSMB(netconfpkg.ROOT + WVDIALCONF)
        except Conf.FileMissing:
            pass
        else:
            for dev in wvdial.keys():
                if dev[:5] != 'Modem':
                    continue

                i = self.addHardware(MODEM)
                hw = self[i]
                hw.Name = dev
                hw.Description = 'Generic Modem'
                hw.Type = MODEM
                hw.Status = HW_CONF
                hw.createModem()
                if not wvdial[dev].has_key('Modem'):
                    wvdial[dev]['Modem'] = '/dev/modem'
                hw.Modem.DeviceName = wvdial[dev]['Modem']

                if not wvdial[dev].has_key('Baud'):
                    wvdial[dev]['Baud'] = '38400'
                hw.Modem.BaudRate = int(wvdial[dev]['Baud'])

                if not wvdial[dev].has_key('SetVolume'):
                    wvdial[dev]['SetVolume'] = '0'
                hw.Modem.ModemVolume = int(wvdial[dev]['SetVolume'])

                if not wvdial[dev].has_key('Dial Command'):
                    wvdial[dev]['Dial Command'] = 'ATDT'
                hw.Modem.DialCommand = wvdial[dev]['Dial Command']

                if not wvdial[dev].has_key('Init1'):
                    wvdial[dev]['Init1'] = 'ATZ'
                hw.Modem.InitString =  wvdial[dev]['Init1']

                if not wvdial[dev].has_key('FlowControl'):
                    wvdial[dev]['FlowControl'] = CRTSCTS
                hw.Modem.FlowControl =  wvdial[dev]['FlowControl']

        self.commit(changed=false)
        #self.updateFromSystem()

    def save(self):
        modules = getMyConfModules(refresh = true)

        # cleanup isdnconf
        isdn = NCisdnhardware.ConfISDN()
        isdn.cleanup()  

        for hw in self:
            hw.save()

        try:
            wvdial = getMyWvDial(create_if_missing = false)
        except:
            wvdial = None
            pass
        
        if wvdial:
            # Clean up wvdial
            for dev in wvdial.keys():
                if dev[:5] != 'Modem':
                    continue
                for hw in self:
                    if hw.Type == MODEM and hw.Name == dev:
                        break
                else:
                    # if the loop does not get interrupted by break
                    # we did not find the Modem in the hardwarelist
                    # and it gets deleted
                    del wvdial[dev]
                    
        # FIXME: [198070] use modinfo to determine options
        # Clean up modules
        for mod in modules.keys():
            type = getDeviceType(mod)
            #
            # FIXME: This is not OO!!
            #
            if type != ETHERNET and type != TOKENRING and type != QETH and type != LCS:
                continue
            #print "Testing " + str(mod)
            for hw in self:
                if (hw.Type == ETHERNET or \
                    hw.Type == TOKENRING or \
                        hw.Type == QETH or \
                        hw.Type == LCS) and \
                        hw.Name == mod:
                    break
            else:
                #print "Removing " + str(mod)
                #print str(modules.vars[mod].keys())
                del modules[mod]
                #print "Test: " + str(modules[mod])

                
        modules.write()
        if wvdial:
            wvdial.write()


__HWList = None
__HWList_root = netconfpkg.ROOT

def getHardwareList(refresh = None):
    global __HWList
    global __HWList_root
    
    if __HWList == None or refresh or \
           __HWList_root != netconfpkg.ROOT:
        __HWList = HardwareList()
        __HWList.load()
        __HWList_root = netconfpkg.ROOT
    return __HWList

def getNextDev(base):
    hwlist = getHardwareList()
    num = 0
    for num in xrange(0,100):
        for hw in hwlist:
            if hw.Name == base + str(num):
                break
        else:
            # no card seems to use this                         
            break
        
    return base + str(num)


if __name__ == '__main__':
    hl = HardwareList()
    hl.load()
    for i in xrange(len(hl)):
        print "Name: ", hl[i].Name
        print "Description: ", hl[i].Description
        print "Type: ", hl[i].Type
        if hl[i].Type == "Ethernet" or hl[i].Type == "ISDN":
            print "ModuleName: ", hl[i].Card.ModuleName
            print "IoPort: ", hl[i].Card.IoPort
            print "IoPort1: ", hl[i].Card.IoPort1
            print "IoPort2: ", hl[i].Card.IoPort2
            print "Mem: ", hl[i].Card.Mem
            print "IRQ: ", hl[i].Card.IRQ
            print "DMA0: ", hl[i].Card.DMA0
            print "DMA1: ", hl[i].Card.DMA1
            print "ChannelProtocol: ", hl[i].Card.ChannelProtocol
            
        if hl[i].Type == "Modem":
            print "DeviceName: ", hl[i].Modem.DeviceName
            print "BaudRate: ", hl[i].Modem.BaudRate
            print "FlowControl: ", hl[i].Modem.FlowControl
            print "ModemVolume: ", hl[i].Modem.ModemVolume
            print "DialCommand: ", hl[i].Modem.DialCommand

        print "-----------------------------------------"

    hl.save()
__author__ = "Harald Hoyer <harald@redhat.com>"
__date__ = "$Date: 2006/07/19 15:18:13 $"
__version__ = "$Revision: 1.77 $"
