/* tpf-persona.c generated by valac 0.16.0, the Vala compiler
 * generated from tpf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks-internal.h>


#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;
typedef struct _TpfPersonaPrivate TpfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaChangeFullNameData TpfPersonaChangeFullNameData;
typedef struct _TpfPersonaChangeBirthdayData TpfPersonaChangeBirthdayData;
typedef struct _TpfPersonaChangeAliasData TpfPersonaChangeAliasData;
typedef struct _TpfPersonaChangeIsFavouriteData TpfPersonaChangeIsFavouriteData;
typedef struct _TpfPersonaChangeEmailAddressesData TpfPersonaChangeEmailAddressesData;
typedef struct _TpfPersonaChangeGroupData TpfPersonaChangeGroupData;
typedef struct _TpfPersonaChangeGroupsData TpfPersonaChangeGroupsData;
typedef struct _TpfPersonaChangePhoneNumbersData TpfPersonaChangePhoneNumbersData;
typedef struct _TpfPersonaChangeUrlsData TpfPersonaChangeUrlsData;
typedef struct _TpfPersonaChangeDetailsData TpfPersonaChangeDetailsData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _TpfPersona {
	FolksPersona parent_instance;
	TpfPersonaPrivate * priv;
};

struct _TpfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TpfPersonaPrivate {
	gchar** _writeable_properties;
	gint _writeable_properties_length1;
	gint __writeable_properties_size_;
	gboolean _is_constructed;
	gboolean _is_in_contact_list;
	GLoadableIcon* _avatar;
	gchar* _full_name;
	GDateTime* _birthday;
	FolksPresenceType _presence_type;
	gchar* _presence_status;
	gchar* _presence_message;
	gchar* _alias;
	gboolean _is_favourite;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	GeeHashMultiMap* _im_addresses;
	GeeHashSet* _groups;
	GeeSet* _groups_ro;
	TpContact* _contact;
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
};

struct _TpfPersonaChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* full_name;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	TpfPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	GError* e1;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GError* e2;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError* e3;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GDateTime* birthday;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gboolean _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	TpfPersonaStore* _tmp13_;
	GDateTime* _tmp14_;
	GError* e1;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GError* e2;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError* e3;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* alias;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
};

struct _TpfPersonaChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gboolean is_favourite;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeEmailAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* email_addresses;
	GeeSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* group;
	gboolean is_member;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	TpfPersonaStore* _tmp5_;
	TpfPersonaStore* store;
	TpfPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
};

struct _TpfPersonaChangeGroupsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* groups;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* store;
	GeeSet* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _group1_it;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	gchar* group1;
	GeeHashSet* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	TpfPersonaStore* _tmp12_;
	const gchar* _tmp13_;
	GeeHashSet* _tmp14_;
	GeeIterator* _tmp15_;
	GeeIterator* _group2_it;
	GeeIterator* _tmp16_;
	gboolean _tmp17_;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	gchar* group2;
	GeeSet* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	TpfPersonaStore* _tmp23_;
	const gchar* _tmp24_;
};

struct _TpfPersonaChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* phone_numbers;
	GeeSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeUrlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* urls;
	GeeSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* details;
	GeeSet* member_set;
	gchar* field_name;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	TpfPersonaStore* _tmp7_;
	GeeSet* _tmp8_;
	const gchar* _tmp9_;
	GError* e1;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError* e2;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError* e3;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	TpAccount* account_found;
	TpConnection* conn;
};


static gpointer tpf_persona_parent_class = NULL;
static FolksAliasDetailsIface* tpf_persona_folks_alias_details_parent_iface = NULL;
static FolksAvatarDetailsIface* tpf_persona_folks_avatar_details_parent_iface = NULL;
static FolksBirthdayDetailsIface* tpf_persona_folks_birthday_details_parent_iface = NULL;
static FolksEmailDetailsIface* tpf_persona_folks_email_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* tpf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGroupDetailsIface* tpf_persona_folks_group_details_parent_iface = NULL;
static FolksImDetailsIface* tpf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* tpf_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface* tpf_persona_folks_phone_details_parent_iface = NULL;
static FolksPresenceDetailsIface* tpf_persona_folks_presence_details_parent_iface = NULL;
static FolksUrlDetailsIface* tpf_persona_folks_url_details_parent_iface = NULL;

GType tpf_persona_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA, TpfPersonaPrivate))
enum  {
	TPF_PERSONA_DUMMY_PROPERTY,
	TPF_PERSONA_IS_IN_CONTACT_LIST,
	TPF_PERSONA_AVATAR,
	TPF_PERSONA_STRUCTURED_NAME,
	TPF_PERSONA_FULL_NAME,
	TPF_PERSONA_NICKNAME,
	TPF_PERSONA_CALENDAR_EVENT_ID,
	TPF_PERSONA_BIRTHDAY,
	TPF_PERSONA_PRESENCE_TYPE,
	TPF_PERSONA_PRESENCE_STATUS,
	TPF_PERSONA_PRESENCE_MESSAGE,
	TPF_PERSONA_LINKABLE_PROPERTIES,
	TPF_PERSONA_WRITEABLE_PROPERTIES,
	TPF_PERSONA_ALIAS,
	TPF_PERSONA_IS_FAVOURITE,
	TPF_PERSONA_EMAIL_ADDRESSES,
	TPF_PERSONA_IM_ADDRESSES,
	TPF_PERSONA_GROUPS,
	TPF_PERSONA_CONTACT,
	TPF_PERSONA_PHONE_NUMBERS,
	TPF_PERSONA_URLS
};
static void _tpf_persona_contact_weak_notify_cb (TpfPersona* self, GObject* obj);
static void __tpf_persona_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object);
static void tpf_persona_real_change_full_name_data_free (gpointer _data);
static void tpf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_full_name_co (TpfPersonaChangeFullNameData* _data_);
GType tpf_persona_store_get_type (void) G_GNUC_CONST;
void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_birthday_data_free (gpointer _data);
static void tpf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_birthday_co (TpfPersonaChangeBirthdayData* _data_);
void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_alias_data_free (gpointer _data);
static void tpf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_alias_co (TpfPersonaChangeAliasData* _data_);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_is_favourite_data_free (gpointer _data);
static void tpf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_is_favourite_co (TpfPersonaChangeIsFavouriteData* _data_);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_email_addresses_data_free (gpointer _data);
static void tpf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_email_addresses_co (TpfPersonaChangeEmailAddressesData* _data_);
static void _tpf_persona_change_details (TpfPersona* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeSet* details, GeeSet* member_set, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_change_details_finish (TpfPersona* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_group_data_free (gpointer _data);
static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_);
static gboolean _tpf_persona_change_group (TpfPersona* self, const gchar* group, gboolean is_member);
void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_groups_data_free (gpointer _data);
static void tpf_persona_real_change_groups (FolksGroupDetails* base, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_groups_co (TpfPersonaChangeGroupsData* _data_);
static void tpf_persona_change_groups_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_phone_numbers_data_free (gpointer _data);
static void tpf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_phone_numbers_co (TpfPersonaChangePhoneNumbersData* _data_);
static void tpf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_urls_data_free (gpointer _data);
static void tpf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_urls_co (TpfPersonaChangeUrlsData* _data_);
static void tpf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_change_details_data_free (gpointer _data);
static gboolean _tpf_persona_change_details_co (TpfPersonaChangeDetailsData* _data_);
void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_change_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static TpAccount* _tpf_persona_account_for_connection (TpConnection* conn);
static void tpf_persona_real_constructed (GObject* base);
static void _tpf_persona_store_notify_supported_fields (TpfPersona* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_contact_notify_contact_info (TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static GeeMultiMap* _tpf_persona_afd_params_from_strv (TpfPersona* self, gchar** parameters, int parameters_length1);
TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls);
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda20_ (Block1Data* _data1_, TpAccount* l);
static void ___lambda20__gfunc (gconstpointer data, gpointer self);
static void _tpf_persona_contact_notify_presence_message (TpfPersona* self);
static void _tpf_persona_contact_notify_presence_type (TpfPersona* self);
static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type);
static void _tpf_persona_contact_notify_presence_status (TpfPersona* self);
static void _tpf_persona_contact_notify_avatar (TpfPersona* self);
TpfPersona* tpf_persona_dup_for_contact (TpContact* contact);
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account);
TpfPersona* _tpf_persona_store_ensure_persona_from_contact (TpfPersonaStore* self, TpContact* contact);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
static void tpf_persona_set_contact (TpfPersona* self, TpContact* value);
static GObject * tpf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _tpf_persona___lambda21_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda22_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda23_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda24_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda25_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda26_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda27_ (TpfPersona* self, TpfPersonaStore* s, const gchar* group, GList* added, GList* removed);
static void __tpf_persona___lambda27__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const gchar* group, GList* added, GList* removed, gpointer self);
static void _tpf_persona___lambda28_ (TpfPersona* self, TpfPersonaStore* s, const gchar* group, GError* _error_);
static void __tpf_persona___lambda28__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const gchar* group, GError* _error_, gpointer self);
static void _tpf_persona____lambda29_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona____lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_finalize (GObject* obj);
static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TPF_PERSONA__linkable_properties[1] = {"im-addresses"};
static const gchar* TPF_PERSONA__always_writeable_properties[3] = {"alias", "is-favourite", "groups"};

static void __tpf_persona_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object) {
	_tpf_persona_contact_weak_notify_cb (self, object);
}


static void tpf_persona_real_change_full_name_data_free (gpointer _data) {
	TpfPersonaChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeFullNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeFullNameData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->full_name = _tmp2_;
	tpf_persona_real_change_full_name_co (_data_);
}


static void tpf_persona_real_change_full_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_full_name_co (_data_);
}


static gboolean tpf_persona_real_change_full_name_co (TpfPersonaChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (TPF_IS_PERSONA_STORE (_data_->_tmp1_) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->full_name;
	_data_->_tmp4_ = _data_->self->priv->_full_name;
	if (g_strcmp0 (_data_->_tmp3_, _data_->_tmp4_) == 0) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp5_) {
		{
			_data_->_tmp6_ = _data_->tpf_store;
			_data_->_tmp7_ = _data_->full_name;
			_data_->_state_ = 1;
			tpf_persona_store_change_user_full_name (_data_->_tmp6_, _data_->self, _data_->_tmp7_, tpf_persona_change_full_name_ready, _data_);
			return FALSE;
			_state_1:
			tpf_persona_store_change_user_full_name_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch0_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch0_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch0_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally0;
		__catch0_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp8_ = _data_->e1;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			_data_->_tmp10_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp9_);
			_data_->_inner_error_ = _data_->_tmp10_;
			_g_error_free0 (_data_->e1);
			goto __finally0;
		}
		goto __finally0;
		__catch0_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp11_ = _data_->e2;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			_data_->_tmp13_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp12_);
			_data_->_inner_error_ = _data_->_tmp13_;
			_g_error_free0 (_data_->e2);
			goto __finally0;
		}
		goto __finally0;
		__catch0_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp14_ = _data_->e3;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			_data_->_tmp16_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp15_);
			_data_->_inner_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e3);
			goto __finally0;
		}
		__finally0:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_birthday_data_free (gpointer _data) {
	TpfPersonaChangeBirthdayData* _data_;
	_data_ = _data;
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void tpf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeBirthdayData* _data_;
	TpfPersona* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = birthday;
	_tmp2_ = _g_date_time_ref0 (_tmp1_);
	_data_->birthday = _tmp2_;
	tpf_persona_real_change_birthday_co (_data_);
}


static void tpf_persona_real_change_birthday_finish (FolksBirthdayDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_birthday_co (_data_);
}


static gboolean tpf_persona_real_change_birthday_co (TpfPersonaChangeBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (TPF_IS_PERSONA_STORE (_data_->_tmp1_) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp5_ = _data_->birthday;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->self->priv->_birthday;
		_data_->_tmp4_ = _data_->_tmp6_ != NULL;
	} else {
		_data_->_tmp4_ = FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp4_;
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = _data_->birthday;
		_data_->_tmp9_ = _data_->self->priv->_birthday;
		_data_->_tmp10_ = FALSE;
		_data_->_tmp10_ = g_date_time_equal (_data_->_tmp8_, _data_->_tmp9_);
		_data_->_tmp3_ = _data_->_tmp10_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	_data_->_tmp11_ = _data_->_tmp3_;
	if (_data_->_tmp11_) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp12_) {
		{
			_data_->_tmp13_ = _data_->tpf_store;
			_data_->_tmp14_ = _data_->birthday;
			_data_->_state_ = 1;
			tpf_persona_store_change_user_birthday (_data_->_tmp13_, _data_->self, _data_->_tmp14_, tpf_persona_change_birthday_ready, _data_);
			return FALSE;
			_state_1:
			tpf_persona_store_change_user_birthday_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch1_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch1_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch1_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = _data_->e1;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			_data_->_tmp17_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp16_);
			_data_->_inner_error_ = _data_->_tmp17_;
			_g_error_free0 (_data_->e1);
			goto __finally1;
		}
		goto __finally1;
		__catch1_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp18_ = _data_->e2;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			_data_->_tmp20_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp19_);
			_data_->_inner_error_ = _data_->_tmp20_;
			_g_error_free0 (_data_->e2);
			goto __finally1;
		}
		goto __finally1;
		__catch1_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp21_ = _data_->e3;
			_data_->_tmp22_ = _data_->_tmp21_->message;
			_data_->_tmp23_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp22_);
			_data_->_inner_error_ = _data_->_tmp23_;
			_g_error_free0 (_data_->e3);
			goto __finally1;
		}
		__finally1:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_alias_data_free (gpointer _data) {
	TpfPersonaChangeAliasData* _data_;
	_data_ = _data;
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeAliasData, _data_);
}


static void tpf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeAliasData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = alias;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->alias = _tmp2_;
	tpf_persona_real_change_alias_co (_data_);
}


static void tpf_persona_real_change_alias_finish (FolksAliasDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeAliasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeAliasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_alias_co (_data_);
}


static gboolean tpf_persona_real_change_alias_co (TpfPersonaChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_alias;
	_data_->_tmp1_ = _data_->alias;
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp1_) == 0) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->alias;
		_data_->_state_ = 1;
		tpf_persona_store_change_alias (TPF_PERSONA_STORE (_data_->_tmp4_), _data_->self, _data_->_tmp5_, tpf_persona_change_alias_ready, _data_);
		return FALSE;
		_state_1:
		tpf_persona_store_change_alias_finish (TPF_PERSONA_STORE (_data_->_tmp4_), _data_->_res_);
	}
	_data_->_tmp6_ = _data_->alias;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_g_free0 (_data_->self->priv->_alias);
	_data_->self->priv->_alias = _data_->_tmp7_;
	g_object_notify ((GObject*) _data_->self, "alias");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeIsFavouriteData, _data_);
}


static void tpf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeIsFavouriteData* _data_;
	TpfPersona* _tmp0_;
	gboolean _tmp1_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = is_favourite;
	_data_->is_favourite = _tmp1_;
	tpf_persona_real_change_is_favourite_co (_data_);
}


static void tpf_persona_real_change_is_favourite_finish (FolksFavouriteDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_real_change_is_favourite_co (TpfPersonaChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_is_favourite;
	_data_->_tmp1_ = _data_->is_favourite;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->is_favourite;
		_data_->_state_ = 1;
		tpf_persona_store_change_is_favourite (TPF_PERSONA_STORE (_data_->_tmp4_), (FolksPersona*) _data_->self, _data_->_tmp5_, tpf_persona_change_is_favourite_ready, _data_);
		return FALSE;
		_state_1:
		tpf_persona_store_change_is_favourite_finish (TPF_PERSONA_STORE (_data_->_tmp4_), _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp6_ = _data_->is_favourite;
	_data_->self->priv->_is_favourite = _data_->_tmp6_;
	g_object_notify ((GObject*) _data_->self, "is-favourite");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_email_addresses_data_free (gpointer _data) {
	TpfPersonaChangeEmailAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeEmailAddressesData, _data_);
}


static void tpf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeEmailAddressesData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeEmailAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_email_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_email_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->email_addresses = _tmp2_;
	tpf_persona_real_change_email_addresses_co (_data_);
}


static void tpf_persona_real_change_email_addresses_finish (FolksEmailDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeEmailAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeEmailAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_email_addresses_co (_data_);
}


static gboolean tpf_persona_real_change_email_addresses_co (TpfPersonaChangeEmailAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->email_addresses;
	_data_->_tmp1_ = _data_->self->priv->_email_addresses;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "email", tpf_persona_change_email_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_group_data_free (gpointer _data) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _data;
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupData, _data_);
}


static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_group_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->group = _tmp2_;
	_tmp3_ = is_member;
	_data_->is_member = _tmp3_;
	tpf_persona_real_change_group_co (_data_);
}


static void tpf_persona_real_change_group_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add or remove the Persona from the specified group.
   *
   * See {@link Folks.GroupDetails.change_group}.
   */
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_group_co (_data_);
}


static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->group;
	_data_->_tmp1_ = _data_->is_member;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = _tpf_persona_change_group (_data_->self, _data_->_tmp0_, _data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _g_object_ref0 (TPF_PERSONA_STORE (_data_->_tmp4_));
		_data_->store = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->store;
		_data_->_tmp7_ = _data_->group;
		_data_->_tmp8_ = _data_->is_member;
		_data_->_state_ = 1;
		_tpf_persona_store_change_group_membership (_data_->_tmp6_, (FolksPersona*) _data_->self, _data_->_tmp7_, _data_->_tmp8_, tpf_persona_change_group_ready, _data_);
		return FALSE;
		_state_1:
		_tpf_persona_store_change_group_membership_finish (_data_->_tmp6_, _data_->_res_);
		_g_object_unref0 (_data_->store);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean _tpf_persona_change_group (TpfPersona* self, const gchar* group, gboolean is_member) {
	gboolean result = FALSE;
	gboolean changed;
	gboolean _tmp0_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	changed = FALSE;
	_tmp0_ = is_member;
	if (_tmp0_) {
		GeeHashSet* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->_groups;
		_tmp2_ = group;
		_tmp3_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		changed = _tmp3_;
	} else {
		GeeHashSet* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->_groups;
		_tmp5_ = group;
		_tmp6_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp4_, _tmp5_);
		changed = _tmp6_;
	}
	_tmp7_ = changed;
	if (_tmp7_ == TRUE) {
		const gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = group;
		_tmp9_ = is_member;
		g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp8_, _tmp9_);
	}
	result = changed;
	return result;
}


static void tpf_persona_real_change_groups_data_free (gpointer _data) {
	TpfPersonaChangeGroupsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->groups);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupsData, _data_);
}


static void tpf_persona_real_change_groups (FolksGroupDetails* base, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupsData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_groups);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_groups_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = groups;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->groups = _tmp2_;
	tpf_persona_real_change_groups_co (_data_);
}


static void tpf_persona_real_change_groups_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_groups_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_groups_co (_data_);
}


static gboolean tpf_persona_real_change_groups_co (TpfPersonaChangeGroupsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (TPF_PERSONA_STORE (_data_->_tmp1_));
	_data_->store = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->groups;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
		_data_->_group1_it = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_group1_it;
			_data_->_tmp6_ = FALSE;
			_data_->_tmp6_ = gee_iterator_next (_data_->_tmp5_);
			if (!_data_->_tmp6_) {
				break;
			}
			_data_->_tmp7_ = _data_->_group1_it;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->group1 = (gchar*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->self->priv->_groups;
			_data_->_tmp10_ = _data_->group1;
			_data_->_tmp11_ = FALSE;
			_data_->_tmp11_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp9_, _data_->_tmp10_);
			if (_data_->_tmp11_ == FALSE) {
				_data_->_tmp12_ = _data_->store;
				_data_->_tmp13_ = _data_->group1;
				_data_->_state_ = 1;
				_tpf_persona_store_change_group_membership (_data_->_tmp12_, (FolksPersona*) _data_->self, _data_->_tmp13_, TRUE, tpf_persona_change_groups_ready, _data_);
				return FALSE;
				_state_1:
				_tpf_persona_store_change_group_membership_finish (_data_->_tmp12_, _data_->_res_);
			}
			_g_free0 (_data_->group1);
		}
		_g_object_unref0 (_data_->_group1_it);
	}
	{
		_data_->_tmp14_ = _data_->self->priv->_groups;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp14_);
		_data_->_group2_it = _data_->_tmp15_;
		while (TRUE) {
			_data_->_tmp16_ = _data_->_group2_it;
			_data_->_tmp17_ = FALSE;
			_data_->_tmp17_ = gee_iterator_next (_data_->_tmp16_);
			if (!_data_->_tmp17_) {
				break;
			}
			_data_->_tmp18_ = _data_->_group2_it;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
			_data_->group2 = (gchar*) _data_->_tmp19_;
			_data_->_tmp20_ = _data_->groups;
			_data_->_tmp21_ = _data_->group2;
			_data_->_tmp22_ = FALSE;
			_data_->_tmp22_ = gee_collection_contains ((GeeCollection*) _data_->_tmp20_, _data_->_tmp21_);
			if (_data_->_tmp22_ == FALSE) {
				_data_->_tmp23_ = _data_->store;
				_data_->_tmp24_ = _data_->group2;
				_data_->_state_ = 2;
				_tpf_persona_store_change_group_membership (_data_->_tmp23_, (FolksPersona*) _data_->self, _data_->_tmp24_, FALSE, tpf_persona_change_groups_ready, _data_);
				return FALSE;
				_state_2:
				_tpf_persona_store_change_group_membership_finish (_data_->_tmp23_, _data_->_res_);
			}
			_g_free0 (_data_->group2);
		}
		_g_object_unref0 (_data_->_group2_it);
	}
	g_object_notify ((GObject*) _data_->self, "groups");
	_g_object_unref0 (_data_->store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_contact_weak_notify_cb (TpfPersona* self, GObject* obj) {
	GObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	g_debug ("tpf-persona.vala:471: TpContact %p destroyed; setting ._contact = null" \
" in Persona %p", _tmp0_, self);
	self->priv->_contact = NULL;
	g_object_notify ((GObject*) self, "contact");
}


static void tpf_persona_real_change_phone_numbers_data_free (gpointer _data) {
	TpfPersonaChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangePhoneNumbersData, _data_);
}


static void tpf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangePhoneNumbersData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangePhoneNumbersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_phone_numbers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = phone_numbers;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->phone_numbers = _tmp2_;
	tpf_persona_real_change_phone_numbers_co (_data_);
}


static void tpf_persona_real_change_phone_numbers_finish (FolksPhoneDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangePhoneNumbersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangePhoneNumbersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_phone_numbers_co (_data_);
}


static gboolean tpf_persona_real_change_phone_numbers_co (TpfPersonaChangePhoneNumbersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->phone_numbers;
	_data_->_tmp1_ = _data_->self->priv->_phone_numbers;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "tel", tpf_persona_change_phone_numbers_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_urls_data_free (gpointer _data) {
	TpfPersonaChangeUrlsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->urls);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeUrlsData, _data_);
}


static void tpf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeUrlsData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeUrlsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_urls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_urls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = urls;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->urls = _tmp2_;
	tpf_persona_real_change_urls_co (_data_);
}


static void tpf_persona_real_change_urls_finish (FolksUrlDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeUrlsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeUrlsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_urls_co (_data_);
}


static gboolean tpf_persona_real_change_urls_co (TpfPersonaChangeUrlsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->urls;
	_data_->_tmp1_ = _data_->self->priv->_urls;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "url", tpf_persona_change_urls_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_change_details_data_free (gpointer _data) {
	TpfPersonaChangeDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->details);
	_g_object_unref0 (_data_->member_set);
	_g_free0 (_data_->field_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeDetailsData, _data_);
}


static void _tpf_persona_change_details (TpfPersona* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeSet* details, GeeSet* member_set, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaChangeDetailsData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_data_ = g_slice_new0 (TpfPersonaChangeDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_change_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_change_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	_tmp3_ = member_set;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->member_set = _tmp4_;
	_tmp5_ = field_name;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->field_name = _tmp6_;
	_data_->t_type = t_type;
	_data_->t_dup_func = t_dup_func;
	_data_->t_destroy_func = t_destroy_func;
	_tpf_persona_change_details_co (_data_);
}


static void _tpf_persona_change_details_finish (TpfPersona* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_change_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_change_details_co (_data_);
}


static gboolean _tpf_persona_change_details_co (TpfPersonaChangeDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (TPF_IS_PERSONA_STORE (_data_->_tmp1_) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->details;
	_data_->_tmp4_ = _data_->member_set;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = folks_internal_equal_sets (_data_->t_type, (GBoxedCopyFunc) _data_->t_dup_func, _data_->t_destroy_func, _data_->_tmp3_, _data_->_tmp4_);
	if (_data_->_tmp5_) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp6_) {
		{
			_data_->_tmp7_ = _data_->tpf_store;
			_data_->_tmp8_ = _data_->details;
			_data_->_tmp9_ = _data_->field_name;
			_data_->_state_ = 1;
			_tpf_persona_store_change_user_details (_data_->_tmp7_, _data_->self, _data_->_tmp8_, _data_->_tmp9_, _tpf_persona_change_details_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_change_user_details_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch2_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch2_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch2_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally2;
		__catch2_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp10_ = _data_->e1;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			_data_->_tmp12_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp11_);
			_data_->_inner_error_ = _data_->_tmp12_;
			_g_error_free0 (_data_->e1);
			goto __finally2;
		}
		goto __finally2;
		__catch2_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp13_ = _data_->e2;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			_data_->_tmp15_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp14_);
			_data_->_inner_error_ = _data_->_tmp15_;
			_g_error_free0 (_data_->e2);
			goto __finally2;
		}
		goto __finally2;
		__catch2_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp16_ = _data_->e3;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			_data_->_tmp18_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp17_);
			_data_->_inner_error_ = _data_->_tmp18_;
			_g_error_free0 (_data_->e3);
			goto __finally2;
		}
		__finally2:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the Telepathy contact given by `contact`.
   *
   * @param contact the Telepathy contact being represented by the persona
   * @param store the persona store to place the persona in
   */
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store) {
	TpfPersona * self = NULL;
	TpContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* id;
	TpContact* _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* _tmp5_;
	TpConnection* connection;
	TpAccount* _tmp6_ = NULL;
	TpAccount* account;
	TpfPersonaStore* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	TpfPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* uid;
	TpContact* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	TpfPersonaStore* _tmp20_;
	TpContact* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_identifier (_tmp0_);
	id = _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = tp_contact_get_connection (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	connection = _tmp5_;
	_tmp6_ = _tpf_persona_account_for_connection (connection);
	account = _tmp6_;
	_tmp7_ = store;
	_tmp8_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = store;
	_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = folks_persona_build_uid (_tmp9_, _tmp12_, id);
	uid = _tmp13_;
	_tmp14_ = contact;
	_tmp15_ = tp_account_get_protocol (account);
	_tmp16_ = g_strconcat (_tmp15_, ":", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, id, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = store;
	_tmp21_ = contact;
	_tmp22_ = tp_contact_get_handle (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = tp_connection_get_self_handle (connection);
	_tmp25_ = _tmp24_;
	self = (TpfPersona*) g_object_new (object_type, "contact", _tmp14_, "display-id", id, "iid", _tmp19_, "uid", uid, "store", _tmp20_, "is-user", _tmp23_ == _tmp25_, NULL);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	g_debug ("tpf-persona.vala:631: Created new Tpf.Persona '%s' for service-specifi" \
"c UID '%s': %p", uid, id, self);
	_g_free0 (uid);
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	return self;
}


TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store) {
	return tpf_persona_construct (TPF_TYPE_PERSONA, contact, store);
}


static void tpf_persona_real_constructed (GObject* base) {
	TpfPersona * self;
	self = (TpfPersona*) base;
	self->priv->_is_constructed = TRUE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _tpf_persona_store_notify_supported_fields (TpfPersona* self) {
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	gchar** _tmp3_;
	gint _tmp3__length1;
	TpfPersonaStore* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	TpfPersonaStore* _tmp10_;
	GeeSet* _tmp11_;
	GeeSet* _tmp12_;
	gboolean _tmp13_ = FALSE;
	TpfPersonaStore* _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	gboolean _tmp19_ = FALSE;
	TpfPersonaStore* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	gboolean _tmp25_ = FALSE;
	TpfPersonaStore* _tmp28_;
	GeeSet* _tmp29_;
	GeeSet* _tmp30_;
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (TPF_IS_PERSONA_STORE (_tmp1_) ? ((TpfPersonaStore*) _tmp1_) : NULL);
	tpf_store = _tmp2_;
	_tmp3_ = (TPF_PERSONA__always_writeable_properties != NULL) ? _vala_array_dup1 (TPF_PERSONA__always_writeable_properties, G_N_ELEMENTS (TPF_PERSONA__always_writeable_properties)) : ((gpointer) TPF_PERSONA__always_writeable_properties);
	_tmp3__length1 = G_N_ELEMENTS (TPF_PERSONA__always_writeable_properties);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp3_;
	self->priv->_writeable_properties_length1 = _tmp3__length1;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_tmp4_ = tpf_store;
	_tmp5_ = tpf_persona_store_get_supported_fields (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp6_, "bday");
	if (_tmp7_) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		_tmp8_ = self->priv->_writeable_properties;
		_tmp8__length1 = self->priv->_writeable_properties_length1;
		_tmp9_ = g_strdup ("birthday");
		_vala_array_add1 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp9_);
	}
	_tmp10_ = tpf_store;
	_tmp11_ = tpf_persona_store_get_supported_fields (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_collection_contains ((GeeCollection*) _tmp12_, "email");
	if (_tmp13_) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		_tmp14_ = self->priv->_writeable_properties;
		_tmp14__length1 = self->priv->_writeable_properties_length1;
		_tmp15_ = g_strdup ("email-addresses");
		_vala_array_add2 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp15_);
	}
	_tmp16_ = tpf_store;
	_tmp17_ = tpf_persona_store_get_supported_fields (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_collection_contains ((GeeCollection*) _tmp18_, "fn");
	if (_tmp19_) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		_tmp20_ = self->priv->_writeable_properties;
		_tmp20__length1 = self->priv->_writeable_properties_length1;
		_tmp21_ = g_strdup ("full-name");
		_vala_array_add3 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp21_);
	}
	_tmp22_ = tpf_store;
	_tmp23_ = tpf_persona_store_get_supported_fields (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = gee_collection_contains ((GeeCollection*) _tmp24_, "tel");
	if (_tmp25_) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		_tmp26_ = self->priv->_writeable_properties;
		_tmp26__length1 = self->priv->_writeable_properties_length1;
		_tmp27_ = g_strdup ("phone-numbers");
		_vala_array_add4 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp27_);
	}
	_tmp28_ = tpf_store;
	_tmp29_ = tpf_persona_store_get_supported_fields (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp30_, "url");
	if (_tmp31_) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		_tmp32_ = self->priv->_writeable_properties;
		_tmp32__length1 = self->priv->_writeable_properties_length1;
		_tmp33_ = g_strdup ("urls");
		_vala_array_add5 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp33_);
	}
	_g_object_unref0 (tpf_store);
}


static void _tpf_persona_contact_notify_contact_info (TpfPersona* self) {
	gchar* _tmp0_;
	gchar* new_birthday_str;
	gchar* _tmp1_;
	gchar* new_full_name;
	GeeHashSet* _tmp2_;
	GeeHashSet* new_email_addresses;
	GeeHashSet* _tmp3_;
	GeeHashSet* new_phone_numbers;
	GeeHashSet* _tmp4_;
	GeeHashSet* new_urls;
	TpContact* _tmp5_;
	TpContact* _tmp6_;
	GList* _tmp7_ = NULL;
	GList* contact_info;
	GList* _tmp8_;
	const gchar* _tmp69_;
	GeeHashSet* _tmp89_;
	GeeHashSet* _tmp90_;
	gboolean _tmp91_ = FALSE;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	GeeHashSet* _tmp101_;
	GeeHashSet* _tmp102_;
	gboolean _tmp103_ = FALSE;
	GeeHashSet* _tmp109_;
	GeeHashSet* _tmp110_;
	gboolean _tmp111_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	new_birthday_str = _tmp0_;
	_tmp1_ = g_strdup ("");
	new_full_name = _tmp1_;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	new_email_addresses = _tmp2_;
	_tmp3_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	new_phone_numbers = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	new_urls = _tmp4_;
	_tmp5_ = tpf_persona_get_contact (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = tp_contact_get_contact_info (_tmp6_);
	contact_info = _tmp7_;
	_tmp8_ = contact_info;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp8_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			TpContactInfoField* info = NULL;
			info = (TpContactInfoField*) info_it->data;
			{
				TpContactInfoField* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = info;
				_tmp10_ = _tmp9_->field_name;
				if (g_strcmp0 (_tmp10_, "") == 0) {
				} else {
					TpContactInfoField* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = info;
					_tmp12_ = _tmp11_->field_name;
					if (g_strcmp0 (_tmp12_, "bday") == 0) {
						TpContactInfoField* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp13_ = info;
						_tmp14_ = _tmp13_->field_value;
						_tmp14__length1 = _vala_array_length (_tmp13_->field_value);
						_tmp15_ = _tmp14_[0];
						_tmp16_ = g_strdup (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = _tmp17_;
						if (_tmp18_ == NULL) {
							gchar* _tmp19_;
							_tmp19_ = g_strdup ("");
							_g_free0 (_tmp17_);
							_tmp17_ = _tmp19_;
						}
						_tmp20_ = _tmp17_;
						_tmp21_ = g_strdup (_tmp20_);
						_g_free0 (new_birthday_str);
						new_birthday_str = _tmp21_;
						_g_free0 (_tmp17_);
					} else {
						TpContactInfoField* _tmp22_;
						const gchar* _tmp23_;
						_tmp22_ = info;
						_tmp23_ = _tmp22_->field_name;
						if (g_strcmp0 (_tmp23_, "email") == 0) {
							TpContactInfoField* _tmp24_;
							gchar** _tmp25_;
							gint _tmp25__length1;
							_tmp24_ = info;
							_tmp25_ = _tmp24_->field_value;
							_tmp25__length1 = _vala_array_length (_tmp24_->field_value);
							{
								gchar** email_addr_collection = NULL;
								gint email_addr_collection_length1 = 0;
								gint _email_addr_collection_size_ = 0;
								gint email_addr_it = 0;
								email_addr_collection = _tmp25_;
								email_addr_collection_length1 = _tmp25__length1;
								for (email_addr_it = 0; email_addr_it < _tmp25__length1; email_addr_it = email_addr_it + 1) {
									gchar* _tmp26_;
									gchar* email_addr = NULL;
									_tmp26_ = g_strdup (email_addr_collection[email_addr_it]);
									email_addr = _tmp26_;
									{
										TpContactInfoField* _tmp27_;
										gchar** _tmp28_;
										gint _tmp28__length1;
										GeeMultiMap* _tmp29_ = NULL;
										GeeMultiMap* parameters;
										const gchar* _tmp30_;
										GeeMultiMap* _tmp31_;
										FolksEmailFieldDetails* _tmp32_;
										FolksEmailFieldDetails* email_fd;
										GeeHashSet* _tmp33_;
										FolksEmailFieldDetails* _tmp34_;
										_tmp27_ = info;
										_tmp28_ = _tmp27_->parameters;
										_tmp28__length1 = _vala_array_length (_tmp27_->parameters);
										_tmp29_ = _tpf_persona_afd_params_from_strv (self, _tmp28_, _tmp28__length1);
										parameters = _tmp29_;
										_tmp30_ = email_addr;
										_tmp31_ = parameters;
										_tmp32_ = folks_email_field_details_new (_tmp30_, _tmp31_);
										email_fd = _tmp32_;
										_tmp33_ = new_email_addresses;
										_tmp34_ = email_fd;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
										_g_object_unref0 (email_fd);
										_g_object_unref0 (parameters);
										_g_free0 (email_addr);
									}
								}
							}
						} else {
							TpContactInfoField* _tmp35_;
							const gchar* _tmp36_;
							_tmp35_ = info;
							_tmp36_ = _tmp35_->field_name;
							if (g_strcmp0 (_tmp36_, "fn") == 0) {
								TpContactInfoField* _tmp37_;
								gchar** _tmp38_;
								gint _tmp38__length1;
								const gchar* _tmp39_;
								gchar* _tmp40_;
								const gchar* _tmp41_;
								_tmp37_ = info;
								_tmp38_ = _tmp37_->field_value;
								_tmp38__length1 = _vala_array_length (_tmp37_->field_value);
								_tmp39_ = _tmp38_[0];
								_tmp40_ = g_strdup (_tmp39_);
								_g_free0 (new_full_name);
								new_full_name = _tmp40_;
								_tmp41_ = new_full_name;
								if (_tmp41_ == NULL) {
									gchar* _tmp42_;
									_tmp42_ = g_strdup ("");
									_g_free0 (new_full_name);
									new_full_name = _tmp42_;
								}
							} else {
								TpContactInfoField* _tmp43_;
								const gchar* _tmp44_;
								_tmp43_ = info;
								_tmp44_ = _tmp43_->field_name;
								if (g_strcmp0 (_tmp44_, "tel") == 0) {
									TpContactInfoField* _tmp45_;
									gchar** _tmp46_;
									gint _tmp46__length1;
									_tmp45_ = info;
									_tmp46_ = _tmp45_->field_value;
									_tmp46__length1 = _vala_array_length (_tmp45_->field_value);
									{
										gchar** phone_num_collection = NULL;
										gint phone_num_collection_length1 = 0;
										gint _phone_num_collection_size_ = 0;
										gint phone_num_it = 0;
										phone_num_collection = _tmp46_;
										phone_num_collection_length1 = _tmp46__length1;
										for (phone_num_it = 0; phone_num_it < _tmp46__length1; phone_num_it = phone_num_it + 1) {
											gchar* _tmp47_;
											gchar* phone_num = NULL;
											_tmp47_ = g_strdup (phone_num_collection[phone_num_it]);
											phone_num = _tmp47_;
											{
												TpContactInfoField* _tmp48_;
												gchar** _tmp49_;
												gint _tmp49__length1;
												GeeMultiMap* _tmp50_ = NULL;
												GeeMultiMap* parameters;
												const gchar* _tmp51_;
												GeeMultiMap* _tmp52_;
												FolksPhoneFieldDetails* _tmp53_;
												FolksPhoneFieldDetails* phone_fd;
												GeeHashSet* _tmp54_;
												FolksPhoneFieldDetails* _tmp55_;
												_tmp48_ = info;
												_tmp49_ = _tmp48_->parameters;
												_tmp49__length1 = _vala_array_length (_tmp48_->parameters);
												_tmp50_ = _tpf_persona_afd_params_from_strv (self, _tmp49_, _tmp49__length1);
												parameters = _tmp50_;
												_tmp51_ = phone_num;
												_tmp52_ = parameters;
												_tmp53_ = folks_phone_field_details_new (_tmp51_, _tmp52_);
												phone_fd = _tmp53_;
												_tmp54_ = new_phone_numbers;
												_tmp55_ = phone_fd;
												gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp55_);
												_g_object_unref0 (phone_fd);
												_g_object_unref0 (parameters);
												_g_free0 (phone_num);
											}
										}
									}
								} else {
									TpContactInfoField* _tmp56_;
									const gchar* _tmp57_;
									_tmp56_ = info;
									_tmp57_ = _tmp56_->field_name;
									if (g_strcmp0 (_tmp57_, "url") == 0) {
										TpContactInfoField* _tmp58_;
										gchar** _tmp59_;
										gint _tmp59__length1;
										_tmp58_ = info;
										_tmp59_ = _tmp58_->field_value;
										_tmp59__length1 = _vala_array_length (_tmp58_->field_value);
										{
											gchar** url_collection = NULL;
											gint url_collection_length1 = 0;
											gint _url_collection_size_ = 0;
											gint url_it = 0;
											url_collection = _tmp59_;
											url_collection_length1 = _tmp59__length1;
											for (url_it = 0; url_it < _tmp59__length1; url_it = url_it + 1) {
												gchar* _tmp60_;
												gchar* url = NULL;
												_tmp60_ = g_strdup (url_collection[url_it]);
												url = _tmp60_;
												{
													TpContactInfoField* _tmp61_;
													gchar** _tmp62_;
													gint _tmp62__length1;
													GeeMultiMap* _tmp63_ = NULL;
													GeeMultiMap* parameters;
													const gchar* _tmp64_;
													GeeMultiMap* _tmp65_;
													FolksUrlFieldDetails* _tmp66_;
													FolksUrlFieldDetails* url_fd;
													GeeHashSet* _tmp67_;
													FolksUrlFieldDetails* _tmp68_;
													_tmp61_ = info;
													_tmp62_ = _tmp61_->parameters;
													_tmp62__length1 = _vala_array_length (_tmp61_->parameters);
													_tmp63_ = _tpf_persona_afd_params_from_strv (self, _tmp62_, _tmp62__length1);
													parameters = _tmp63_;
													_tmp64_ = url;
													_tmp65_ = parameters;
													_tmp66_ = folks_url_field_details_new (_tmp64_, _tmp65_);
													url_fd = _tmp66_;
													_tmp67_ = new_urls;
													_tmp68_ = url_fd;
													gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
													_g_object_unref0 (url_fd);
													_g_object_unref0 (parameters);
													_g_free0 (url);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp69_ = new_birthday_str;
	if (g_strcmp0 (_tmp69_, "") != 0) {
		GTimeVal timeval = {0};
		const gchar* _tmp70_;
		gboolean _tmp71_ = FALSE;
		g_get_current_time (&timeval);
		_tmp70_ = new_birthday_str;
		_tmp71_ = g_time_val_from_iso8601 (_tmp70_, &timeval);
		if (_tmp71_) {
			GTimeVal _tmp72_;
			GDateTime* _tmp73_;
			GDateTime* d;
			gboolean _tmp74_ = FALSE;
			GDateTime* _tmp75_;
			gboolean _tmp84_;
			_tmp72_ = timeval;
			_tmp73_ = g_date_time_new_from_timeval_utc (&_tmp72_);
			d = _tmp73_;
			_tmp75_ = self->priv->_birthday;
			if (_tmp75_ == NULL) {
				_tmp74_ = TRUE;
			} else {
				gboolean _tmp76_ = FALSE;
				GDateTime* _tmp77_;
				gboolean _tmp83_;
				_tmp77_ = self->priv->_birthday;
				if (_tmp77_ != NULL) {
					GDateTime* _tmp78_;
					GDateTime* _tmp79_;
					GDateTime* _tmp80_ = NULL;
					GDateTime* _tmp81_;
					gboolean _tmp82_ = FALSE;
					_tmp78_ = self->priv->_birthday;
					_tmp79_ = d;
					_tmp80_ = g_date_time_to_utc (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_date_time_equal (_tmp78_, _tmp81_);
					_tmp76_ = !_tmp82_;
					_g_date_time_unref0 (_tmp81_);
				} else {
					_tmp76_ = FALSE;
				}
				_tmp83_ = _tmp76_;
				_tmp74_ = _tmp83_;
			}
			_tmp84_ = _tmp74_;
			if (_tmp84_) {
				GDateTime* _tmp85_;
				GDateTime* _tmp86_ = NULL;
				_tmp85_ = d;
				_tmp86_ = g_date_time_to_utc (_tmp85_);
				_g_date_time_unref0 (self->priv->_birthday);
				self->priv->_birthday = _tmp86_;
				g_object_notify ((GObject*) self, "birthday");
			}
			_g_date_time_unref0 (d);
		} else {
			const gchar* _tmp87_;
			_tmp87_ = new_birthday_str;
			g_warning ("tpf-persona.vala:841: Failed to parse new birthday string '%s'", _tmp87_);
		}
	} else {
		GDateTime* _tmp88_;
		_tmp88_ = self->priv->_birthday;
		if (_tmp88_ != NULL) {
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = NULL;
			g_object_notify ((GObject*) self, "birthday");
		}
	}
	_tmp89_ = new_email_addresses;
	_tmp90_ = self->priv->_email_addresses;
	_tmp91_ = folks_internal_equal_sets (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp89_, (GeeSet*) _tmp90_);
	if (!_tmp91_) {
		GeeHashSet* _tmp92_;
		GeeHashSet* _tmp93_;
		GeeHashSet* _tmp94_;
		GeeSet* _tmp95_;
		GeeSet* _tmp96_;
		_tmp92_ = new_email_addresses;
		_tmp93_ = _g_object_ref0 (_tmp92_);
		_g_object_unref0 (self->priv->_email_addresses);
		self->priv->_email_addresses = _tmp93_;
		_tmp94_ = new_email_addresses;
		_tmp95_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp94_);
		_tmp96_ = _tmp95_;
		_g_object_unref0 (self->priv->_email_addresses_ro);
		self->priv->_email_addresses_ro = _tmp96_;
		g_object_notify ((GObject*) self, "email-addresses");
	}
	_tmp97_ = new_full_name;
	_tmp98_ = self->priv->_full_name;
	if (g_strcmp0 (_tmp97_, _tmp98_) != 0) {
		const gchar* _tmp99_;
		gchar* _tmp100_;
		_tmp99_ = new_full_name;
		_tmp100_ = g_strdup (_tmp99_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp100_;
		g_object_notify ((GObject*) self, "full-name");
	}
	_tmp101_ = new_phone_numbers;
	_tmp102_ = self->priv->_phone_numbers;
	_tmp103_ = folks_internal_equal_sets (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp101_, (GeeSet*) _tmp102_);
	if (!_tmp103_) {
		GeeHashSet* _tmp104_;
		GeeHashSet* _tmp105_;
		GeeHashSet* _tmp106_;
		GeeSet* _tmp107_;
		GeeSet* _tmp108_;
		_tmp104_ = new_phone_numbers;
		_tmp105_ = _g_object_ref0 (_tmp104_);
		_g_object_unref0 (self->priv->_phone_numbers);
		self->priv->_phone_numbers = _tmp105_;
		_tmp106_ = new_phone_numbers;
		_tmp107_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp106_);
		_tmp108_ = _tmp107_;
		_g_object_unref0 (self->priv->_phone_numbers_ro);
		self->priv->_phone_numbers_ro = _tmp108_;
		g_object_notify ((GObject*) self, "phone-numbers");
	}
	_tmp109_ = new_urls;
	_tmp110_ = self->priv->_urls;
	_tmp111_ = folks_internal_equal_sets (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp109_, (GeeSet*) _tmp110_);
	if (!_tmp111_) {
		GeeHashSet* _tmp112_;
		GeeHashSet* _tmp113_;
		GeeHashSet* _tmp114_;
		GeeSet* _tmp115_;
		GeeSet* _tmp116_;
		_tmp112_ = new_urls;
		_tmp113_ = _g_object_ref0 (_tmp112_);
		_g_object_unref0 (self->priv->_urls);
		self->priv->_urls = _tmp113_;
		_tmp114_ = new_urls;
		_tmp115_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp114_);
		_tmp116_ = _tmp115_;
		_g_object_unref0 (self->priv->_urls_ro);
		self->priv->_urls_ro = _tmp116_;
		g_object_notify ((GObject*) self, "urls");
	}
	_g_list_free0 (contact_info);
	_g_object_unref0 (new_urls);
	_g_object_unref0 (new_phone_numbers);
	_g_object_unref0 (new_email_addresses);
	_g_free0 (new_full_name);
	_g_free0 (new_birthday_str);
}


static GeeMultiMap* _tpf_persona_afd_params_from_strv (TpfPersona* self, gchar** parameters, int parameters_length1) {
	GeeMultiMap* result = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* retval;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	retval = _tmp0_;
	_tmp1_ = parameters;
	_tmp1__length1 = parameters_length1;
	{
		gchar** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp1_;
		entry_collection_length1 = _tmp1__length1;
		for (entry_it = 0; entry_it < _tmp1__length1; entry_it = entry_it + 1) {
			gchar* _tmp2_;
			gchar* entry = NULL;
			_tmp2_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp2_;
			{
				const gchar* _tmp3_;
				gchar** _tmp4_;
				gchar** _tmp5_ = NULL;
				gchar** tokens;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp6_;
				gint _tmp6__length1;
				_tmp3_ = entry;
				_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "=", 2);
				tokens = _tmp5_;
				tokens_length1 = _vala_array_length (_tmp4_);
				_tokens_size_ = tokens_length1;
				_tmp6_ = tokens;
				_tmp6__length1 = tokens_length1;
				if (_tmp6__length1 == 2) {
					GeeHashMultiMap* _tmp7_;
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					_tmp7_ = retval;
					_tmp8_ = tokens;
					_tmp8__length1 = tokens_length1;
					_tmp9_ = _tmp8_[0];
					_tmp10_ = tokens;
					_tmp10__length1 = tokens_length1;
					_tmp11_ = _tmp10_[1];
					gee_multi_map_set ((GeeMultiMap*) _tmp7_, _tmp9_, _tmp11_);
				} else {
					const gchar* _tmp12_;
					_tmp12_ = entry;
					g_warning ("tpf-persona.vala:897: Failed to parse vCard parameter from string '%s'", _tmp12_);
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (entry);
			}
		}
	}
	result = (GeeMultiMap*) retval;
	return result;
}


/**
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * a cached contact for which we currently have no Telepathy contact.
   *
   * @param store The persona store to place the persona in.
   * @param uid The cached UID of the persona.
   * @param iid The cached IID of the persona.
   * @param im_address The cached IM address of the persona (excluding
   * protocol).
   * @param protocol The cached protocol of the persona.
   * @param groups The cached set of groups the persona is in.
   * @param is_favourite Whether the persona is a favourite.
   * @param alias The cached alias for the persona.
   * @param is_in_contact_list Whether the persona is in the user's contact
   * list.
   * @param is_user Whether the persona is the user.
   * @param avatar The icon for the persona's cached avatar, or `null` if they
   * have no avatar.
   * @param birthday The date/time of birth of the persona, or `null` if it's
   * unknown.
   * @param full_name The persona's full name, or the empty string if it's
   * unknown.
   * @param email_addresses A set of the persona's e-mail addresses, which may
   * be empty (but may not be `null`).
   * @param phone_numbers A set of the persona's phone numbers, which may be
   * empty (but may not be `null`).
   * @param urls A set of the persona's URLs, which may be empty (but may not be
   * `null`).
   * @return A new {@link Tpf.Persona} representing the cached persona.
   *
   * @since 0.6.0
   */
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls) {
	TpfPersona * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TpfPersonaStore* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksImFieldDetails* _tmp7_;
	FolksImFieldDetails* im_fd;
	GeeHashMultiMap* _tmp8_;
	const gchar* _tmp9_;
	FolksImFieldDetails* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_;
	GeeHashSet* _tmp16_;
	GeeHashSet* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	GeeHashSet* _tmp21_;
	GeeHashSet* _tmp22_;
	GeeHashSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeSet* _tmp25_;
	GeeHashSet* _tmp26_;
	GeeHashSet* _tmp27_;
	GeeHashSet* _tmp28_;
	GeeSet* _tmp29_;
	GeeSet* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GLoadableIcon* _tmp37_;
	GLoadableIcon* _tmp38_;
	GDateTime* _tmp39_;
	GDateTime* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (iid != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (groups != NULL, NULL);
	g_return_val_if_fail (alias != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	g_return_val_if_fail (email_addresses != NULL, NULL);
	g_return_val_if_fail (phone_numbers != NULL, NULL);
	g_return_val_if_fail (urls != NULL, NULL);
	_tmp0_ = im_address;
	_tmp1_ = iid;
	_tmp2_ = uid;
	_tmp3_ = store;
	_tmp4_ = is_user;
	self = (TpfPersona*) g_object_new (object_type, "contact", NULL, "display-id", _tmp0_, "iid", _tmp1_, "uid", _tmp2_, "store", _tmp3_, "is-user", _tmp4_, NULL);
	_tmp5_ = uid;
	g_debug ("tpf-persona.vala:951: Created new Tpf.Persona '%s' from cache: %p", _tmp5_, self);
	_tmp6_ = im_address;
	_tmp7_ = folks_im_field_details_new (_tmp6_, NULL);
	im_fd = _tmp7_;
	_tmp8_ = self->priv->_im_addresses;
	_tmp9_ = protocol;
	_tmp10_ = im_fd;
	gee_multi_map_set ((GeeMultiMap*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = groups;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp12_;
	_tmp13_ = self->priv->_groups;
	_tmp14_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp15_;
	_tmp16_ = email_addresses;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp17_;
	_tmp18_ = self->priv->_email_addresses;
	_tmp19_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp20_;
	_tmp21_ = phone_numbers;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp22_;
	_tmp23_ = self->priv->_phone_numbers;
	_tmp24_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp23_);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp25_;
	_tmp26_ = urls;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp27_;
	_tmp28_ = self->priv->_urls;
	_tmp29_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp28_);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp30_;
	_tmp31_ = alias;
	if (_tmp31_ == NULL) {
		alias = "";
	}
	_tmp32_ = full_name;
	if (_tmp32_ == NULL) {
		full_name = "";
	}
	_tmp33_ = alias;
	_tmp34_ = g_strdup (_tmp33_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp34_;
	_tmp35_ = is_favourite;
	self->priv->_is_favourite = _tmp35_;
	_tmp36_ = is_in_contact_list;
	tpf_persona_set_is_in_contact_list (self, _tmp36_);
	_tmp37_ = avatar;
	_tmp38_ = _g_object_ref0 (_tmp37_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp38_;
	_tmp39_ = birthday;
	_tmp40_ = _g_date_time_ref0 (_tmp39_);
	_g_date_time_unref0 (self->priv->_birthday);
	self->priv->_birthday = _tmp40_;
	_tmp41_ = full_name;
	_tmp42_ = g_strdup (_tmp41_);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp42_;
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, FOLKS_PRESENCE_TYPE_OFFLINE);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, "");
	_g_object_unref0 (im_fd);
	return self;
}


TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls) {
	return tpf_persona_construct_from_cache (TPF_TYPE_PERSONA, store, uid, iid, im_address, protocol, groups, is_favourite, alias, is_in_contact_list, is_user, avatar, birthday, full_name, email_addresses, phone_numbers, urls);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->account_found);
		_g_object_unref0 (_data1_->conn);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda20_ (Block1Data* _data1_, TpAccount* l) {
	TpAccount* _tmp0_;
	TpAccount* account;
	TpAccount* _tmp1_;
	TpConnection* _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	account = TP_ACCOUNT (_tmp0_);
	_tmp1_ = account;
	_tmp2_ = tp_account_get_connection (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->conn;
	if (_tmp3_ == _tmp4_) {
		TpAccount* _tmp5_;
		TpAccount* _tmp6_;
		_tmp5_ = account;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (_data1_->account_found);
		_data1_->account_found = _tmp6_;
		return;
	}
}


static void ___lambda20__gfunc (gconstpointer data, gpointer self) {
	__lambda20_ (self, data);
}


static TpAccount* _tpf_persona_account_for_connection (TpConnection* conn) {
	TpAccount* result = NULL;
	Block1Data* _data1_;
	TpConnection* _tmp0_;
	TpConnection* _tmp1_;
	TpAccountManager* _tmp2_ = NULL;
	TpAccountManager* manager;
	GList* _tmp3_ = NULL;
	GList* accounts;
	TpAccount* _tmp4_;
	g_return_val_if_fail (conn != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = conn;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data1_->conn = _tmp1_;
	_tmp2_ = tp_account_manager_dup ();
	manager = _tmp2_;
	_tmp3_ = tp_account_manager_get_valid_accounts (manager);
	accounts = _tmp3_;
	_data1_->account_found = NULL;
	g_list_foreach (accounts, ___lambda20__gfunc, _data1_);
	_tmp4_ = _g_object_ref0 (_data1_->account_found);
	result = _tmp4_;
	_g_list_free0 (accounts);
	_g_object_unref0 (manager);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void _tpf_persona_contact_notify_presence_message (TpfPersona* self) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_get_contact (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_contact_get_presence_message (_tmp1_);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, _tmp2_);
}


static void _tpf_persona_contact_notify_presence_type (TpfPersona* self) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	TpConnectionPresenceType _tmp2_ = 0;
	FolksPresenceType _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_get_contact (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_contact_get_presence_type (_tmp1_);
	_tmp3_ = _tpf_persona_folks_presence_type_from_tp (_tmp2_);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, _tmp3_);
}


static void _tpf_persona_contact_notify_presence_status (TpfPersona* self) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_get_contact (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_contact_get_presence_status (_tmp1_);
	folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, _tmp2_);
}


static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type) {
	FolksPresenceType result = 0;
	TpConnectionPresenceType _tmp0_;
	_tmp0_ = type;
	switch (_tmp0_) {
		case TP_CONNECTION_PRESENCE_TYPE_AVAILABLE:
		{
			result = FOLKS_PRESENCE_TYPE_AVAILABLE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_BUSY:
		{
			result = FOLKS_PRESENCE_TYPE_BUSY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_ERROR:
		{
			result = FOLKS_PRESENCE_TYPE_ERROR;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_EXTENDED_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_HIDDEN:
		{
			result = FOLKS_PRESENCE_TYPE_HIDDEN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_OFFLINE:
		{
			result = FOLKS_PRESENCE_TYPE_OFFLINE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNKNOWN:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNSET:
		{
			result = FOLKS_PRESENCE_TYPE_UNSET;
			return result;
		}
		default:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
	}
}


static void _tpf_persona_contact_notify_avatar (TpfPersona* self) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	GIcon* icon;
	GFile* _tmp5_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GLoadableIcon* _tmp10_;
	gboolean _tmp12_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tpf_persona_get_contact (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_contact_get_avatar_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	file = _tmp4_;
	icon = NULL;
	_tmp5_ = file;
	if (_tmp5_ != NULL) {
		GFile* _tmp6_;
		GFileIcon* _tmp7_;
		_tmp6_ = file;
		_tmp7_ = (GFileIcon*) g_file_icon_new (_tmp6_);
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp7_;
	}
	_tmp10_ = self->priv->_avatar;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		GIcon* _tmp11_;
		_tmp11_ = icon;
		_tmp9_ = _tmp11_ == NULL;
	}
	_tmp12_ = _tmp9_;
	if (_tmp12_) {
		_tmp8_ = TRUE;
	} else {
		GLoadableIcon* _tmp13_;
		GIcon* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = self->priv->_avatar;
		_tmp14_ = icon;
		_tmp15_ = g_icon_equal ((GIcon*) _tmp13_, _tmp14_);
		_tmp8_ = !_tmp15_;
	}
	_tmp16_ = _tmp8_;
	if (_tmp16_) {
		GIcon* _tmp17_;
		GLoadableIcon* _tmp18_;
		_tmp17_ = icon;
		_tmp18_ = _g_object_ref0 (G_LOADABLE_ICON (_tmp17_));
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp18_;
		g_object_notify ((GObject*) self, "avatar");
	}
	_g_object_unref0 (icon);
	_g_object_unref0 (file);
}


/**
   * Look up a {@link Tpf.Persona} by its {@link TelepathyGLib.Contact}.
   *
   * If the {@link TelepathyGLib.Account} for the contact's
   * {@link TelepathyGLib.Connection} is `null`, or if a
   * {@link Tpf.PersonaStore} can't be found for that account, `null` will be
   * returned. Otherwise, if a {@link Tpf.Persona} already exists for the given
   * contact, that will be returned; if one doesn't exist a new one will be
   * created and returned. In this case, the {@link Tpf.Persona} will be added
   * to the {@link PersonaStore} associated with the account, and will be
   * removed when `contact` is destroyed.
   *
   * @param contact the Telepathy contact of the persona
   * @return the persona associated with the contact, or `null`
   * @since 0.6.6
   */
TpfPersona* tpf_persona_dup_for_contact (TpContact* contact) {
	TpfPersona* result = NULL;
	TpContact* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* _tmp2_;
	TpAccount* _tmp3_ = NULL;
	TpAccount* _tmp4_;
	TpAccount* account;
	TpContact* _tmp5_;
	TpAccount* _tmp6_;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpfPersonaStore* _tmp9_ = NULL;
	TpfPersonaStore* store;
	TpfPersonaStore* _tmp10_;
	TpContact* _tmp11_;
	TpfPersona* _tmp12_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_connection (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tp_connection_get_account (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	account = _tmp4_;
	_tmp5_ = contact;
	_tmp6_ = account;
	g_debug ("tpf-persona.vala:1106: Tpf.Persona.dup_for_contact (%p): got account %" \
"p", _tmp5_, _tmp6_);
	_tmp7_ = account;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (account);
		return result;
	}
	_tmp8_ = account;
	_tmp9_ = tpf_persona_store_dup_for_account (_tmp8_);
	store = _tmp9_;
	_tmp10_ = store;
	_tmp11_ = contact;
	_tmp12_ = _tpf_persona_store_ensure_persona_from_contact (_tmp10_, _tmp11_);
	result = _tmp12_;
	_g_object_unref0 (store);
	_g_object_unref0 (account);
	return result;
}


gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_in_contact_list;
	result = _tmp0_;
	return result;
}


void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_in_contact_list = _tmp0_;
	g_object_notify ((GObject *) self, "is-in-contact-list");
}


static GLoadableIcon* tpf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	TpfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	TpfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* tpf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = NULL;
	return result;
}


static void tpf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	TpfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = "";
	return result;
}


static void tpf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_calendar_event_id (FolksBirthdayDetails* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = NULL;
	return result;
}


static void tpf_persona_real_set_calendar_event_id (FolksBirthdayDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_calendar_event_id ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static GDateTime* tpf_persona_real_get_birthday (FolksBirthdayDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_birthday;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_birthday (FolksBirthdayDetails* base, GDateTime* value) {
	TpfPersona* self;
	GDateTime* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_birthday ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static FolksPresenceType tpf_persona_real_get_presence_type (FolksPresenceDetails* base) {
	FolksPresenceType result;
	TpfPersona* self;
	FolksPresenceType _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_type;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_type (FolksPresenceDetails* base, FolksPresenceType value) {
	TpfPersona* self;
	FolksPresenceType _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	self->priv->_presence_type = _tmp0_;
	g_object_notify ((GObject *) self, "presence-type");
}


static const gchar* tpf_persona_real_get_presence_status (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_status;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_status (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_status);
	self->priv->_presence_status = _tmp1_;
	g_object_notify ((GObject *) self, "presence-status");
}


static const gchar* tpf_persona_real_get_presence_message (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_message;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_message (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_message);
	self->priv->_presence_message = _tmp1_;
	g_object_notify ((GObject *) self, "presence-message");
}


static gchar** tpf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TpfPersona*) base;
	_tmp0_ = TPF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TPF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	self = (TpfPersona*) base;
	_tmp0_ = folks_persona_get_is_user ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = self->priv->_writeable_properties;
		_tmp2__length1 = self->priv->_writeable_properties_length1;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp2__length1;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = TPF_PERSONA__always_writeable_properties;
	_tmp4__length1 = G_N_ELEMENTS (TPF_PERSONA__always_writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static const gchar* tpf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_alias;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_alias_details_change_alias ((FolksAliasDetails*) self, _tmp0_, NULL, NULL);
}


static gboolean tpf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TpfPersona* self;
	gboolean _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TpfPersona* self;
	gboolean _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_favourite_details_change_is_favourite ((FolksFavouriteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* tpf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TpfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void tpf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TpfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_groups (FolksGroupDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_groups_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_groups (FolksGroupDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_group_details_change_groups ((FolksGroupDetails*) self, _tmp0_, NULL, NULL);
}


TpContact* tpf_persona_get_contact (TpfPersona* self) {
	TpContact* result;
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_contact;
	result = _tmp1_;
	return result;
}


static void tpf_persona_set_contact (TpfPersona* self, TpContact* value) {
	TpContact* _tmp0_;
	TpContact* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ != NULL) {
		TpContact* _tmp1_;
		_tmp1_ = value;
		g_object_weak_ref ((GObject*) _tmp1_, __tpf_persona_contact_weak_notify_cb_gweak_notify, self);
	}
	_tmp2_ = value;
	self->priv->_contact = _tmp2_;
	g_object_notify ((GObject *) self, "contact");
}


static GeeSet* tpf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static void _tpf_persona___lambda21_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	TpContact* _tmp5_;
	TpContact* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = tpf_persona_get_contact (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tp_contact_get_alias (_tmp1_);
	_tmp3_ = _tmp2_;
	g_assert (_tmp3_ != NULL);
	_tmp4_ = self->priv->_alias;
	_tmp5_ = tpf_persona_get_contact (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = tp_contact_get_alias (_tmp6_);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp4_, _tmp8_) != 0) {
		TpContact* _tmp9_;
		TpContact* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = tpf_persona_get_contact (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = tp_contact_get_alias (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp13_;
		g_object_notify ((GObject*) self, "alias");
	}
}


static void __tpf_persona___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda21_ (self, _sender, pspec);
}


static void _tpf_persona___lambda22_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_avatar (self);
}


static void __tpf_persona___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda22_ (self, _sender, pspec);
}


static void _tpf_persona___lambda23_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_message (self);
}


static void __tpf_persona___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda23_ (self, _sender, pspec);
}


static void _tpf_persona___lambda24_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_type (self);
}


static void __tpf_persona___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda24_ (self, _sender, pspec);
}


static void _tpf_persona___lambda25_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_status (self);
}


static void __tpf_persona___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda25_ (self, _sender, pspec);
}


static void _tpf_persona___lambda26_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_contact_info (self);
}


static void __tpf_persona___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda26_ (self, _sender, pspec);
}


static void _tpf_persona___lambda27_ (TpfPersona* self, TpfPersonaStore* s, const gchar* group, GList* added, GList* removed) {
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* _tmp3_;
	GList* _tmp4_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = added;
	_tmp1_ = g_list_find (_tmp0_, self);
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = group;
		_tpf_persona_change_group (self, _tmp2_, TRUE);
	}
	_tmp3_ = removed;
	_tmp4_ = g_list_find (_tmp3_, self);
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = group;
		_tpf_persona_change_group (self, _tmp5_, FALSE);
	}
}


static void __tpf_persona___lambda27__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const gchar* group, GList* added, GList* removed, gpointer self) {
	_tpf_persona___lambda27_ (self, _sender, group, added, removed);
}


static void _tpf_persona___lambda28_ (TpfPersona* self, TpfPersonaStore* s, const gchar* group, GError* _error_) {
	gboolean _tmp0_ = FALSE;
	GError* _tmp1_;
	gboolean _tmp9_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	_tmp1_ = _error_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		GError* _tmp3_;
		GQuark _tmp4_;
		GQuark _tmp5_ = 0U;
		gboolean _tmp8_;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->domain;
		_tmp5_ = tp_dbus_errors_quark ();
		if (_tmp4_ != _tmp5_) {
			_tmp2_ = TRUE;
		} else {
			GError* _tmp6_;
			gint _tmp7_;
			_tmp6_ = _error_;
			_tmp7_ = _tmp6_->code;
			_tmp2_ = _tmp7_ != ((gint) TP_DBUS_ERROR_OBJECT_REMOVED);
		}
		_tmp8_ = _tmp2_;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_debug ("tpf-persona.vala:729: Group invalidated: %s", _tmp11_);
		_tmp12_ = group;
		_tpf_persona_change_group (self, _tmp12_, FALSE);
	}
}


static void __tpf_persona___lambda28__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const gchar* group, GError* _error_, gpointer self) {
	_tpf_persona___lambda28_ (self, _sender, group, _error_);
}


static void _tpf_persona____lambda29_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_store_notify_supported_fields (self);
}


static void __tpf_persona____lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona____lambda29_ (self, _sender, pspec);
}


static GObject * tpf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TpfPersona * self;
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeHashSet* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	TpContact* _tmp12_;
	TpContact* _tmp13_;
	TpContact* _tmp14_;
	TpContact* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	TpContact* _tmp18_;
	TpContact* _tmp19_;
	TpContact* _tmp20_;
	TpContact* _tmp21_;
	TpConnection* _tmp22_;
	TpConnection* _tmp23_;
	TpConnection* _tmp24_;
	TpConnection* connection;
	TpConnection* _tmp25_;
	TpAccount* _tmp26_ = NULL;
	TpAccount* account;
	TpContact* _tmp40_;
	TpContact* _tmp41_;
	TpContact* _tmp42_;
	TpContact* _tmp43_;
	TpContact* _tmp44_;
	TpContact* _tmp45_;
	TpContact* _tmp46_;
	TpContact* _tmp47_;
	TpContact* _tmp48_;
	TpContact* _tmp49_;
	FolksPersonaStore* _tmp50_;
	FolksPersonaStore* _tmp51_;
	FolksPersonaStore* _tmp52_;
	FolksPersonaStore* _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (tpf_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TPF_PERSONA (obj);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp2_;
	_tmp3_ = self->priv->_email_addresses;
	_tmp4_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp5_;
	_tmp6_ = self->priv->_phone_numbers;
	_tmp7_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp8_;
	_tmp9_ = self->priv->_urls;
	_tmp10_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp11_;
	_tmp12_ = tpf_persona_get_contact (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		return obj;
	}
	_tmp14_ = tpf_persona_get_contact (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = tp_contact_get_alias (_tmp15_);
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp17_;
	_tmp18_ = tpf_persona_get_contact (self);
	_tmp19_ = _tmp18_;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::alias", (GCallback) __tpf_persona___lambda21__g_object_notify, self, 0);
	_tmp20_ = tpf_persona_get_contact (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = tp_contact_get_connection (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	connection = _tmp24_;
	_tmp25_ = connection;
	_tmp26_ = _tpf_persona_account_for_connection (_tmp25_);
	account = _tmp26_;
	{
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		TpAccount* _tmp29_;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* im_addr;
		const gchar* _tmp32_;
		FolksImFieldDetails* _tmp33_;
		FolksImFieldDetails* im_fd;
		GeeHashMultiMap* _tmp34_;
		TpAccount* _tmp35_;
		const gchar* _tmp36_ = NULL;
		FolksImFieldDetails* _tmp37_;
		_tmp27_ = folks_persona_get_display_id ((FolksPersona*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = account;
		_tmp30_ = tp_account_get_protocol (_tmp29_);
		_tmp31_ = folks_im_details_normalise_im_address (_tmp28_, _tmp30_, &_inner_error_);
		im_addr = _tmp31_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch3_folks_im_details_error;
			}
			_g_object_unref0 (account);
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp32_ = im_addr;
		_tmp33_ = folks_im_field_details_new (_tmp32_, NULL);
		im_fd = _tmp33_;
		_tmp34_ = self->priv->_im_addresses;
		_tmp35_ = account;
		_tmp36_ = tp_account_get_protocol (_tmp35_);
		_tmp37_ = im_fd;
		gee_multi_map_set ((GeeMultiMap*) _tmp34_, _tmp36_, _tmp37_);
		_g_object_unref0 (im_fd);
		_g_free0 (im_addr);
	}
	goto __finally3;
	__catch3_folks_im_details_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("tpf-persona.vala:678: %s", _tmp39_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (account);
		_g_object_unref0 (connection);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp40_ = tpf_persona_get_contact (self);
	_tmp41_ = _tmp40_;
	g_signal_connect_object ((GObject*) _tmp41_, "notify::avatar-file", (GCallback) __tpf_persona___lambda22__g_object_notify, self, 0);
	_tpf_persona_contact_notify_avatar (self);
	_tmp42_ = tpf_persona_get_contact (self);
	_tmp43_ = _tmp42_;
	g_signal_connect_object ((GObject*) _tmp43_, "notify::presence-message", (GCallback) __tpf_persona___lambda23__g_object_notify, self, 0);
	_tmp44_ = tpf_persona_get_contact (self);
	_tmp45_ = _tmp44_;
	g_signal_connect_object ((GObject*) _tmp45_, "notify::presence-type", (GCallback) __tpf_persona___lambda24__g_object_notify, self, 0);
	_tmp46_ = tpf_persona_get_contact (self);
	_tmp47_ = _tmp46_;
	g_signal_connect_object ((GObject*) _tmp47_, "notify::presence-status", (GCallback) __tpf_persona___lambda25__g_object_notify, self, 0);
	_tpf_persona_contact_notify_presence_message (self);
	_tpf_persona_contact_notify_presence_type (self);
	_tpf_persona_contact_notify_presence_status (self);
	_tmp48_ = tpf_persona_get_contact (self);
	_tmp49_ = _tmp48_;
	g_signal_connect_object ((GObject*) _tmp49_, "notify::contact-info", (GCallback) __tpf_persona___lambda26__g_object_notify, self, 0);
	_tpf_persona_contact_notify_contact_info (self);
	_tmp50_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp51_ = _tmp50_;
	g_signal_connect_object (TPF_PERSONA_STORE (_tmp51_), "group-members-changed", (GCallback) __tpf_persona___lambda27__tpf_persona_store_group_members_changed, self, 0);
	_tmp52_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp53_ = _tmp52_;
	g_signal_connect_object (TPF_PERSONA_STORE (_tmp53_), "group-removed", (GCallback) __tpf_persona___lambda28__tpf_persona_store_group_removed, self, 0);
	_tmp54_ = folks_persona_get_is_user ((FolksPersona*) self);
	_tmp55_ = _tmp54_;
	if (_tmp55_) {
		FolksPersonaStore* _tmp56_;
		FolksPersonaStore* _tmp57_;
		_tmp56_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp57_ = _tmp56_;
		g_signal_connect_object ((GObject*) TPF_PERSONA_STORE (_tmp57_), "notify::supported-fields", (GCallback) __tpf_persona____lambda29__g_object_notify, self, 0);
		_tpf_persona_store_notify_supported_fields (self);
	}
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	return obj;
}


static void tpf_persona_class_init (TpfPersonaClass * klass) {
	tpf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaPrivate));
	G_OBJECT_CLASS (klass)->constructed = tpf_persona_real_constructed;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = tpf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = tpf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = tpf_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_finalize;
	/**
	   * Whether the Persona is in the user's contact list.
	   *
	   * This will be true for most {@link Folks.Persona}s, but may not be true for
	   * personas where {@link Folks.Persona.is_user} is true. If it's false in
	   * this case, it means that the persona has been retrieved from the Telepathy
	   * connection, but has not been added to the user's contact list.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_IN_CONTACT_LIST, g_param_spec_boolean ("is-in-contact-list", "is-in-contact-list", "is-in-contact-list", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * ContactInfo has no equivalent field, so this is unsupported.
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CALENDAR_EVENT_ID, g_param_spec_string ("calendar-event-id", "calendar-event-id", "calendar-event-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_BIRTHDAY, g_param_spec_boxed ("birthday", "birthday", "birthday", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence type.
	   *
	   * See {@link Folks.PresenceDetails.presence_type}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_TYPE, g_param_spec_enum ("presence-type", "presence-type", "presence-type", FOLKS_TYPE_PRESENCE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence status.
	   *
	   * See {@link Folks.PresenceDetails.presence_status}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_STATUS, g_param_spec_string ("presence-status", "presence-status", "presence-status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence message.
	   *
	   * See {@link Folks.PresenceDetails.presence_message}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_MESSAGE, g_param_spec_string ("presence-message", "presence-message", "presence-message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * An alias for the Persona.
	   *
	   * See {@link Folks.AliasDetails.alias}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_ALIAS, g_param_spec_string ("alias", "alias", "alias", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this Persona is a user-defined favourite.
	   *
	   * See {@link Folks.FavouriteDetails.is_favourite}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_FAVOURITE, g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * A mapping of IM protocol to an (unordered) set of IM addresses.
	   *
	   * See {@link Folks.ImDetails.im_addresses}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_ADDRESSES, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * A mapping of group ID to whether the contact is a member.
	   *
	   * See {@link Folks.GroupDetails.groups}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_GROUPS, g_param_spec_object ("groups", "groups", "groups", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Telepathy contact represented by this persona.
	   *
	   * Note that this may be `null` if the {@link PersonaStore} providing this
	   * {@link Persona} isn't currently available (e.g. due to not being connected
	   * to the network). In this case, most other properties of the {@link Persona}
	   * are being retrieved from a cache and may not be current (though there's no
	   * way to tell this).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", tp_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_URLS, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tpf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	tpf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_alias = (void (*)(FolksAliasDetails*, const gchar*, GError**)) tpf_persona_real_change_alias;
	iface->change_alias_finish = tpf_persona_real_change_alias_finish;
	iface->get_alias = tpf_persona_real_get_alias;
	iface->set_alias = tpf_persona_real_set_alias;
}


static void tpf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	tpf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = tpf_persona_real_get_avatar;
	iface->set_avatar = tpf_persona_real_set_avatar;
}


static void tpf_persona_folks_birthday_details_interface_init (FolksBirthdayDetailsIface * iface) {
	tpf_persona_folks_birthday_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_birthday = (void (*)(FolksBirthdayDetails*, GDateTime*, GError**)) tpf_persona_real_change_birthday;
	iface->change_birthday_finish = tpf_persona_real_change_birthday_finish;
	iface->get_calendar_event_id = tpf_persona_real_get_calendar_event_id;
	iface->set_calendar_event_id = tpf_persona_real_set_calendar_event_id;
	iface->get_birthday = tpf_persona_real_get_birthday;
	iface->set_birthday = tpf_persona_real_set_birthday;
}


static void tpf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	tpf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_email_addresses = (void (*)(FolksEmailDetails*, GeeSet*, GError**)) tpf_persona_real_change_email_addresses;
	iface->change_email_addresses_finish = tpf_persona_real_change_email_addresses_finish;
	iface->get_email_addresses = tpf_persona_real_get_email_addresses;
	iface->set_email_addresses = tpf_persona_real_set_email_addresses;
}


static void tpf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	tpf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_is_favourite = (void (*)(FolksFavouriteDetails*, gboolean, GError**)) tpf_persona_real_change_is_favourite;
	iface->change_is_favourite_finish = tpf_persona_real_change_is_favourite_finish;
	iface->get_is_favourite = tpf_persona_real_get_is_favourite;
	iface->set_is_favourite = tpf_persona_real_set_is_favourite;
}


static void tpf_persona_folks_group_details_interface_init (FolksGroupDetailsIface * iface) {
	tpf_persona_folks_group_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupDetails*, const gchar*, gboolean, GError**)) tpf_persona_real_change_group;
	iface->change_group_finish = tpf_persona_real_change_group_finish;
	iface->change_groups = (void (*)(FolksGroupDetails*, GeeSet*, GError**)) tpf_persona_real_change_groups;
	iface->change_groups_finish = tpf_persona_real_change_groups_finish;
	iface->get_groups = tpf_persona_real_get_groups;
	iface->set_groups = tpf_persona_real_set_groups;
}


static void tpf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	tpf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = tpf_persona_real_get_im_addresses;
	iface->set_im_addresses = tpf_persona_real_set_im_addresses;
}


static void tpf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	tpf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_full_name = (void (*)(FolksNameDetails*, const gchar*, GError**)) tpf_persona_real_change_full_name;
	iface->change_full_name_finish = tpf_persona_real_change_full_name_finish;
	iface->get_structured_name = tpf_persona_real_get_structured_name;
	iface->set_structured_name = tpf_persona_real_set_structured_name;
	iface->get_full_name = tpf_persona_real_get_full_name;
	iface->set_full_name = tpf_persona_real_set_full_name;
	iface->get_nickname = tpf_persona_real_get_nickname;
	iface->set_nickname = tpf_persona_real_set_nickname;
}


static void tpf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	tpf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_phone_numbers = (void (*)(FolksPhoneDetails*, GeeSet*, GError**)) tpf_persona_real_change_phone_numbers;
	iface->change_phone_numbers_finish = tpf_persona_real_change_phone_numbers_finish;
	iface->get_phone_numbers = tpf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = tpf_persona_real_set_phone_numbers;
}


static void tpf_persona_folks_presence_details_interface_init (FolksPresenceDetailsIface * iface) {
	tpf_persona_folks_presence_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = tpf_persona_real_get_presence_type;
	iface->set_presence_type = tpf_persona_real_set_presence_type;
	iface->get_presence_status = tpf_persona_real_get_presence_status;
	iface->set_presence_status = tpf_persona_real_set_presence_status;
	iface->get_presence_message = tpf_persona_real_get_presence_message;
	iface->set_presence_message = tpf_persona_real_set_presence_message;
}


static void tpf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	tpf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_urls = (void (*)(FolksUrlDetails*, GeeSet*, GError**)) tpf_persona_real_change_urls;
	iface->change_urls_finish = tpf_persona_real_change_urls_finish;
	iface->get_urls = tpf_persona_real_get_urls;
	iface->set_urls = tpf_persona_real_set_urls;
}


static void tpf_persona_instance_init (TpfPersona * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_;
	self->priv = TPF_PERSONA_GET_PRIVATE (self);
	self->priv->_writeable_properties = NULL;
	self->priv->_is_constructed = FALSE;
	self->priv->_avatar = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	self->priv->_birthday = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->_alias = _tmp1_;
	self->priv->_is_favourite = FALSE;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_email_addresses = _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_im_addresses = _tmp3_;
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	self->priv->_groups = _tmp4_;
	self->priv->_contact = NULL;
	_tmp5_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_phone_numbers = _tmp5_;
	_tmp6_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_urls = _tmp6_;
}


static void tpf_persona_finalize (GObject* obj) {
	TpfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpContact* _tmp2_;
	self = TPF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona.vala:1000: Destroying Tpf.Persona '%s': %p", _tmp1_, self);
	_tmp2_ = self->priv->_contact;
	if (_tmp2_ != NULL) {
		TpContact* _tmp3_;
		_tmp3_ = self->priv->_contact;
		g_object_weak_unref ((GObject*) _tmp3_, __tpf_persona_contact_weak_notify_cb_gweak_notify, self);
	}
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_full_name);
	_g_date_time_unref0 (self->priv->_birthday);
	_g_free0 (self->priv->_presence_status);
	_g_free0 (self->priv->_presence_message);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_groups_ro);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	G_OBJECT_CLASS (tpf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single instant messaging contact from
 * Telepathy.
 */
GType tpf_persona_get_type (void) {
	static volatile gsize tpf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersona), 0, (GInstanceInitFunc) tpf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) tpf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) tpf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_birthday_details_info = { (GInterfaceInitFunc) tpf_persona_folks_birthday_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) tpf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) tpf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_group_details_info = { (GInterfaceInitFunc) tpf_persona_folks_group_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) tpf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) tpf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) tpf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_details_info = { (GInterfaceInitFunc) tpf_persona_folks_presence_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) tpf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tpf_persona_type_id;
		tpf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TpfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_BIRTHDAY_DETAILS, &folks_birthday_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_GROUP_DETAILS, &folks_group_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PRESENCE_DETAILS, &folks_presence_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_once_init_leave (&tpf_persona_type_id__volatile, tpf_persona_type_id);
	}
	return tpf_persona_type_id__volatile;
}


static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		g_value_set_boolean (value, tpf_persona_get_is_in_contact_list (self));
		break;
		case TPF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TPF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_CALENDAR_EVENT_ID:
		g_value_set_string (value, folks_birthday_details_get_calendar_event_id ((FolksBirthdayDetails*) self));
		break;
		case TPF_PERSONA_BIRTHDAY:
		g_value_set_boxed (value, folks_birthday_details_get_birthday ((FolksBirthdayDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_details_get_presence_type ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		g_value_set_string (value, folks_presence_details_get_presence_status ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_details_get_presence_message ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TPF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TPF_PERSONA_GROUPS:
		g_value_set_object (value, folks_group_details_get_groups ((FolksGroupDetails*) self));
		break;
		case TPF_PERSONA_CONTACT:
		g_value_set_object (value, tpf_persona_get_contact (self));
		break;
		case TPF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case TPF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		tpf_persona_set_is_in_contact_list (self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_CALENDAR_EVENT_ID:
		folks_birthday_details_set_calendar_event_id ((FolksBirthdayDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_BIRTHDAY:
		folks_birthday_details_set_birthday ((FolksBirthdayDetails*) self, g_value_get_boxed (value));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, g_value_get_enum (value));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_GROUPS:
		folks_group_details_set_groups ((FolksGroupDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_CONTACT:
		tpf_persona_set_contact (self, g_value_get_object (value));
		break;
		case TPF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



