/* gnome-mahjongg.c generated by valac 0.29.3.12-795f, the Vala compiler
 * generated from gnome-mahjongg.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <locale.h>


#define TYPE_MAHJONGG (mahjongg_get_type ())
#define MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG, Mahjongg))
#define MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG, MahjonggClass))
#define IS_MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG))
#define IS_MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG))
#define MAHJONGG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG, MahjonggClass))

typedef struct _Mahjongg Mahjongg;
typedef struct _MahjonggClass MahjonggClass;
typedef struct _MahjonggPrivate MahjonggPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define MAHJONGG_TYPE_NO_MOVES_DIALOG_RESPONSE (mahjongg_no_moves_dialog_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _MapPrivate MapPrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _GameViewPrivate GameViewPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define TYPE_MATCH (match_get_type ())
#define MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH, Match))
#define MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH, MatchClass))
#define IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH))
#define IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH))
#define MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH, MatchClass))

typedef struct _Match Match;
typedef struct _MatchClass MatchClass;
typedef struct _MatchPrivate MatchPrivate;

#define TYPE_MAP_LOADER (map_loader_get_type ())
#define MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_LOADER, MapLoader))
#define MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_LOADER, MapLoaderClass))
#define IS_MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_LOADER))
#define IS_MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_LOADER))
#define MAP_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_LOADER, MapLoaderClass))

typedef struct _MapLoader MapLoader;
typedef struct _MapLoaderClass MapLoaderClass;
typedef struct _MapLoaderPrivate MapLoaderPrivate;

struct _Mahjongg {
	GtkApplication parent_instance;
	MahjonggPrivate * priv;
};

struct _MahjonggClass {
	GtkApplicationClass parent_class;
};

struct _MahjonggPrivate {
	GSettings* settings;
	History* history;
	GList* maps;
	GtkApplicationWindow* window;
	GtkLabel* title;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean is_tiled;
	GameView* game_view;
	GtkButton* pause_button;
	GtkLabel* moves_label;
	GtkLabel* clock_label;
	GtkDialog* preferences_dialog;
};

typedef enum  {
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME
} MahjonggNoMovesDialogResponse;

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _Match {
	GObject parent_instance;
	MatchPrivate * priv;
	Tile* tile0;
	Tile* tile1;
};

struct _MatchClass {
	GObjectClass parent_class;
};

struct _MapLoader {
	GObject parent_instance;
	MapLoaderPrivate * priv;
	GList* maps;
};

struct _MapLoaderClass {
	GObjectClass parent_class;
};


static gpointer mahjongg_parent_class = NULL;

GType mahjongg_get_type (void) G_GNUC_CONST;
GType history_get_type (void) G_GNUC_CONST;
GType map_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
#define MAHJONGG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAHJONGG, MahjonggPrivate))
enum  {
	MAHJONGG_DUMMY_PROPERTY
};
static GType mahjongg_no_moves_dialog_response_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void mahjongg_new_game_cb (Mahjongg* self);
static void _mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_undo_cb (Mahjongg* self);
static void _mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_redo_cb (Mahjongg* self);
static void _mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_hint_cb (Mahjongg* self);
static void _mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_pause_cb (Mahjongg* self);
static void _mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_restart_game_cb (Mahjongg* self);
static void _mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_scores_cb (Mahjongg* self);
static void _mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_preferences_cb (Mahjongg* self);
static void _mahjongg_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_help_cb (Mahjongg* self);
static void _mahjongg_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_about_cb (Mahjongg* self);
static void _mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mahjongg_quit_cb (Mahjongg* self);
static void _mahjongg_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mahjongg* mahjongg_new (void);
Mahjongg* mahjongg_construct (GType object_type);
static void mahjongg_real_startup (GApplication* base);
static void mahjongg_load_maps (Mahjongg* self);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static void mahjongg_size_allocate_cb (Mahjongg* self, GtkAllocation* allocation);
static void _mahjongg_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean mahjongg_window_state_event_cb (Mahjongg* self, GdkEventWindowState* event);
static gboolean _mahjongg_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static gboolean mahjongg_view_button_press_event (Mahjongg* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mahjongg_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean mahjongg_is_desktop (Mahjongg* self, const gchar* name);
static void mahjongg_conf_value_changed_cb (Mahjongg* self, GSettings* settings, const gchar* key);
static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void mahjongg_new_game (Mahjongg* self);
static void mahjongg_tick_cb (Mahjongg* self);
static void mahjongg_real_shutdown (GApplication* base);
static gint mahjongg_real_handle_local_options (GApplication* base, GVariantDict* options);
static void mahjongg_real_activate (GApplication* base);
static void mahjongg_update_ui (Mahjongg* self);
GType game_get_type (void) G_GNUC_CONST;
Game* game_view_get_game (GameView* self);
gboolean game_get_started (Game* self);
gboolean game_get_paused (Game* self);
guint game_get_moves_left (Game* self);
gboolean game_get_can_undo (Game* self);
gboolean game_get_can_redo (Game* self);
static void mahjongg_theme_changed_cb (Mahjongg* self, GtkComboBox* widget);
void game_view_set_theme (GameView* self, const gchar* value);
void game_view_set_background (GameView* self, const gchar* colour);
void game_set_paused (Game* self, gboolean value);
static void mahjongg_background_changed_cb (Mahjongg* self, GtkColorButton* widget);
static void mahjongg_map_changed_cb (Mahjongg* self, GtkComboBox* widget);
GType slot_get_type (void) G_GNUC_CONST;
static void mahjongg_moved_cb (Mahjongg* self);
gboolean game_get_complete (Game* self);
gdouble game_get_elapsed (Game* self);
GType history_entry_get_type (void) G_GNUC_CONST;
GType tile_get_type (void) G_GNUC_CONST;
HistoryEntry* history_entry_new (GDateTime* date, const gchar* name, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, const gchar* name, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gint mahjongg_show_scores (Mahjongg* self, HistoryEntry* selected_entry, gboolean show_quit);
gboolean game_get_can_move (Game* self);
gint game_number_of_movable_tiles (Game* self);
static void mahjongg_shuffle_cb (Mahjongg* self);
static void mahjongg_restart_game (Mahjongg* self);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit);
static void mahjongg_preferences_dialog_response_cb (Mahjongg* self, GtkDialog* dialog, gint response);
static void _mahjongg_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GList* mahjongg_load_themes (Mahjongg* self);
static void _mahjongg_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _mahjongg_map_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _mahjongg_background_changed_cb_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType match_get_type (void) G_GNUC_CONST;
GList* game_find_matches (Game* self, Tile* tile);
Tile* game_get_selected_tile (Game* self);
void game_set_hint (Game* self, Tile* tile0, Tile* tile1);
void game_shuffle_remaining (Game* self, gboolean redraw);
void game_set_selected_tile (Game* self, Tile* value);
void game_redo (Game* self);
void game_undo (Game* self);
void game_reset (Game* self);
Game* game_new (Map* map);
Game* game_construct (GType object_type, Map* map);
void game_view_set_game (GameView* self, Game* value);
static void _mahjongg_moved_cb_game_moved (Game* _sender, gpointer self);
static void _mahjongg_tick_cb_game_tick (Game* _sender, gpointer self);
Map* map_new_builtin (void);
Map* map_construct_builtin (GType object_type);
GType map_loader_get_type (void) G_GNUC_CONST;
MapLoader* map_loader_new (void);
MapLoader* map_loader_construct (GType object_type);
void map_loader_load (MapLoader* self, const gchar* filename, GError** error);
gint mahjongg_main (gchar** args, int args_length1);
static void mahjongg_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry MAHJONGG_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry MAHJONGG_action_entries[11] = {{"new-game", _mahjongg_new_game_cb_gsimple_action_activate_callback}, {"undo", _mahjongg_undo_cb_gsimple_action_activate_callback}, {"redo", _mahjongg_redo_cb_gsimple_action_activate_callback}, {"hint", _mahjongg_hint_cb_gsimple_action_activate_callback}, {"pause", _mahjongg_pause_cb_gsimple_action_activate_callback}, {"restart-game", _mahjongg_restart_game_cb_gsimple_action_activate_callback}, {"scores", _mahjongg_scores_cb_gsimple_action_activate_callback}, {"preferences", _mahjongg_preferences_cb_gsimple_action_activate_callback}, {"help", _mahjongg_help_cb_gsimple_action_activate_callback}, {"about", _mahjongg_about_cb_gsimple_action_activate_callback}, {"quit", _mahjongg_quit_cb_gsimple_action_activate_callback}};

static GType mahjongg_no_moves_dialog_response_get_type (void) {
	static volatile gsize mahjongg_no_moves_dialog_response_type_id__volatile = 0;
	if (g_once_init_enter (&mahjongg_no_moves_dialog_response_type_id__volatile)) {
		static const GEnumValue values[] = {{MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO", "undo"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE", "shuffle"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART", "restart"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME", "new-game"}, {0, NULL, NULL}};
		GType mahjongg_no_moves_dialog_response_type_id;
		mahjongg_no_moves_dialog_response_type_id = g_enum_register_static ("MahjonggNoMovesDialogResponse", values);
		g_once_init_leave (&mahjongg_no_moves_dialog_response_type_id__volatile, mahjongg_no_moves_dialog_response_type_id);
	}
	return mahjongg_no_moves_dialog_response_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_new_game_cb ((Mahjongg*) self);
}


static void _mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_undo_cb ((Mahjongg*) self);
}


static void _mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_redo_cb ((Mahjongg*) self);
}


static void _mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_hint_cb ((Mahjongg*) self);
}


static void _mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_pause_cb ((Mahjongg*) self);
}


static void _mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_restart_game_cb ((Mahjongg*) self);
}


static void _mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_scores_cb ((Mahjongg*) self);
}


static void _mahjongg_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_preferences_cb ((Mahjongg*) self);
}


static void _mahjongg_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_help_cb ((Mahjongg*) self);
}


static void _mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_about_cb ((Mahjongg*) self);
}


static void _mahjongg_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mahjongg_quit_cb ((Mahjongg*) self);
}


Mahjongg* mahjongg_construct (GType object_type) {
	Mahjongg * self = NULL;
	self = (Mahjongg*) g_object_new (object_type, "application-id", "org.gnome.gnome-mahjongg", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, MAHJONGG_option_entries);
	return self;
}


Mahjongg* mahjongg_new (void) {
	return mahjongg_construct (TYPE_MAHJONGG);
}


static void _mahjongg_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	mahjongg_size_allocate_cb ((Mahjongg*) self, allocation);
}


static gboolean _mahjongg_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mahjongg_window_state_event_cb ((Mahjongg*) self, event);
	return result;
}


static gboolean _mahjongg_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mahjongg_view_button_press_event ((Mahjongg*) self, _sender, event);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	mahjongg_conf_value_changed_cb ((Mahjongg*) self, _sender, key);
}


static void mahjongg_real_startup (GApplication* base) {
	Mahjongg * self;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GSettings* _tmp12_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp13_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	History* _tmp18_ = NULL;
	History* _tmp19_ = NULL;
	GtkApplicationWindow* _tmp20_ = NULL;
	GtkApplicationWindow* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkApplicationWindow* _tmp23_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GtkBox* status_box = NULL;
	GtkBox* _tmp31_ = NULL;
	GtkBox* group_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkBox* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* spacer = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkBox* _tmp41_ = NULL;
	GtkLabel* _tmp42_ = NULL;
	GtkBox* _tmp43_ = NULL;
	GtkBox* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp48_ = NULL;
	GameView* _tmp49_ = NULL;
	GameView* _tmp50_ = NULL;
	GameView* _tmp51_ = NULL;
	GtkLabel* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	GtkStyleContext* _tmp54_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp55_ = NULL;
	GtkBox* _tmp56_ = NULL;
	GtkStyleContext* _tmp57_ = NULL;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp58_ = NULL;
	GtkButton* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkButton* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkBox* _tmp63_ = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkButton* redo_button = NULL;
	GtkButton* _tmp65_ = NULL;
	GtkButton* _tmp66_ = NULL;
	GtkButton* _tmp67_ = NULL;
	GtkButton* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkButton* _tmp71_ = NULL;
	GtkButton* hint_button = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkButton* _tmp73_ = NULL;
	GtkButton* _tmp74_ = NULL;
	GtkButton* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkButton* _tmp77_ = NULL;
	GtkButton* _tmp78_ = NULL;
	GtkButton* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	const gchar* _tmp81_ = NULL;
	GtkBox* title_box = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkBox* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkBox* _tmp86_ = NULL;
	GtkBox* _tmp87_ = NULL;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp88_ = NULL;
	gboolean _tmp89_ = FALSE;
	GtkHeaderBar* header_bar = NULL;
	GtkHeaderBar* _tmp117_ = NULL;
	GtkHeaderBar* _tmp118_ = NULL;
	GtkBox* _tmp119_ = NULL;
	GtkHeaderBar* _tmp120_ = NULL;
	GtkBox* _tmp121_ = NULL;
	GtkHeaderBar* _tmp122_ = NULL;
	GtkButton* _tmp123_ = NULL;
	GtkHeaderBar* _tmp124_ = NULL;
	GtkButton* _tmp125_ = NULL;
	gchar* desktop = NULL;
	const gchar* _tmp126_ = NULL;
	gchar* _tmp127_ = NULL;
	gboolean _tmp128_ = FALSE;
	GtkBox* _tmp134_ = NULL;
	GameView* _tmp135_ = NULL;
	GtkApplicationWindow* _tmp136_ = NULL;
	GtkBox* _tmp137_ = NULL;
	GtkApplicationWindow* _tmp138_ = NULL;
	GSettings* _tmp139_ = NULL;
	GameView* _tmp140_ = NULL;
	GSettings* _tmp141_ = NULL;
	GSettings* _tmp142_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Mahjongg*) base;
	G_APPLICATION_CLASS (mahjongg_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, MAHJONGG_action_entries, G_N_ELEMENTS (MAHJONGG_action_entries), self);
	_tmp0_ = g_strdup ("Pause");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Primary>h");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.hint", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Primary>z");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Primary><Shift>z");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_settings_new ("org.gnome.mahjongg");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp12_;
	_tmp13_ = gtk_builder_new ();
	builder = _tmp13_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/mahjongg/ui/menu.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e->message;
		g_error ("gnome-mahjongg.vala:76: loading menu builder file: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	mahjongg_load_maps (self);
	_tmp15_ = g_get_user_data_dir ();
	_tmp16_ = g_build_filename (_tmp15_, "gnome-mahjongg", "history", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = history_new (_tmp17_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = self->priv->history;
	history_load (_tmp19_);
	_tmp20_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp20_;
	_tmp21_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "size-allocate", (GCallback) _mahjongg_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp22_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "window-state-event", (GCallback) _mahjongg_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp23_ = self->priv->window;
	_tmp24_ = self->priv->settings;
	_tmp25_ = g_settings_get_int (_tmp24_, "window-width");
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_get_int (_tmp26_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) _tmp23_, _tmp25_, _tmp27_);
	_tmp28_ = self->priv->settings;
	_tmp29_ = g_settings_get_boolean (_tmp28_, "window-is-maximized");
	if (_tmp29_) {
		GtkApplicationWindow* _tmp30_ = NULL;
		_tmp30_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp30_);
	}
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp31_);
	status_box = _tmp31_;
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp32_);
	group_box = _tmp32_;
	_tmp33_ = _ ("Moves Left:");
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
	g_object_ref_sink (_tmp34_);
	label = _tmp34_;
	_tmp35_ = group_box;
	_tmp36_ = label;
	gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
	_tmp37_ = (GtkLabel*) gtk_label_new (" ");
	g_object_ref_sink (_tmp37_);
	spacer = _tmp37_;
	_tmp38_ = group_box;
	_tmp39_ = spacer;
	gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
	_tmp40_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->moves_label);
	self->priv->moves_label = _tmp40_;
	_tmp41_ = group_box;
	_tmp42_ = self->priv->moves_label;
	gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, FALSE, FALSE, (guint) 0);
	_tmp43_ = status_box;
	_tmp44_ = group_box;
	gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
	_tmp45_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp45_;
	_tmp46_ = status_box;
	_tmp47_ = self->priv->clock_label;
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
	_tmp48_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp48_);
	vbox = _tmp48_;
	_tmp49_ = game_view_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp49_;
	_tmp50_ = self->priv->game_view;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "button-press-event", (GCallback) _mahjongg_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp51_ = self->priv->game_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp51_, 600, 400);
	_tmp52_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->title);
	self->priv->title = _tmp52_;
	_tmp53_ = self->priv->title;
	_tmp54_ = gtk_widget_get_style_context ((GtkWidget*) _tmp53_);
	gtk_style_context_add_class (_tmp54_, "title");
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp55_);
	hbox = _tmp55_;
	_tmp56_ = hbox;
	_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) _tmp56_);
	gtk_style_context_add_class (_tmp57_, "linked");
	_tmp58_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp58_);
	undo_button = _tmp58_;
	_tmp59_ = undo_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp59_, GTK_ALIGN_CENTER);
	_tmp60_ = undo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp60_, "app.undo");
	_tmp61_ = undo_button;
	_tmp62_ = _ ("Undo your last move");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp61_, _tmp62_);
	_tmp63_ = hbox;
	_tmp64_ = undo_button;
	gtk_box_pack_start (_tmp63_, (GtkWidget*) _tmp64_, TRUE, TRUE, (guint) 0);
	_tmp65_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp65_);
	redo_button = _tmp65_;
	_tmp66_ = redo_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp66_, GTK_ALIGN_CENTER);
	_tmp67_ = redo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp67_, "app.redo");
	_tmp68_ = redo_button;
	_tmp69_ = _ ("Redo your last move");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp68_, _tmp69_);
	_tmp70_ = hbox;
	_tmp71_ = redo_button;
	gtk_box_pack_start (_tmp70_, (GtkWidget*) _tmp71_, TRUE, TRUE, (guint) 0);
	_tmp72_ = (GtkButton*) gtk_button_new_from_icon_name ("dialog-question-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp72_);
	hint_button = _tmp72_;
	_tmp73_ = hint_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp73_, GTK_ALIGN_CENTER);
	_tmp74_ = hint_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp74_, "app.hint");
	_tmp75_ = hint_button;
	_tmp76_ = _ ("Receive a hint for your next move");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp75_, _tmp76_);
	_tmp77_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp77_;
	_tmp78_ = self->priv->pause_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp78_, GTK_ALIGN_CENTER);
	_tmp79_ = self->priv->pause_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp79_, "app.pause");
	_tmp80_ = self->priv->pause_button;
	_tmp81_ = _ ("Pause the game");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp80_, _tmp81_);
	_tmp82_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp82_);
	title_box = _tmp82_;
	_tmp83_ = title_box;
	_tmp84_ = self->priv->title;
	gtk_box_pack_start (_tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 0);
	_tmp85_ = status_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp85_, GTK_ALIGN_CENTER);
	_tmp86_ = title_box;
	_tmp87_ = status_box;
	gtk_box_pack_start (_tmp86_, (GtkWidget*) _tmp87_, FALSE, FALSE, (guint) 0);
	_tmp88_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp88_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
	_tmp89_ = shell_shows_menubar;
	if (!_tmp89_) {
		GMenuModel* app_menu = NULL;
		GObject* _tmp90_ = NULL;
		GMenuModel* _tmp91_ = NULL;
		GMenuModel* _tmp92_ = NULL;
		_tmp90_ = gtk_builder_get_object (builder, "appmenu");
		_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp90_) : NULL);
		app_menu = _tmp91_;
		_tmp92_ = app_menu;
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp92_);
		_g_object_unref0 (app_menu);
	} else {
		GMenu* menu = NULL;
		GMenu* _tmp93_ = NULL;
		GMenu* mahjongg_menu = NULL;
		GMenu* _tmp94_ = NULL;
		GMenu* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		GMenu* _tmp97_ = NULL;
		GMenu* _tmp98_ = NULL;
		const gchar* _tmp99_ = NULL;
		GMenu* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		GMenu* _tmp102_ = NULL;
		const gchar* _tmp103_ = NULL;
		GMenu* _tmp104_ = NULL;
		const gchar* _tmp105_ = NULL;
		GMenu* _tmp106_ = NULL;
		const gchar* _tmp107_ = NULL;
		GMenu* help_menu = NULL;
		GMenu* _tmp108_ = NULL;
		GMenu* _tmp109_ = NULL;
		const gchar* _tmp110_ = NULL;
		GMenu* _tmp111_ = NULL;
		GMenu* _tmp112_ = NULL;
		const gchar* _tmp113_ = NULL;
		GMenu* _tmp114_ = NULL;
		const gchar* _tmp115_ = NULL;
		GMenu* _tmp116_ = NULL;
		_tmp93_ = g_menu_new ();
		menu = _tmp93_;
		_tmp94_ = g_menu_new ();
		mahjongg_menu = _tmp94_;
		_tmp95_ = menu;
		_tmp96_ = _ ("_Mahjongg");
		_tmp97_ = mahjongg_menu;
		g_menu_append_submenu (_tmp95_, _tmp96_, (GMenuModel*) _tmp97_);
		_tmp98_ = mahjongg_menu;
		_tmp99_ = _ ("_New Game");
		g_menu_append (_tmp98_, _tmp99_, "app.new-game");
		_tmp100_ = mahjongg_menu;
		_tmp101_ = _ ("_Restart Game");
		g_menu_append (_tmp100_, _tmp101_, "app.restart-game");
		_tmp102_ = mahjongg_menu;
		_tmp103_ = _ ("_Scores");
		g_menu_append (_tmp102_, _tmp103_, "app.scores");
		_tmp104_ = mahjongg_menu;
		_tmp105_ = _ ("_Preferences");
		g_menu_append (_tmp104_, _tmp105_, "app.preferences");
		_tmp106_ = mahjongg_menu;
		_tmp107_ = _ ("_Quit");
		g_menu_append (_tmp106_, _tmp107_, "app.quit");
		_tmp108_ = g_menu_new ();
		help_menu = _tmp108_;
		_tmp109_ = menu;
		_tmp110_ = _ ("_Help");
		_tmp111_ = help_menu;
		g_menu_append_submenu (_tmp109_, _tmp110_, (GMenuModel*) _tmp111_);
		_tmp112_ = help_menu;
		_tmp113_ = _ ("_Contents");
		g_menu_append (_tmp112_, _tmp113_, "app.help");
		_tmp114_ = help_menu;
		_tmp115_ = _ ("_About");
		g_menu_append (_tmp114_, _tmp115_, "app.about");
		_tmp116_ = menu;
		gtk_application_set_menubar ((GtkApplication*) self, (GMenuModel*) _tmp116_);
		_g_object_unref0 (help_menu);
		_g_object_unref0 (mahjongg_menu);
		_g_object_unref0 (menu);
	}
	_tmp117_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp117_);
	header_bar = _tmp117_;
	_tmp118_ = header_bar;
	_tmp119_ = title_box;
	gtk_header_bar_set_custom_title (_tmp118_, (GtkWidget*) _tmp119_);
	_tmp120_ = header_bar;
	_tmp121_ = hbox;
	gtk_header_bar_pack_start (_tmp120_, (GtkWidget*) _tmp121_);
	_tmp122_ = header_bar;
	_tmp123_ = hint_button;
	gtk_header_bar_pack_end (_tmp122_, (GtkWidget*) _tmp123_);
	_tmp124_ = header_bar;
	_tmp125_ = self->priv->pause_button;
	gtk_header_bar_pack_end (_tmp124_, (GtkWidget*) _tmp125_);
	_tmp126_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp127_ = g_strdup (_tmp126_);
	desktop = _tmp127_;
	_tmp128_ = mahjongg_is_desktop (self, "Unity");
	if (!_tmp128_) {
		GtkHeaderBar* _tmp129_ = NULL;
		GtkApplicationWindow* _tmp130_ = NULL;
		GtkHeaderBar* _tmp131_ = NULL;
		_tmp129_ = header_bar;
		gtk_header_bar_set_show_close_button (_tmp129_, TRUE);
		_tmp130_ = self->priv->window;
		_tmp131_ = header_bar;
		gtk_window_set_titlebar ((GtkWindow*) _tmp130_, (GtkWidget*) _tmp131_);
	} else {
		GtkBox* _tmp132_ = NULL;
		GtkHeaderBar* _tmp133_ = NULL;
		_tmp132_ = vbox;
		_tmp133_ = header_bar;
		gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, FALSE, FALSE, (guint) 0);
	}
	_tmp134_ = vbox;
	_tmp135_ = self->priv->game_view;
	gtk_box_pack_start (_tmp134_, (GtkWidget*) _tmp135_, TRUE, TRUE, (guint) 0);
	_tmp136_ = self->priv->window;
	_tmp137_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
	_tmp138_ = self->priv->window;
	gtk_widget_show_all ((GtkWidget*) _tmp138_);
	_tmp139_ = self->priv->settings;
	g_signal_connect_object (_tmp139_, "changed", (GCallback) _mahjongg_conf_value_changed_cb_g_settings_changed, self, 0);
	mahjongg_new_game (self);
	_tmp140_ = self->priv->game_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp140_);
	_tmp141_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp141_, "tileset");
	_tmp142_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp142_, "bgcolour");
	mahjongg_tick_cb (self);
	_g_free0 (desktop);
	_g_object_unref0 (header_bar);
	_g_object_unref0 (title_box);
	_g_object_unref0 (hint_button);
	_g_object_unref0 (redo_button);
	_g_object_unref0 (undo_button);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	_g_object_unref0 (spacer);
	_g_object_unref0 (label);
	_g_object_unref0 (group_box);
	_g_object_unref0 (status_box);
	_g_object_unref0 (builder);
}


static gboolean mahjongg_is_desktop (Mahjongg* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp1_ = g_strdup (_tmp0_);
	desktop_name_list = _tmp1_;
	_tmp2_ = desktop_name_list;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (desktop_name_list);
		return result;
	}
	_tmp3_ = desktop_name_list;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
		n_collection = _tmp5_;
		n_collection_length1 = _vala_array_length (_tmp4_);
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
			_tmp6_ = g_strdup (n_collection[n_it]);
			n = _tmp6_;
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				_tmp7_ = n;
				_tmp8_ = name;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					result = TRUE;
					_g_free0 (n);
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (desktop_name_list);
					return result;
				}
				_g_free0 (n);
			}
		}
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	_g_free0 (desktop_name_list);
	return result;
}


static void mahjongg_size_allocate_cb (Mahjongg* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = *allocation;
	_tmp4_ = _tmp3_.width;
	self->priv->window_width = _tmp4_;
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.height;
	self->priv->window_height = _tmp6_;
}


static gboolean mahjongg_window_state_event_cb (Mahjongg* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static void mahjongg_real_shutdown (GApplication* base) {
	Mahjongg * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (Mahjongg*) base;
	G_APPLICATION_CLASS (mahjongg_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
}


static gint mahjongg_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Mahjongg * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (Mahjongg*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-mahjongg", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}


static void mahjongg_real_activate (GApplication* base) {
	Mahjongg * self;
	GtkApplicationWindow* _tmp0_ = NULL;
	self = (Mahjongg*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void mahjongg_update_ui (Mahjongg* self) {
	GSimpleAction* pause_action = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* hint_action = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* redo_action = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GameView* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GameView* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GtkLabel* _tmp40_ = NULL;
	GameView* _tmp41_ = NULL;
	Game* _tmp42_ = NULL;
	Game* _tmp43_ = NULL;
	guint _tmp44_ = 0U;
	guint _tmp45_ = 0U;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	pause_action = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "hint");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	hint_action = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	undo_action = _tmp5_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	redo_action = _tmp7_;
	_tmp8_ = pause_action;
	_tmp9_ = self->priv->game_view;
	_tmp10_ = game_view_get_game (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = game_get_started (_tmp11_);
	_tmp13_ = _tmp12_;
	g_simple_action_set_enabled (_tmp8_, _tmp13_);
	_tmp14_ = self->priv->game_view;
	_tmp15_ = game_view_get_game (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = game_get_paused (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		GSimpleAction* _tmp19_ = NULL;
		GSimpleAction* _tmp20_ = NULL;
		GSimpleAction* _tmp21_ = NULL;
		_tmp19_ = hint_action;
		g_simple_action_set_enabled (_tmp19_, FALSE);
		_tmp20_ = undo_action;
		g_simple_action_set_enabled (_tmp20_, FALSE);
		_tmp21_ = redo_action;
		g_simple_action_set_enabled (_tmp21_, FALSE);
	} else {
		GSimpleAction* _tmp22_ = NULL;
		GameView* _tmp23_ = NULL;
		Game* _tmp24_ = NULL;
		Game* _tmp25_ = NULL;
		guint _tmp26_ = 0U;
		guint _tmp27_ = 0U;
		GSimpleAction* _tmp28_ = NULL;
		GameView* _tmp29_ = NULL;
		Game* _tmp30_ = NULL;
		Game* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		GSimpleAction* _tmp34_ = NULL;
		GameView* _tmp35_ = NULL;
		Game* _tmp36_ = NULL;
		Game* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		_tmp22_ = hint_action;
		_tmp23_ = self->priv->game_view;
		_tmp24_ = game_view_get_game (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_get_moves_left (_tmp25_);
		_tmp27_ = _tmp26_;
		g_simple_action_set_enabled (_tmp22_, _tmp27_ > ((guint) 0));
		_tmp28_ = undo_action;
		_tmp29_ = self->priv->game_view;
		_tmp30_ = game_view_get_game (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = game_get_can_undo (_tmp31_);
		_tmp33_ = _tmp32_;
		g_simple_action_set_enabled (_tmp28_, _tmp33_);
		_tmp34_ = redo_action;
		_tmp35_ = self->priv->game_view;
		_tmp36_ = game_view_get_game (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = game_get_can_redo (_tmp37_);
		_tmp39_ = _tmp38_;
		g_simple_action_set_enabled (_tmp34_, _tmp39_);
	}
	_tmp40_ = self->priv->moves_label;
	_tmp41_ = self->priv->game_view;
	_tmp42_ = game_view_get_game (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = game_get_moves_left (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf ("%2u", _tmp45_);
	_tmp47_ = _tmp46_;
	gtk_label_set_text (_tmp40_, _tmp47_);
	_g_free0 (_tmp47_);
	_g_object_unref0 (redo_action);
	_g_object_unref0 (undo_action);
	_g_object_unref0 (hint_action);
	_g_object_unref0 (pause_action);
}


static void mahjongg_theme_changed_cb (Mahjongg* self, GtkComboBox* widget) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gchar* theme = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &theme, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_string (_tmp6_, "tileset", theme);
	_g_free0 (theme);
}


static void mahjongg_conf_value_changed_cb (Mahjongg* self, GSettings* settings, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "tileset") == 0) {
		gchar* theme = NULL;
		GSettings* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GameView* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp1_ = settings;
		_tmp2_ = g_settings_get_string (_tmp1_, "tileset");
		theme = _tmp2_;
		_tmp3_ = self->priv->game_view;
		_tmp4_ = theme;
		_tmp5_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		game_view_set_theme (_tmp3_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (theme);
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = key;
		if (g_strcmp0 (_tmp7_, "bgcolour") == 0) {
			GameView* _tmp8_ = NULL;
			GSettings* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp8_ = self->priv->game_view;
			_tmp9_ = settings;
			_tmp10_ = g_settings_get_string (_tmp9_, "bgcolour");
			_tmp11_ = _tmp10_;
			game_view_set_background (_tmp8_, _tmp11_);
			_g_free0 (_tmp11_);
		} else {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = key;
			if (g_strcmp0 (_tmp12_, "mapset") == 0) {
				GameView* _tmp13_ = NULL;
				Game* _tmp14_ = NULL;
				Game* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				_tmp13_ = self->priv->game_view;
				_tmp14_ = game_view_get_game (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = game_get_started (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_) {
					GtkMessageDialog* dialog = NULL;
					GtkApplicationWindow* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					GtkMessageDialog* _tmp20_ = NULL;
					GtkMessageDialog* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					GtkMessageDialog* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					GtkMessageDialog* _tmp26_ = NULL;
					gint response = 0;
					GtkMessageDialog* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					GtkMessageDialog* _tmp30_ = NULL;
					_tmp18_ = self->priv->window;
					_tmp19_ = _ ("Do you want to start a new game with this map?");
					_tmp20_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp18_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp19_);
					g_object_ref_sink (_tmp20_);
					dialog = _tmp20_;
					_tmp21_ = dialog;
					_tmp22_ = _ ("If you continue playing the next game will use the new map.");
					gtk_message_dialog_format_secondary_text (_tmp21_, "%s", _tmp22_);
					_tmp23_ = dialog;
					_tmp24_ = _ ("_Continue playing");
					_tmp25_ = _ ("Use _new map");
					gtk_dialog_add_buttons ((GtkDialog*) _tmp23_, _tmp24_, GTK_RESPONSE_REJECT, _tmp25_, GTK_RESPONSE_ACCEPT, NULL, NULL);
					_tmp26_ = dialog;
					gtk_dialog_set_default_response ((GtkDialog*) _tmp26_, (gint) GTK_RESPONSE_ACCEPT);
					_tmp27_ = dialog;
					_tmp28_ = gtk_dialog_run ((GtkDialog*) _tmp27_);
					response = _tmp28_;
					_tmp29_ = response;
					if (_tmp29_ == ((gint) GTK_RESPONSE_ACCEPT)) {
						mahjongg_new_game (self);
					}
					_tmp30_ = dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp30_);
					_g_object_unref0 (dialog);
				} else {
					mahjongg_new_game (self);
				}
			}
		}
	}
}


static gboolean mahjongg_view_button_press_event (Mahjongg* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GameView* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		_tmp5_ = self->priv->game_view;
		_tmp6_ = game_view_get_game (_tmp5_);
		_tmp7_ = _tmp6_;
		game_set_paused (_tmp7_, FALSE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mahjongg_background_changed_cb (Mahjongg* self, GtkColorButton* widget) {
	GdkRGBA colour = {0};
	GtkColorButton* _tmp0_ = NULL;
	GdkRGBA _tmp1_ = {0};
	GSettings* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GdkRGBA _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	GdkRGBA _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
	colour = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = colour;
	_tmp4_ = _tmp3_.red;
	_tmp5_ = colour;
	_tmp6_ = _tmp5_.green;
	_tmp7_ = colour;
	_tmp8_ = _tmp7_.blue;
	_tmp9_ = g_strdup_printf ("#%04x%04x%04x", (guint) ((gint) ((_tmp4_ * 65536) + 0.5)), (guint) ((gint) ((_tmp6_ * 65536) + 0.5)), (guint) ((gint) ((_tmp8_ * 65536) + 0.5)));
	_tmp10_ = _tmp9_;
	g_settings_set_string (_tmp2_, "bgcolour", _tmp10_);
	_g_free0 (_tmp10_);
}


static void mahjongg_map_changed_cb (Mahjongg* self, GtkComboBox* widget) {
	GSettings* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->maps;
	_tmp2_ = widget;
	_tmp3_ = gtk_combo_box_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_list_nth_data (_tmp1_, (guint) _tmp4_);
	_tmp6_ = ((Map*) _tmp5_)->name;
	g_settings_set_string (_tmp0_, "mapset", _tmp6_);
}


static void mahjongg_moved_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	mahjongg_update_ui (self);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_complete (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GDateTime* date = NULL;
		GDateTime* _tmp5_ = NULL;
		guint duration = 0U;
		GameView* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Game* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		HistoryEntry* entry = NULL;
		GDateTime* _tmp11_ = NULL;
		GameView* _tmp12_ = NULL;
		Game* _tmp13_ = NULL;
		Game* _tmp14_ = NULL;
		Map* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		HistoryEntry* _tmp18_ = NULL;
		History* _tmp19_ = NULL;
		HistoryEntry* _tmp20_ = NULL;
		History* _tmp21_ = NULL;
		HistoryEntry* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		_tmp5_ = g_date_time_new_now_local ();
		date = _tmp5_;
		_tmp6_ = self->priv->game_view;
		_tmp7_ = game_view_get_game (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = game_get_elapsed (_tmp8_);
		_tmp10_ = _tmp9_;
		duration = (guint) (_tmp10_ + 0.5);
		_tmp11_ = date;
		_tmp12_ = self->priv->game_view;
		_tmp13_ = game_view_get_game (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->map;
		_tmp16_ = _tmp15_->score_name;
		_tmp17_ = duration;
		_tmp18_ = history_entry_new (_tmp11_, _tmp16_, _tmp17_);
		entry = _tmp18_;
		_tmp19_ = self->priv->history;
		_tmp20_ = entry;
		history_add (_tmp19_, _tmp20_);
		_tmp21_ = self->priv->history;
		history_save (_tmp21_);
		_tmp22_ = entry;
		_tmp23_ = mahjongg_show_scores (self, _tmp22_, TRUE);
		if (_tmp23_ == ((gint) GTK_RESPONSE_CLOSE)) {
			GtkApplicationWindow* _tmp24_ = NULL;
			_tmp24_ = self->priv->window;
			gtk_widget_destroy ((GtkWidget*) _tmp24_);
		} else {
			mahjongg_new_game (self);
		}
		_g_object_unref0 (entry);
		_g_date_time_unref0 (date);
	} else {
		GameView* _tmp25_ = NULL;
		Game* _tmp26_ = NULL;
		Game* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp25_ = self->priv->game_view;
		_tmp26_ = game_view_get_game (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = game_get_can_move (_tmp27_);
		_tmp29_ = _tmp28_;
		if (!_tmp29_) {
			gboolean allow_shuffle = FALSE;
			GameView* _tmp30_ = NULL;
			Game* _tmp31_ = NULL;
			Game* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			GtkMessageDialog* dialog = NULL;
			GtkApplicationWindow* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			GtkMessageDialog* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			GtkMessageDialog* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			GtkMessageDialog* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			gint _result_ = 0;
			GtkMessageDialog* _tmp53_ = NULL;
			gint _tmp54_ = 0;
			GtkMessageDialog* _tmp55_ = NULL;
			gint _tmp56_ = 0;
			_tmp30_ = self->priv->game_view;
			_tmp31_ = game_view_get_game (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = game_number_of_movable_tiles (_tmp32_);
			allow_shuffle = _tmp33_ > 1;
			_tmp34_ = self->priv->window;
			_tmp35_ = _ ("There are no more moves.");
			_tmp36_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp34_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _tmp35_);
			g_object_ref_sink (_tmp36_);
			dialog = _tmp36_;
			_tmp38_ = allow_shuffle;
			if (_tmp38_) {
				_tmp37_ = " ";
			} else {
				_tmp37_ = "";
			}
			_tmp40_ = allow_shuffle;
			if (_tmp40_) {
				const gchar* _tmp41_ = NULL;
				_tmp41_ = _ ("You can also try to reshuffle the game, but this does not guarantee a " \
"solution.");
				_tmp39_ = _tmp41_;
			} else {
				_tmp39_ = "";
			}
			_tmp42_ = dialog;
			_tmp43_ = _ ("Each puzzle has at least one solution.  You can undo your moves and tr" \
"y and find the solution, restart this game, or start a new one.");
			_tmp44_ = g_strdup_printf ("%s%s%s", _tmp43_, _tmp37_, _tmp39_);
			_tmp45_ = _tmp44_;
			gtk_message_dialog_format_secondary_text (_tmp42_, "%s", _tmp45_);
			_g_free0 (_tmp45_);
			_tmp47_ = allow_shuffle;
			if (_tmp47_) {
				const gchar* _tmp48_ = NULL;
				_tmp48_ = _ ("_Shuffle");
				_tmp46_ = _tmp48_;
			} else {
				_tmp46_ = NULL;
			}
			_tmp49_ = dialog;
			_tmp50_ = _ ("_Undo");
			_tmp51_ = _ ("_Restart");
			_tmp52_ = _ ("_New game");
			gtk_dialog_add_buttons ((GtkDialog*) _tmp49_, _tmp50_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO, _tmp51_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART, _tmp52_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME, _tmp46_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE, NULL);
			_tmp53_ = dialog;
			_tmp54_ = gtk_dialog_run ((GtkDialog*) _tmp53_);
			_result_ = _tmp54_;
			_tmp55_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp55_);
			_tmp56_ = _result_;
			switch (_tmp56_) {
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO:
				{
					mahjongg_undo_cb (self);
					break;
				}
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE:
				{
					mahjongg_shuffle_cb (self);
					break;
				}
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART:
				{
					mahjongg_restart_game (self);
					break;
				}
				case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME:
				{
					mahjongg_new_game (self);
					break;
				}
				case GTK_RESPONSE_DELETE_EVENT:
				{
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			_g_object_unref0 (dialog);
		}
	}
}


static gint mahjongg_show_scores (Mahjongg* self, HistoryEntry* selected_entry, gboolean show_quit) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_quit;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void _mahjongg_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	mahjongg_preferences_dialog_response_cb ((Mahjongg*) self, _sender, response_id);
}


static void _mahjongg_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	mahjongg_theme_changed_cb ((Mahjongg*) self, _sender);
}


static void _mahjongg_map_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	mahjongg_map_changed_cb ((Mahjongg*) self, _sender);
}


static void _mahjongg_background_changed_cb_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
	mahjongg_background_changed_cb ((Mahjongg*) self, _sender);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void mahjongg_preferences_cb (Mahjongg* self) {
	GtkDialog* _tmp0_ = NULL;
	gboolean dialogs_use_header = FALSE;
	GtkSettings* _tmp2_ = NULL;
	GtkDialogFlags _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GtkApplicationWindow* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkBox* dialog_content_area = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GtkDialog* _tmp14_ = NULL;
	GtkDialog* _tmp15_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkGrid* _tmp18_ = NULL;
	GtkGrid* _tmp19_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkGrid* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GList* themes = NULL;
	GList* _tmp25_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkListStore* theme_store = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	GtkListStore* _tmp29_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkComboBox* _tmp31_ = NULL;
	GtkCellRendererText* _tmp32_ = NULL;
	GtkComboBox* _tmp33_ = NULL;
	GtkCellRendererText* _tmp34_ = NULL;
	GList* _tmp35_ = NULL;
	GtkComboBox* _tmp56_ = NULL;
	GtkComboBox* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GtkComboBox* _tmp59_ = NULL;
	GtkLabel* _tmp60_ = NULL;
	GtkComboBox* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkLabel* _tmp64_ = NULL;
	GtkGrid* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkComboBox* map_combo = NULL;
	GtkComboBox* _tmp67_ = NULL;
	GtkListStore* map_store = NULL;
	GtkListStore* _tmp68_ = NULL;
	GtkComboBox* _tmp69_ = NULL;
	GtkListStore* _tmp70_ = NULL;
	GtkCellRendererText* _tmp71_ = NULL;
	GtkComboBox* _tmp72_ = NULL;
	GtkCellRendererText* _tmp73_ = NULL;
	GtkComboBox* _tmp74_ = NULL;
	GtkCellRendererText* _tmp75_ = NULL;
	GList* _tmp76_ = NULL;
	GtkComboBox* _tmp96_ = NULL;
	GtkComboBox* _tmp97_ = NULL;
	GtkGrid* _tmp98_ = NULL;
	GtkComboBox* _tmp99_ = NULL;
	GtkLabel* _tmp100_ = NULL;
	GtkComboBox* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkLabel* _tmp103_ = NULL;
	GtkLabel* _tmp104_ = NULL;
	GtkGrid* _tmp105_ = NULL;
	GtkLabel* _tmp106_ = NULL;
	GtkColorButton* widget = NULL;
	GtkColorButton* _tmp107_ = NULL;
	GtkColorButton* _tmp108_ = NULL;
	GameView* _tmp109_ = NULL;
	GdkRGBA _tmp110_ = {0};
	GtkColorButton* _tmp111_ = NULL;
	GtkColorButton* _tmp112_ = NULL;
	GtkGrid* _tmp113_ = NULL;
	GtkColorButton* _tmp114_ = NULL;
	GtkLabel* _tmp115_ = NULL;
	GtkColorButton* _tmp116_ = NULL;
	GtkBox* _tmp117_ = NULL;
	GtkGrid* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	GtkDialog* _tmp122_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		GtkDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp2_, "gtk-dialogs-use-header", &dialogs_use_header, NULL);
	_tmp4_ = dialogs_use_header;
	if (_tmp4_) {
		_tmp3_ = GTK_DIALOG_USE_HEADER_BAR;
	} else {
		_tmp3_ = 0;
	}
	_tmp5_ = _ ("Preferences");
	_tmp6_ = self->priv->window;
	_tmp7_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp5_, (GtkWindow*) _tmp6_, _tmp3_, NULL, NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp7_;
	_tmp8_ = self->priv->preferences_dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp8_, (guint) 5);
	_tmp9_ = self->priv->preferences_dialog;
	_tmp10_ = (GtkBox*) gtk_dialog_get_content_area (_tmp9_);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_box_get_type (), GtkBox));
	dialog_content_area = _tmp11_;
	_tmp12_ = dialog_content_area;
	gtk_box_set_spacing (_tmp12_, 2);
	_tmp13_ = self->priv->preferences_dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp13_, FALSE);
	_tmp14_ = self->priv->preferences_dialog;
	gtk_dialog_set_default_response (_tmp14_, (gint) GTK_RESPONSE_CLOSE);
	_tmp15_ = self->priv->preferences_dialog;
	g_signal_connect_object (_tmp15_, "response", (GCallback) _mahjongg_preferences_dialog_response_cb_gtk_dialog_response, self, 0);
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	grid = _tmp16_;
	_tmp17_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp17_, (guint) 5);
	_tmp18_ = grid;
	gtk_grid_set_row_spacing (_tmp18_, (guint) 6);
	_tmp19_ = grid;
	gtk_grid_set_column_spacing (_tmp19_, (guint) 18);
	_tmp20_ = _ ("_Theme:");
	_tmp21_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp20_);
	g_object_ref_sink (_tmp21_);
	label = _tmp21_;
	_tmp22_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp22_, (gfloat) 0, 0.5f);
	_tmp23_ = grid;
	_tmp24_ = label;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 0, 0, 1, 1);
	_tmp25_ = mahjongg_load_themes (self);
	themes = _tmp25_;
	_tmp26_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp26_);
	theme_combo = _tmp26_;
	_tmp27_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	theme_store = _tmp27_;
	_tmp28_ = theme_combo;
	_tmp29_ = theme_store;
	gtk_combo_box_set_model (_tmp28_, (GtkTreeModel*) _tmp29_);
	_tmp30_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp30_);
	renderer = _tmp30_;
	_tmp31_ = theme_combo;
	_tmp32_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, TRUE);
	_tmp33_ = theme_combo;
	_tmp34_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, "text", 0);
	_tmp35_ = themes;
	{
		GList* theme_collection = NULL;
		GList* theme_it = NULL;
		theme_collection = _tmp35_;
		for (theme_it = theme_collection; theme_it != NULL; theme_it = theme_it->next) {
			gchar* _tmp36_ = NULL;
			gchar* theme = NULL;
			_tmp36_ = g_strdup ((const gchar*) theme_it->data);
			theme = _tmp36_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp37_ = NULL;
				gchar** _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar* name = NULL;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp43_ = NULL;
				GtkTreeIter _tmp44_ = {0};
				GtkListStore* _tmp45_ = NULL;
				GtkTreeIter _tmp46_ = {0};
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				GSettings* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
				_tmp37_ = theme;
				_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, ".", -1);
				tokens = _tmp39_;
				tokens_length1 = _vala_array_length (_tmp38_);
				_tokens_size_ = tokens_length1;
				_tmp40_ = tokens;
				_tmp40__length1 = tokens_length1;
				_tmp41_ = _tmp40_[0];
				_tmp42_ = g_strdup (_tmp41_);
				name = _tmp42_;
				_tmp43_ = theme_store;
				gtk_list_store_append (_tmp43_, &_tmp44_);
				iter = _tmp44_;
				_tmp45_ = theme_store;
				_tmp46_ = iter;
				_tmp47_ = name;
				_tmp48_ = theme;
				gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, _tmp48_, -1, -1);
				_tmp49_ = theme;
				_tmp50_ = self->priv->settings;
				_tmp51_ = g_settings_get_string (_tmp50_, "tileset");
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strcmp0 (_tmp49_, _tmp52_) == 0;
				_g_free0 (_tmp52_);
				if (_tmp53_) {
					GtkComboBox* _tmp54_ = NULL;
					GtkTreeIter _tmp55_ = {0};
					_tmp54_ = theme_combo;
					_tmp55_ = iter;
					gtk_combo_box_set_active_iter (_tmp54_, &_tmp55_);
				}
				_g_free0 (name);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (theme);
			}
		}
	}
	_tmp56_ = theme_combo;
	g_signal_connect_object (_tmp56_, "changed", (GCallback) _mahjongg_theme_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp57_ = theme_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp57_, TRUE);
	_tmp58_ = grid;
	_tmp59_ = theme_combo;
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 1, 0, 1, 1);
	_tmp60_ = label;
	_tmp61_ = theme_combo;
	gtk_label_set_mnemonic_widget (_tmp60_, (GtkWidget*) _tmp61_);
	_tmp62_ = _ ("_Layout:");
	_tmp63_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp62_);
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (label);
	label = _tmp63_;
	_tmp64_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp64_, (gfloat) 0, 0.5f);
	_tmp65_ = grid;
	_tmp66_ = label;
	gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 0, 1, 1, 1);
	_tmp67_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp67_);
	map_combo = _tmp67_;
	_tmp68_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	map_store = _tmp68_;
	_tmp69_ = map_combo;
	_tmp70_ = map_store;
	gtk_combo_box_set_model (_tmp69_, (GtkTreeModel*) _tmp70_);
	_tmp71_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (renderer);
	renderer = _tmp71_;
	_tmp72_ = map_combo;
	_tmp73_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp72_, (GtkCellRenderer*) _tmp73_, TRUE);
	_tmp74_ = map_combo;
	_tmp75_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp74_, (GtkCellRenderer*) _tmp75_, "text", 0);
	_tmp76_ = self->priv->maps;
	{
		GList* map_collection = NULL;
		GList* map_it = NULL;
		map_collection = _tmp76_;
		for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
			Map* _tmp77_ = NULL;
			Map* map = NULL;
			_tmp77_ = _g_object_ref0 ((Map*) map_it->data);
			map = _tmp77_;
			{
				gchar* display_name = NULL;
				Map* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp82_ = NULL;
				GtkTreeIter _tmp83_ = {0};
				GtkListStore* _tmp84_ = NULL;
				GtkTreeIter _tmp85_ = {0};
				const gchar* _tmp86_ = NULL;
				Map* _tmp87_ = NULL;
				GSettings* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				gchar* _tmp90_ = NULL;
				Map* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				gboolean _tmp93_ = FALSE;
				_tmp78_ = map;
				_tmp79_ = _tmp78_->name;
				_tmp80_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp79_);
				_tmp81_ = g_strdup (_tmp80_);
				display_name = _tmp81_;
				_tmp82_ = map_store;
				gtk_list_store_append (_tmp82_, &_tmp83_);
				iter = _tmp83_;
				_tmp84_ = map_store;
				_tmp85_ = iter;
				_tmp86_ = display_name;
				_tmp87_ = map;
				gtk_list_store_set (_tmp84_, &_tmp85_, 0, _tmp86_, 1, _tmp87_, -1, -1);
				_tmp88_ = self->priv->settings;
				_tmp89_ = g_settings_get_string (_tmp88_, "mapset");
				_tmp90_ = _tmp89_;
				_tmp91_ = map;
				_tmp92_ = _tmp91_->name;
				_tmp93_ = g_strcmp0 (_tmp90_, _tmp92_) == 0;
				_g_free0 (_tmp90_);
				if (_tmp93_) {
					GtkComboBox* _tmp94_ = NULL;
					GtkTreeIter _tmp95_ = {0};
					_tmp94_ = map_combo;
					_tmp95_ = iter;
					gtk_combo_box_set_active_iter (_tmp94_, &_tmp95_);
				}
				_g_free0 (display_name);
				_g_object_unref0 (map);
			}
		}
	}
	_tmp96_ = map_combo;
	g_signal_connect_object (_tmp96_, "changed", (GCallback) _mahjongg_map_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp97_ = map_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp97_, TRUE);
	_tmp98_ = grid;
	_tmp99_ = map_combo;
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 1, 1, 1, 1);
	_tmp100_ = label;
	_tmp101_ = map_combo;
	gtk_label_set_mnemonic_widget (_tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = _ ("_Background color:");
	_tmp103_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp102_);
	g_object_ref_sink (_tmp103_);
	_g_object_unref0 (label);
	label = _tmp103_;
	_tmp104_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp104_, (gfloat) 0, 0.5f);
	_tmp105_ = grid;
	_tmp106_ = label;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 0, 2, 1, 1);
	_tmp107_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp107_);
	widget = _tmp107_;
	_tmp108_ = widget;
	_tmp109_ = self->priv->game_view;
	_tmp110_ = _tmp109_->background_color;
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp108_, &_tmp110_);
	_tmp111_ = widget;
	g_signal_connect_object (_tmp111_, "color-set", (GCallback) _mahjongg_background_changed_cb_gtk_color_button_color_set, self, 0);
	_tmp112_ = widget;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp112_, TRUE);
	_tmp113_ = grid;
	_tmp114_ = widget;
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 1, 2, 1, 1);
	_tmp115_ = label;
	_tmp116_ = widget;
	gtk_label_set_mnemonic_widget (_tmp115_, (GtkWidget*) _tmp116_);
	_tmp117_ = dialog_content_area;
	_tmp118_ = grid;
	gtk_box_pack_start (_tmp117_, (GtkWidget*) _tmp118_, TRUE, TRUE, (guint) 0);
	_tmp119_ = dialogs_use_header;
	if (!_tmp119_) {
		GtkDialog* _tmp120_ = NULL;
		const gchar* _tmp121_ = NULL;
		_tmp120_ = self->priv->preferences_dialog;
		_tmp121_ = _ ("_Close");
		gtk_dialog_add_button (_tmp120_, _tmp121_, (gint) GTK_RESPONSE_CLOSE);
	}
	_tmp122_ = self->priv->preferences_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp122_);
	_g_object_unref0 (widget);
	_g_object_unref0 (map_store);
	_g_object_unref0 (map_combo);
	_g_object_unref0 (renderer);
	_g_object_unref0 (theme_store);
	_g_object_unref0 (theme_combo);
	__g_list_free__g_free0_0 (themes);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (dialog_content_area);
}


static void mahjongg_preferences_dialog_response_cb (Mahjongg* self, GtkDialog* dialog, gint response) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = NULL;
}


static GList* mahjongg_load_themes (Mahjongg* self) {
	GList* result = NULL;
	GList* themes = NULL;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	themes = NULL;
	{
		GDir* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GDir* _tmp3_ = NULL;
		GDir* _tmp4_ = NULL;
		GDir* _tmp5_ = NULL;
		_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_dir_close0 (dir);
			__g_list_free__g_free0_0 (themes);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp5_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = themes;
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (dir);
		__g_list_free__g_free0_0 (themes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		gchar* s = NULL;
		GDir* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp6_ = dir;
		_tmp7_ = g_dir_read_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		s = _tmp8_;
		_tmp9_ = s;
		if (_tmp9_ == NULL) {
			_g_free0 (s);
			break;
		}
		_tmp15_ = s;
		_tmp16_ = g_str_has_suffix (_tmp15_, ".xpm");
		if (_tmp16_) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp17_ = s;
			_tmp18_ = g_str_has_suffix (_tmp17_, ".svg");
			_tmp14_ = _tmp18_;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = s;
			_tmp20_ = g_str_has_suffix (_tmp19_, ".gif");
			_tmp13_ = _tmp20_;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = s;
			_tmp22_ = g_str_has_suffix (_tmp21_, ".png");
			_tmp12_ = _tmp22_;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = s;
			_tmp24_ = g_str_has_suffix (_tmp23_, ".jpg");
			_tmp11_ = _tmp24_;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = s;
			_tmp26_ = g_str_has_suffix (_tmp25_, ".xbm");
			_tmp10_ = _tmp26_;
		}
		if (_tmp10_) {
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp27_ = s;
			_tmp28_ = g_strdup (_tmp27_);
			themes = g_list_append (themes, _tmp28_);
		}
		_g_free0 (s);
	}
	result = themes;
	_g_dir_close0 (dir);
	return result;
}


static void mahjongg_hint_cb (Mahjongg* self) {
	GList* matches = NULL;
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GameView* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Tile* _tmp6_ = NULL;
	Tile* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gint32 n = 0;
	GList* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	gint32 _tmp22_ = 0;
	Match* match = NULL;
	GList* _tmp23_ = NULL;
	gint32 _tmp24_ = 0;
	gconstpointer _tmp25_ = NULL;
	Match* _tmp26_ = NULL;
	GameView* _tmp27_ = NULL;
	Game* _tmp28_ = NULL;
	Game* _tmp29_ = NULL;
	Match* _tmp30_ = NULL;
	Tile* _tmp31_ = NULL;
	Match* _tmp32_ = NULL;
	Tile* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_selected_tile (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = game_find_matches (_tmp2_, _tmp7_);
	matches = _tmp8_;
	_tmp9_ = matches;
	_tmp10_ = g_list_length (_tmp9_);
	if (_tmp10_ == ((guint) 0)) {
		GameView* _tmp11_ = NULL;
		Game* _tmp12_ = NULL;
		Game* _tmp13_ = NULL;
		Tile* _tmp14_ = NULL;
		Tile* _tmp15_ = NULL;
		GameView* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		Game* _tmp18_ = NULL;
		GList* _tmp19_ = NULL;
		_tmp11_ = self->priv->game_view;
		_tmp12_ = game_view_get_game (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = game_get_selected_tile (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == NULL) {
			__g_list_free__g_object_unref0_0 (matches);
			return;
		}
		_tmp16_ = self->priv->game_view;
		_tmp17_ = game_view_get_game (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = game_find_matches (_tmp18_, NULL);
		__g_list_free__g_object_unref0_0 (matches);
		matches = _tmp19_;
	}
	_tmp20_ = matches;
	_tmp21_ = g_list_length (_tmp20_);
	_tmp22_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp21_));
	n = _tmp22_;
	_tmp23_ = matches;
	_tmp24_ = n;
	_tmp25_ = g_list_nth_data (_tmp23_, (guint) _tmp24_);
	_tmp26_ = _g_object_ref0 ((Match*) _tmp25_);
	match = _tmp26_;
	_tmp27_ = self->priv->game_view;
	_tmp28_ = game_view_get_game (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = match;
	_tmp31_ = _tmp30_->tile0;
	_tmp32_ = match;
	_tmp33_ = _tmp32_->tile1;
	game_set_hint (_tmp29_, _tmp31_, _tmp33_);
	mahjongg_update_ui (self);
	_g_object_unref0 (match);
	__g_list_free__g_object_unref0_0 (matches);
}


static void mahjongg_shuffle_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_shuffle_remaining (_tmp2_, TRUE);
}


static void mahjongg_about_cb (Mahjongg* self) {
	gchar** authors = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkApplicationWindow* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Francisco Bustamante");
	_tmp3_ = g_strdup ("Max Watson");
	_tmp4_ = g_strdup ("Heinz Hempe");
	_tmp5_ = g_strdup ("Michael Meeks");
	_tmp6_ = g_strdup ("Philippe Chavin");
	_tmp7_ = g_strdup ("Callum McKenzie");
	_tmp8_ = g_strdup ("Robert Ancell");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Maps:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Rexford Newbould");
	_tmp13_ = g_strdup ("Krzysztof Foltman");
	_tmp14_ = g_new0 (gchar*, 13 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp6_;
	_tmp14_[6] = _tmp7_;
	_tmp14_[7] = _tmp8_;
	_tmp14_[8] = _tmp9_;
	_tmp14_[9] = _tmp11_;
	_tmp14_[10] = _tmp12_;
	_tmp14_[11] = _tmp13_;
	_tmp14_[12] = NULL;
	authors = _tmp14_;
	authors_length1 = 13;
	_authors_size_ = authors_length1;
	_tmp15_ = _ ("Tiles:");
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = g_strdup ("Jonathan Buzzard");
	_tmp18_ = g_strdup ("Jim Evans");
	_tmp19_ = g_strdup ("Richard Hoelscher");
	_tmp20_ = g_strdup ("Gonzalo Odiard");
	_tmp21_ = g_strdup ("Max Watson");
	_tmp22_ = g_new0 (gchar*, 7 + 1);
	_tmp22_[0] = _tmp16_;
	_tmp22_[1] = _tmp17_;
	_tmp22_[2] = _tmp18_;
	_tmp22_[3] = _tmp19_;
	_tmp22_[4] = _tmp20_;
	_tmp22_[5] = _tmp21_;
	_tmp22_[6] = NULL;
	artists = _tmp22_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp23_ = g_strdup ("Tiffany Antopolski");
	_tmp24_ = g_strdup ("Chris Beiser");
	_tmp25_ = g_new0 (gchar*, 3 + 1);
	_tmp25_[0] = _tmp23_;
	_tmp25_[1] = _tmp24_;
	_tmp25_[2] = NULL;
	documenters = _tmp25_;
	documenters_length1 = 3;
	_documenters_size_ = documenters_length1;
	_tmp26_ = self->priv->window;
	_tmp27_ = _ ("Mahjongg");
	_tmp28_ = _ ("A matching game played with Mahjongg tiles");
	_tmp29_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) _tmp26_, "program-name", _tmp27_, "version", VERSION, "comments", _tmp28_, "copyright", "Copyright © 1998–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp29_, "logo-icon-name", "gnome-mahjongg", "website", "https://wiki.gnome.org/Apps/Mahjongg", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void mahjongg_pause_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GameView* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	GameView* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	GtkImage* pause_image = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	GtkImage* _tmp17_ = NULL;
	GameView* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	Game* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_paused (_tmp5_);
	_tmp7_ = _tmp6_;
	game_set_paused (_tmp2_, !_tmp7_);
	_tmp8_ = self->priv->game_view;
	_tmp9_ = game_view_get_game (_tmp8_);
	_tmp10_ = _tmp9_;
	game_set_hint (_tmp10_, NULL, NULL);
	_tmp11_ = self->priv->game_view;
	_tmp12_ = game_view_get_game (_tmp11_);
	_tmp13_ = _tmp12_;
	game_set_selected_tile (_tmp13_, NULL);
	_tmp14_ = self->priv->pause_button;
	_tmp15_ = gtk_button_get_image (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_image_get_type (), GtkImage));
	pause_image = _tmp17_;
	_tmp18_ = self->priv->game_view;
	_tmp19_ = game_view_get_game (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = game_get_paused (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_) {
		GtkImage* _tmp23_ = NULL;
		GtkButton* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp23_ = pause_image;
		g_object_set (_tmp23_, "icon-name", "media-playback-start-symbolic", NULL);
		_tmp24_ = self->priv->pause_button;
		_tmp25_ = _ ("Unpause the game");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _tmp25_);
	} else {
		GtkImage* _tmp26_ = NULL;
		GtkButton* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		_tmp26_ = pause_image;
		g_object_set (_tmp26_, "icon-name", "media-playback-pause-symbolic", NULL);
		_tmp27_ = self->priv->pause_button;
		_tmp28_ = _ ("Pause the game");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _tmp28_);
	}
	mahjongg_update_ui (self);
	_g_object_unref0 (pause_image);
}


static void mahjongg_scores_cb (Mahjongg* self) {
	g_return_if_fail (self != NULL);
	mahjongg_show_scores (self, NULL, FALSE);
}


static void mahjongg_new_game_cb (Mahjongg* self) {
	g_return_if_fail (self != NULL);
	mahjongg_new_game (self);
}


static void mahjongg_restart_game_cb (Mahjongg* self) {
	g_return_if_fail (self != NULL);
	mahjongg_restart_game (self);
}


static void mahjongg_quit_cb (Mahjongg* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mahjongg_redo_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->game_view;
	_tmp6_ = game_view_get_game (_tmp5_);
	_tmp7_ = _tmp6_;
	game_redo (_tmp7_);
	mahjongg_update_ui (self);
}


static void mahjongg_undo_cb (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_undo (_tmp2_);
	mahjongg_update_ui (self);
}


static void mahjongg_restart_game (Mahjongg* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GameView* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_reset (_tmp2_);
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_paused (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		mahjongg_pause_cb (self);
	}
	mahjongg_update_ui (self);
}


static void _mahjongg_moved_cb_game_moved (Game* _sender, gpointer self) {
	mahjongg_moved_cb ((Mahjongg*) self);
}


static void _mahjongg_tick_cb_game_tick (Game* _sender, gpointer self) {
	mahjongg_tick_cb ((Mahjongg*) self);
}


static void mahjongg_new_game (Mahjongg* self) {
	Map* map = NULL;
	GList* _tmp0_ = NULL;
	Map* _tmp10_ = NULL;
	GameView* _tmp14_ = NULL;
	Map* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	Game* _tmp17_ = NULL;
	GameView* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	Game* _tmp20_ = NULL;
	GameView* _tmp21_ = NULL;
	Game* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gchar* display_name = NULL;
	GameView* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	Game* _tmp26_ = NULL;
	Map* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GtkImage* pause_image = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	GtkImage* _tmp36_ = NULL;
	g_return_if_fail (self != NULL);
	map = NULL;
	_tmp0_ = self->priv->maps;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp0_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Map* _tmp1_ = NULL;
			Map* m = NULL;
			_tmp1_ = _g_object_ref0 ((Map*) m_it->data);
			m = _tmp1_;
			{
				Map* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				GSettings* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = m;
				_tmp3_ = _tmp2_->name;
				_tmp4_ = self->priv->settings;
				_tmp5_ = g_settings_get_string (_tmp4_, "mapset");
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					Map* _tmp8_ = NULL;
					Map* _tmp9_ = NULL;
					_tmp8_ = m;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (map);
					map = _tmp9_;
					_g_object_unref0 (m);
					break;
				}
				_g_object_unref0 (m);
			}
		}
	}
	_tmp10_ = map;
	if (_tmp10_ == NULL) {
		GList* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		Map* _tmp13_ = NULL;
		_tmp11_ = self->priv->maps;
		_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
		_tmp13_ = _g_object_ref0 ((Map*) _tmp12_);
		_g_object_unref0 (map);
		map = _tmp13_;
	}
	_tmp14_ = self->priv->game_view;
	_tmp15_ = map;
	_tmp16_ = game_new (_tmp15_);
	_tmp17_ = _tmp16_;
	game_view_set_game (_tmp14_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->game_view;
	_tmp19_ = game_view_get_game (_tmp18_);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "moved", (GCallback) _mahjongg_moved_cb_game_moved, self, 0);
	_tmp21_ = self->priv->game_view;
	_tmp22_ = game_view_get_game (_tmp21_);
	_tmp23_ = _tmp22_;
	g_signal_connect_object (_tmp23_, "tick", (GCallback) _mahjongg_tick_cb_game_tick, self, 0);
	_tmp24_ = self->priv->game_view;
	_tmp25_ = game_view_get_game (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_->map;
	_tmp28_ = _tmp27_->name;
	_tmp29_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp28_);
	_tmp30_ = g_strdup (_tmp29_);
	display_name = _tmp30_;
	_tmp31_ = self->priv->title;
	_tmp32_ = _ (display_name);
	gtk_label_set_label (_tmp31_, _tmp32_);
	mahjongg_update_ui (self);
	mahjongg_tick_cb (self);
	_tmp33_ = self->priv->pause_button;
	_tmp34_ = gtk_button_get_image (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_image_get_type (), GtkImage));
	pause_image = _tmp36_;
	g_object_set (pause_image, "icon-name", "media-playback-pause-symbolic", NULL);
	_g_object_unref0 (pause_image);
	_g_free0 (display_name);
	_g_object_unref0 (map);
}


static void mahjongg_tick_cb (Mahjongg* self) {
	gint elapsed = 0;
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint hours = 0;
	gint _tmp8_ = 0;
	gint minutes = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint seconds = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GameView* _tmp3_ = NULL;
		Game* _tmp4_ = NULL;
		Game* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp3_ = self->priv->game_view;
		_tmp4_ = game_view_get_game (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_get_elapsed (_tmp5_);
		_tmp7_ = _tmp6_;
		elapsed = (gint) (_tmp7_ + 0.5);
	}
	_tmp8_ = elapsed;
	hours = _tmp8_ / 3600;
	_tmp9_ = elapsed;
	_tmp10_ = hours;
	minutes = (_tmp9_ - (_tmp10_ * 3600)) / 60;
	_tmp11_ = elapsed;
	_tmp12_ = hours;
	_tmp13_ = minutes;
	seconds = (_tmp11_ - (_tmp12_ * 3600)) - (_tmp13_ * 60);
	_tmp14_ = hours;
	if (_tmp14_ > 0) {
		GtkLabel* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp15_ = self->priv->clock_label;
		_tmp16_ = hours;
		_tmp17_ = minutes;
		_tmp18_ = seconds;
		_tmp19_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		gtk_label_set_text (_tmp15_, _tmp20_);
		_g_free0 (_tmp20_);
	} else {
		GtkLabel* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp21_ = self->priv->clock_label;
		_tmp22_ = minutes;
		_tmp23_ = seconds;
		_tmp24_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		gtk_label_set_text (_tmp21_, _tmp25_);
		_g_free0 (_tmp25_);
	}
}


static void mahjongg_help_cb (Mahjongg* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-mahjongg", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-mahjongg.vala:763: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void mahjongg_load_maps (Mahjongg* self) {
	Map* _tmp0_ = NULL;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->maps);
	self->priv->maps = NULL;
	_tmp0_ = map_new_builtin ();
	self->priv->maps = g_list_append (self->priv->maps, _tmp0_);
	{
		GDir* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GDir* _tmp4_ = NULL;
		GDir* _tmp5_ = NULL;
		GDir* _tmp6_ = NULL;
		_tmp2_ = g_build_filename (DATA_DIRECTORY, "maps", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp6_;
		_g_dir_close0 (_tmp1_);
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	while (TRUE) {
		gchar* filename = NULL;
		GDir* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		MapLoader* loader = NULL;
		MapLoader* _tmp13_ = NULL;
		gchar* path = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		MapLoader* _tmp21_ = NULL;
		GList* _tmp22_ = NULL;
		_tmp7_ = dir;
		_tmp8_ = g_dir_read_name (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		filename = _tmp9_;
		_tmp10_ = filename;
		if (_tmp10_ == NULL) {
			_g_free0 (filename);
			break;
		}
		_tmp11_ = filename;
		_tmp12_ = g_str_has_suffix (_tmp11_, ".map");
		if (!_tmp12_) {
			_g_free0 (filename);
			continue;
		}
		_tmp13_ = map_loader_new ();
		loader = _tmp13_;
		_tmp14_ = filename;
		_tmp15_ = g_build_filename (DATA_DIRECTORY, "maps", _tmp14_, NULL);
		path = _tmp15_;
		{
			MapLoader* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = loader;
			_tmp17_ = path;
			map_loader_load (_tmp16_, _tmp17_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp18_ = NULL;
			GError* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = path;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_warning ("gnome-mahjongg.vala:800: Could not load map %s: %s\n", _tmp18_, _tmp20_);
			_g_error_free0 (e);
			_g_free0 (path);
			_g_object_unref0 (loader);
			_g_free0 (filename);
			continue;
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (path);
			_g_object_unref0 (loader);
			_g_free0 (filename);
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = loader;
		_tmp22_ = _tmp21_->maps;
		{
			GList* map_collection = NULL;
			GList* map_it = NULL;
			map_collection = _tmp22_;
			for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
				Map* _tmp23_ = NULL;
				Map* map = NULL;
				_tmp23_ = _g_object_ref0 ((Map*) map_it->data);
				map = _tmp23_;
				{
					Map* _tmp24_ = NULL;
					Map* _tmp25_ = NULL;
					_tmp24_ = map;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					self->priv->maps = g_list_append (self->priv->maps, _tmp25_);
					_g_object_unref0 (map);
				}
			}
		}
		_g_free0 (path);
		_g_object_unref0 (loader);
		_g_free0 (filename);
	}
	_g_dir_close0 (dir);
}


gint mahjongg_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Mahjongg* app = NULL;
	Mahjongg* _tmp1_ = NULL;
	gint _result_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("Mahjongg");
	g_set_application_name (_tmp0_);
	gtk_window_set_default_icon_name ("gnome-mahjongg");
	_tmp1_ = mahjongg_new ();
	app = _tmp1_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = g_application_run ((GApplication*) app, _tmp2__length1, _tmp2_);
	_result_ = _tmp3_;
	g_settings_sync ();
	result = _result_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return mahjongg_main (argv, argc);
}


static void mahjongg_class_init (MahjonggClass * klass) {
	mahjongg_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MahjonggPrivate));
	((GApplicationClass *) klass)->startup = mahjongg_real_startup;
	((GApplicationClass *) klass)->shutdown = mahjongg_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = mahjongg_real_handle_local_options;
	((GApplicationClass *) klass)->activate = mahjongg_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mahjongg_finalize;
}


static void mahjongg_instance_init (Mahjongg * self) {
	self->priv = MAHJONGG_GET_PRIVATE (self);
	self->priv->maps = NULL;
	self->priv->preferences_dialog = NULL;
}


static void mahjongg_finalize (GObject* obj) {
	Mahjongg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAHJONGG, Mahjongg);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->history);
	__g_list_free__g_object_unref0_0 (self->priv->maps);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->title);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->moves_label);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->preferences_dialog);
	G_OBJECT_CLASS (mahjongg_parent_class)->finalize (obj);
}


GType mahjongg_get_type (void) {
	static volatile gsize mahjongg_type_id__volatile = 0;
	if (g_once_init_enter (&mahjongg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MahjonggClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mahjongg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mahjongg), 0, (GInstanceInitFunc) mahjongg_instance_init, NULL };
		GType mahjongg_type_id;
		mahjongg_type_id = g_type_register_static (gtk_application_get_type (), "Mahjongg", &g_define_type_info, 0);
		g_once_init_leave (&mahjongg_type_id__volatile, mahjongg_type_id);
	}
	return mahjongg_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



