/* gterminal.c generated by valac 0.24.0.37-7b33e4, the Vala compiler
 * generated from gterminal.vala, do not modify */

/*
 * Copyright © 2014 Christian Persch
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "terminal-client-utils.h"
#include <gio/gunixfdlist.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include "terminal-profiles-list.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/wait.h>
#include "terminal-settings-list.h"
#include <locale.h>


#define GTERMINAL_TYPE_OUTPUT (gterminal_output_get_type ())
typedef struct _GTerminalOutput GTerminalOutput;
#define _g_option_group_free0(var) ((var == NULL) ? NULL : (var = (g_option_group_free (var), NULL)))

#define GTERMINAL_TYPE_GLOBAL_OPTIONS (gterminal_global_options_get_type ())
typedef struct _GTerminalGlobalOptions GTerminalGlobalOptions;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GTERMINAL_TYPE_OPEN_OPTIONS (gterminal_open_options_get_type ())
typedef struct _GTerminalOpenOptions GTerminalOpenOptions;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define GTERMINAL_TYPE_SERVER (gterminal_server_get_type ())
#define GTERMINAL_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTERMINAL_TYPE_SERVER, GTerminalServer))
#define GTERMINAL_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTERMINAL_TYPE_SERVER))
#define GTERMINAL_SERVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTERMINAL_TYPE_SERVER, GTerminalServerIface))

typedef struct _GTerminalServer GTerminalServer;
typedef struct _GTerminalServerIface GTerminalServerIface;

#define GTERMINAL_TYPE_SERVER_PROXY (gterminal_server_proxy_get_type ())
typedef GDBusProxy GTerminalServerProxy;
typedef GDBusProxyClass GTerminalServerProxyClass;

#define GTERMINAL_TYPE_RECEIVER (gterminal_receiver_get_type ())
#define GTERMINAL_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTERMINAL_TYPE_RECEIVER, GTerminalReceiver))
#define GTERMINAL_IS_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTERMINAL_TYPE_RECEIVER))
#define GTERMINAL_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTERMINAL_TYPE_RECEIVER, GTerminalReceiverIface))

typedef struct _GTerminalReceiver GTerminalReceiver;
typedef struct _GTerminalReceiverIface GTerminalReceiverIface;

#define GTERMINAL_TYPE_RECEIVER_PROXY (gterminal_receiver_proxy_get_type ())
typedef GDBusProxy GTerminalReceiverProxy;
typedef GDBusProxyClass GTerminalReceiverProxyClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define GTERMINAL_TYPE_COMMAND_MAP (gterminal_command_map_get_type ())
typedef struct _GTerminalCommandMap GTerminalCommandMap;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GTerminalOutput {
};

struct _GTerminalGlobalOptions {
};

struct _GTerminalOpenOptions {
};

struct _GTerminalServerIface {
	GTypeInterface parent_iface;
};

struct _GTerminalReceiverIface {
	GTypeInterface parent_iface;
};

struct _Block1Data {
	int _ref_count_;
	gint status;
	GMainLoop* loop;
};

typedef gint (*GTerminalCommandFunc) (gchar** args, int args_length1, void* user_data, GError** error);
struct _GTerminalCommandMap {
	const gchar* verb;
	GTerminalCommandFunc func;
	gpointer func_target;
};


extern gboolean gterminal_output_quiet;
gboolean gterminal_output_quiet = FALSE;
extern gboolean gterminal_output_verbose;
gboolean gterminal_output_verbose = FALSE;
extern gchar* gterminal_global_options_app_id;
gchar* gterminal_global_options_app_id = NULL;
extern gchar** gterminal_open_options_pass_fds;
gchar** gterminal_open_options_pass_fds = NULL;
extern gboolean gterminal_open_options_pass_stdin;
gboolean gterminal_open_options_pass_stdin = FALSE;
extern gboolean gterminal_open_options_pass_stdout;
gboolean gterminal_open_options_pass_stdout = FALSE;
extern gboolean gterminal_open_options_pass_stderr;
gboolean gterminal_open_options_pass_stderr = FALSE;
extern PassFdElement* gterminal_open_options_fd_array;
extern gint gterminal_open_options_fd_array_length1;
PassFdElement* gterminal_open_options_fd_array = NULL;
gint gterminal_open_options_fd_array_length1 = 0;
extern GUnixFDList* gterminal_open_options_fd_list;
GUnixFDList* gterminal_open_options_fd_list = NULL;
extern gchar* gterminal_open_options_geometry;
gchar* gterminal_open_options_geometry = NULL;
extern gchar* gterminal_open_options_role;
gchar* gterminal_open_options_role = NULL;
extern gboolean gterminal_open_options_show_menubar;
gboolean gterminal_open_options_show_menubar = TRUE;
extern gboolean gterminal_open_options_show_menubar_set;
gboolean gterminal_open_options_show_menubar_set = FALSE;
extern gboolean gterminal_open_options_maximise;
gboolean gterminal_open_options_maximise = FALSE;
extern gboolean gterminal_open_options_fullscreen;
gboolean gterminal_open_options_fullscreen = FALSE;
extern gchar* gterminal_open_options_working_directory;
gchar* gterminal_open_options_working_directory = NULL;
extern gchar* gterminal_open_options_profile;
gchar* gterminal_open_options_profile = NULL;
extern gchar* gterminal_open_options_title;
gchar* gterminal_open_options_title = NULL;
extern gdouble gterminal_open_options_zoom;
gdouble gterminal_open_options_zoom = 1.0;
extern gboolean gterminal_open_options_wait_for_remote;
gboolean gterminal_open_options_wait_for_remote = FALSE;
extern gchar** gterminal_open_options_argv_pre;
gchar** gterminal_open_options_argv_pre = NULL;
extern gchar** gterminal_open_options_argv_post;
gchar** gterminal_open_options_argv_post = NULL;
extern gchar* gterminal_open_options_display_name;
gchar* gterminal_open_options_display_name = NULL;
extern gchar* gterminal_open_options_startup_id;
gchar* gterminal_open_options_startup_id = NULL;

GType gterminal_output_get_type (void) G_GNUC_CONST;
GTerminalOutput* gterminal_output_dup (const GTerminalOutput* self);
void gterminal_output_free (GTerminalOutput* self);
void gterminal_output_set_quiet (gboolean value);
GOptionGroup* gterminal_output_get_option_group (GTerminalOutput *self);
void gterminal_output_print (GTerminalOutput *self, const gchar* format, ...);
void gterminal_output_printerr (GTerminalOutput *self, const gchar* format, ...);
void gterminal_output_info (GTerminalOutput *self, const gchar* format, ...);
GType gterminal_global_options_get_type (void) G_GNUC_CONST;
GTerminalGlobalOptions* gterminal_global_options_dup (const GTerminalGlobalOptions* self);
void gterminal_global_options_free (GTerminalGlobalOptions* self);
static gboolean gterminal_global_options_option_app_id (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error);
gchar* gterminal_global_options_get_app_id (void);
GOptionGroup* gterminal_global_options_get_option_group (void);
GType gterminal_open_options_get_type (void) G_GNUC_CONST;
GTerminalOpenOptions* gterminal_open_options_dup (const GTerminalOpenOptions* self);
void gterminal_open_options_free (GTerminalOpenOptions* self);
static gboolean gterminal_open_options_option_profile (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error);
static gboolean gterminal_open_options_option_zoom (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error);
static gboolean gterminal_open_options_post_parse (GOptionContext* context, GOptionGroup* group, void* unused_user_data, GError** error);
static void _vala_array_add1 (PassFdElement** array, int* length, int* size, PassFdElement value);
static PassFdElement* _vala_array_dup1 (PassFdElement* self, int length);
GOptionGroup* gterminal_open_options_get_exec_option_group (void);
GOptionGroup* gterminal_open_options_get_window_option_group (void);
GOptionGroup* gterminal_open_options_get_terminal_option_group (void);
GOptionGroup* gterminal_open_options_get_processing_option_group (void);
void gterminal_open_options_parse_argv (gchar** argv, int argv_length1, GError** error);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
GType gterminal_server_get_type (void) G_GNUC_CONST;
GType gterminal_server_proxy_get_type (void) G_GNUC_CONST;
guint gterminal_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define GTERMINAL_SERVER_SERVICE_NAME "org.gnome.Terminal"
#define GTERMINAL_SERVER_INTERFACE_NAME "org.gnome.Terminal.Factory0"
#define GTERMINAL_SERVER_OBJECT_PATH "/org/gnome/Terminal/Factory0"
static void gterminal_server_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void gterminal_server_proxy_gterminal_server_interface_init (GTerminalServerIface* iface);
static void gterminal_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gterminal_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gterminal_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gterminal_server_unregister_object (gpointer user_data);
GType gterminal_receiver_get_type (void) G_GNUC_CONST;
GType gterminal_receiver_proxy_get_type (void) G_GNUC_CONST;
guint gterminal_receiver_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define GTERMINAL_RECEIVER_INTERFACE_NAME "org.gnome.Terminal.Terminal0"
static void gterminal_receiver_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_gterminal_receiver_child_exited (GTerminalReceiver* self, GVariant* parameters);
static void gterminal_receiver_proxy_gterminal_receiver_interface_init (GTerminalReceiverIface* iface);
static void gterminal_receiver_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gterminal_receiver_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gterminal_receiver_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_gterminal_receiver_child_exited (GObject* _sender, gint exit_code, gpointer* _data);
static void _gterminal_receiver_unregister_object (gpointer user_data);
GTerminalServer* gterminal_get_server (GError** error);
GTerminalReceiver* gterminal_create_terminal (GError** error);
gint gterminal_mangle_exit_code (gint status);
gint gterminal_run (GTerminalReceiver* receiver);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda3_ (Block1Data* _data1_, gint s);
static void ___lambda3__gterminal_receiver_child_exited (GTerminalReceiver* _sender, gint exit_code, gpointer self);
gint gterminal_open (gchar** argv, int argv_length1, GError** error);
gint gterminal_help (gchar** argv, int argv_length1, GError** error);
gint gterminal_complete (gchar** argv, int argv_length1, GError** error);
GType gterminal_command_map_get_type (void) G_GNUC_CONST;
GTerminalCommandMap* gterminal_command_map_dup (const GTerminalCommandMap* self);
void gterminal_command_map_free (GTerminalCommandMap* self);
static gint _gterminal_help_gterminal_command_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_open_gterminal_command_func (gchar** args, int args_length1, gpointer self, GError** error);
static gint _gterminal_complete_gterminal_command_func (gchar** args, int args_length1, gpointer self, GError** error);
gint gterminal_main (gchar** argv, int argv_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry GTERMINAL_OUTPUT_entries[3] = {{"quiet", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_output_quiet, "Suppress output", NULL}, {"verbose", 'v', (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_output_verbose, "Verbose output", NULL}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_GLOBAL_OPTIONS_entries[2] = {{"app-id", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_CALLBACK, (void*) gterminal_global_options_option_app_id, "Server application ID", "ID"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_exec_entries[5] = {{"stdin", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_open_options_pass_stdin, "Forward stdin", NULL}, {"stdout", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_open_options_pass_stdout, "Forward stdout", NULL}, {"stderr", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &gterminal_open_options_pass_stderr, "Forward stderr", NULL}, {"fd", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &gterminal_open_options_pass_fds, "Forward file descriptor", "FD"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_window_entries[5] = {{"maximise", (gchar) 0, 0, G_OPTION_ARG_NONE, &gterminal_open_options_maximise, "Maximise the window", NULL}, {"fullscreen", (gchar) 0, 0, G_OPTION_ARG_NONE, &gterminal_open_options_fullscreen, "Full-screen the window", NULL}, {"geometry", (gchar) 0, 0, G_OPTION_ARG_STRING, &gterminal_open_options_geometry, "Set the window size; for example: 80x24, or 80x24+200+200 (COLSxROWS+X" \
"+Y)", "GEOMETRY"}, {"role", (gchar) 0, 0, G_OPTION_ARG_STRING, &gterminal_open_options_role, "Set the window role", "ROLE"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_terminal_entries[5] = {{"profile", (gchar) 0, 0, G_OPTION_ARG_CALLBACK, (void*) gterminal_open_options_option_profile, "Use the given profile instead of the default profile", "UUID"}, {"title", (gchar) 0, 0, G_OPTION_ARG_STRING, &gterminal_open_options_title, "Set the terminal title", "TITLE"}, {"cwd", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &gterminal_open_options_working_directory, "Set the working directory", "DIRNAME"}, {"zoom", (gchar) 0, 0, G_OPTION_ARG_CALLBACK, (void*) gterminal_open_options_option_zoom, "Set the terminal's zoom factor (1.0 = normal size)", "ZOOM"}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GOptionEntry GTERMINAL_OPEN_OPTIONS_processing_entries[2] = {{"wait", (gchar) 0, 0, G_OPTION_ARG_NONE, &gterminal_open_options_wait_for_remote, "Wait until the child exits", NULL}, {NULL, (gchar) 0, 0, 0, NULL, NULL, NULL}};
static const GDBusMethodInfo * const _gterminal_server_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _gterminal_server_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gterminal_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gterminal_server_dbus_interface_info = {-1, "org.gnome.Terminal.Factory0", (GDBusMethodInfo **) (&_gterminal_server_dbus_method_info), (GDBusSignalInfo **) (&_gterminal_server_dbus_signal_info), (GDBusPropertyInfo **) (&_gterminal_server_dbus_property_info)};
static const GDBusInterfaceVTable _gterminal_server_dbus_interface_vtable = {gterminal_server_dbus_interface_method_call, gterminal_server_dbus_interface_get_property, gterminal_server_dbus_interface_set_property};
static const GDBusMethodInfo * const _gterminal_receiver_dbus_method_info[] = {NULL};
static const GDBusArgInfo _gterminal_receiver_dbus_arg_info_child_exited_exit_code = {-1, "exit_code", "i"};
static const GDBusArgInfo * const _gterminal_receiver_dbus_arg_info_child_exited[] = {&_gterminal_receiver_dbus_arg_info_child_exited_exit_code, NULL};
static const GDBusSignalInfo _gterminal_receiver_dbus_signal_info_child_exited = {-1, "ChildExited", (GDBusArgInfo **) (&_gterminal_receiver_dbus_arg_info_child_exited)};
static const GDBusSignalInfo * const _gterminal_receiver_dbus_signal_info[] = {&_gterminal_receiver_dbus_signal_info_child_exited, NULL};
static const GDBusPropertyInfo * const _gterminal_receiver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gterminal_receiver_dbus_interface_info = {-1, "org.gnome.Terminal.Terminal0", (GDBusMethodInfo **) (&_gterminal_receiver_dbus_method_info), (GDBusSignalInfo **) (&_gterminal_receiver_dbus_signal_info), (GDBusPropertyInfo **) (&_gterminal_receiver_dbus_property_info)};
static const GDBusInterfaceVTable _gterminal_receiver_dbus_interface_vtable = {gterminal_receiver_dbus_interface_method_call, gterminal_receiver_dbus_interface_get_property, gterminal_receiver_dbus_interface_set_property};
const GTerminalCommandMap GTERMINAL_commands[4] = {{"help", _gterminal_help_gterminal_command_func}, {"open", _gterminal_open_gterminal_command_func}, {"shell", _gterminal_open_gterminal_command_func}, {"_complete", _gterminal_complete_gterminal_command_func}};

void gterminal_output_set_quiet (gboolean value) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = value;
	gterminal_output_quiet = _tmp0_;
}


GOptionGroup* gterminal_output_get_option_group (GTerminalOutput *self) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("output", "Output options:", "Show output options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OUTPUT_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


void gterminal_output_print (GTerminalOutput *self, const gchar* format, ...) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (format != NULL);
	_tmp0_ = gterminal_output_quiet;
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		va_list _tmp3_ = {0};
		_tmp1_ = stdout;
		_tmp2_ = format;
		va_start (_tmp3_, format);
		vfprintf (_tmp1_, _tmp2_, _tmp3_);
		va_end (_tmp3_);
	}
}


void gterminal_output_printerr (GTerminalOutput *self, const gchar* format, ...) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (format != NULL);
	_tmp0_ = gterminal_output_quiet;
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		va_list _tmp3_ = {0};
		_tmp1_ = stderr;
		_tmp2_ = format;
		va_start (_tmp3_, format);
		vfprintf (_tmp1_, _tmp2_, _tmp3_);
		va_end (_tmp3_);
	}
}


void gterminal_output_info (GTerminalOutput *self, const gchar* format, ...) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (format != NULL);
	_tmp0_ = gterminal_output_verbose;
	if (_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		va_list _tmp3_ = {0};
		_tmp1_ = stderr;
		_tmp2_ = format;
		va_start (_tmp3_, format);
		vfprintf (_tmp1_, _tmp2_, _tmp3_);
		va_end (_tmp3_);
	}
}


GTerminalOutput* gterminal_output_dup (const GTerminalOutput* self) {
	GTerminalOutput* dup;
	dup = g_new0 (GTerminalOutput, 1);
	memcpy (dup, self, sizeof (GTerminalOutput));
	return dup;
}


void gterminal_output_free (GTerminalOutput* self) {
	g_free (self);
}


GType gterminal_output_get_type (void) {
	static volatile gsize gterminal_output_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_output_type_id__volatile)) {
		GType gterminal_output_type_id;
		gterminal_output_type_id = g_boxed_type_register_static ("GTerminalOutput", (GBoxedCopyFunc) gterminal_output_dup, (GBoxedFreeFunc) gterminal_output_free);
		g_once_init_leave (&gterminal_output_type_id__volatile, gterminal_output_type_id);
	}
	return gterminal_output_type_id__volatile;
}


static gboolean gterminal_global_options_option_app_id (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = value;
	_tmp1_ = g_application_id_is_valid (_tmp0_);
	if (!_tmp1_) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = _ ("\"%s\" is not a valid application ID");
		_tmp3_ = value;
		_tmp4_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp2_, _tmp3_);
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == G_OPTION_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp5_ = value;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (gterminal_global_options_app_id);
	gterminal_global_options_app_id = _tmp6_;
	result = TRUE;
	return result;
}


gchar* gterminal_global_options_get_app_id (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp1_ = gterminal_global_options_app_id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = gterminal_global_options_app_id;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "org.gnome.Terminal";
	}
	_tmp3_ = g_strdup (_tmp0_);
	result = _tmp3_;
	return result;
}


GOptionGroup* gterminal_global_options_get_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("global", "Global options:", "Show global options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_GLOBAL_OPTIONS_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


GTerminalGlobalOptions* gterminal_global_options_dup (const GTerminalGlobalOptions* self) {
	GTerminalGlobalOptions* dup;
	dup = g_new0 (GTerminalGlobalOptions, 1);
	memcpy (dup, self, sizeof (GTerminalGlobalOptions));
	return dup;
}


void gterminal_global_options_free (GTerminalGlobalOptions* self) {
	g_free (self);
}


GType gterminal_global_options_get_type (void) {
	static volatile gsize gterminal_global_options_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_global_options_type_id__volatile)) {
		GType gterminal_global_options_type_id;
		gterminal_global_options_type_id = g_boxed_type_register_static ("GTerminalGlobalOptions", (GBoxedCopyFunc) gterminal_global_options_dup, (GBoxedFreeFunc) gterminal_global_options_free);
		g_once_init_leave (&gterminal_global_options_type_id__volatile, gterminal_global_options_type_id);
	}
	return gterminal_global_options_type_id__volatile;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static void _vala_array_add1 (PassFdElement** array, int* length, int* size, PassFdElement value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PassFdElement, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static PassFdElement* _vala_array_dup1 (PassFdElement* self, int length) {
	return g_memdup (self, length * sizeof (PassFdElement));
}


static gboolean gterminal_open_options_post_parse (GOptionContext* context, GOptionGroup* group, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	GUnixFDList* _tmp14_ = NULL;
	PassFdElement* arr = NULL;
	PassFdElement* _tmp15_ = NULL;
	gint arr_length1 = 0;
	gint _arr_size_ = 0;
	PassFdElement* _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
	PassFdElement* _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp2_ = gterminal_open_options_pass_stdin;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = gterminal_open_options_pass_stdout;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = gterminal_open_options_pass_stderr;
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		GError* _tmp12_ = NULL;
		_tmp6_ = gterminal_open_options_pass_stdin;
		if (_tmp6_) {
			const gchar* _tmp7_ = NULL;
			_tmp7_ = _ ("FD passing of stdin is not supported");
			_tmp5_ = _tmp7_;
		} else {
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp9_ = gterminal_open_options_pass_stdout;
			if (_tmp9_) {
				const gchar* _tmp10_ = NULL;
				_tmp10_ = _ ("FD passing of stdout is not supported");
				_tmp8_ = _tmp10_;
			} else {
				const gchar* _tmp11_ = NULL;
				_tmp11_ = _ ("FD passing of stderr is not supported");
				_tmp8_ = _tmp11_;
			}
			_tmp5_ = _tmp8_;
		}
		_tmp12_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp5_);
		_inner_error_ = _tmp12_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp13_ = gterminal_open_options_pass_fds;
	_tmp13__length1 = _vala_array_length (gterminal_open_options_pass_fds);
	if (_tmp13_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp14_ = g_unix_fd_list_new ();
	_g_object_unref0 (gterminal_open_options_fd_list);
	gterminal_open_options_fd_list = _tmp14_;
	_tmp15_ = g_new0 (PassFdElement, 0);
	arr = _tmp15_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				guint _tmp18_ = 0U;
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint64 v = 0LL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				guint _tmp24_ = 0U;
				const gchar* _tmp25_ = NULL;
				gint64 _tmp26_ = 0LL;
				gboolean _tmp27_ = FALSE;
				gint fd = 0;
				gint64 _tmp38_ = 0LL;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_ = 0;
				gint idx = 0;
				GUnixFDList* _tmp64_ = NULL;
				gint _tmp65_ = 0;
				gint _tmp66_ = 0;
				PassFdElement e = {0};
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				PassFdElement _tmp69_ = {0};
				PassFdElement* _tmp70_ = NULL;
				gint _tmp70__length1 = 0;
				PassFdElement _tmp71_ = {0};
				gboolean _tmp72_ = FALSE;
				gint _tmp73_ = 0;
				if (!_tmp16_) {
					guint _tmp17_ = 0U;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = gterminal_open_options_pass_fds;
				_tmp19__length1 = _vala_array_length (gterminal_open_options_pass_fds);
				if (!(_tmp18_ < ((guint) _tmp19__length1))) {
					break;
				}
				_tmp23_ = gterminal_open_options_pass_fds;
				_tmp23__length1 = _vala_array_length (gterminal_open_options_pass_fds);
				_tmp24_ = i;
				_tmp25_ = _tmp23_[_tmp24_];
				_tmp27_ = int64_try_parse (_tmp25_, &_tmp26_);
				v = _tmp26_;
				if (!_tmp27_) {
					_tmp22_ = TRUE;
				} else {
					gint64 _tmp28_ = 0LL;
					_tmp28_ = v;
					_tmp22_ = _tmp28_ == ((gint64) (-1));
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					gint64 _tmp29_ = 0LL;
					gint _tmp30_ = 0;
					_tmp29_ = v;
					_tmp30_ = G_MININT;
					_tmp21_ = _tmp29_ < ((gint64) _tmp30_);
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					gint64 _tmp31_ = 0LL;
					gint _tmp32_ = 0;
					_tmp31_ = v;
					_tmp32_ = G_MAXINT;
					_tmp20_ = _tmp31_ > ((gint64) _tmp32_);
				}
				if (_tmp20_) {
					const gchar* _tmp33_ = NULL;
					gchar** _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					guint _tmp35_ = 0U;
					const gchar* _tmp36_ = NULL;
					GError* _tmp37_ = NULL;
					_tmp33_ = _ ("Invalid argument \"%s\" to --fd option");
					_tmp34_ = gterminal_open_options_pass_fds;
					_tmp34__length1 = _vala_array_length (gterminal_open_options_pass_fds);
					_tmp35_ = i;
					_tmp36_ = _tmp34_[_tmp35_];
					_tmp37_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp33_, _tmp36_);
					_inner_error_ = _tmp37_;
					g_propagate_error (error, _inner_error_);
					arr = (g_free (arr), NULL);
					return FALSE;
				}
				_tmp38_ = v;
				fd = (gint) _tmp38_;
				_tmp41_ = fd;
				if (_tmp41_ == STDIN_FILENO) {
					_tmp40_ = TRUE;
				} else {
					gint _tmp42_ = 0;
					_tmp42_ = fd;
					_tmp40_ = _tmp42_ == STDOUT_FILENO;
				}
				if (_tmp40_) {
					_tmp39_ = TRUE;
				} else {
					gint _tmp43_ = 0;
					_tmp43_ = fd;
					_tmp39_ = _tmp43_ == STDERR_FILENO;
				}
				if (_tmp39_) {
					const gchar* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					GError* _tmp51_ = NULL;
					_tmp45_ = fd;
					if (_tmp45_ == STDIN_FILENO) {
						const gchar* _tmp46_ = NULL;
						_tmp46_ = _ ("FD passing of stdin is not supported");
						_tmp44_ = _tmp46_;
					} else {
						const gchar* _tmp47_ = NULL;
						gint _tmp48_ = 0;
						_tmp48_ = fd;
						if (_tmp48_ == STDOUT_FILENO) {
							const gchar* _tmp49_ = NULL;
							_tmp49_ = _ ("FD passing of stdout is not supported");
							_tmp47_ = _tmp49_;
						} else {
							const gchar* _tmp50_ = NULL;
							_tmp50_ = _ ("FD passing of stderr is not supported");
							_tmp47_ = _tmp50_;
						}
						_tmp44_ = _tmp47_;
					}
					_tmp51_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp44_);
					_inner_error_ = _tmp51_;
					g_propagate_error (error, _inner_error_);
					arr = (g_free (arr), NULL);
					return FALSE;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp52_ = FALSE;
						_tmp52_ = TRUE;
						while (TRUE) {
							guint _tmp54_ = 0U;
							PassFdElement* _tmp55_ = NULL;
							gint _tmp55__length1 = 0;
							PassFdElement* _tmp56_ = NULL;
							gint _tmp56__length1 = 0;
							guint _tmp57_ = 0U;
							PassFdElement _tmp58_ = {0};
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							if (!_tmp52_) {
								guint _tmp53_ = 0U;
								_tmp53_ = j;
								j = _tmp53_ + 1;
							}
							_tmp52_ = FALSE;
							_tmp54_ = j;
							_tmp55_ = arr;
							_tmp55__length1 = arr_length1;
							if (!(_tmp54_ < ((guint) _tmp55__length1))) {
								break;
							}
							_tmp56_ = arr;
							_tmp56__length1 = arr_length1;
							_tmp57_ = j;
							_tmp58_ = _tmp56_[_tmp57_];
							_tmp59_ = _tmp58_.fd;
							_tmp60_ = fd;
							if (_tmp59_ == _tmp60_) {
								const gchar* _tmp61_ = NULL;
								gint _tmp62_ = 0;
								GError* _tmp63_ = NULL;
								_tmp61_ = _ ("Cannot pass FD %d twice");
								_tmp62_ = fd;
								_tmp63_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp61_, _tmp62_);
								_inner_error_ = _tmp63_;
								g_propagate_error (error, _inner_error_);
								arr = (g_free (arr), NULL);
								return FALSE;
							}
						}
					}
				}
				_tmp64_ = gterminal_open_options_fd_list;
				_tmp65_ = fd;
				_tmp66_ = g_unix_fd_list_append (_tmp64_, _tmp65_, &_inner_error_);
				idx = _tmp66_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					arr = (g_free (arr), NULL);
					return FALSE;
				}
				_tmp67_ = idx;
				_tmp68_ = fd;
				_tmp69_.index = _tmp67_;
				_tmp69_.fd = _tmp68_;
				e = _tmp69_;
				_tmp70_ = arr;
				_tmp70__length1 = arr_length1;
				_tmp71_ = e;
				_vala_array_add1 (&arr, &arr_length1, &_arr_size_, _tmp71_);
				_tmp73_ = fd;
				if (_tmp73_ == STDOUT_FILENO) {
					_tmp72_ = TRUE;
				} else {
					gint _tmp74_ = 0;
					_tmp74_ = fd;
					_tmp72_ = _tmp74_ == STDERR_FILENO;
				}
				if (_tmp72_) {
					gterminal_output_set_quiet (TRUE);
				}
			}
		}
	}
	_tmp75_ = arr;
	_tmp75__length1 = arr_length1;
	_tmp76_ = (_tmp75_ != NULL) ? _vala_array_dup1 (_tmp75_, _tmp75__length1) : ((gpointer) _tmp75_);
	_tmp76__length1 = _tmp75__length1;
	gterminal_open_options_fd_array = (g_free (gterminal_open_options_fd_array), NULL);
	gterminal_open_options_fd_array = _tmp76_;
	gterminal_open_options_fd_array_length1 = _tmp76__length1;
	result = TRUE;
	arr = (g_free (arr), NULL);
	return result;
}


GOptionGroup* gterminal_open_options_get_exec_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("exec", "Exec options:", "Show exec options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_exec_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	g_option_group_set_parse_hooks (group, NULL, (GOptionParseFunc) gterminal_open_options_post_parse);
	result = group;
	return result;
}


GOptionGroup* gterminal_open_options_get_window_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("window", "Window options:", "Show window options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_window_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


static gboolean gterminal_open_options_option_profile (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	TerminalSettingsList* profiles = NULL;
	TerminalSettingsList* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = gterminal_open_options_profile;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp1_ = _ ("May only use option %s once");
		_tmp2_ = option_name;
		_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp1_, _tmp2_);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp4_ = terminal_profiles_list_new ();
	profiles = _tmp4_;
	_tmp6_ = value;
	_tmp7_ = terminal_profiles_list_dup_uuid (profiles, _tmp6_, &_inner_error_);
	_tmp5_ = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (profiles);
		return FALSE;
	}
	_tmp8_ = _tmp5_;
	_tmp5_ = NULL;
	_g_free0 (gterminal_open_options_profile);
	gterminal_open_options_profile = _tmp8_;
	result = TRUE;
	_g_free0 (_tmp5_);
	_g_object_unref0 (profiles);
	return result;
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtod (_tmp0_, &_tmp1_);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean gterminal_open_options_option_zoom (const gchar* option_name, const gchar* value, void* unused_user_data, GError** error) {
	gboolean result = FALSE;
	gdouble v = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp12_ = 0.0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = value;
	_tmp2_ = double_try_parse (_tmp0_, &_tmp1_);
	v = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		_tmp3_ = _ ("\"%s\" is not a valid zoom factor");
		_tmp4_ = value;
		_tmp5_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp3_, _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp7_ = v;
	if (_tmp7_ < 0.25) {
		_tmp6_ = TRUE;
	} else {
		gdouble _tmp8_ = 0.0;
		_tmp8_ = v;
		_tmp6_ = _tmp8_ > 4.0;
	}
	if (_tmp6_) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp9_ = _ ("Zoom value \"%s\" is outside allowed range");
		_tmp10_ = value;
		_tmp11_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp9_, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp12_ = v;
	gterminal_open_options_zoom = _tmp12_;
	result = TRUE;
	return result;
}


GOptionGroup* gterminal_open_options_get_terminal_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("terminal", "Terminal options:", "Show terminal options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_terminal_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


GOptionGroup* gterminal_open_options_get_processing_option_group (void) {
	GOptionGroup* result = NULL;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_ = NULL;
	_tmp0_ = g_option_group_new ("processing", "Processing options:", "Show processing options", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GTERMINAL_OPEN_OPTIONS_processing_entries);
	g_option_group_set_translation_domain (group, GETTEXT_PACKAGE);
	result = group;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void gterminal_open_options_parse_argv (gchar** argv, int argv_length1, GError** error) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean found_dashdash = FALSE;
	gboolean _tmp19_ = FALSE;
	GOptionContext* context = NULL;
	GOptionContext* _tmp22_ = NULL;
	GOptionGroup* _tmp23_ = NULL;
	GOptionGroup* _tmp24_ = NULL;
	GOptionGroup* _tmp25_ = NULL;
	GOptionGroup* _tmp26_ = NULL;
	GOptionGroup* _tmp27_ = NULL;
	GOptionGroup* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp31_ = NULL;
	GdkDisplay* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_getenv ("DESKTOP_STARTUP_ID");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (gterminal_open_options_startup_id);
	gterminal_open_options_startup_id = _tmp1_;
	found_dashdash = FALSE;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp4_ = 0U;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				guint _tmp7_ = 0U;
				const gchar* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp13_ = 0U;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				if (!_tmp2_) {
					guint _tmp3_ = 0U;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = argv;
				_tmp5__length1 = argv_length1;
				if (!(_tmp4_ < ((guint) _tmp5__length1))) {
					break;
				}
				_tmp6_ = argv;
				_tmp6__length1 = argv_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (g_strcmp0 (_tmp8_, "--") != 0) {
					continue;
				}
				_tmp9_ = i;
				if (_tmp9_ > ((guint) 0)) {
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					guint _tmp11_ = 0U;
					gchar** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					_tmp10_ = argv;
					_tmp10__length1 = argv_length1;
					_tmp11_ = i;
					_tmp12_ = ((_tmp10_ + 0) != NULL) ? _vala_array_dup2 (_tmp10_ + 0, ((gint) _tmp11_) - 0) : ((gpointer) (_tmp10_ + 0));
					_tmp12__length1 = ((gint) _tmp11_) - 0;
					gterminal_open_options_argv_pre = (_vala_array_free (gterminal_open_options_argv_pre, _vala_array_length (gterminal_open_options_argv_pre), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_pre = _tmp12_;
				} else {
					gterminal_open_options_argv_pre = (_vala_array_free (gterminal_open_options_argv_pre, _vala_array_length (gterminal_open_options_argv_pre), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_pre = NULL;
				}
				_tmp13_ = i;
				_tmp14_ = argv;
				_tmp14__length1 = argv_length1;
				if ((_tmp13_ + 1) < ((guint) _tmp14__length1)) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					guint _tmp16_ = 0U;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					_tmp15_ = argv;
					_tmp15__length1 = argv_length1;
					_tmp16_ = i;
					_tmp17_ = argv;
					_tmp17__length1 = argv_length1;
					_tmp18_ = ((_tmp15_ + ((gint) (_tmp16_ + 1))) != NULL) ? _vala_array_dup3 (_tmp15_ + ((gint) (_tmp16_ + 1)), _tmp17__length1 - ((gint) (_tmp16_ + 1))) : ((gpointer) (_tmp15_ + ((gint) (_tmp16_ + 1))));
					_tmp18__length1 = _tmp17__length1 - ((gint) (_tmp16_ + 1));
					gterminal_open_options_argv_post = (_vala_array_free (gterminal_open_options_argv_post, _vala_array_length (gterminal_open_options_argv_post), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_post = _tmp18_;
				} else {
					gterminal_open_options_argv_post = (_vala_array_free (gterminal_open_options_argv_post, _vala_array_length (gterminal_open_options_argv_post), (GDestroyNotify) g_free), NULL);
					gterminal_open_options_argv_post = NULL;
				}
				found_dashdash = TRUE;
				break;
			}
		}
	}
	_tmp19_ = found_dashdash;
	if (!_tmp19_) {
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		_tmp20_ = argv;
		_tmp20__length1 = argv_length1;
		_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup4 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
		_tmp21__length1 = _tmp20__length1;
		gterminal_open_options_argv_pre = (_vala_array_free (gterminal_open_options_argv_pre, _vala_array_length (gterminal_open_options_argv_pre), (GDestroyNotify) g_free), NULL);
		gterminal_open_options_argv_pre = _tmp21_;
		gterminal_open_options_argv_post = (_vala_array_free (gterminal_open_options_argv_post, _vala_array_length (gterminal_open_options_argv_post), (GDestroyNotify) g_free), NULL);
		gterminal_open_options_argv_post = NULL;
	}
	_tmp22_ = g_option_context_new ("— terminal client");
	context = _tmp22_;
	g_option_context_set_translation_domain (context, GETTEXT_PACKAGE);
	_tmp23_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp23_);
	_tmp24_ = gterminal_global_options_get_option_group ();
	g_option_context_add_group (context, _tmp24_);
	_tmp25_ = gterminal_open_options_get_window_option_group ();
	g_option_context_add_group (context, _tmp25_);
	_tmp26_ = gterminal_open_options_get_terminal_option_group ();
	g_option_context_add_group (context, _tmp26_);
	_tmp27_ = gterminal_open_options_get_exec_option_group ();
	g_option_context_add_group (context, _tmp27_);
	_tmp28_ = gterminal_open_options_get_processing_option_group ();
	g_option_context_add_group (context, _tmp28_);
	g_option_context_parse_strv (context, &gterminal_open_options_argv_pre, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (context);
		return;
	}
	_tmp29_ = gterminal_open_options_working_directory;
	if (_tmp29_ == NULL) {
		gchar* _tmp30_ = NULL;
		_tmp30_ = g_get_current_dir ();
		_g_free0 (gterminal_open_options_working_directory);
		gterminal_open_options_working_directory = _tmp30_;
	}
	_tmp31_ = gterminal_open_options_startup_id;
	if (_tmp31_ == NULL) {
		gchar* _tmp32_ = NULL;
		_tmp32_ = terminal_client_get_fallback_startup_id ();
		_g_free0 (gterminal_open_options_startup_id);
		gterminal_open_options_startup_id = _tmp32_;
	}
	_tmp33_ = gdk_display_get_default ();
	_tmp34_ = gdk_display_get_name (_tmp33_);
	_tmp35_ = g_strdup (_tmp34_);
	_g_free0 (gterminal_open_options_display_name);
	gterminal_open_options_display_name = _tmp35_;
	_g_option_context_free0 (context);
}


GTerminalOpenOptions* gterminal_open_options_dup (const GTerminalOpenOptions* self) {
	GTerminalOpenOptions* dup;
	dup = g_new0 (GTerminalOpenOptions, 1);
	memcpy (dup, self, sizeof (GTerminalOpenOptions));
	return dup;
}


void gterminal_open_options_free (GTerminalOpenOptions* self) {
	g_free (self);
}


GType gterminal_open_options_get_type (void) {
	static volatile gsize gterminal_open_options_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_open_options_type_id__volatile)) {
		GType gterminal_open_options_type_id;
		gterminal_open_options_type_id = g_boxed_type_register_static ("GTerminalOpenOptions", (GBoxedCopyFunc) gterminal_open_options_dup, (GBoxedFreeFunc) gterminal_open_options_free);
		g_once_init_leave (&gterminal_open_options_type_id__volatile, gterminal_open_options_type_id);
	}
	return gterminal_open_options_type_id__volatile;
}


static void gterminal_server_base_init (GTerminalServerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gterminal_server_get_type (void) {
	static volatile gsize gterminal_server_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GTerminalServerIface), (GBaseInitFunc) gterminal_server_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gterminal_server_type_id;
		gterminal_server_type_id = g_type_register_static (G_TYPE_INTERFACE, "GTerminalServer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gterminal_server_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gterminal_server_proxy_get_type);
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Terminal.Factory0");
		g_type_set_qdata (gterminal_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gterminal_server_register_object);
		g_once_init_leave (&gterminal_server_type_id__volatile, gterminal_server_type_id);
	}
	return gterminal_server_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GTerminalServerProxy, gterminal_server_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GTERMINAL_TYPE_SERVER, gterminal_server_proxy_gterminal_server_interface_init) )
static void gterminal_server_proxy_class_init (GTerminalServerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gterminal_server_proxy_g_signal;
}


static void gterminal_server_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gterminal_server_proxy_init (GTerminalServerProxy* self) {
}


static void gterminal_server_proxy_gterminal_server_interface_init (GTerminalServerIface* iface) {
}


static void gterminal_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* gterminal_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gterminal_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gterminal_server_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gterminal_server_dbus_interface_info), &_gterminal_server_dbus_interface_vtable, data, _gterminal_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gterminal_server_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void gterminal_receiver_base_init (GTerminalReceiverIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("child_exited", GTERMINAL_TYPE_RECEIVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	}
}


GType gterminal_receiver_get_type (void) {
	static volatile gsize gterminal_receiver_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_receiver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GTerminalReceiverIface), (GBaseInitFunc) gterminal_receiver_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gterminal_receiver_type_id;
		gterminal_receiver_type_id = g_type_register_static (G_TYPE_INTERFACE, "GTerminalReceiver", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gterminal_receiver_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gterminal_receiver_proxy_get_type);
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Terminal.Terminal0");
		g_type_set_qdata (gterminal_receiver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gterminal_receiver_register_object);
		g_once_init_leave (&gterminal_receiver_type_id__volatile, gterminal_receiver_type_id);
	}
	return gterminal_receiver_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GTerminalReceiverProxy, gterminal_receiver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GTERMINAL_TYPE_RECEIVER, gterminal_receiver_proxy_gterminal_receiver_interface_init) )
static void gterminal_receiver_proxy_class_init (GTerminalReceiverProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gterminal_receiver_proxy_g_signal;
}


static void _dbus_handle_gterminal_receiver_child_exited (GTerminalReceiver* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gint exit_code = 0;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	exit_code = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "child-exited", exit_code);
}


static void gterminal_receiver_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "ChildExited") == 0) {
		_dbus_handle_gterminal_receiver_child_exited ((GTerminalReceiver*) proxy, parameters);
	}
}


static void gterminal_receiver_proxy_init (GTerminalReceiverProxy* self) {
}


static void gterminal_receiver_proxy_gterminal_receiver_interface_init (GTerminalReceiverIface* iface) {
}


static void gterminal_receiver_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* gterminal_receiver_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gterminal_receiver_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_gterminal_receiver_child_exited (GObject* _sender, gint exit_code, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (exit_code));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Terminal.Terminal0", "ChildExited", _arguments, NULL);
}


guint gterminal_receiver_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gterminal_receiver_dbus_interface_info), &_gterminal_receiver_dbus_interface_vtable, data, _gterminal_receiver_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "child-exited", (GCallback) _dbus_gterminal_receiver_child_exited, data);
	return result;
}


static void _gterminal_receiver_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gterminal_receiver_child_exited, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


GTerminalServer* gterminal_get_server (GError** error) {
	GTerminalServer* result = NULL;
	GTerminalServer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GTerminalServer* _tmp3_ = NULL;
	GTerminalServer* _tmp4_ = NULL;
	GTerminalServer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp1_ = gterminal_global_options_get_app_id ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_initable_new (GTERMINAL_TYPE_SERVER_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", _tmp2_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GTERMINAL_SERVER_OBJECT_PATH, "g-interface-name", "org.gnome.Terminal.Factory0", NULL);
	_tmp4_ = (GTerminalServer*) _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}


GTerminalReceiver* gterminal_create_terminal (GError** error) {
	GTerminalReceiver* result = NULL;
	GTerminalServer* server = NULL;
	GTerminalServer* _tmp0_ = NULL;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp1_ = NULL;
	GVariantBuilder* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GVariant* path = NULL;
	GTerminalServer* _tmp17_ = NULL;
	GVariantBuilder* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	gchar* obj_path = NULL;
	GVariant* _tmp23_ = NULL;
	GTerminalReceiver* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GTerminalReceiver* _tmp28_ = NULL;
	GTerminalReceiver* _tmp29_ = NULL;
	GTerminalReceiver* _tmp30_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = gterminal_get_server (&_inner_error_);
	server = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = G_VARIANT_TYPE_VARDICT;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	builder = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gterminal_open_options_display_name;
	_tmp5_ = gterminal_open_options_startup_id;
	_tmp6_ = gterminal_open_options_geometry;
	_tmp7_ = gterminal_open_options_role;
	_tmp8_ = gterminal_open_options_profile;
	_tmp9_ = gterminal_open_options_title;
	_tmp10_ = gterminal_open_options_maximise;
	_tmp11_ = gterminal_open_options_fullscreen;
	terminal_client_append_create_instance_options (_tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = gterminal_open_options_show_menubar_set;
	if (_tmp12_) {
		GVariantBuilder* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GVariant* _tmp15_ = NULL;
		GVariant* _tmp16_ = NULL;
		_tmp13_ = builder;
		_tmp14_ = gterminal_open_options_show_menubar;
		_tmp15_ = g_variant_new_boolean (_tmp14_);
		g_variant_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		g_variant_builder_add (_tmp13_, "{sv}", "show-menubar", _tmp16_, NULL);
		_g_variant_unref0 (_tmp16_);
	}
	_tmp17_ = server;
	_tmp18_ = builder;
	_tmp19_ = g_variant_new ("(a{sv})", _tmp18_, NULL);
	g_variant_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_dbus_proxy_call_sync ((GDBusProxy*) _tmp17_, "CreateInstance", _tmp20_, G_DBUS_CALL_FLAGS_NO_AUTO_START, -1, NULL, &_inner_error_);
	_tmp22_ = _tmp21_;
	_g_variant_unref0 (_tmp20_);
	path = _tmp22_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (server);
		return NULL;
	}
	_tmp23_ = path;
	g_variant_get (_tmp23_, "(o)", &obj_path, NULL);
	_tmp25_ = gterminal_global_options_get_app_id ();
	_tmp26_ = _tmp25_;
	_tmp27_ = obj_path;
	_tmp28_ = g_initable_new (GTERMINAL_TYPE_RECEIVER_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _tmp26_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp27_, "g-interface-name", "org.gnome.Terminal.Terminal0", NULL);
	_tmp29_ = (GTerminalReceiver*) _tmp28_;
	_g_free0 (_tmp26_);
	_tmp24_ = _tmp29_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (obj_path);
		_g_variant_unref0 (path);
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (server);
		return NULL;
	}
	_tmp30_ = _tmp24_;
	_tmp24_ = NULL;
	result = _tmp30_;
	_g_object_unref0 (_tmp24_);
	_g_free0 (obj_path);
	_g_variant_unref0 (path);
	_g_variant_builder_unref0 (builder);
	_g_object_unref0 (server);
	return result;
}


gint gterminal_mangle_exit_code (gint status) {
	gint result = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = status;
	_tmp1_ = WIFEXITED (_tmp0_);
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp2_ = status;
		_tmp3_ = WEXITSTATUS (_tmp2_);
		_tmp4_ = CLAMP (_tmp3_, 0, 127);
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = status;
		_tmp6_ = WIFSIGNALED (_tmp5_);
		if (_tmp6_) {
			gint _tmp7_ = 0;
			int _tmp8_ = 0;
			_tmp7_ = status;
			_tmp8_ = WTERMSIG (_tmp7_);
			result = 128 + ((gint) _tmp8_);
			return result;
		} else {
			result = 127;
			return result;
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda3_ (Block1Data* _data1_, gint s) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	_tmp0_ = g_main_loop_is_running (_data1_->loop);
	if (_tmp0_) {
		g_main_loop_quit (_data1_->loop);
	}
	_tmp1_ = s;
	_data1_->status = _tmp1_;
}


static void ___lambda3__gterminal_receiver_child_exited (GTerminalReceiver* _sender, gint exit_code, gpointer self) {
	__lambda3_ (self, exit_code);
}


gint gterminal_run (GTerminalReceiver* receiver) {
	gint result = 0;
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	gulong id = 0UL;
	GTerminalReceiver* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GTerminalReceiver* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_val_if_fail (receiver != NULL, 0);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->status = 0;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->loop = _tmp0_;
	_tmp1_ = receiver;
	_tmp2_ = g_signal_connect_data (_tmp1_, "child-exited", (GCallback) ___lambda3__gterminal_receiver_child_exited, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	id = _tmp2_;
	g_main_loop_run (_data1_->loop);
	_tmp3_ = receiver;
	g_signal_handler_disconnect ((GObject*) _tmp3_, id);
	_tmp4_ = gterminal_mangle_exit_code (_data1_->status);
	result = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


gint gterminal_open (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	GTerminalReceiver* receiver = NULL;
	GTerminalReceiver* _tmp9_ = NULL;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp10_ = NULL;
	GVariantBuilder* _tmp11_ = NULL;
	GVariantBuilder* _tmp12_ = NULL;
	const GVariantType* _tmp13_ = NULL;
	GVariantBuilder* _tmp19_ = NULL;
	GVariantBuilder* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GTerminalReceiver* _tmp24_ = NULL;
	GVariantBuilder* _tmp25_ = NULL;
	GVariant* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	GUnixFDList* _tmp28_ = NULL;
	GVariant* _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GTerminalReceiver* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	gterminal_open_options_parse_argv (_tmp0_, _tmp0__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp2_ = argv;
	_tmp2__length1 = argv_length1;
	_tmp3_ = _tmp2_[0];
	if (g_strcmp0 (_tmp3_, "run") == 0) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = gterminal_open_options_argv_post;
		_tmp4__length1 = _vala_array_length (gterminal_open_options_argv_post);
		_tmp1_ = _tmp4_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		_tmp5_ = _ ("'%s' needs the command to run as arguments after '--'");
		_tmp6_ = argv;
		_tmp6__length1 = argv_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp5_, _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp9_ = gterminal_create_terminal (&_inner_error_);
	receiver = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp10_ = G_VARIANT_TYPE_TUPLE;
	_tmp11_ = g_variant_builder_new (_tmp10_);
	builder = _tmp11_;
	_tmp12_ = builder;
	_tmp13_ = G_VARIANT_TYPE_VARDICT;
	g_variant_builder_open (_tmp12_, _tmp13_);
	{
		GVariantBuilder* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		PassFdElement* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		_tmp14_ = builder;
		_tmp15_ = gterminal_open_options_working_directory;
		_tmp16_ = gterminal_open_options_fd_array;
		_tmp16__length1 = gterminal_open_options_fd_array_length1;
		_tmp17_ = argv;
		_tmp17__length1 = argv_length1;
		_tmp18_ = _tmp17_[0];
		terminal_client_append_exec_options (_tmp14_, _tmp15_, _tmp16_, _tmp16__length1, g_strcmp0 (_tmp18_, "shell") == 0);
	}
	_tmp19_ = builder;
	g_variant_builder_close (_tmp19_);
	_tmp20_ = builder;
	_tmp21_ = gterminal_open_options_argv_post;
	_tmp21__length1 = _vala_array_length (gterminal_open_options_argv_post);
	_tmp22_ = g_variant_new_bytestring_array (_tmp21_, _tmp21__length1);
	g_variant_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	g_variant_builder_add_value (_tmp20_, _tmp23_);
	_g_variant_unref0 (_tmp23_);
	_tmp24_ = receiver;
	_tmp25_ = builder;
	_tmp26_ = g_variant_builder_end (_tmp25_);
	g_variant_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	_tmp28_ = gterminal_open_options_fd_list;
	_tmp29_ = g_dbus_proxy_call_with_unix_fd_list_sync ((GDBusProxy*) _tmp24_, "Exec", _tmp27_, G_DBUS_CALL_FLAGS_NO_AUTO_START, -1, _tmp28_, NULL, NULL, &_inner_error_);
	_tmp30_ = _tmp29_;
	_g_variant_unref0 (_tmp30_);
	_g_variant_unref0 (_tmp27_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (receiver);
		return 0;
	}
	_tmp31_ = gterminal_open_options_wait_for_remote;
	if (!_tmp31_) {
		result = EXIT_SUCCESS;
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (receiver);
		return result;
	}
	_tmp32_ = receiver;
	_tmp33_ = gterminal_run (_tmp32_);
	result = _tmp33_;
	_g_variant_builder_unref0 (builder);
	_g_object_unref0 (receiver);
	return result;
}


gint gterminal_help (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	result = EXIT_SUCCESS;
	return result;
}


static gint _gterminal_help_gterminal_command_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_help (args, args_length1, error);
	return result;
}


static gint _gterminal_open_gterminal_command_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_open (args, args_length1, error);
	return result;
}


static gint _gterminal_complete_gterminal_command_func (gchar** args, int args_length1, gpointer self, GError** error) {
	gint result;
	result = gterminal_complete (args, args_length1, error);
	return result;
}


gint gterminal_complete (gchar** argv, int argv_length1, GError** error) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar** _tmp53_ = NULL;
	gint _tmp53__length1 = 0;
	const gchar* _tmp54_ = NULL;
	GError* _tmp55_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	if (_tmp0__length1 < 2) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("Missing argument");
		_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	_tmp4_ = _tmp3_[1];
	if (g_strcmp0 (_tmp4_, "commands") == 0) {
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* prefix = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = argv;
		_tmp6__length1 = argv_length1;
		if (_tmp6__length1 > 2) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = argv;
			_tmp7__length1 = argv_length1;
			_tmp8_ = _tmp7_[2];
			_tmp5_ = _tmp8_;
		} else {
			_tmp5_ = NULL;
		}
		_tmp9_ = g_strdup (_tmp5_);
		prefix = _tmp9_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					guint _tmp12_ = 0U;
					guint _tmp13_ = 0U;
					GTerminalCommandMap _tmp14_ = {0};
					const gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp18_ = NULL;
					if (!_tmp10_) {
						guint _tmp11_ = 0U;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = i;
					if (!(_tmp12_ < ((guint) G_N_ELEMENTS (GTERMINAL_commands)))) {
						break;
					}
					_tmp13_ = i;
					_tmp14_ = GTERMINAL_commands[_tmp13_];
					_tmp15_ = _tmp14_.verb;
					_tmp16_ = g_str_has_prefix (_tmp15_, "_");
					if (_tmp16_) {
						continue;
					}
					_tmp18_ = prefix;
					if (_tmp18_ == NULL) {
						_tmp17_ = TRUE;
					} else {
						guint _tmp19_ = 0U;
						GTerminalCommandMap _tmp20_ = {0};
						const gchar* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
						gboolean _tmp23_ = FALSE;
						_tmp19_ = i;
						_tmp20_ = GTERMINAL_commands[_tmp19_];
						_tmp21_ = _tmp20_.verb;
						_tmp22_ = prefix;
						_tmp23_ = g_str_has_prefix (_tmp21_, _tmp22_);
						_tmp17_ = _tmp23_;
					}
					if (_tmp17_) {
						guint _tmp24_ = 0U;
						GTerminalCommandMap _tmp25_ = {0};
						const gchar* _tmp26_ = NULL;
						_tmp24_ = i;
						_tmp25_ = GTERMINAL_commands[_tmp24_];
						_tmp26_ = _tmp25_.verb;
						g_print ("%s\n", _tmp26_);
					}
				}
			}
		}
		result = EXIT_SUCCESS;
		_g_free0 (prefix);
		return result;
	} else {
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		const gchar* _tmp28_ = NULL;
		_tmp27_ = argv;
		_tmp27__length1 = argv_length1;
		_tmp28_ = _tmp27_[1];
		if (g_strcmp0 (_tmp28_, "profiles") == 0) {
			TerminalSettingsList* service = NULL;
			TerminalSettingsList* _tmp29_ = NULL;
			gchar** profiles = NULL;
			TerminalSettingsList* _tmp30_ = NULL;
			gchar** _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint profiles_length1 = 0;
			gint _profiles_size_ = 0;
			const gchar* _tmp33_ = NULL;
			gchar** _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gchar* prefix = NULL;
			gchar* _tmp37_ = NULL;
			_tmp29_ = terminal_profiles_list_new ();
			service = _tmp29_;
			_tmp30_ = service;
			_tmp32_ = _tmp31_ = terminal_settings_list_dupv_children (_tmp30_);
			profiles = _tmp32_;
			profiles_length1 = _vala_array_length (_tmp31_);
			_profiles_size_ = profiles_length1;
			_tmp34_ = argv;
			_tmp34__length1 = argv_length1;
			if (_tmp34__length1 > 2) {
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				const gchar* _tmp36_ = NULL;
				_tmp35_ = argv;
				_tmp35__length1 = argv_length1;
				_tmp36_ = _tmp35_[2];
				_tmp33_ = _tmp36_;
			} else {
				_tmp33_ = NULL;
			}
			_tmp37_ = g_strdup (_tmp33_);
			prefix = _tmp37_;
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp38_ = FALSE;
					_tmp38_ = TRUE;
					while (TRUE) {
						guint _tmp40_ = 0U;
						gchar** _tmp41_ = NULL;
						gint _tmp41__length1 = 0;
						gboolean _tmp42_ = FALSE;
						const gchar* _tmp43_ = NULL;
						if (!_tmp38_) {
							guint _tmp39_ = 0U;
							_tmp39_ = i;
							i = _tmp39_ + 1;
						}
						_tmp38_ = FALSE;
						_tmp40_ = i;
						_tmp41_ = profiles;
						_tmp41__length1 = profiles_length1;
						if (!(_tmp40_ < ((guint) _tmp41__length1))) {
							break;
						}
						_tmp43_ = prefix;
						if (_tmp43_ == NULL) {
							_tmp42_ = TRUE;
						} else {
							gchar** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							guint _tmp45_ = 0U;
							const gchar* _tmp46_ = NULL;
							const gchar* _tmp47_ = NULL;
							gboolean _tmp48_ = FALSE;
							_tmp44_ = profiles;
							_tmp44__length1 = profiles_length1;
							_tmp45_ = i;
							_tmp46_ = _tmp44_[_tmp45_];
							_tmp47_ = prefix;
							_tmp48_ = g_str_has_prefix (_tmp46_, _tmp47_);
							_tmp42_ = _tmp48_;
						}
						if (_tmp42_) {
							gchar** _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							guint _tmp50_ = 0U;
							const gchar* _tmp51_ = NULL;
							_tmp49_ = profiles;
							_tmp49__length1 = profiles_length1;
							_tmp50_ = i;
							_tmp51_ = _tmp49_[_tmp50_];
							g_print ("%s\n", _tmp51_);
						}
					}
				}
			}
			result = EXIT_SUCCESS;
			_g_free0 (prefix);
			profiles = (_vala_array_free (profiles, profiles_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (service);
			return result;
		}
	}
	_tmp52_ = _ ("Unknown completion request for \"%s\"");
	_tmp53_ = argv;
	_tmp53__length1 = argv_length1;
	_tmp54_ = _tmp53_[0];
	_tmp55_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp52_, _tmp54_);
	_inner_error_ = _tmp55_;
	g_propagate_error (error, _inner_error_);
	return 0;
}


GTerminalCommandMap* gterminal_command_map_dup (const GTerminalCommandMap* self) {
	GTerminalCommandMap* dup;
	dup = g_new0 (GTerminalCommandMap, 1);
	memcpy (dup, self, sizeof (GTerminalCommandMap));
	return dup;
}


void gterminal_command_map_free (GTerminalCommandMap* self) {
	g_free (self);
}


GType gterminal_command_map_get_type (void) {
	static volatile gsize gterminal_command_map_type_id__volatile = 0;
	if (g_once_init_enter (&gterminal_command_map_type_id__volatile)) {
		GType gterminal_command_map_type_id;
		gterminal_command_map_type_id = g_boxed_type_register_static ("GTerminalCommandMap", (GBoxedCopyFunc) gterminal_command_map_dup, (GBoxedFreeFunc) gterminal_command_map_free);
		g_once_init_leave (&gterminal_command_map_type_id__volatile, gterminal_command_map_type_id);
	}
	return gterminal_command_map_type_id__volatile;
}


gint gterminal_main (gchar** argv, int argv_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_set_prgname ("gterminal");
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("GTerminal");
	g_set_application_name (_tmp0_);
	{
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		const gchar* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		_tmp1_ = argv;
		_tmp1__length1 = argv_length1;
		if (_tmp1__length1 == 1) {
			const gchar* _tmp2_ = NULL;
			GError* _tmp3_ = NULL;
			_tmp2_ = _ ("Missing command");
			_tmp3_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, _tmp2_);
			_inner_error_ = _tmp3_;
			goto __catch0_g_error;
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					guint _tmp6_ = 0U;
					guint _tmp7_ = 0U;
					GTerminalCommandMap _tmp8_ = {0};
					const gchar* _tmp9_ = NULL;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					const gchar* _tmp11_ = NULL;
					if (!_tmp4_) {
						guint _tmp5_ = 0U;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ < ((guint) G_N_ELEMENTS (GTERMINAL_commands)))) {
						break;
					}
					_tmp7_ = i;
					_tmp8_ = GTERMINAL_commands[_tmp7_];
					_tmp9_ = _tmp8_.verb;
					_tmp10_ = argv;
					_tmp10__length1 = argv_length1;
					_tmp11_ = _tmp10_[1];
					if (g_strcmp0 (_tmp9_, _tmp11_) == 0) {
						gint _tmp12_ = 0;
						guint _tmp13_ = 0U;
						GTerminalCommandMap _tmp14_ = {0};
						GTerminalCommandFunc _tmp15_ = NULL;
						void* _tmp15__target = NULL;
						gchar** _tmp16_ = NULL;
						gint _tmp16__length1 = 0;
						gchar** _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						gint _tmp18_ = 0;
						_tmp13_ = i;
						_tmp14_ = GTERMINAL_commands[_tmp13_];
						_tmp15_ = _tmp14_.func;
						_tmp15__target = _tmp14_.func_target;
						_tmp16_ = argv;
						_tmp16__length1 = argv_length1;
						_tmp17_ = argv;
						_tmp17__length1 = argv_length1;
						_tmp18_ = _tmp15_ (_tmp16_ + 1, _tmp17__length1 - 1, _tmp15__target, &_inner_error_);
						_tmp12_ = _tmp18_;
						if (_inner_error_ != NULL) {
							goto __catch0_g_error;
						}
						result = _tmp12_;
						return result;
					}
				}
			}
		}
		_tmp19_ = _ ("Unknown command \"%s\"");
		_tmp20_ = argv;
		_tmp20__length1 = argv_length1;
		_tmp21_ = _tmp20_[1];
		_tmp22_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, _tmp19_, _tmp21_);
		_inner_error_ = _tmp22_;
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		g_dbus_error_strip_remote_error (_tmp23_);
		_tmp24_ = _ ("Error processing arguments: %s\n");
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_printerr (_tmp24_, _tmp26_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return gterminal_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



