/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SW_SOURCE_FILTER_XML_XMLEXP_HXX
#define INCLUDED_SW_SOURCE_FILTER_XML_XMLEXP_HXX

#include <xmloff/xmlexp.hxx>
#include "xmlitmap.hxx"
#include <xmloff/xmltoken.hxx>
#include <vector>

class SwDoc;
class SwFormat;
class SwFrameFormat;
class SvXMLUnitConverter;
class SvXMLExportItemMapper;
class SvXMLAutoStylePoolP;
class SwTableLine;
class SwTableLines;
class SwTableBox;
class SwXMLTableColumn_Impl;
class SwXMLTableLines_Impl;
class SwXMLTableColumnsSortByWidth_Impl;
class SwXMLTableFrameFormatsSort_Impl;
class SwXMLTableInfo_Impl;
class SwTableNode;
class XMLPropertySetMapper;
class SwXMLTableLines_Impl;

typedef ::std::vector< SwXMLTableLines_Impl* > SwXMLTableLinesCache_Impl;

class SwXMLExport : public SvXMLExport
{
    SvXMLUnitConverter*         pTwipUnitConv;
    SvXMLExportItemMapper*      pTableItemMapper;
    SwXMLTableLinesCache_Impl*  pTableLines;

    SvXMLItemMapEntriesRef      xTableItemMap;
    SvXMLItemMapEntriesRef      xTableRowItemMap;
    SvXMLItemMapEntriesRef      xTableCellItemMap;
    rtl::Reference < XMLPropertySetMapper > xParaPropMapper;

    bool                    bBlock : 1;         // export text block?
    bool                    bShowProgress : 1;
    bool                    bSavedShowChanges : 1;

    SwDoc*                      doc; // cached for getDoc()

    void _InitItemExport();
    void _FinitItemExport();
    void ExportTableLinesAutoStyles( const SwTableLines& rLines,
                                 sal_uInt32 nAbsWidth,
                                 sal_uInt32 nBaseWidth,
                                 const OUString& rNamePrefix,
                                 SwXMLTableColumnsSortByWidth_Impl& rExpCols,
                                 SwXMLTableFrameFormatsSort_Impl& rExpRows,
                                 SwXMLTableFrameFormatsSort_Impl& rExpCells,
                                 SwXMLTableInfo_Impl& rTableInfo,
                                 bool bTop=false );

    void ExportFormat( const SwFormat& rFormat,  enum ::xmloff::token::XMLTokenEnum eClass = ::xmloff::token::XML_TOKEN_INVALID );
    void ExportTableFormat( const SwFrameFormat& rFormat, sal_uInt32 nAbsWidth );

    void ExportTableColumnStyle( const SwXMLTableColumn_Impl& rCol );
    void ExportTableBox( const SwTableBox& rBox, sal_uInt32 nColSpan, sal_uInt32 nRowSpan,
                         SwXMLTableInfo_Impl& rTableInfo );
    void ExportTableLine( const SwTableLine& rLine,
                          const SwXMLTableLines_Impl& rLines,
                          SwXMLTableInfo_Impl& rTableInfo );
    void ExportTableLines( const SwTableLines& rLines,
                           SwXMLTableInfo_Impl& rTableInfo,
                           sal_uInt32 nHeaderRows = 0 );

    virtual void _ExportMeta() SAL_OVERRIDE;
    virtual void _ExportFontDecls() SAL_OVERRIDE;
    virtual void _ExportStyles( bool bUsed ) SAL_OVERRIDE;
    virtual void _ExportAutoStyles() SAL_OVERRIDE;
    virtual void _ExportMasterStyles() SAL_OVERRIDE;
    virtual void SetBodyAttributes() SAL_OVERRIDE;
    virtual void _ExportContent() SAL_OVERRIDE;
    virtual void GetViewSettings(com::sun::star::uno::Sequence<com::sun::star::beans::PropertyValue>& aProps) SAL_OVERRIDE;
    virtual void GetConfigurationSettings(com::sun::star::uno::Sequence<com::sun::star::beans::PropertyValue>& aProps) SAL_OVERRIDE;
    virtual sal_Int32 GetDocumentSpecificSettings( ::std::list< SettingsGroup >& _out_rSettings ) SAL_OVERRIDE;

    // string constants for table cell export
    const OUString sNumberFormat;
    const OUString sIsProtected;
    const OUString sCell;

    void setBlockMode();
private:
    void DeleteTableLines();
protected:

    virtual XMLTextParagraphExport* CreateTextParagraphExport() SAL_OVERRIDE;
    virtual SvXMLAutoStylePoolP* CreateAutoStylePool() SAL_OVERRIDE;
    virtual XMLPageExport* CreatePageExport() SAL_OVERRIDE;
    virtual XMLShapeExport* CreateShapeExport() SAL_OVERRIDE;
    virtual XMLFontAutoStylePool* CreateFontAutoStylePool() SAL_OVERRIDE;

public:
    SwXMLExport(
        const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XComponentContext >& rContext,
        OUString const & implementationName, SvXMLExportFlags nExportFlags);

    virtual ~SwXMLExport();

    virtual sal_uInt32 exportDoc( enum ::xmloff::token::XMLTokenEnum eClass = ::xmloff::token::XML_TOKEN_INVALID ) SAL_OVERRIDE;

    inline const SvXMLUnitConverter& GetTwipUnitConverter() const;

    void ExportTableAutoStyles( const SwTableNode& rTableNd );
    void ExportTable( const SwTableNode& rTableNd );

    SvXMLExportItemMapper& GetTableItemMapper() { return *pTableItemMapper; }
    const rtl::Reference < XMLPropertySetMapper >& GetParaPropMapper()
    {
        return xParaPropMapper;
    }

    bool IsShowProgress() const { return bShowProgress; }
    void SetShowProgress( bool b ) { bShowProgress = b; }
    bool IsBlockMode() const { return bBlock; }

    // XUnoTunnel
    static const ::com::sun::star::uno::Sequence< sal_Int8 > & getUnoTunnelId() throw();
    virtual sal_Int64 SAL_CALL getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier ) throw(::com::sun::star::uno::RuntimeException, std::exception) SAL_OVERRIDE;

    const SwDoc* getDoc() const;
    SwDoc* getDoc();
};

inline const SvXMLUnitConverter& SwXMLExport::GetTwipUnitConverter() const
{
    return *pTwipUnitConv;
}

#endif // INCLUDED_SW_SOURCE_FILTER_XML_XMLEXP_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
