/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDataStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextDescriptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextDisplayAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNameAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextVariableInputElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "variable-input");

    public TextVariableInputElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getOfficeValueTypeAttribute() {
        OfficeValueTypeAttribute attr = (OfficeValueTypeAttribute)this.getOdfAttribute(OdfDocumentNamespace.OFFICE, "value-type");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setOfficeValueTypeAttribute(String officeValueTypeValue) {
        OfficeValueTypeAttribute attr = new OfficeValueTypeAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(officeValueTypeValue);
    }

    public String getStyleDataStyleNameAttribute() {
        StyleDataStyleNameAttribute attr = (StyleDataStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "data-style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleDataStyleNameAttribute(String styleDataStyleNameValue) {
        StyleDataStyleNameAttribute attr = new StyleDataStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleDataStyleNameValue);
    }

    public String getTextDescriptionAttribute() {
        TextDescriptionAttribute attr = (TextDescriptionAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "description");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextDescriptionAttribute(String textDescriptionValue) {
        TextDescriptionAttribute attr = new TextDescriptionAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textDescriptionValue);
    }

    public String getTextDisplayAttribute() {
        TextDisplayAttribute attr = (TextDisplayAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "display");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextDisplayAttribute(String textDisplayValue) {
        TextDisplayAttribute attr = new TextDisplayAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textDisplayValue);
    }

    public String getTextNameAttribute() {
        TextNameAttribute attr = (TextNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextNameAttribute(String textNameValue) {
        TextNameAttribute attr = new TextNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textNameValue);
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

