/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNameAttribute;
import org.odftoolkit.odfdom.dom.element.text.TextOutlineLevelStyleElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextOutlineStyleElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "outline-style");

    public TextOutlineStyleElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleNameAttribute() {
        StyleNameAttribute attr = (StyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNameAttribute(String styleNameValue) {
        StyleNameAttribute attr = new StyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNameValue);
    }

    public TextOutlineLevelStyleElement newTextOutlineLevelStyleElement(String styleNumFormatValue, int textLevelValue) {
        TextOutlineLevelStyleElement textOutlineLevelStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextOutlineLevelStyleElement.class);
        textOutlineLevelStyle.setStyleNumFormatAttribute(styleNumFormatValue);
        textOutlineLevelStyle.setTextLevelAttribute(textLevelValue);
        this.appendChild(textOutlineLevelStyle);
        return textOutlineLevelStyle;
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

