/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawDisplayAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawProtectedAttribute;
import org.odftoolkit.odfdom.dom.element.svg.SvgDescElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgTitleElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class DrawLayerElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.DRAW, "layer");

    public DrawLayerElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getDrawDisplayAttribute() {
        DrawDisplayAttribute attr = (DrawDisplayAttribute)this.getOdfAttribute(OdfDocumentNamespace.DRAW, "display");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return "always";
    }

    public void setDrawDisplayAttribute(String drawDisplayValue) {
        DrawDisplayAttribute attr = new DrawDisplayAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(drawDisplayValue);
    }

    public String getDrawNameAttribute() {
        DrawNameAttribute attr = (DrawNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.DRAW, "name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setDrawNameAttribute(String drawNameValue) {
        DrawNameAttribute attr = new DrawNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(drawNameValue);
    }

    public Boolean getDrawProtectedAttribute() {
        DrawProtectedAttribute attr = (DrawProtectedAttribute)this.getOdfAttribute(OdfDocumentNamespace.DRAW, "protected");
        if (attr != null) {
            return attr.booleanValue();
        }
        return Boolean.valueOf("false");
    }

    public void setDrawProtectedAttribute(Boolean drawProtectedValue) {
        DrawProtectedAttribute attr = new DrawProtectedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(drawProtectedValue);
    }

    public SvgDescElement newSvgDescElement() {
        SvgDescElement svgDesc = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgDescElement.class);
        this.appendChild(svgDesc);
        return svgDesc;
    }

    public SvgTitleElement newSvgTitleElement() {
        SvgTitleElement svgTitle = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgTitleElement.class);
        this.appendChild(svgTitle);
        return svgTitle;
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

