/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GraphUtil {
    private static Map1<Triple, Node> mapSubject = new Map1<Triple, Node>(){

        @Override
        public Node map1(Triple triple) {
            return triple.getSubject();
        }
    };
    private static Map1<Triple, Node> mapPredicate = new Map1<Triple, Node>(){

        @Override
        public Node map1(Triple triple) {
            return triple.getPredicate();
        }
    };
    private static Map1<Triple, Node> mapObject = new Map1<Triple, Node>(){

        @Override
        public Node map1(Triple triple) {
            return triple.getObject();
        }
    };
    private static final boolean OldStyle = true;
    private static final int sliceSize = 1000;

    private GraphUtil() {
    }

    public static ExtendedIterator<Node> listSubjects(Graph g, Node p, Node o) {
        ExtendedIterator<Triple> iter = g.find(Node.ANY, p, o);
        Set<Node> nodes = iter.mapWith(mapSubject).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static ExtendedIterator<Node> listPredicates(Graph g, Node s, Node o) {
        ExtendedIterator<Triple> iter = g.find(s, Node.ANY, o);
        Set<Node> nodes = iter.mapWith(mapPredicate).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static ExtendedIterator<Node> listObjects(Graph g, Node s, Node p) {
        ExtendedIterator<Triple> iter = g.find(s, p, Node.ANY);
        Set<Node> nodes = iter.mapWith(mapObject).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static boolean containsNode(Graph graph, Node node) {
        return graph.contains(node, Node.ANY, Node.ANY) || graph.contains(Node.ANY, Node.ANY, node) || graph.contains(Node.ANY, node, Node.ANY);
    }

    public static ExtendedIterator<Triple> findAll(Graph g) {
        return g.find(Triple.ANY);
    }

    public static void add(Graph graph, Triple[] triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : triples) {
                g.performAdd(t);
            }
            graph.getEventManager().notifyAddArray(graph, triples);
        } else {
            for (Triple t : triples) {
                graph.add(t);
            }
        }
    }

    public static void add(Graph graph, List<Triple> triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : triples) {
                g.performAdd(t);
            }
            graph.getEventManager().notifyAddList(graph, triples);
        } else {
            for (Triple t : triples) {
                graph.add(t);
            }
        }
    }

    public static void add(Graph graph, Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : s) {
                g.performAdd(t);
            }
            graph.getEventManager().notifyAddIterator(graph, s);
        } else {
            for (Triple t : s) {
                graph.add(t);
            }
        }
    }

    public static void addInto(Graph dstGraph, Graph srcGraph) {
        GraphUtil.addIteratorWorker(dstGraph, GraphUtil.findAll(srcGraph));
        dstGraph.getEventManager().notifyAddGraph(dstGraph, srcGraph);
    }

    private static void addIteratorWorker(Graph graph, Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : s) {
                g.performAdd(t);
            }
        } else {
            for (Triple t : s) {
                graph.add(t);
            }
        }
    }

    public static void delete(Graph graph, Triple[] triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : triples) {
                g.performDelete(t);
            }
            graph.getEventManager().notifyDeleteArray(graph, triples);
        } else {
            for (Triple t : triples) {
                graph.delete(t);
            }
        }
    }

    public static void delete(Graph graph, List<Triple> triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : triples) {
                g.performDelete(t);
            }
            graph.getEventManager().notifyDeleteList(graph, triples);
        } else {
            for (Triple t : triples) {
                graph.delete(t);
            }
        }
    }

    public static void delete(Graph graph, Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : s) {
                g.performDelete(t);
            }
            graph.getEventManager().notifyDeleteIterator(graph, s);
        } else {
            for (Triple t : s) {
                graph.delete(t);
            }
        }
    }

    public static void deleteFrom(Graph dstGraph, Graph srcGraph) {
        GraphUtil.deleteIteratorWorker(dstGraph, GraphUtil.findAll(srcGraph));
        dstGraph.getEventManager().notifyDeleteGraph(dstGraph, srcGraph);
    }

    private static void deleteIteratorWorker(Graph graph, Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : s) {
                g.performDelete(t);
            }
        } else {
            for (Triple t : s) {
                graph.delete(t);
            }
        }
    }

    public static void remove(Graph g, Node s, Node p, Node o) {
        int len;
        Triple[] array = new Triple[1000];
        do {
            ExtendedIterator<Triple> iter = g.find(s, p, o);
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = (Triple)iter.next();
            }
            for (int i = 0; i < len; ++i) {
                g.delete(array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
    }
}

