/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Validator;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionDataElement;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfvalidator.ContentFilter;
import org.odftoolkit.odfvalidator.DSigFilter;
import org.odftoolkit.odfvalidator.ForeignContentFilter;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.MathML101Filter;
import org.odftoolkit.odfvalidator.MathML20Filter;
import org.odftoolkit.odfvalidator.MetaFilter;
import org.odftoolkit.odfvalidator.ODFValidationResult;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.ODFValidatorProvider;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.odftoolkit.odfvalidator.SAXVersionException;
import org.odftoolkit.odfvalidator.SchemaErrorHandler;
import org.odftoolkit.odfvalidator.VersionHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

abstract class ODFPackageValidator {
    static final String DOCUMENT_SETTINGS = "document-settings";
    static final String DOCUMENT_STYLES = "document-styles";
    static final String DOCUMENT_CONTENT = "document-content";
    protected Logger.LogLevel m_nLogLevel;
    protected OdfValidatorMode m_eMode = OdfValidatorMode.CONFORMANCE;
    protected SAXParseExceptionFilter m_aFilter = null;
    protected ODFValidatorProvider m_aValidatorProvider = null;
    protected ODFValidationResult m_aResult = null;
    protected OdfVersion m_aConfigVersion = null;
    private SAXParserFactory m_aSAXParserFactory = null;
    protected OdfVersion mOdfPackageVersion = null;

    protected ODFPackageValidator(Logger.LogLevel nLogLevel, OdfValidatorMode eMode, OdfVersion aVersion, SAXParseExceptionFilter aFilter, ODFValidatorProvider aValidatorProvider) {
        this.m_nLogLevel = nLogLevel;
        this.m_eMode = eMode;
        this.m_aFilter = aFilter;
        this.m_aValidatorProvider = aValidatorProvider;
        this.m_aConfigVersion = aVersion;
        this.m_aResult = new ODFValidationResult(aVersion, eMode);
    }

    protected abstract String getLoggerName();

    protected abstract String getDocumentPath();

    protected abstract OdfPackage getPackage(Logger var1);

    protected abstract String getStreamName(String var1);

    protected boolean validate(PrintStream aOut) throws ODFValidatorException {
        Logger aLogger = new Logger(this.getLoggerName(), this.getDocumentPath(), aOut, this.m_nLogLevel);
        return this._validate(aLogger);
    }

    protected boolean validate(Logger aParentLogger) throws ODFValidatorException {
        Logger aLogger = new Logger(this.getDocumentPath(), aParentLogger);
        return this._validate(aLogger);
    }

    OdfVersion getOdfPackageVersion() {
        return this.mOdfPackageVersion;
    }

    private boolean _validate(Logger aLogger) throws ODFValidatorException {
        boolean bHasErrors = false;
        OdfPackage aPkg = this.getPackage(aLogger);
        if (aPkg == null) {
            return true;
        }
        try {
            String aDocVersion = this.getVersion(aLogger);
            if (aDocVersion != null) {
                aLogger.logInfo("ODF version of root document: " + aDocVersion, false);
                this.mOdfPackageVersion = OdfVersion.valueOf(aDocVersion, true);
            }
            OdfVersion aVersion = this.m_aConfigVersion == null ? OdfVersion.valueOf(aDocVersion, true) : this.m_aConfigVersion;
            bHasErrors |= this.validatePre(aLogger, aVersion);
            aLogger.logInfo("Media Type: " + this.m_aResult.getMediaType(), false);
            bHasErrors |= this.validateMeta(aLogger, this.getStreamName(OdfSchemaDocument.OdfXMLFile.META.getFileName()), aVersion, true);
            bHasErrors |= this.validateEntry(aLogger, this.getStreamName(OdfSchemaDocument.OdfXMLFile.SETTINGS.getFileName()), DOCUMENT_SETTINGS, aVersion);
            bHasErrors |= this.validateEntry(aLogger, this.getStreamName(OdfSchemaDocument.OdfXMLFile.STYLES.getFileName()), DOCUMENT_STYLES, aVersion);
            bHasErrors = this.m_aResult.getMediaType().equals("application/vnd.oasis.opendocument.formula") ? (bHasErrors |= this.validateMathML(aLogger, this.getStreamName(OdfSchemaDocument.OdfXMLFile.CONTENT.getFileName()), aVersion)) : (bHasErrors |= this.validateEntry(aLogger, this.getStreamName(OdfSchemaDocument.OdfXMLFile.CONTENT.getFileName()), DOCUMENT_CONTENT, aVersion));
            bHasErrors |= this.validatePost(aLogger, aVersion);
        }
        catch (ZipException e) {
            aLogger.logFatalError(e.getMessage());
        }
        catch (IOException e) {
            aLogger.logFatalError(e.getMessage());
        }
        this.logSummary(bHasErrors, aLogger);
        return bHasErrors || aLogger.hasError();
    }

    protected boolean validatePre(Logger aLogger, OdfVersion aVersion) throws ODFValidatorException, IOException {
        return false;
    }

    protected boolean validatePost(Logger aLogger, OdfVersion aVersion) throws ODFValidatorException, IOException {
        return false;
    }

    protected void logSummary(boolean bHasErrors, Logger aLogger) {
    }

    protected boolean validateEntry(Logger aParentLogger, String aEntryName, String aLocalElementName, OdfVersion aVersion) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        Logger aLogger = new Logger(aEntryName, aParentLogger);
        XMLFilterImpl aFilter = new ContentFilter(aLogger, aLocalElementName);
        if (this.m_eMode == OdfValidatorMode.CONFORMANCE && aVersion.compareTo(OdfVersion.V1_1) <= 0 || this.m_eMode == OdfValidatorMode.EXTENDED_CONFORMANCE) {
            ForeignContentFilter aAlienFilter = new ForeignContentFilter(aLogger, aVersion, this.m_aResult);
            aAlienFilter.setParent(aFilter);
            aFilter = aAlienFilter;
        }
        Validator aValidator = null;
        aValidator = this.m_eMode == OdfValidatorMode.VALIDATE_STRICT ? this.m_aValidatorProvider.getStrictValidator(aParentLogger.getOutputStream(), aVersion) : this.m_aValidatorProvider.getValidator(aParentLogger.getOutputStream(), aVersion);
        return this.validateEntry(aFilter, aValidator, aLogger, aEntryName);
    }

    private boolean validateMeta(Logger aParentLogger, String aEntryName, OdfVersion aVersion, boolean bIsRoot) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        Logger aLogger = new Logger(aEntryName, aParentLogger);
        XMLFilterImpl aFilter = new MetaFilter(aLogger, this.m_aResult);
        if (this.m_eMode == OdfValidatorMode.CONFORMANCE && aVersion.compareTo(OdfVersion.V1_1) <= 0 || this.m_eMode == OdfValidatorMode.EXTENDED_CONFORMANCE) {
            ForeignContentFilter aAlienFilter = new ForeignContentFilter(aLogger, aVersion, this.m_aResult);
            aAlienFilter.setParent(aFilter);
            aFilter = aAlienFilter;
        }
        Validator aValidator = null;
        aValidator = this.m_eMode == OdfValidatorMode.VALIDATE_STRICT ? this.m_aValidatorProvider.getStrictValidator(aParentLogger.getOutputStream(), aVersion) : this.m_aValidatorProvider.getValidator(aParentLogger.getOutputStream(), aVersion);
        return this.validateEntry(aFilter, aValidator, aLogger, aEntryName);
    }

    private boolean validateMathML(Logger aParentLogger, String aEntryName, OdfVersion aVersion) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        Logger aLogger = new Logger(aEntryName, aParentLogger);
        String aMathMLDTDSystemId = this.m_aValidatorProvider.getMathMLDTDSystemId(aVersion);
        if (aMathMLDTDSystemId != null) {
            return this.parseEntry(new MathML101Filter(aMathMLDTDSystemId, aLogger), aLogger, aEntryName, true);
        }
        Validator aMathMLValidator = this.m_aValidatorProvider.getMathMLValidator(aParentLogger.getOutputStream(), null);
        if (aMathMLValidator == null) {
            aLogger.logInfo("MathML schema is not available. Validation has been skipped.", false);
            return false;
        }
        return this.validateEntry(new MathML20Filter(aLogger), aMathMLValidator, aLogger, aEntryName);
    }

    protected boolean validateDSig(Logger aParentLogger, String aEntryName, OdfVersion aVersion) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        Validator aValidator = this.m_aValidatorProvider.getDSigValidator(aParentLogger.getOutputStream(), aVersion);
        Logger aLogger = new Logger(aEntryName, aParentLogger);
        if (aValidator == null) {
            aLogger.logWarning("Signature not validated because there is no Signature Validator configured for the selected Configuration");
            return false;
        }
        return this.validateEntry(new DSigFilter(aLogger), aValidator, aLogger, aEntryName);
    }

    protected boolean validateEntry(XMLFilter aFilter, Validator aValidator, Logger aLogger, String aEntryName) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        OdfPackage aPkg = this.getPackage(aLogger);
        if (!aEntryName.equals(OdfPackage.OdfFile.MANIFEST.getPath()) && this.isEncrypted(aEntryName, aLogger)) {
            return false;
        }
        InputStream aInStream = null;
        try {
            aInStream = aPkg.getInputStream(aEntryName, true);
        }
        catch (Exception e) {
            throw new ODFValidatorException(e);
        }
        if (aValidator == null) {
            aLogger.logWarning("no Validator configured in selected Configuration for this file type");
            return false;
        }
        return aInStream != null ? this.validate(aInStream, aFilter, aValidator, aLogger) : false;
    }

    private boolean validate(InputStream aInStream, XMLFilter aFilter, Validator aValidator, Logger aLogger) throws ODFValidatorException {
        SAXParser aParser = this.getSAXParser(false);
        SchemaErrorHandler aErrorHandler = new SchemaErrorHandler(aLogger, this.m_aFilter);
        try {
            XMLReader aReader;
            if (aFilter != null) {
                XMLReader aParent = aFilter.getParent();
                if (aParent != null) {
                    ((XMLFilter)aParent).setParent(aParser.getXMLReader());
                } else {
                    aFilter.setParent(aParser.getXMLReader());
                }
                aReader = aFilter;
            } else {
                aReader = aParser.getXMLReader();
            }
            if (this.m_aFilter != null) {
                this.m_aFilter.startSubFile();
            }
            aValidator.setErrorHandler(aErrorHandler);
            try {
                aValidator.validate(new SAXSource(aReader, new InputSource(aInStream)));
            }
            catch (RuntimeException e) {
                aLogger.logFatalError(e.getMessage());
                this.m_aValidatorProvider.resetValidatorProvider();
            }
        }
        catch (SAXParseException e) {
            aErrorHandler.fatalErrorNoException(e);
        }
        catch (SAXException e) {
            aLogger.logFatalError(e.getMessage());
        }
        catch (IOException e) {
            aLogger.logFatalError(e.getMessage());
        }
        aLogger.logSummaryInfo();
        if (this.m_aResult.hasForeignElements()) {
            Set<String> aForeignElementURISet = this.m_aResult.getForeignElements().keySet();
            StringBuilder aBuffer = new StringBuilder();
            Iterator<String> aIter = aForeignElementURISet.iterator();
            boolean bFirst = true;
            while (aIter.hasNext()) {
                String aURI = aIter.next();
                aBuffer.setLength(0);
                aBuffer.append(this.m_aResult.getForeignElements().get(aURI));
                aBuffer.append(" extension elements from the following namespace were found: ");
                aBuffer.append(aURI);
                aLogger.logInfo(aBuffer.toString(), false);
            }
        }
        if (this.m_aResult.hasForeignAttributes()) {
            Set<String> aForeignAttributeURISet = this.m_aResult.getForeignAttributes().keySet();
            Iterator<String> aIter = aForeignAttributeURISet.iterator();
            StringBuilder aBuffer = new StringBuilder();
            while (aIter.hasNext()) {
                String aURI = aIter.next();
                aBuffer.setLength(0);
                aBuffer.append(this.m_aResult.getForeignAttributes().get(aURI));
                aBuffer.append(" extension attributes from the following namespace were found: ");
                aBuffer.append(aURI);
                aLogger.logInfo(aBuffer.toString(), false);
            }
        }
        return aLogger.hasError();
    }

    protected boolean parseEntry(XMLFilter aFilter, Logger aLogger, String aEntryName, boolean bValidating) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        OdfPackage aPkg = this.getPackage(aLogger);
        if (this.isEncrypted(aEntryName, aLogger)) {
            return false;
        }
        InputStream aInStream = null;
        try {
            aInStream = this.getPackage(aLogger).getInputStream(aEntryName, true);
        }
        catch (Exception e) {
            throw new ODFValidatorException(e);
        }
        return aInStream != null ? this.parse(aInStream, aFilter, bValidating, aLogger) : false;
    }

    private boolean parse(InputStream aInStream, XMLFilter aFilter, boolean bValidating, Logger aLogger) throws ODFValidatorException {
        SAXParser aParser = this.getSAXParser(bValidating);
        SchemaErrorHandler aErrorHandler = new SchemaErrorHandler(aLogger, this.m_aFilter);
        try {
            XMLReader aReader;
            if (aFilter != null) {
                aFilter.setParent(aParser.getXMLReader());
                aReader = aFilter;
            } else {
                aReader = aParser.getXMLReader();
            }
            if (this.m_aFilter != null) {
                this.m_aFilter.startSubFile();
            }
            aReader.setErrorHandler(aErrorHandler);
            aReader.parse(new InputSource(aInStream));
        }
        catch (SAXParseException e) {
            aErrorHandler.fatalErrorNoException(e);
        }
        catch (SAXException e) {
            aLogger.logFatalError(e.getMessage());
        }
        catch (IOException e) {
            aLogger.logFatalError(e.getMessage());
        }
        if (bValidating) {
            aLogger.logSummaryInfo();
        }
        return aLogger.hasError();
    }

    private boolean isEncrypted(String aEntryName, Logger aLogger) {
        EncryptionDataElement aEncData;
        OdfFileEntry aFileEntry = this.getPackage(aLogger).getFileEntry(aEntryName);
        if (aFileEntry != null && (aEncData = aFileEntry.getEncryptionData()) != null) {
            aLogger.logFatalError("stream content is encrypted. Validataion of encrypted content is not supported.");
            return true;
        }
        return false;
    }

    private SAXParser getSAXParser(boolean bValidating) throws ODFValidatorException {
        SAXParser aParser = null;
        if (this.m_aSAXParserFactory == null) {
            this.m_aSAXParserFactory = SAXParserFactory.newInstance();
            this.m_aSAXParserFactory.setNamespaceAware(true);
        }
        try {
            this.m_aSAXParserFactory.setValidating(bValidating);
            aParser = this.m_aSAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ODFValidatorException(e);
        }
        catch (SAXException e) {
            throw new ODFValidatorException(e);
        }
        return aParser;
    }

    public String getGenerator() {
        return this.m_aResult.getGenerator();
    }

    private String getVersion(Logger aLogger) throws ODFValidatorException {
        String aVersion = null;
        InputStream aInStream = null;
        try {
            OdfPackage aPkg = this.getPackage(aLogger);
            aInStream = aPkg.getInputStream(this.getStreamName(OdfSchemaDocument.OdfXMLFile.META.getFileName()), true);
            if (aInStream == null) {
                aInStream = aPkg.getInputStream(this.getStreamName(OdfSchemaDocument.OdfXMLFile.SETTINGS.getFileName()), true);
            }
            if (aInStream == null) {
                aInStream = aPkg.getInputStream(this.getStreamName(OdfSchemaDocument.OdfXMLFile.CONTENT.getFileName()), true);
            }
            if (aInStream == null) {
                return null;
            }
        }
        catch (Exception e) {
            aLogger.logFatalError(e.getMessage());
        }
        SAXParser aParser = this.getSAXParser(false);
        VersionHandler aHandler = new VersionHandler();
        try {
            aParser.parse(aInStream, (DefaultHandler)aHandler);
        }
        catch (SAXVersionException e) {
            aVersion = e.getVersion();
        }
        catch (SAXException e) {
            aLogger.logFatalError(e.getMessage());
        }
        catch (IOException e) {
            aLogger.logFatalError(e.getMessage());
        }
        return aVersion;
    }
}

