// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#ifndef CORE_FPDFAPI_EDIT_CPDF_FLATEENCODER_H_
#define CORE_FPDFAPI_EDIT_CPDF_FLATEENCODER_H_

#include <memory>

#include "core/fpdfapi/parser/cpdf_dictionary.h"
#include "core/fpdfapi/parser/cpdf_stream_acc.h"
#include "core/fxcrt/fx_memory.h"
#include "core/fxcrt/maybe_owned.h"
#include "core/fxcrt/retain_ptr.h"

class CPDF_Stream;

class CPDF_FlateEncoder {
 public:
  CPDF_FlateEncoder(const CPDF_Stream* pStream, bool bFlateEncode);
  ~CPDF_FlateEncoder();

  void CloneDict();
  CPDF_Dictionary* GetClonedDict();

  // Returns |m_pClonedDict| if it is valid. Otherwise returns |m_pDict|.
  const CPDF_Dictionary* GetDict() const;

  uint32_t GetSize() const { return m_dwSize; }
  const uint8_t* GetData() const { return m_pData.Get(); }

 private:
  uint32_t m_dwSize;
  MaybeOwned<uint8_t, FxFreeDeleter> m_pData;

  // Only one of these two pointers is valid at any time.
  UnownedPtr<const CPDF_Dictionary> m_pDict;
  std::unique_ptr<CPDF_Dictionary> m_pClonedDict;

  RetainPtr<CPDF_StreamAcc> m_pAcc;
};

#endif  // CORE_FPDFAPI_EDIT_CPDF_FLATEENCODER_H_
