/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <rtl/ustring.hxx>
#include <svtools/rtfkeywd.hxx>
#include <svtools/rtftoken.h>

#include <algorithm>
#include <string.h>
#include <stdlib.h>

// the table is still to be sorted
struct RTF_TokenEntry
{
    OUStringLiteral sToken;
    int nToken;
};

// Flag: RTF-token table has been sorted
static bool bSortKeyWords = false;

static RTF_TokenEntry aRTFTokenTab[] = {
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_IGNORE),        RTF_IGNOREFLAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTF),           RTF_RTF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ANSI),          RTF_ANSITYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MAC),           RTF_MACTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PC),            RTF_PCTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PCA),           RTF_PCATYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NEXTCSET),      RTF_NEXTTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_STYLESHEET),    RTF_STYLESHEET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBASEDON),      RTF_SBASEDON},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SNEXT),         RTF_SNEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FONTTBL),       RTF_FONTTBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DEFF),          RTF_DEFF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FNIL),          RTF_FNIL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FROMAN),        RTF_FROMAN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FSWISS),        RTF_FSWISS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FMODERN),       RTF_FMODERN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FSCRIPT),       RTF_FSCRIPT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FDECOR),        RTF_FDECOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTECH),         RTF_FTECH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FCHARSET),     RTF_FCHARSET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FALT),         RTF_FALT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FPRQ),         RTF_FPRQ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLORTBL),      RTF_COLORTBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RED),           RTF_RED},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GREEN),         RTF_GREEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BLUE),          RTF_BLUE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CF),            RTF_CF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CB),            RTF_CB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_INFO),          RTF_INFO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TITLE),         RTF_TITLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SUBJECT),       RTF_SUBJECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AUTHOR),        RTF_AUTHOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OPERATOR),      RTF_OPERATOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_KEYWORDS),      RTF_KEYWORDS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COMMENT),       RTF_COMMENT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VERSION),       RTF_VERSION},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOCCOMM),       RTF_DOCCOMM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VERN),          RTF_VERN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CREATIM),       RTF_CREATIM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVTIM),        RTF_REVTIM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PRINTIM),       RTF_PRINTIM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BUPTIM),        RTF_BUPTIM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EDMINS),        RTF_EDMINS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOFPAGES),      RTF_NOFPAGES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOFWORDS),      RTF_NOFWORDS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOFCHARS),      RTF_NOFCHARS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ID),            RTF_ID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_YR),            RTF_YR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MO),            RTF_MO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DY),            RTF_DY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HR),            RTF_HR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MIN),           RTF_MIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ANNOTATION),    RTF_ANNOTATION},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATNID),         RTF_ATNID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTNOTE),      RTF_FOOTNOTE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTER),        RTF_FOOTER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERL),       RTF_FOOTERL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERR),       RTF_FOOTERR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERF),       RTF_FOOTERF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADER),        RTF_HEADER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERL),       RTF_HEADERL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERR),       RTF_HEADERR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERF),       RTF_HEADERF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_XE),            RTF_XE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BXE),           RTF_BXE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_IXE),           RTF_IXE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RXE),           RTF_RXE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TXE),           RTF_TXE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TC),            RTF_TC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TCF),           RTF_TCF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TCL),           RTF_TCL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BKMKSTART),     RTF_BKMKSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BKMKEND),       RTF_BKMKEND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICT),          RTF_PICT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICW),          RTF_PICW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICH),          RTF_PICH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WBMBITSPIXEL),  RTF_WBMBITSPIXEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WBMPLANES),     RTF_WBMPLANES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WBMWIDTHBYTES), RTF_WBMWIDTHBYTES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICWGOAL),      RTF_PICWGOAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICHGOAL),      RTF_PICHGOAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BIN),           RTF_BIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICSCALEX),     RTF_PICSCALEX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICSCALEY),     RTF_PICSCALEY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICSCALED),     RTF_PICSCALED},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WBITMAP),       RTF_WBITMAP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WMETAFILE),     RTF_WMETAFILE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MACPICT),       RTF_MACPICT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICCROPT),      RTF_PICCROPT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICCROPB),      RTF_PICCROPB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICCROPL),      RTF_PICCROPL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICCROPR),      RTF_PICCROPR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FIELD),         RTF_FIELD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDDIRTY),      RTF_FLDDIRTY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDEDIT),       RTF_FLDEDIT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDLOCK),       RTF_FLDLOCK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDPRIV),       RTF_FLDPRIV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDINST),       RTF_FLDINST},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDRSLT),       RTF_FLDRSLT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PAPERW),        RTF_PAPERW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PAPERH),        RTF_PAPERH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGL),         RTF_MARGL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGR),         RTF_MARGR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGT),         RTF_MARGT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGB),         RTF_MARGB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FACINGP),       RTF_FACINGP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GUTTER),        RTF_GUTTER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DEFTAB),        RTF_DEFTAB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WIDOWCTRL),     RTF_WIDOWCTRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHHOTZ),      RTF_HYPHHOTZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNSEP),        RTF_FTNSEP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNSEPC),       RTF_FTNSEPC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNCN),         RTF_FTNCN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ENDNOTES),      RTF_ENDNOTES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ENDDOC),        RTF_ENDDOC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNTJ),         RTF_FTNTJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNBJ),         RTF_FTNBJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNSTART),      RTF_FTNSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNRESTART),    RTF_FTNRESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNSTART),      RTF_PGNSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINESTART),     RTF_LINESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LANDSCAPE),     RTF_LANDSCAPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRACWIDTH),     RTF_FRACWIDTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NEXTFILE),      RTF_NEXTFILE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TEMPLATE),      RTF_TEMPLATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MAKEBACKUP),    RTF_MAKEBACKUP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DEFFORMAT),     RTF_DEFFORMAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVISIONS),     RTF_REVISIONS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGMIRROR),    RTF_MARGMIRROR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVPROP),       RTF_REVPROP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVBAR),        RTF_REVBAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTD),         RTF_SECTD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBKNONE),       RTF_SBKNONE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBKCOL),        RTF_SBKCOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBKPAGE),       RTF_SBKPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBKEVEN),       RTF_SBKEVEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBKODD),        RTF_SBKODD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNSTARTS),     RTF_PGNSTARTS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNCONT),       RTF_PGNCONT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNRESTART),    RTF_PGNRESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNDEC),        RTF_PGNDEC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNUCRM),       RTF_PGNUCRM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNLCRM),       RTF_PGNLCRM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNUCLTR),      RTF_PGNUCLTR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNLCLTR),      RTF_PGNLCLTR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNX),          RTF_PGNX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNY),          RTF_PGNY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERY),       RTF_HEADERY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERY),       RTF_FOOTERY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINEMOD),       RTF_LINEMOD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINEX),         RTF_LINEX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINESTARTS),    RTF_LINESTARTS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINERESTART),   RTF_LINERESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINEPPAGE),     RTF_LINEPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINECONT),      RTF_LINECONT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VERTALT),       RTF_VERTALT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VERTALB),       RTF_VERTALB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VERTALC),       RTF_VERTALC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VERTALJ),       RTF_VERTALJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLS),          RTF_COLS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLSX),         RTF_COLSX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLNO),            RTF_COLNO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLSR),            RTF_COLSR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLW),         RTF_COLW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINEBETCOL),    RTF_LINEBETCOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ENDNHERE),      RTF_ENDNHERE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TITLEPG),       RTF_TITLEPG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PARD),          RTF_PARD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_S),             RTF_S},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_QL),            RTF_QL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_QR),            RTF_QR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_QJ),            RTF_QJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_QC),            RTF_QC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FI),            RTF_FI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LI),            RTF_LI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LIN),           RTF_LIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RI),            RTF_RI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RIN),           RTF_RIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SB),            RTF_SB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SA),            RTF_SA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SL),            RTF_SL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_INTBL),         RTF_INTBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_KEEP),          RTF_KEEP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_KEEPN),         RTF_KEEPN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVEL),            RTF_LEVEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SBYS),          RTF_SBYS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PAGEBB),        RTF_PAGEBB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOLINE),        RTF_NOLINE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TX),            RTF_TX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TQL),           RTF_TQL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TQR),           RTF_TQR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TQC),           RTF_TQC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TQDEC),         RTF_TQDEC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TB),            RTF_TB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRT),         RTF_BRDRT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRB),         RTF_BRDRB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRL),         RTF_BRDRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRR),         RTF_BRDRR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BOX),           RTF_BOX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRS),         RTF_BRDRS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTH),        RTF_BRDRTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRSH),        RTF_BRDRSH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDB),        RTF_BRDRDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDOT),       RTF_BRDRDOT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRHAIR),      RTF_BRDRHAIR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRSP),          RTF_BRSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TLDOT),         RTF_TLDOT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TLHYPH),        RTF_TLHYPH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TLUL),          RTF_TLUL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TLTH),          RTF_TLTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSX),          RTF_POSX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSXC),         RTF_POSXC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSXI),         RTF_POSXI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSXL),         RTF_POSXL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSXO),         RTF_POSXO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSXR),         RTF_POSXR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSY),          RTF_POSY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSYIL),        RTF_POSYIL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSYT),         RTF_POSYT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSYC),         RTF_POSYC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSYB),         RTF_POSYB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ABSW),          RTF_ABSW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DXFRTEXT),      RTF_DXFRTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PVMRG),         RTF_PVMRG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PVPG),          RTF_PVPG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PHMRG),         RTF_PHMRG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PHPG),          RTF_PHPG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PHCOL),         RTF_PHCOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBRDRB),       RTF_CLBRDRB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBRDRT),       RTF_CLBRDRT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBRDRL),       RTF_CLBRDRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBRDRR),       RTF_CLBRDRR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADL),        RTF_CLPADL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADT),        RTF_CLPADT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADB),        RTF_CLPADB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADR),        RTF_CLPADR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADFL),       RTF_CLPADFL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADFT),       RTF_CLPADFT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADFB),       RTF_CLPADFB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLPADFR),       RTF_CLPADFR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TROWD),         RTF_TROWD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRQL),          RTF_TRQL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRQR),          RTF_TRQR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRQC),          RTF_TRQC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRGAPH),        RTF_TRGAPH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRRH),          RTF_TRRH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRLEFT),        RTF_TRLEFT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CELLX),         RTF_CELLX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLMGF),         RTF_CLMGF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLMRG),         RTF_CLMRG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PLAIN),         RTF_PLAIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_B),             RTF_B},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_I),             RTF_I},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_STRIKE),        RTF_STRIKE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OUTL),          RTF_OUTL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHAD),          RTF_SHAD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SCAPS),         RTF_SCAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CAPS),          RTF_CAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_V),             RTF_V},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_F),             RTF_F},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FS),            RTF_FS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EXPND),         RTF_EXPND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EXPNDTW),       RTF_EXPNDTW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_KERNING),       RTF_KERNING},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_UL),            RTF_UL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULW),           RTF_ULW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULD),           RTF_ULD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULDB),          RTF_ULDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULNONE),        RTF_ULNONE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_UP),            RTF_UP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DN),            RTF_DN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVISED),       RTF_REVISED},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SUB),          RTF_SUB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOSUPERSUB),   RTF_NOSUPERSUB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SUPER),            RTF_SUPER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHDATE),        RTF_CHDATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHTIME),        RTF_CHTIME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHPGN),         RTF_CHPGN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHFTN),         RTF_CHFTN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHATN),         RTF_CHATN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHFTNSEP),      RTF_CHFTNSEP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHFTNSEPC),     RTF_CHFTNSEPC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FORMULA),       RTF_FORMULA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOBREAK),       RTF_NONBREAKINGSPACE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OPTHYPH),       RTF_OPTIONALHYPHEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOBRKHYPH),     RTF_NONBREAKINGHYPHEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEXCHAR),       RTF_HEX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CELL),          RTF_CELL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ROW),           RTF_ROW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PAR),           RTF_PAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECT),          RTF_SECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PAGE),          RTF_PAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COLUMN),        RTF_COLUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINE),          RTF_LINE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TAB),           RTF_TAB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SUBENTRY),      RTF_SUBENTRYINDEX},

{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DEFLANG),       RTF_DEFLANG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LANG),          RTF_LANG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PMMETAFILE),    RTF_OSMETAFILE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DIBITMAP),      RTF_DIBITMAP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_KEYCODE),       RTF_KEYCODE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FN),            RTF_FNKEY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ALT),           RTF_ALTKEY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHIFT),         RTF_SHIFTKEY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CTRL),          RTF_CTRLKEY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHDPL),         RTF_CHDATEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHDPA),         RTF_CHDATEA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EMDASH),        RTF_EMDASH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ENDASH),        RTF_ENDASH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BULLET),        RTF_BULLET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LQUOTE),        RTF_LQUOTE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RQUOTE),        RTF_RQUOTE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LDBLQUOTE),     RTF_LDBLQUOTE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RDBLQUOTE),     RTF_RDBLQUOTE},

{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BKMKCOLF),      RTF_BKMKCOLF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BKMKCOLL),      RTF_BKMKCOLL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PSOVER),        RTF_PSOVER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOCTEMP),       RTF_DOCTEMP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BINFSXN),       RTF_BINFSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BINSXN),        RTF_BINSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGWSXN),        RTF_PGWSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGHSXN),        RTF_PGHSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGLSXN),      RTF_MARGLSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGRSXN),      RTF_MARGRSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGTSXN),      RTF_MARGTSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MARGBSXN),      RTF_MARGBSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GUTTERSXN),     RTF_GUTTERSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LNDSCPSXN),     RTF_LNDSCPSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FACPGSXN),      RTF_FACPGSXN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TLEQ),          RTF_TLEQ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRBTW),       RTF_BRDRBTW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRBAR),       RTF_BRDRBAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRW),         RTF_BRDRW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRCF),        RTF_BRDRCF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ABSH),          RTF_ABSH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PVPARA),        RTF_PVPARA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOWRAP),        RTF_NOWRAP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRMTXTX),      RTF_DFRMTXTX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRMTXTY),      RTF_DFRMTXTY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DROPCAPLI),     RTF_DROPCAPLI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DROPCAPT),      RTF_DROPCAPT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ABSNOOVRLP),    RTF_ABSNOOVRLP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSNEGX),       RTF_POSNEGX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSNEGY),       RTF_POSNEGY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DELETED),       RTF_DELETED},

{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHADING),       RTF_SHADING},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGHORIZ),       RTF_BGHORIZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGVERT),        RTF_BGVERT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGFDIAG),       RTF_BGFDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGBDIAG),       RTF_BGBDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGCROSS),       RTF_BGCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDCROSS),      RTF_BGDCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDKHORIZ),     RTF_BGDKHORIZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDKVERT),      RTF_BGDKVERT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDKFDIAG),     RTF_BGDKFDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDKBDIAG),     RTF_BGDKBDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDKCROSS),     RTF_BGDKCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BGDKDCROSS),    RTF_BGDKDCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CFPAT),         RTF_CFPAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CBPAT),         RTF_CBPAT},

{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLSHDNG),       RTF_CLSHDNG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGHORIZ),     RTF_CLBGHORIZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGVERT),      RTF_CLBGVERT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGFDIAG),     RTF_CLBGFDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGBDIAG),     RTF_CLBGBDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGCROSS),     RTF_CLBGCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDCROSS),    RTF_CLBGDCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDKHOR),    RTF_CLBGDKHOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDKVERT),    RTF_CLBGDKVERT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDKFDIAG),   RTF_CLBGDKFDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDKBDIAG),   RTF_CLBGDKBDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDKCROSS),   RTF_CLBGDKCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLBGDKDCROSS),  RTF_CLBGDKDCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLCFPAT),       RTF_CLCFPAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLCBPAT),       RTF_CLCBPAT},

{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AB),           RTF_AB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ACAPS),            RTF_ACAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ACF),          RTF_ACF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ADDITIVE),     RTF_ADDITIVE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ADN),          RTF_ADN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AENDDOC),      RTF_AENDDOC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AENDNOTES),        RTF_AENDNOTES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AEXPND),       RTF_AEXPND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AF),           RTF_AF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFS),          RTF_AFS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNBJ),       RTF_AFTNBJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNCN),       RTF_AFTNCN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNALC),     RTF_AFTNNALC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNAR),      RTF_AFTNNAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNAUC),     RTF_AFTNNAUC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNCHI),     RTF_AFTNNCHI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNRLC),     RTF_AFTNNRLC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNRUC),     RTF_AFTNNRUC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNRESTART),  RTF_AFTNRESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNRSTCONT),  RTF_AFTNRSTCONT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNSEP),      RTF_AFTNSEP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNSEPC),     RTF_AFTNSEPC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNSTART),        RTF_AFTNSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNTJ),       RTF_AFTNTJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AI),           RTF_AI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ALANG),            RTF_ALANG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ALLPROT),      RTF_ALLPROT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ANNOTPROT),        RTF_ANNOTPROT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AOUTL),            RTF_AOUTL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ASCAPS),       RTF_ASCAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ASHAD),            RTF_ASHAD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ASTRIKE),      RTF_ASTRIKE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATNAUTHOR),        RTF_ATNAUTHOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATNICN),       RTF_ATNICN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATNREF),       RTF_ATNREF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATNTIME),      RTF_ATNTIME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATRFEND),      RTF_ATRFEND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ATRFSTART),        RTF_ATRFSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AUL),          RTF_AUL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AULD),         RTF_AULD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AULDB),            RTF_AULDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AULNONE),      RTF_AULNONE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AULW),         RTF_AULW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AUP),          RTF_AUP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BKMKPUB),      RTF_BKMKPUB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDASH),     RTF_BRDRDASH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRKFRM),       RTF_BRKFRM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CCHS),         RTF_CCHS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CPG),          RTF_CPG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CS),           RTF_CS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CVMME),            RTF_CVMME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DATAFIELD),        RTF_DATAFIELD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DO),           RTF_DO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOBXCOLUMN),   RTF_DOBXCOLUMN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOBXMARGIN),   RTF_DOBXMARGIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOBXPAGE),     RTF_DOBXPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOBYMARGIN),   RTF_DOBYMARGIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOBYPAGE),     RTF_DOBYPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOBYPARA),     RTF_DOBYPARA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DODHGT),       RTF_DODHGT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOLOCK),       RTF_DOLOCK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPAENDHOL),        RTF_DPAENDHOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPAENDL),      RTF_DPAENDL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPAENDSOL),        RTF_DPAENDSOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPAENDW),      RTF_DPAENDW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPARC),            RTF_DPARC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPARCFLIPX),   RTF_DPARCFLIPX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPARCFLIPY),   RTF_DPARCFLIPY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPASTARTHOL),  RTF_DPASTARTHOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPASTARTL),        RTF_DPASTARTL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPASTARTSOL),  RTF_DPASTARTSOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPASTARTW),        RTF_DPASTARTW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCALLOUT),        RTF_DPCALLOUT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOA),            RTF_DPCOA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOACCENT),   RTF_DPCOACCENT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOBESTFIT),  RTF_DPCOBESTFIT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOBORDER),   RTF_DPCOBORDER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCODABS),     RTF_DPCODABS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCODBOTTOM),  RTF_DPCODBOTTOM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCODCENTER),  RTF_DPCODCENTER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCODTOP),     RTF_DPCODTOP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOLENGTH),   RTF_DPCOLENGTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOMINUSX),   RTF_DPCOMINUSX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOMINUSY),   RTF_DPCOMINUSY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOOFFSET),   RTF_DPCOOFFSET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOSMARTA),   RTF_DPCOSMARTA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOTDOUBLE),  RTF_DPCOTDOUBLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOTRIGHT),   RTF_DPCOTRIGHT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOTSINGLE),  RTF_DPCOTSINGLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOTTRIPLE),  RTF_DPCOTTRIPLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCOUNT),      RTF_DPCOUNT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPELLIPSE),        RTF_DPELLIPSE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPENDGROUP),   RTF_DPENDGROUP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLBGCB),   RTF_DPFILLBGCB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLBGCG),   RTF_DPFILLBGCG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLBGCR),   RTF_DPFILLBGCR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLBGGRAY), RTF_DPFILLBGGRAY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLBGPAL),  RTF_DPFILLBGPAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLFGCB),   RTF_DPFILLFGCB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLFGCG),   RTF_DPFILLFGCG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLFGCR),   RTF_DPFILLFGCR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLFGGRAY), RTF_DPFILLFGGRAY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLFGPAL),  RTF_DPFILLFGPAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPFILLPAT),        RTF_DPFILLPAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPGROUP),      RTF_DPGROUP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINE),       RTF_DPLINE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINECOB),        RTF_DPLINECOB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINECOG),        RTF_DPLINECOG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINECOR),        RTF_DPLINECOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEDADO),   RTF_DPLINEDADO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEDADODO), RTF_DPLINEDADODO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEDASH),   RTF_DPLINEDASH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEDOT),        RTF_DPLINEDOT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEGRAY),   RTF_DPLINEGRAY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEHOLLOW), RTF_DPLINEHOLLOW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEPAL),        RTF_DPLINEPAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINESOLID),  RTF_DPLINESOLID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPLINEW),      RTF_DPLINEW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPPOLYCOUNT),  RTF_DPPOLYCOUNT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPPOLYGON),        RTF_DPPOLYGON},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPPOLYLINE),   RTF_DPPOLYLINE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPPTX),            RTF_DPPTX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPPTY),            RTF_DPPTY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPRECT),       RTF_DPRECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPROUNDR),     RTF_DPROUNDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPSHADOW),     RTF_DPSHADOW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPSHADX),      RTF_DPSHADX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPSHADY),      RTF_DPSHADY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPTXBX),       RTF_DPTXBX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPTXBXMAR),        RTF_DPTXBXMAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPTXBXTEXT),   RTF_DPTXBXTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPX),          RTF_DPX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPXSIZE),      RTF_DPXSIZE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPY),          RTF_DPY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPYSIZE),      RTF_DPYSIZE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DS),           RTF_DS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EMSPACE),      RTF_EMSPACE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ENSPACE),      RTF_ENSPACE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FBIDI),            RTF_FBIDI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FET),          RTF_FET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FID),          RTF_FID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FILE),         RTF_FILE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FILETBL),      RTF_FILETBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDALT),       RTF_FLDALT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FNETWORK),     RTF_FNETWORK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FONTEMB),      RTF_FONTEMB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FONTFILE),     RTF_FONTFILE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FORMDISP),     RTF_FORMDISP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FORMPROT),     RTF_FORMPROT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FORMSHADE),        RTF_FORMSHADE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOSNUM),       RTF_FOSNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRELATIVE),        RTF_FRELATIVE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNALT),       RTF_FTNALT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNIL),            RTF_FTNIL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNALC),      RTF_FTNNALC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNAR),       RTF_FTNNAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNAUC),      RTF_FTNNAUC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNCHI),      RTF_FTNNCHI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNRLC),      RTF_FTNNRLC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNRUC),      RTF_FTNNRUC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNRSTCONT),   RTF_FTNRSTCONT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNRSTPG),     RTF_FTNRSTPG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTTRUETYPE),   RTF_FTTRUETYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FVALIDDOS),        RTF_FVALIDDOS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FVALIDHPFS),   RTF_FVALIDHPFS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FVALIDMAC),        RTF_FVALIDMAC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FVALIDNTFS),   RTF_FVALIDNTFS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHAUTO),     RTF_HYPHAUTO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHCAPS),     RTF_HYPHCAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHCONSEC),   RTF_HYPHCONSEC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHPAR),      RTF_HYPHPAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINKSELF),     RTF_LINKSELF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINKSTYLES),   RTF_LINKSTYLES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LTRCH),            RTF_LTRCH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LTRDOC),       RTF_LTRDOC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LTRMARK),      RTF_LTRMARK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LTRPAR),       RTF_LTRPAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LTRROW),       RTF_LTRROW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LTRSECT),      RTF_LTRSECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOCOLBAL),     RTF_NOCOLBAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOEXTRASPRL),  RTF_NOEXTRASPRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOTABIND),     RTF_NOTABIND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOWIDCTLPAR),  RTF_NOWIDCTLPAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJALIAS),     RTF_OBJALIAS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJALIGN),     RTF_OBJALIGN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJAUTLINK),   RTF_OBJAUTLINK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJCLASS),     RTF_OBJCLASS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJCROPB),     RTF_OBJCROPB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJCROPL),     RTF_OBJCROPL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJCROPR),     RTF_OBJCROPR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJCROPT),     RTF_OBJCROPT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJDATA),      RTF_OBJDATA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJECT),       RTF_OBJECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJEMB),       RTF_OBJEMB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJH),         RTF_OBJH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJICEMB),     RTF_OBJICEMB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJLINK),      RTF_OBJLINK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJLOCK),      RTF_OBJLOCK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJNAME),      RTF_OBJNAME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJPUB),       RTF_OBJPUB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJSCALEX),        RTF_OBJSCALEX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJSCALEY),        RTF_OBJSCALEY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJSECT),      RTF_OBJSECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJSETSIZE),   RTF_OBJSETSIZE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJSUB),       RTF_OBJSUB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJTIME),      RTF_OBJTIME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJTRANSY),        RTF_OBJTRANSY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJUPDATE),        RTF_OBJUPDATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJW),         RTF_OBJW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OTBLRUL),      RTF_OTBLRUL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNHN),            RTF_PGNHN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNHNSC),      RTF_PGNHNSC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNHNSH),      RTF_PGNHNSH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNHNSM),      RTF_PGNHNSM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNHNSN),      RTF_PGNHNSN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNHNSP),      RTF_PGNHNSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICBMP),       RTF_PICBMP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICBPP),       RTF_PICBPP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PN),           RTF_PN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNACROSS),     RTF_PNACROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNB),          RTF_PNB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNCAPS),       RTF_PNCAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNCARD),       RTF_PNCARD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNCF),         RTF_PNCF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNDEC),            RTF_PNDEC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNF),          RTF_PNF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNFS),         RTF_PNFS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNHANG),       RTF_PNHANG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNI),          RTF_PNI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNINDENT),     RTF_PNINDENT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNLCLTR),      RTF_PNLCLTR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNLCRM),       RTF_PNLCRM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNLVL),            RTF_PNLVL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNLVLBLT),     RTF_PNLVLBLT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNLVLBODY),        RTF_PNLVLBODY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNLVLCONT),        RTF_PNLVLCONT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNNUMONCE),        RTF_PNNUMONCE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNORD),            RTF_PNORD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNORDT),       RTF_PNORDT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNPREV),       RTF_PNPREV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNQC),         RTF_PNQC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNQL),         RTF_PNQL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNQR),         RTF_PNQR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRESTART),        RTF_PNRESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNSCAPS),      RTF_PNSCAPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNSECLVL),     RTF_PNSECLVL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNSP),         RTF_PNSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNSTART),      RTF_PNSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNSTRIKE),     RTF_PNSTRIKE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNTEXT),       RTF_PNTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNTXTA),       RTF_PNTXTA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNTXTB),       RTF_PNTXTB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNUCLTR),      RTF_PNUCLTR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNUCRM),       RTF_PNUCRM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNUL),         RTF_PNUL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNULD),            RTF_PNULD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNULDB),       RTF_PNULDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNULNONE),     RTF_PNULNONE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNULW),            RTF_PNULW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PRCOLBL),      RTF_PRCOLBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PRINTDATA),        RTF_PRINTDATA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PSZ),          RTF_PSZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PUBAUTO),      RTF_PUBAUTO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RESULT),       RTF_RESULT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVAUTH),      RTF_REVAUTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVDTTM),      RTF_REVDTTM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVPROT),      RTF_REVPROT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVTBL),       RTF_REVTBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RSLTBMP),      RTF_RSLTBMP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RSLTMERGE),        RTF_RSLTMERGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RSLTPICT),     RTF_RSLTPICT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RSLTRTF),      RTF_RSLTRTF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RSLTTXT),      RTF_RSLTTXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTLCH),            RTF_RTLCH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTLDOC),       RTF_RTLDOC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTLMARK),      RTF_RTLMARK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTLPAR),       RTF_RTLPAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTLROW),       RTF_RTLROW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_RTLSECT),      RTF_RTLSECT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SEC),          RTF_SEC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTNUM),      RTF_SECTNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTUNLOCKED), RTF_SECTUNLOCKED},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SLMULT),       RTF_SLMULT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SOFTCOL),      RTF_SOFTCOL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SOFTLHEIGHT),  RTF_SOFTLHEIGHT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SOFTLINE),     RTF_SOFTLINE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SOFTPAGE),     RTF_SOFTPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SPRSSPBF),     RTF_SPRSSPBF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SPRSTSP),      RTF_SPRSTSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SUBDOCUMENT),  RTF_SUBDOCUMENT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SWPBDR),       RTF_SWPBDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TCN),          RTF_TCN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRANSMF),      RTF_TRANSMF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRBRDRB),      RTF_TRBRDRB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRBRDRH),      RTF_TRBRDRH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRBRDRL),      RTF_TRBRDRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRBRDRR),      RTF_TRBRDRR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRBRDRT),      RTF_TRBRDRT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRBRDRV),      RTF_TRBRDRV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRHDR),            RTF_TRHDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRKEEP),       RTF_TRKEEP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDB),      RTF_TRPADDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDL),      RTF_TRPADDL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDR),      RTF_TRPADDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDT),      RTF_TRPADDT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDFB),      RTF_TRPADDFB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDFL),      RTF_TRPADDFL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDFR),      RTF_TRPADDFR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRPADDFT),      RTF_TRPADDFT},


{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WRAPTRSP),     RTF_WRAPTRSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_XEF),          RTF_XEF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ZWJ),          RTF_ZWJ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ZWNJ),         RTF_ZWNJ},


{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ABSLOCK),      RTF_ABSLOCK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ADJUSTRIGHT),  RTF_ADJUSTRIGHT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNCHOSUNG), RTF_AFTNNCHOSUNG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNCNUM),        RTF_AFTNNCNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNDBAR),        RTF_AFTNNDBAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNDBNUM),   RTF_AFTNNDBNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMD),  RTF_AFTNNDBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMK),  RTF_AFTNNDBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMT),  RTF_AFTNNDBNUMT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNGANADA),  RTF_AFTNNGANADA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNGBNUM),   RTF_AFTNNGBNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMD),  RTF_AFTNNGBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMK),  RTF_AFTNNGBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNGBNUML),  RTF_AFTNNGBNUML},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNZODIAC),  RTF_AFTNNZODIAC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNZODIACD), RTF_AFTNNZODIACD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_AFTNNZODIACL), RTF_AFTNNZODIACL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ANIMTEXT),     RTF_ANIMTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ANSICPG),      RTF_ANSICPG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BACKGROUND),   RTF_BACKGROUND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BDBFHDR),      RTF_BDBFHDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BLIPTAG),      RTF_BLIPTAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BLIPUID),      RTF_BLIPUID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BLIPUPI),      RTF_BLIPUPI},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRART),      RTF_BRDRART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDASHD),        RTF_BRDRDASHD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDASHDD),   RTF_BRDRDASHDD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDASHDOTSTR),RTF_BRDRDASHDOTSTR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRDASHSM),   RTF_BRDRDASHSM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRINSET),    RTF_BRDRINSET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDROUTSET),   RTF_BRDROUTSET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDREMBOSS),   RTF_BRDREMBOSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRENGRAVE),  RTF_BRDRENGRAVE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRFRAME),        RTF_BRDRFRAME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTHTNLG),   RTF_BRDRTHTNLG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTHTNMG),   RTF_BRDRTHTNMG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTHTNSG),   RTF_BRDRTHTNSG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTNTHLG),   RTF_BRDRTNTHLG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTNTHMG),   RTF_BRDRTNTHMG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTNTHSG),   RTF_BRDRTNTHSG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNLG), RTF_BRDRTNTHTNLG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNMG), RTF_BRDRTNTHTNMG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNSG), RTF_BRDRTNTHTNSG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRTRIPLE),   RTF_BRDRTRIPLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRWAVY),     RTF_BRDRWAVY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDRWAVYDB),   RTF_BRDRWAVYDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CATEGORY),     RTF_CATEGORY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CGRID),            RTF_CGRID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHARSCALEX),   RTF_CHARSCALEX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGBDIAG),        RTF_CHBGBDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGCROSS),        RTF_CHBGCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDCROSS),   RTF_CHBGDCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDKBDIAG),  RTF_CHBGDKBDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDKCROSS),  RTF_CHBGDKCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDKDCROSS), RTF_CHBGDKDCROSS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDKFDIAG),  RTF_CHBGDKFDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDKHORIZ),  RTF_CHBGDKHORIZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGDKVERT),   RTF_CHBGDKVERT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGFDIAG),        RTF_CHBGFDIAG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGHORIZ),        RTF_CHBGHORIZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBGVERT),     RTF_CHBGVERT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHBRDR),       RTF_CHBRDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHCBPAT),      RTF_CHCBPAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHCFPAT),      RTF_CHCFPAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CHSHDNG),      RTF_CHSHDNG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLTXLRTB),     RTF_CLTXLRTB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLTXTBRL),     RTF_CLTXTBRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLVERTALB),        RTF_CLVERTALB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLVERTALC),        RTF_CLVERTALC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLVERTALT),        RTF_CLVERTALT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLVMGF),       RTF_CLVMGF},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLVMRG),       RTF_CLVMRG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLTXTBRLV),    RTF_CLTXTBRLV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLTXBTLR),         RTF_CLTXBTLR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CLTXLRTBV),        RTF_CLTXLRTBV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_COMPANY),      RTF_COMPANY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CRAUTH),       RTF_CRAUTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_CRDATE),       RTF_CRDATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DATE),         RTF_DATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DEFLANGFE),        RTF_DEFLANGFE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRAUTH),      RTF_DFRAUTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRDATE),      RTF_DFRDATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRSTART),     RTF_DFRSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRSTOP),      RTF_DFRSTOP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRXST),       RTF_DFRXST},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DGMARGIN),     RTF_DGMARGIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DNTBLNSBDB),   RTF_DNTBLNSBDB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOCTYPE),      RTF_DOCTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DOCVAR),       RTF_DOCVAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DPCODESCENT),  RTF_DPCODESCENT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EMBO),         RTF_EMBO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EMFBLIP),      RTF_EMFBLIP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_EXPSHRTN),     RTF_EXPSHRTN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FAAUTO),       RTF_FAAUTO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FBIAS),            RTF_FBIAS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFDEFRES),     RTF_FFDEFRES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFDEFTEXT),        RTF_FFDEFTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFENTRYMCR),   RTF_FFENTRYMCR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFEXITMCR),        RTF_FFEXITMCR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFFORMAT),     RTF_FFFORMAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFHASLISTBOX), RTF_FFHASLISTBOX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFHELPTEXT),   RTF_FFHELPTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFHPS),            RTF_FFHPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFL),          RTF_FFL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFMAXLEN),     RTF_FFMAXLEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFNAME),       RTF_FFNAME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFOWNHELP),        RTF_FFOWNHELP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFOWNSTAT),        RTF_FFOWNSTAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFPROT),       RTF_FFPROT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFRECALC),     RTF_FFRECALC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFRES),            RTF_FFRES},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFSIZE),       RTF_FFSIZE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFSTATTEXT),   RTF_FFSTATTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFTYPE),       RTF_FFTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FFTYPETXT),        RTF_FFTYPETXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLDTYPE),      RTF_FLDTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FNAME),            RTF_FNAME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FORMFIELD),        RTF_FORMFIELD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FROMTEXT),     RTF_FROMTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNCHOSUNG),  RTF_FTNNCHOSUNG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNCNUM),     RTF_FTNNCNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNDBAR),     RTF_FTNNDBAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNDBNUM),        RTF_FTNNDBNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNDBNUMD),   RTF_FTNNDBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNDBNUMK),   RTF_FTNNDBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNDBNUMT),   RTF_FTNNDBNUMT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNGANADA),   RTF_FTNNGANADA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNGBNUM),        RTF_FTNNGBNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNGBNUMD),   RTF_FTNNGBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNGBNUMK),   RTF_FTNNGBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNGBNUML),   RTF_FTNNGBNUML},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNZODIAC),   RTF_FTNNZODIAC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNZODIACD),  RTF_FTNNZODIACD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FTNNZODIACL),  RTF_FTNNZODIACL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_G),                RTF_G},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GCW),          RTF_GCW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GRIDTBL),      RTF_GRIDTBL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HIGHLIGHT),        RTF_HIGHLIGHT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HLFR),         RTF_HLFR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HLINKBASE),        RTF_HLINKBASE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HLLOC),            RTF_HLLOC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HLSRC),            RTF_HLSRC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ILVL),         RTF_ILVL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_IMPR),         RTF_IMPR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_JPEGBLIP),     RTF_JPEGBLIP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELFOLLOW),  RTF_LEVELFOLLOW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELINDENT),  RTF_LEVELINDENT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELJC),      RTF_LEVELJC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELLEGAL),   RTF_LEVELLEGAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELNFC),     RTF_LEVELNFC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELNORESTART),RTF_LEVELNORESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELNUMBERS), RTF_LEVELNUMBERS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELOLD),     RTF_LEVELOLD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELPREV),        RTF_LEVELPREV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELPREVSPACE),RTF_LEVELPREVSPACE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELSPACE),   RTF_LEVELSPACE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELSTARTAT), RTF_LEVELSTARTAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LEVELTEXT),        RTF_LEVELTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LINKVAL),      RTF_LINKVAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LIST),         RTF_LIST},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTID),       RTF_LISTID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTLEVEL),     RTF_LISTLEVEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTNAME),     RTF_LISTNAME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTOVERRIDE), RTF_LISTOVERRIDE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTOVERRIDECOUNT),        RTF_LISTOVERRIDECOUNT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTOVERRIDEFORMAT),   RTF_LISTOVERRIDEFORMAT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTOVERRIDESTART),        RTF_LISTOVERRIDESTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTOVERRIDETABLE),        RTF_LISTOVERRIDETABLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTRESTARTHDN),RTF_LISTRESTARTHDN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTSIMPLE),   RTF_LISTSIMPLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTTABLE),        RTF_LISTTABLE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTTEMPLATEID),RTF_LISTTEMPLATEID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LISTTEXT),     RTF_LISTTEXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LS),           RTF_LS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LYTEXCTTP),        RTF_LYTEXCTTP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LYTPRTMET),        RTF_LYTPRTMET},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MANAGER),      RTF_MANAGER},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_MSMCAP),       RTF_MSMCAP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOFCHARSWS),   RTF_NOFCHARSWS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOLEAD),       RTF_NOLEAD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NONSHPPICT),   RTF_NONSHPPICT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOSECTEXPAND), RTF_NOSECTEXPAND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOSNAPLINEGRID),RTF_NOSNAPLINEGRID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOSPACEFORUL), RTF_NOSPACEFORUL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOULTRLSPC),   RTF_NOULTRLSPC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOXLATTOYEN),  RTF_NOXLATTOYEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJATTPH),     RTF_OBJATTPH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJHTML),      RTF_OBJHTML},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OBJOCX),       RTF_OBJOCX},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLDLINEWRAP),  RTF_OLDLINEWRAP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OUTLINELEVEL), RTF_OUTLINELEVEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OVERLAY),      RTF_OVERLAY},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PANOSE),       RTF_PANOSE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRB),      RTF_PGBRDRB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRFOOT),   RTF_PGBRDRFOOT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRHEAD),   RTF_PGBRDRHEAD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRL),      RTF_PGBRDRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDROPT),        RTF_PGBRDROPT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRR),      RTF_PGBRDRR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRSNAP),   RTF_PGBRDRSNAP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRDRT),      RTF_PGBRDRT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNCHOSUNG),   RTF_PGNCHOSUNG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNCNUM),      RTF_PGNCNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNDBNUMK),        RTF_PGNDBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNDBNUMT),        RTF_PGNDBNUMT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNGANADA),        RTF_PGNGANADA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNGBNUM),     RTF_PGNGBNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNGBNUMD),        RTF_PGNGBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNGBNUMK),        RTF_PGNGBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNGBNUML),        RTF_PGNGBNUML},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNZODIAC),        RTF_PGNZODIAC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNZODIACD),   RTF_PGNZODIACD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGNZODIACL),   RTF_PGNZODIACL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PICPROP),      RTF_PICPROP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNAIUEO),      RTF_PNAIUEO},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNAIUEOD),     RTF_PNAIUEOD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNCHOSUNG),        RTF_PNCHOSUNG},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNDBNUMD),     RTF_PNDBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNDBNUMK),     RTF_PNDBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNDBNUML),     RTF_PNDBNUML},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNDBNUMT),     RTF_PNDBNUMT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNGANADA),     RTF_PNGANADA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNGBLIP),      RTF_PNGBLIP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNGBNUM),      RTF_PNGBNUM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNGBNUMD),     RTF_PNGBNUMD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNGBNUMK),     RTF_PNGBNUMK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNGBNUML),     RTF_PNGBNUML},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRAUTH),      RTF_PNRAUTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRDATE),      RTF_PNRDATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRNFC),       RTF_PNRNFC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRNOT),       RTF_PNRNOT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRPNBR),      RTF_PNRPNBR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRRGB),       RTF_PNRRGB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRSTART),     RTF_PNRSTART},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRSTOP),      RTF_PNRSTOP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNRXST),       RTF_PNRXST},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNZODIAC),     RTF_PNZODIAC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNZODIACD),        RTF_PNZODIACD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PNZODIACL),        RTF_PNZODIACL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LFOLEVEL),     RTF_LFOLEVEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSYIN),       RTF_POSYIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_POSYOUT),      RTF_POSYOUT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PRIVATE),      RTF_PRIVATE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PROPNAME),     RTF_PROPNAME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PROPTYPE),     RTF_PROPTYPE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVAUTHDEL),   RTF_REVAUTHDEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_REVDTTMDEL),   RTF_REVDTTMDEL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SAUTOUPD),     RTF_SAUTOUPD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTDEFAULTCL),    RTF_SECTDEFAULTCL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTEXPAND),   RTF_SECTEXPAND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTLINEGRID), RTF_SECTLINEGRID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTSPECIFYCL),    RTF_SECTSPECIFYCL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SECTSPECIFYL), RTF_SECTSPECIFYL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHIDDEN),      RTF_SHIDDEN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBOTTOM),        RTF_SHPBOTTOM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBXCOLUMN),  RTF_SHPBXCOLUMN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBXMARGIN),  RTF_SHPBXMARGIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBXPAGE),        RTF_SHPBXPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBYMARGIN),  RTF_SHPBYMARGIN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBYPAGE),        RTF_SHPBYPAGE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBYPARA),        RTF_SHPBYPARA},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPFBLWTXT),   RTF_SHPFBLWTXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPFHDR),      RTF_SHPFHDR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPGRP),       RTF_SHPGRP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPINST),      RTF_SHPINST},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPLEFT),      RTF_SHPLEFT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPLID),       RTF_SHPLID},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPLOCKANCHOR),    RTF_SHPLOCKANCHOR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPPICT),      RTF_SHPPICT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPRIGHT),     RTF_SHPRIGHT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPRSLT),      RTF_SHPRSLT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPTOP),       RTF_SHPTOP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPTXT),       RTF_SHPTXT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPWRK),       RTF_SHPWRK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPWR),            RTF_SHPWR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPZ),         RTF_SHPZ},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SPRSBSP),      RTF_SPRSBSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SPRSLNSP),     RTF_SPRSLNSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SPRSTSM),      RTF_SPRSTSM},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_STATICVAL),        RTF_STATICVAL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_STEXTFLOW),        RTF_STEXTFLOW},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_STRIKED),      RTF_STRIKED},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SUBFONTBYSIZE),    RTF_SUBFONTBYSIZE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TCELLD),       RTF_TCELLD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TIME),         RTF_TIME},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TRUNCATEFONTHEIGHT),   RTF_TRUNCATEFONTHEIGHT},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_UC),           RTF_UC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_UD),           RTF_UD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULDASH),       RTF_ULDASH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULDASHD),      RTF_ULDASHD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULDASHDD),     RTF_ULDASHDD},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULTH),         RTF_ULTH},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULWAVE),       RTF_ULWAVE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULC),          RTF_ULC},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_U),                RTF_U},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_UPR),          RTF_UPR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_USERPROPS),        RTF_USERPROPS},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VIEWKIND),     RTF_VIEWKIND},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VIEWSCALE),        RTF_VIEWSCALE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_VIEWZK),       RTF_VIEWZK},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WIDCTLPAR),        RTF_WIDCTLPAR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WINDOWCAPTION),    RTF_WINDOWCAPTION},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WPEQN),            RTF_WPEQN},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WPJST),            RTF_WPJST},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_WPSP),         RTF_WPSP},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_YXE),          RTF_YXE},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRMTXLRTB),    RTF_FRMTXLRTB},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRMTXTBRL),    RTF_FRMTXTBRL},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRMTXBTLR),    RTF_FRMTXBTLR},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRMTXLRTBV),   RTF_FRMTXLRTBV},
{OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FRMTXTBRLV),   RTF_FRMTXTBRLV},

// MS-2000 Tokens
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULTHD),         RTF_ULTHD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULTHDASH),      RTF_ULTHDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULLDASH),       RTF_ULLDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULTHLDASH),     RTF_ULTHLDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULTHDASHD),     RTF_ULTHDASHD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULTHDASHDD),    RTF_ULTHDASHDD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULHWAVE),       RTF_ULHWAVE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ULULDBWAVE),    RTF_ULULDBWAVE},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LOCH),         RTF_LOCH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HICH),         RTF_HICH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DBCH),         RTF_DBCH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_LANGFE),       RTF_LANGFE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ADEFLANG),     RTF_ADEFLANG},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ADEFF),            RTF_ADEFF},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ACCNONE),      RTF_ACCNONE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ACCDOT),       RTF_ACCDOT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ACCCOMMA),     RTF_ACCCOMMA},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TWOINONE),     RTF_TWOINONE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HORZVERT),     RTF_HORZVERT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FAHANG),       RTF_FAHANG},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FAVAR),            RTF_FAVAR},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FACENTER),     RTF_FACENTER},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FAROMAN),      RTF_FAROMAN},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FAFIXED),      RTF_FAFIXED},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOCWRAP),       RTF_NOCWRAP},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_NOOVERFLOW),    RTF_NOOVERFLOW},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_ASPALPHA),      RTF_ASPALPHA},

// SWG specific attributes
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GRFALIGNV),     RTF_GRF_ALIGNV},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GRFALIGNH),     RTF_GRF_ALIGNH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_GRFMIRROR),     RTF_GRF_MIRROR},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERYB),      RTF_HEADER_YB},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERXL),      RTF_HEADER_XL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERXR),      RTF_HEADER_XR},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERYT),      RTF_FOOTER_YT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERXL),      RTF_FOOTER_XL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERXR),      RTF_FOOTER_XR},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HEADERYH),      RTF_HEADER_YH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FOOTERYH),      RTF_FOOTER_YH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BALANCEDCOLUMN),RTF_BALANCED_COLUMN},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_UPDNPROP),      RTF_SWG_ESCPROP},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PRTDATA),       RTF_SWG_PRTDATA},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BKMKKEY),       RTF_BKMK_KEY},

// Attributes for fly frames
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYPRINT),      RTF_FLYPRINT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYOPAQUE),     RTF_FLYOPAQUE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYPRTCTD),     RTF_FLYPRTCTD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYMAINCNT),    RTF_FLYMAINCNT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYVERT),       RTF_FLYVERT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYHORZ),       RTF_FLYHORZ},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRMTXTL),      RTF_FLYOUTLEFT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRMTXTR),      RTF_FLYOUTRIGHT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRMTXTU),      RTF_FLYOUTUPPER},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_DFRMTXTW),      RTF_FLYOUTLOWER},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYANCHOR),     RTF_FLYANCHOR},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYCNTNT),      RTF_FLY_CNTNT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYCOLUMN),     RTF_FLY_COLUMN},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYPAGE),       RTF_FLY_PAGE},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDBOX),        RTF_BRDBOX},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDLNCOL),      RTF_BRDLINE_COL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDLNIN),       RTF_BRDLINE_IN},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDLNOUT),      RTF_BRDLINE_OUT},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_BRDLNDIST),     RTF_BRDLINE_DIST},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHADOW),        RTF_SHADOW},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHDWDIST),      RTF_SHDW_DIST},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHDWSTYLE),     RTF_SHDW_STYLE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHDWCOL),       RTF_SHDW_COL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHDWFCOL),      RTF_SHDW_FCOL},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_FLYINPARA),     RTF_FLY_INPARA},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGDSCTBL),      RTF_PGDSCTBL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGDSC),         RTF_PGDSC},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGDSCUSE),      RTF_PGDSCUSE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGDSCNXT),      RTF_PGDSCNXT},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHEN),        RTF_HYPHEN},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHLEAD),      RTF_HYPHLEAD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHTRAIL),     RTF_HYPHTRAIL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_HYPHMAX),       RTF_HYPHMAX},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_TLSWG),         RTF_TLSWG},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGBRK),         RTF_PGBRK},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_PGDSCNO),       RTF_PGDSCNO},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SOUTLVL),       RTF_SOUTLVL},

        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHP),       RTF_SHP},
        /*
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPLEFT),       RTF_SHPLEFT}
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPTOP),       RTF_SHPTOP}
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBOTTOM),       RTF_SHPBOTTOM}
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPRIGHT),       RTF_SHPRIGHT}
        */
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SN),       RTF_SN},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SV),       RTF_SV},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SP),       RTF_SP},

// Support for overline attributes
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OL),           RTF_OL},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLW),          RTF_OLW},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLD),          RTF_OLD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLDB),         RTF_OLDB},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLNONE),       RTF_OLNONE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLDASH),       RTF_OLDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLDASHD),      RTF_OLDASHD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLDASHDD),     RTF_OLDASHDD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLTH),         RTF_OLTH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLWAVE),       RTF_OLWAVE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLC),          RTF_OLC},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLTHD),            RTF_OLTHD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLTHDASH),     RTF_OLTHDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLLDASH),      RTF_OLLDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLTHLDASH),        RTF_OLTHLDASH},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLTHDASHD),        RTF_OLTHDASHD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLTHDASHDD),   RTF_OLTHDASHDD},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLHWAVE),      RTF_OLHWAVE},
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_OLOLDBWAVE),   RTF_OLOLDBWAVE}
};


int GetRTFToken( const OUString& rSearch )
{
    if( !bSortKeyWords )
    {
        std::sort( std::begin(aRTFTokenTab), std::end(aRTFTokenTab),
                    [](const RTF_TokenEntry & lhs, const RTF_TokenEntry & rhs)
                    {
                        return strcmp(lhs.sToken.data, rhs.sToken.data) < 0;
                    } );
        bSortKeyWords = true;
    }

    auto findCompare = [](const RTF_TokenEntry & lhs, const OUString & s)
        {
            return s.compareToIgnoreAsciiCaseAscii(lhs.sToken.data) > 0;
        };
    auto findIt = std::lower_bound( std::begin(aRTFTokenTab), std::end(aRTFTokenTab), rSearch, findCompare);
    if (findIt != std::end(aRTFTokenTab) && rSearch.compareToIgnoreAsciiCaseAscii(findIt->sToken.data)==0)
        return findIt->nToken;

    return 0;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
