## RabbitMQ 3.7.19

RabbitMQ `3.7.19` is a maintenance release that focuses on bug fixes.
RabbitMQ `3.7.x` series is supported [through March 2020](https://www.rabbitmq.com/versions.html).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * `rabbit_diagnostics:binary_refs/1`, a predecessor to Recon used for binary heap inspection,
   could fail with an exception due to a race condition.

   Contributed by John Eckersberg (@jeckersb).

   GitHub issue: [rabbitmq/rabbitmq-server#2117](https://github.com/rabbitmq/rabbitmq-server/pull/2117)

 * It was not possible to set `ERL_MAX_PORTS` in `rabbitmq-env-conf.bat`.

   GitHub issue: [rabbitmq/rabbitmq-server#2084](https://github.com/rabbitmq/rabbitmq-server/issues/2084)


### Management Plugin

#### Bug Fixes

 * Import of large definition files submitted via management UI form could fail.

   GitHub issue: [rabbitmq/rabbitmq-management#739](https://github.com/rabbitmq/rabbitmq-management/issues/739)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics node_health_check` would pass even when some cluster nodes had
   network partitions in effect.

   Contributed by Lajos Gerecs (@luos).

   GitHub issue: [rabbitmq/rabbitmq-server#2127](https://github.com/rabbitmq/rabbitmq-server/pull/2127)

 * `rabbitmqctl set_parameter` output could be misleading.

   Contributed by @Whitespirit0.

   GitHub issue: [rabbitmq/rabbitmq-cli#376](https://github.com/rabbitmq/rabbitmq-cli/issues/376)


### STOMP Plugin

#### Bug Fixes

 * Cleanup of a subscription after a server-initiated [consumer cancelation](https://www.rabbitmq.com/consumer-cancel.html)
   failed with an exception.

   GitHub issue: [rabbitmq/rabbitmq-stomp#136](https://github.com/rabbitmq/rabbitmq-stomp/issues/136)


### Event Exchange Plugin

#### Bug Fixes

 * Events could fail to be emitted in multi-node clusters.

   GitHub issue: [rabbitmq/rabbitmq-event-exchange#41](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/41)


### Management Exchange Plugin

#### Bug Fixes

 * The plugin was not updated to correctly fetch a list of TCP and TLS listeners used
   by the management plugin.

   GitHub issue: [rabbitmq/rabbitmq-management-exchange#8](https://github.com/rabbitmq/rabbitmq-management-exchange/issues/8)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.19.tar.xz`.
