/* DirectoryMonitor.c generated by valac 0.34.7, the Vala compiler
 * generated from DirectoryMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* DirectoryMonitor will monitor an entire directory for changes to all files and directories*/
/* within it.  It uses FileMonitor to monitor all directories it discovers at initialization*/
/* and reports changes to the files and directories just as FileMonitor reports them.  Subclasses*/
/* can override the notify_* methods to filter or monitor events before the signal is fired,*/
/* or can override the signals themselves to be notified afterwards.*/
/**/
/* start_discovery() must be called to initiate monitoring.  Directories and files will be reported*/
/* as they're discovered.  Directories will be monitored as they're discovered as well.  Discovery*/
/* can only be initiated once.*/
/**/
/* All signals are virtual and have a corresponding notify_* protected virtual function.*/
/* Subclasses can either override the notify or the signal to decide when they want to process*/
/* the event.*/
/**/
/* DirectoryMonitor also adds a level of intelligence to GLib's monitoring API.Because certain*/
/* file/directory events are decomposed by FileMonitor into more atomic events, it's difficult*/
/* to know when these "composed" events have occurred.  (For example, a file move is reported*/
/* as a DELETED event followed by a CREATED event, with no clue that the two are related.)  Later*/
/* versions added the MOVE event, but we can't rely on those being installed.  Also, documentation*/
/* suggests it's only available with certain back-ends.*/
/**/
/* DirectoryMonitor attempts to solve this by deducing when a set of events actually equals*/
/* a composite event.  It requires more memory in order to do this (i.e. it stores all files and*/
/* their information), but the trade-off is easier file/directory monitoring via familiar*/
/* semantics.*/
/**/
/* DirectoryMonitor also will synthesize events when normal monitor events don't produce expected*/
/* results.  For example, if a directory is moved out of DirectoryMonitor's root, it is reported*/
/* as a delete event, but none of its children are reported as deleted.  Similarly, a directory*/
/* rename can be captured as a move, but notifications for all its children are not fired and*/
/* are synthesized by DirectoryMonitor.  DirectoryMonitor will fire delete and move notifications*/
/* for all the directory's children in depth-first order.*/
/**/
/* In general, DirectoryMonitor attempts to preserve ordering of events, so that (for example) a*/
/* file-altered event doesn't fire before a file-created, and so on.*/
/**/
/* Because of these requirements, DirectoryMonitor maintains a FileInfo struct on all directories */
/* and files being monitored.  (It maintains the attributes gather during the discovery phase, i.e. */
/* SUPPLIED_ATTRIBUTES.)  This information can be retrieved via get_info(), get_file_id(), and*/
/* get_etag().  These calls can be made at any time; the information is stored before any signal*/
/* is fired.*/
/**/
/* Note that DirectoryMonitor currently only supports files and directories.  Other file types*/
/* (special, symbolic links, shortcuts, and mount points) are not supported.  It has been seen*/
/* when a temporary file is created for its file type to be reported as "unknown" and when it's*/
/* altered/deleted to be reported as a regular file.  This means it's possible for a file not to*/
/* be reported as discovered or created but to be reported as altered and/or deleted.*/
/**/
/* DirectoryMonitor can be configured to not recurse (in which case it only discovers/monitors*/
/* the root directory) and to not monitor (in which case only discovery occurs).*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;
typedef struct _DirectoryMonitorPrivate DirectoryMonitorPrivate;

#define DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT (directory_monitor_query_info_queue_element_get_type ())
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElement))
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElementClass))
#define DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT))
#define DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT))
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElementClass))

typedef struct _DirectoryMonitorQueryInfoQueueElement DirectoryMonitorQueryInfoQueueElement;
typedef struct _DirectoryMonitorQueryInfoQueueElementClass DirectoryMonitorQueryInfoQueueElementClass;

#define DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP (directory_monitor_file_info_map_get_type ())
#define DIRECTORY_MONITOR_FILE_INFO_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMap))
#define DIRECTORY_MONITOR_FILE_INFO_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapClass))
#define DIRECTORY_MONITOR_IS_FILE_INFO_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP))
#define DIRECTORY_MONITOR_IS_FILE_INFO_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP))
#define DIRECTORY_MONITOR_FILE_INFO_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapClass))

typedef struct _DirectoryMonitorFileInfoMap DirectoryMonitorFileInfoMap;
typedef struct _DirectoryMonitorFileInfoMapClass DirectoryMonitorFileInfoMapClass;

#define DIRECTORY_MONITOR_TYPE_FTYPE (directory_monitor_ftype_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _directory_monitor_file_info_map_unref0(var) ((var == NULL) ? NULL : (var = (directory_monitor_file_info_map_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DirectoryMonitorAsyncInternalNotifyDirectoryMovedData DirectoryMonitorAsyncInternalNotifyDirectoryMovedData;
typedef struct _DirectoryMonitorAsyncNotifyDirectoryDeletedData DirectoryMonitorAsyncNotifyDirectoryDeletedData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _DirectoryMonitorExploreAsyncData DirectoryMonitorExploreAsyncData;
typedef struct _DirectoryMonitorNotifyDirectoryFilesData DirectoryMonitorNotifyDirectoryFilesData;
typedef struct _DirectoryMonitorQueryInfoQueueElementPrivate DirectoryMonitorQueryInfoQueueElementPrivate;
#define _directory_monitor_query_info_queue_element_unref0(var) ((var == NULL) ? NULL : (var = (directory_monitor_query_info_queue_element_unref (var), NULL)))
typedef struct _DirectoryMonitorParamSpecQueryInfoQueueElement DirectoryMonitorParamSpecQueryInfoQueueElement;
typedef struct _DirectoryMonitorFileInfoMapPrivate DirectoryMonitorFileInfoMapPrivate;
typedef struct _DirectoryMonitorParamSpecFileInfoMap DirectoryMonitorParamSpecFileInfoMap;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DirectoryMonitor {
	GObject parent_instance;
	DirectoryMonitorPrivate * priv;
};

struct _DirectoryMonitorClass {
	GObjectClass parent_class;
	void (*notify_root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*notify_root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*notify_discovery_started) (DirectoryMonitor* self);
	void (*internal_notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*internal_notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*notify_discovery_completed) (DirectoryMonitor* self);
	void (*notify_file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*notify_file_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*notify_directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*notify_directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*notify_closed) (DirectoryMonitor* self);
	void (*close) (DirectoryMonitor* self);
	void (*root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*discovery_started) (DirectoryMonitor* self);
	void (*file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*directory_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*discovery_completed) (DirectoryMonitor* self);
	void (*file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*file_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*closed) (DirectoryMonitor* self);
};

struct _DirectoryMonitorPrivate {
	GFile* root;
	gboolean recurse;
	gboolean monitoring;
	GeeHashMap* monitors;
	GeeQueue* query_info_queue;
	DirectoryMonitorFileInfoMap* files;
	DirectoryMonitorFileInfoMap* parent_moved;
	GCancellable* cancellable;
	gint outstanding_exploration_dirs;
	gboolean started;
	gboolean has_discovery_started;
	guint delete_timer_id;
};

typedef enum  {
	DIRECTORY_MONITOR_FTYPE_FILE,
	DIRECTORY_MONITOR_FTYPE_DIRECTORY,
	DIRECTORY_MONITOR_FTYPE_UNSUPPORTED
} DirectoryMonitorFType;

struct _DirectoryMonitorAsyncInternalNotifyDirectoryMovedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GFile* old_dir;
	GFileInfo* old_dir_info;
	GFile* new_dir;
	GFileInfo* new_dir_info;
	GeeArrayList* file_children;
	GeeArrayList* _tmp0_;
	GeeArrayList* dir_children;
	GeeArrayList* _tmp1_;
	gint count;
	DirectoryMonitorFileInfoMap* _tmp2_;
	GFile* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _dir_child_list;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _dir_child_size;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _dir_child_index;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GFile* dir_child;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gpointer _tmp18_;
	GFileInfo* dir_info;
	DirectoryMonitorFileInfoMap* _tmp19_;
	GFile* _tmp20_;
	GFileInfo* _tmp21_;
	GFileInfo* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFile* _tmp26_;
	GFileInfo* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFileInfo* _tmp34_;
	GeeArrayList* _file_child_list;
	GeeArrayList* _tmp35_;
	GeeArrayList* _tmp36_;
	gint _file_child_size;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _file_child_index;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GFile* file_child;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gpointer _tmp45_;
	GFileInfo* file_info;
	DirectoryMonitorFileInfoMap* _tmp46_;
	GFile* _tmp47_;
	GFileInfo* _tmp48_;
	GFileInfo* _tmp49_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GFile* _tmp53_;
	GFile* _tmp54_;
	GFile* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GFile* _tmp58_;
	GFile* _tmp59_;
	GFileInfo* _tmp60_;
	DirectoryMonitorFileInfoMap* _tmp61_;
	GFile* _tmp62_;
	gboolean updated;
	DirectoryMonitorFileInfoMap* _tmp63_;
	GFile* _tmp64_;
	GFileInfo* _tmp65_;
	gboolean _tmp66_;
	GFile* _tmp67_;
	GFileInfo* _tmp68_;
	GFile* _tmp69_;
	GFileInfo* _tmp70_;
	GFile* _tmp71_;
	GFile* _tmp72_;
	GFileInfo* _tmp73_;
};

struct _DirectoryMonitorAsyncNotifyDirectoryDeletedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GFile* dir;
	gboolean already_removed;
	GeeArrayList* file_children;
	GeeArrayList* _tmp0_;
	GeeArrayList* dir_children;
	GeeArrayList* _tmp1_;
	gint count;
	DirectoryMonitorFileInfoMap* _tmp2_;
	GFile* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _dir_child_list;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _dir_child_size;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _dir_child_index;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GFile* dir_child;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gpointer _tmp18_;
	GFile* _tmp19_;
	GeeArrayList* _file_child_list;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	gint _file_child_size;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _file_child_index;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GFile* file_child;
	GeeArrayList* _tmp28_;
	gint _tmp29_;
	gpointer _tmp30_;
	DirectoryMonitorFileInfoMap* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	gboolean _tmp34_;
	DirectoryMonitorFileInfoMap* _tmp35_;
	GFile* _tmp36_;
	GFile* _tmp37_;
};

struct _DirectoryMonitorExploreAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GFile* dir;
	GFileInfo* dir_info;
	gboolean in_discovery;
	DirectoryMonitorFileInfoMap* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	GFileInfo* local_dir_info;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	GFileInfo* _tmp11_;
	GFile* _tmp12_;
	GCancellable* _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GError* err;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	GFileInfo* _tmp22_;
	gboolean _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	GFileInfo* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp31_;
	GFileInfo* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GFileInfo* _tmp36_;
	GFileType _tmp37_;
	const gchar* _tmp38_;
	GFile* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GFileInfo* _tmp42_;
	GFileType _tmp43_;
	GEnumValue* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	GeeHashMap* dir_map;
	GeeHashMap* file_map;
	GFileEnumerator* enumerator;
	GFile* _tmp48_;
	GCancellable* _tmp49_;
	GFileEnumerator* _tmp50_;
	gboolean _tmp51_;
	GList* infos;
	GFileEnumerator* _tmp52_;
	GCancellable* _tmp53_;
	GList* _tmp54_;
	GList* _tmp55_;
	GList* _tmp56_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp57_;
	GFileInfo* info;
	GFileInfo* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gboolean _tmp61_;
	GFileInfo* _tmp62_;
	GFile* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	GFileInfo* _tmp66_;
	gboolean _tmp67_;
	GFile* _tmp68_;
	GFileInfo* _tmp69_;
	const gchar* _tmp70_;
	GFile* _tmp71_;
	GFile* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GFileInfo* _tmp75_;
	gboolean _tmp76_;
	GFileInfo* _tmp77_;
	GFileType _tmp78_;
	GeeHashMap* _tmp79_;
	GeeHashMap* _tmp80_;
	GeeHashMap* _tmp81_;
	GFile* _tmp82_;
	GFileInfo* _tmp83_;
	const gchar* _tmp84_;
	GFile* _tmp85_;
	GFile* _tmp86_;
	GFileInfo* _tmp87_;
	GeeHashMap* _tmp88_;
	GeeHashMap* _tmp89_;
	GeeHashMap* _tmp90_;
	GFile* _tmp91_;
	GFileInfo* _tmp92_;
	const gchar* _tmp93_;
	GFile* _tmp94_;
	GFile* _tmp95_;
	GFileInfo* _tmp96_;
	GError* err2;
	GFile* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	GError* _tmp100_;
	const gchar* _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp103_;
	GFile* _tmp104_;
	GFileInfo* _tmp105_;
	GFile* _tmp106_;
	GFileInfo* _tmp107_;
	GFile* _tmp108_;
	GFileInfo* _tmp109_;
	GeeHashMap* _tmp110_;
	GeeHashMap* _tmp111_;
	gboolean _tmp112_;
	gboolean _tmp113_;
	gboolean _tmp114_;
	GeeHashMap* _tmp115_;
	GeeIterator* _subdir_it;
	GeeHashMap* _tmp116_;
	GeeSet* _tmp117_;
	GeeSet* _tmp118_;
	GeeSet* _tmp119_;
	GeeIterator* _tmp120_;
	GeeIterator* _tmp121_;
	GeeIterator* _tmp122_;
	gboolean _tmp123_;
	GFile* subdir;
	GeeIterator* _tmp124_;
	gpointer _tmp125_;
	gint _tmp126_;
	gint _tmp127_;
	GFile* _tmp128_;
	GeeHashMap* _tmp129_;
	GFile* _tmp130_;
	gpointer _tmp131_;
	GFileInfo* _tmp132_;
	gboolean _tmp133_;
	GFile* _tmp134_;
	GeeHashMap* _tmp135_;
	GFile* _tmp136_;
	gpointer _tmp137_;
	GFileInfo* _tmp138_;
	gboolean _tmp139_;
	gboolean _tmp140_;
	GError * _inner_error_;
};

struct _DirectoryMonitorNotifyDirectoryFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GeeMap* map;
	gboolean in_discovery;
	GeeMapIterator* iter;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeMapIterator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeMapIterator* _tmp5_;
	gpointer _tmp6_;
	GFile* _tmp7_;
	GeeMapIterator* _tmp8_;
	gpointer _tmp9_;
	GFileInfo* _tmp10_;
	GeeMapIterator* _tmp11_;
	gpointer _tmp12_;
	GFile* _tmp13_;
	GeeMapIterator* _tmp14_;
	gpointer _tmp15_;
	GFileInfo* _tmp16_;
};

struct _DirectoryMonitorQueryInfoQueueElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DirectoryMonitorQueryInfoQueueElementPrivate * priv;
	DirectoryMonitor* owner;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event;
	guint position;
	gulong time_created_msec;
	GFileInfo* info;
	GError* err;
	gboolean completed;
};

struct _DirectoryMonitorQueryInfoQueueElementClass {
	GTypeClass parent_class;
	void (*finalize) (DirectoryMonitorQueryInfoQueueElement *self);
};

struct _DirectoryMonitorParamSpecQueryInfoQueueElement {
	GParamSpec parent_instance;
};

struct _DirectoryMonitorFileInfoMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DirectoryMonitorFileInfoMapPrivate * priv;
};

struct _DirectoryMonitorFileInfoMapClass {
	GTypeClass parent_class;
	void (*finalize) (DirectoryMonitorFileInfoMap *self);
};

struct _DirectoryMonitorFileInfoMapPrivate {
	GeeHashMap* map;
	GeeHashMap* id_map;
};

struct _DirectoryMonitorParamSpecFileInfoMap {
	GParamSpec parent_instance;
};


static gpointer directory_monitor_parent_class = NULL;
static gpointer directory_monitor_query_info_queue_element_parent_class = NULL;
static guint directory_monitor_query_info_queue_element_current;
static guint directory_monitor_query_info_queue_element_current = (guint) 0;
static gpointer directory_monitor_file_info_map_parent_class = NULL;

GType directory_monitor_get_type (void) G_GNUC_CONST;
static gpointer directory_monitor_query_info_queue_element_ref (gpointer instance);
static void directory_monitor_query_info_queue_element_unref (gpointer instance);
static GParamSpec* directory_monitor_param_spec_query_info_queue_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void directory_monitor_value_set_query_info_queue_element (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void directory_monitor_value_take_query_info_queue_element (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer directory_monitor_value_get_query_info_queue_element (const GValue* value) G_GNUC_UNUSED;
static GType directory_monitor_query_info_queue_element_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer directory_monitor_file_info_map_ref (gpointer instance);
static void directory_monitor_file_info_map_unref (gpointer instance);
static GParamSpec* directory_monitor_param_spec_file_info_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void directory_monitor_value_set_file_info_map (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void directory_monitor_value_take_file_info_map (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer directory_monitor_value_get_file_info_map (const GValue* value) G_GNUC_UNUSED;
static GType directory_monitor_file_info_map_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define DIRECTORY_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIRECTORY_MONITOR, DirectoryMonitorPrivate))
enum  {
	DIRECTORY_MONITOR_DUMMY_PROPERTY
};
static GType directory_monitor_ftype_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_new (void);
static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_construct (GType object_type);
#define DIRECTORY_MONITOR_DEFAULT_PRIORITY G_PRIORITY_LOW
#define DIRECTORY_MONITOR_DIR_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_FILE_INFO_FLAGS G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS
#define DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_SUPPORT_DIR_SYMLINKS TRUE
#define DIRECTORY_MONITOR_SUPPORT_FILE_SYMLINKS FALSE
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
#define DIRECTORY_MONITOR_FILE_MONITOR_FLAGS G_FILE_MONITOR_SEND_MOVED
#define DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC ((guint) 500)
#define DIRECTORY_MONITOR_MAX_EXPLORATION_DIRS 5
DirectoryMonitor* directory_monitor_new (GFile* root, gboolean recurse, gboolean monitoring);
DirectoryMonitor* directory_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring);
void directory_monitor_mdbg (const gchar* msg);
gboolean directory_monitor_is_recursive (DirectoryMonitor* self);
gboolean directory_monitor_is_monitoring (DirectoryMonitor* self);
void directory_monitor_notify_root_deleted (DirectoryMonitor* self, GFile* root);
static void directory_monitor_real_notify_root_deleted (DirectoryMonitor* self, GFile* root);
static void directory_monitor_internal_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
static gboolean directory_monitor_file_info_map_remove (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
static gboolean directory_monitor_file_info_map_update (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
static void directory_monitor_real_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
void directory_monitor_notify_discovery_started (DirectoryMonitor* self);
static void directory_monitor_real_notify_discovery_started (DirectoryMonitor* self);
void directory_monitor_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason);
static void directory_monitor_real_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason);
void directory_monitor_notify_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_real_notify_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_internal_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static gboolean directory_monitor_is_file_create_move (DirectoryMonitor* self, GFile* file, GFileInfo* info, GFile** old_file, GFileInfo** old_file_info);
static void directory_monitor_internal_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
void directory_monitor_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
static void directory_monitor_real_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
void directory_monitor_notify_file_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_notify_file_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_internal_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_internal_notify_file_deleted (DirectoryMonitor* self, GFile* file);
void directory_monitor_notify_file_deleted (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_notify_file_deleted (DirectoryMonitor* self, GFile* file);
static void directory_monitor_internal_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_file_info_map_remove_descendents (DirectoryMonitorFileInfoMap* self, GFile* root, DirectoryMonitorFileInfoMap* descendents);
static void directory_monitor_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info);
void directory_monitor_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_async_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_async_internal_notify_directory_moved_finish (DirectoryMonitor* self, GAsyncResult* _res_);
static void directory_monitor_async_internal_notify_directory_moved_data_free (gpointer _data);
static gboolean directory_monitor_async_internal_notify_directory_moved_co (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint directory_monitor_file_info_map_get_children (DirectoryMonitorFileInfoMap* self, GFile* root, GeeCollection* files, GeeCollection* dirs);
static GFileInfo* directory_monitor_file_info_map_get_info (DirectoryMonitorFileInfoMap* self, GFile* file);
static void directory_monitor_async_internal_notify_directory_moved_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _directory_monitor_async_internal_notify_directory_moved_co_gsource_func (gpointer self);
static gboolean directory_monitor_remove_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static gboolean directory_monitor_add_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
static void directory_monitor_real_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
void directory_monitor_notify_directory_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_notify_directory_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_internal_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_internal_notify_directory_deleted (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_async_notify_directory_deleted (DirectoryMonitor* self, GFile* dir, gboolean already_removed, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_async_notify_directory_deleted_finish (DirectoryMonitor* self, GAsyncResult* _res_);
static void directory_monitor_async_notify_directory_deleted_data_free (gpointer _data);
static gboolean directory_monitor_async_notify_directory_deleted_co (DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_);
static void directory_monitor_async_notify_directory_deleted_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _directory_monitor_async_notify_directory_deleted_co_gsource_func (gpointer self);
void directory_monitor_notify_directory_deleted (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_notify_directory_deleted (DirectoryMonitor* self, GFile* dir);
void directory_monitor_notify_closed (DirectoryMonitor* self);
static void directory_monitor_real_notify_closed (DirectoryMonitor* self);
GFile* directory_monitor_get_root (DirectoryMonitor* self);
gboolean directory_monitor_is_in_root (DirectoryMonitor* self, GFile* file);
gboolean directory_monitor_has_started (DirectoryMonitor* self);
void directory_monitor_start_discovery (DirectoryMonitor* self);
static void directory_monitor_explore_async (DirectoryMonitor* self, GFile* dir, GFileInfo* dir_info, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_explore_finish (DirectoryMonitor* self, GAsyncResult* _res_);
void directory_monitor_close (DirectoryMonitor* self);
static void directory_monitor_real_close (DirectoryMonitor* self);
static void directory_monitor_cancel_monitor (DirectoryMonitor* self, GFileMonitor* monitor);
static DirectoryMonitorFType directory_monitor_get_ftype (GFileInfo* info);
const gchar* g_file_type_to_string (GFileType self);
static void directory_monitor_explore_async_data_free (gpointer _data);
static gboolean directory_monitor_explore_async_co (DirectoryMonitorExploreAsyncData* _data_);
static gboolean directory_monitor_file_info_map_contains (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
static void directory_monitor_explore_directory_completed (DirectoryMonitor* self, gboolean in_discovery);
static void directory_monitor_explore_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* get_file_info_id (GFileInfo* info);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean directory_monitor_is_file_symlink_supported (GFileInfo* info);
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
static void directory_monitor_notify_directory_files (DirectoryMonitor* self, GeeMap* map, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_notify_directory_files_finish (DirectoryMonitor* self, GAsyncResult* _res_);
static void directory_monitor_notify_directory_files_data_free (gpointer _data);
static gboolean directory_monitor_notify_directory_files_co (DirectoryMonitorNotifyDirectoryFilesData* _data_);
static gboolean _directory_monitor_notify_directory_files_co_gsource_func (gpointer self);
static gchar* directory_monitor_file_info_map_get_id (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
static void directory_monitor_on_monitor_notification (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _directory_monitor_on_monitor_notification_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
const gchar* g_file_monitor_event_to_string (GFileMonitorEvent self);
static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_new (DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event);
static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_construct (GType object_type, DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void directory_monitor_query_info_queue_element_on_completed (DirectoryMonitorQueryInfoQueueElement* self, GObject* source, GAsyncResult* aresult);
static void _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean directory_monitor_check_for_expired_delete_events (DirectoryMonitor* self);
static gboolean _directory_monitor_check_for_expired_delete_events_gsource_func (gpointer self);
static void directory_monitor_process_query_queue (DirectoryMonitor* self, DirectoryMonitorQueryInfoQueueElement* query_info);
static GFile* directory_monitor_file_info_map_find_match (DirectoryMonitorFileInfoMap* self, GFileInfo* match);
static void directory_monitor_on_monitor_notification_ready (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileInfo* info, GFileMonitorEvent event);
GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self, GFile* file);
gulong now_ms (void);
GeeCollection* directory_monitor_get_files (DirectoryMonitor* self);
static GeeCollection* directory_monitor_file_info_map_get_all (DirectoryMonitorFileInfoMap* self);
GFileInfo* directory_monitor_query_file_info (DirectoryMonitor* self, GFile* file);
static GFileInfo* directory_monitor_file_info_map_query_info (DirectoryMonitorFileInfoMap* self, GFile* file, GCancellable* cancellable);
static void directory_monitor_real_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void directory_monitor_real_root_deleted (DirectoryMonitor* self, GFile* root);
static void directory_monitor_real_discovery_started (DirectoryMonitor* self);
static void directory_monitor_real_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void directory_monitor_real_directory_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_discovery_failed (DirectoryMonitor* self, const gchar* reason);
static void directory_monitor_real_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_real_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
static void directory_monitor_real_file_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_file_attributes_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_file_deleted (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
static void directory_monitor_real_directory_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_directory_attributes_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_directory_deleted (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_closed (DirectoryMonitor* self);
enum  {
	DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_DUMMY_PROPERTY
};
static void directory_monitor_query_info_queue_element_finalize (DirectoryMonitorQueryInfoQueueElement* obj);
#define DIRECTORY_MONITOR_FILE_INFO_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapPrivate))
enum  {
	DIRECTORY_MONITOR_FILE_INFO_MAP_DUMMY_PROPERTY
};
static gboolean directory_monitor_file_info_map_normalize_file (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info, GFile** normalized, gchar** id);
static void directory_monitor_file_info_map_remove_all (DirectoryMonitorFileInfoMap* self, GeeCollection* files);
static void directory_monitor_file_info_map_finalize (DirectoryMonitorFileInfoMap* obj);
static void directory_monitor_finalize (GObject* obj);


static GType directory_monitor_ftype_get_type (void) {
	static volatile gsize directory_monitor_ftype_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_ftype_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTORY_MONITOR_FTYPE_FILE, "DIRECTORY_MONITOR_FTYPE_FILE", "file"}, {DIRECTORY_MONITOR_FTYPE_DIRECTORY, "DIRECTORY_MONITOR_FTYPE_DIRECTORY", "directory"}, {DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "DIRECTORY_MONITOR_FTYPE_UNSUPPORTED", "unsupported"}, {0, NULL, NULL}};
		GType directory_monitor_ftype_type_id;
		directory_monitor_ftype_type_id = g_enum_register_static ("DirectoryMonitorFType", values);
		g_once_init_leave (&directory_monitor_ftype_type_id__volatile, directory_monitor_ftype_type_id);
	}
	return directory_monitor_ftype_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 465 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 810 "DirectoryMonitor.c"
}


DirectoryMonitor* directory_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring) {
	DirectoryMonitor * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 464 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (root), NULL);
#line 464 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = (DirectoryMonitor*) g_object_new (object_type, NULL);
#line 465 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = root;
#line 465 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 465 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->root);
#line 465 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->root = _tmp1_;
#line 466 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = recurse;
#line 466 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->recurse = _tmp2_;
#line 467 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = monitoring;
#line 467 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->monitoring = _tmp3_;
#line 464 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self;
#line 842 "DirectoryMonitor.c"
}


DirectoryMonitor* directory_monitor_new (GFile* root, gboolean recurse, gboolean monitoring) {
#line 464 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return directory_monitor_construct (TYPE_DIRECTORY_MONITOR, root, recurse, monitoring);
#line 849 "DirectoryMonitor.c"
}


void directory_monitor_mdbg (const gchar* msg) {
#line 470 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (msg != NULL);
#line 856 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_recursive (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 476 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 477 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->recurse;
#line 477 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp0_;
#line 477 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 871 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_monitoring (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 480 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 481 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->monitoring;
#line 481 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp0_;
#line 481 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 886 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_root_deleted (DirectoryMonitor* self, GFile* root) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
#line 484 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (root));
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = root;
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp2_, "this.root.equal(root)");
#line 487 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg ("root deleted");
#line 488 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = root;
#line 488 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "root-deleted", _tmp3_);
#line 911 "DirectoryMonitor.c"
}


void directory_monitor_notify_root_deleted (DirectoryMonitor* self, GFile* root) {
#line 484 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 484 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_root_deleted (self, root);
#line 920 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
	gboolean removed = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFileInfo* _tmp11_ = NULL;
#line 491 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 491 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_root));
#line 491 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_root));
#line 491 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_root_info));
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_root;
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_remove (_tmp0_, _tmp1_, NULL);
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	removed = _tmp2_;
#line 493 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (removed, "removed");
#line 495 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = self->priv->files;
#line 495 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = new_root;
#line 495 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = new_root_info;
#line 495 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = directory_monitor_file_info_map_update (_tmp3_, _tmp4_, _tmp5_);
#line 495 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp6_;
#line 496 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = new_root;
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->root);
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->root = _tmp8_;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = old_root;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = new_root;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = new_root_info;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_root_moved (self, _tmp9_, _tmp10_, _tmp11_);
#line 985 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFileInfo* _tmp13_ = NULL;
#line 503 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_root));
#line 503 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_root));
#line 503 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_root_info));
#line 504 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 504 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_root;
#line 504 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
#line 504 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp2_, "this.root.equal(old_root)");
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = old_root;
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = new_root;
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = g_file_get_path (_tmp6_);
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = _tmp7_;
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = g_strdup_printf ("root moved: %s -> %s", _tmp5_, _tmp8_);
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = _tmp9_;
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp10_);
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp10_);
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp8_);
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp5_);
#line 507 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = old_root;
#line 507 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = new_root;
#line 507 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = new_root_info;
#line 507 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "root-moved", _tmp11_, _tmp12_, _tmp13_);
#line 1050 "DirectoryMonitor.c"
}


void directory_monitor_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
#line 503 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 503 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_root_moved (self, old_root, new_root, new_root_info);
#line 1059 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_discovery_started (DirectoryMonitor* self) {
#line 511 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg ("discovery started");
#line 512 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "discovery-started");
#line 1068 "DirectoryMonitor.c"
}


void directory_monitor_notify_discovery_started (DirectoryMonitor* self) {
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_discovery_started (self);
#line 1077 "DirectoryMonitor.c"
}


static void directory_monitor_real_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 515 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 516 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 516 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 516 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 516 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 516 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp3_) {
#line 1102 "DirectoryMonitor.c"
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = _tmp5_;
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_debug ("DirectoryMonitor.vala:517: DirectoryMonitor.internal_notify_file_disco" \
"vered: %s discovered but not added to file map", _tmp6_);
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp6_);
#line 520 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return;
#line 1118 "DirectoryMonitor.c"
	}
#line 523 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = file;
#line 523 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = info;
#line 523 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_discovered (self, _tmp7_, _tmp8_);
#line 1126 "DirectoryMonitor.c"
}


void directory_monitor_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 515 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 515 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->internal_notify_file_discovered (self, file, info);
#line 1135 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file discovered: %s", _tmp2_);
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 528 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 528 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 528 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-discovered", _tmp5_, _tmp6_);
#line 1173 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_discovered (self, file, info);
#line 1182 "DirectoryMonitor.c"
}


static void directory_monitor_real_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 531 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 531 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp3_;
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 535 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = dir;
#line 535 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = info;
#line 535 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_discovered (self, _tmp4_, _tmp5_);
#line 1216 "DirectoryMonitor.c"
}


void directory_monitor_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 531 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 531 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->internal_notify_directory_discovered (self, dir, info);
#line 1225 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 538 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 538 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory discovered: %s", _tmp2_);
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 540 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 540 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 540 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-discovered", _tmp5_, _tmp6_);
#line 1263 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 538 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 538 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_discovered (self, dir, info);
#line 1272 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 543 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (reason != NULL);
#line 544 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = reason;
#line 544 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_warning ("DirectoryMonitor.vala:544: discovery failed: %s", _tmp0_);
#line 545 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = reason;
#line 545 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "discovery-failed", _tmp1_);
#line 1289 "DirectoryMonitor.c"
}


void directory_monitor_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason) {
#line 543 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 543 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_discovery_failed (self, reason);
#line 1298 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_discovery_completed (DirectoryMonitor* self) {
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "discovery-completed");
#line 1305 "DirectoryMonitor.c"
}


void directory_monitor_notify_discovery_completed (DirectoryMonitor* self) {
#line 548 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 548 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_discovery_completed (self);
#line 1314 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* old_file = NULL;
	GFileInfo* old_file_info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_is_file_create_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file);
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_file = _tmp2_;
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file_info);
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_file_info = _tmp3_;
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp4_) {
#line 1348 "DirectoryMonitor.c"
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
#line 556 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = old_file;
#line 556 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = file;
#line 556 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = info;
#line 556 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_file_moved (self, _tmp5_, _tmp6_, _tmp7_);
#line 1360 "DirectoryMonitor.c"
	} else {
		gboolean updated = FALSE;
		DirectoryMonitorFileInfoMap* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFileInfo* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		GFile* _tmp13_ = NULL;
		GFileInfo* _tmp14_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = self->priv->files;
#line 558 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = file;
#line 558 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = info;
#line 558 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = directory_monitor_file_info_map_update (_tmp8_, _tmp9_, _tmp10_);
#line 558 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		updated = _tmp11_;
#line 559 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = updated;
#line 559 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp12_, "updated");
#line 561 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = file;
#line 561 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = info;
#line 561 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_file_created (self, _tmp13_, _tmp14_);
#line 1390 "DirectoryMonitor.c"
	}
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file_info);
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file);
#line 1396 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 565 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file created: %s", _tmp2_);
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 566 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 567 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 567 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 567 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-created", _tmp5_, _tmp6_);
#line 1434 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 565 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 565 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_created (self, file, info);
#line 1443 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
#line 570 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 570 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 570 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 570 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_file_info));
#line 573 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 573 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_file;
#line 573 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_file_info_map_remove (_tmp0_, _tmp1_, NULL);
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = self->priv->files;
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_file;
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = new_file_info;
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = directory_monitor_file_info_map_update (_tmp2_, _tmp3_, _tmp4_);
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp5_;
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 578 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = old_file;
#line 578 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = new_file;
#line 578 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = new_file_info;
#line 578 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_moved (self, _tmp6_, _tmp7_, _tmp8_);
#line 1492 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFileInfo* _tmp10_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_file_info));
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = old_file;
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_file;
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_strdup_printf ("file moved: %s -> %s", _tmp2_, _tmp5_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = _tmp6_;
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp7_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp7_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp5_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 583 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = old_file;
#line 583 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = new_file;
#line 583 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = new_file_info;
#line 583 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-moved", _tmp8_, _tmp9_, _tmp10_);
#line 1546 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_moved (self, old_file, new_file, new_file_info);
#line 1555 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_altered (DirectoryMonitor* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file altered: %s", _tmp2_);
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 588 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 588 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-altered", _tmp5_);
#line 1588 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_altered (DirectoryMonitor* self, GFile* file) {
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_altered (self, file);
#line 1597 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 591 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 591 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 591 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp3_;
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 595 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = file;
#line 595 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = info;
#line 595 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_alteration_completed (self, _tmp4_, _tmp5_);
#line 1633 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file alteration completed: %s", _tmp2_);
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 600 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 600 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 600 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-alteration-completed", _tmp5_, _tmp6_);
#line 1671 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_alteration_completed (self, file, info);
#line 1680 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file attributes altered: %s", _tmp2_);
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 605 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 605 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-attributes-altered", _tmp5_);
#line 1713 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file) {
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_attributes_altered (self, file);
#line 1722 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_deleted (DirectoryMonitor* self, GFile* file) {
	gboolean removed = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 608 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_remove (_tmp0_, _tmp1_, NULL);
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	removed = _tmp2_;
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (removed, "removed");
#line 612 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = file;
#line 612 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_deleted (self, _tmp3_);
#line 1750 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_deleted (DirectoryMonitor* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 615 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file deleted: %s", _tmp2_);
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 616 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-deleted", _tmp5_);
#line 1783 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_deleted (DirectoryMonitor* self, GFile* file) {
#line 615 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 615 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_deleted (self, file);
#line 1792 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* old_dir = NULL;
	GFileInfo* old_dir_info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 620 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 620 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 620 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_is_file_create_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir);
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_dir = _tmp2_;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir_info);
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_dir_info = _tmp3_;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp4_) {
#line 1826 "DirectoryMonitor.c"
		DirectoryMonitorFileInfoMap* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		DirectoryMonitorFileInfoMap* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFileInfo* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileInfo* _tmp11_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = self->priv->files;
#line 629 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = old_dir;
#line 629 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = self->priv->parent_moved;
#line 629 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove_descendents (_tmp5_, _tmp6_, _tmp7_);
#line 631 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = old_dir;
#line 631 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = old_dir_info;
#line 631 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = dir;
#line 631 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = info;
#line 631 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_directory_moved (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 1852 "DirectoryMonitor.c"
	} else {
		gboolean updated = FALSE;
		DirectoryMonitorFileInfoMap* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFileInfo* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		GFile* _tmp17_ = NULL;
		GFileInfo* _tmp18_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = self->priv->files;
#line 633 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = dir;
#line 633 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = info;
#line 633 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = directory_monitor_file_info_map_update (_tmp12_, _tmp13_, _tmp14_);
#line 633 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		updated = _tmp15_;
#line 634 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = updated;
#line 634 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp16_, "updated");
#line 636 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = dir;
#line 636 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp18_ = info;
#line 636 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_directory_created (self, _tmp17_, _tmp18_);
#line 1882 "DirectoryMonitor.c"
	}
#line 620 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir_info);
#line 620 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir);
#line 1888 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 640 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 640 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory created: %s", _tmp2_);
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 642 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 642 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 642 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-created", _tmp5_, _tmp6_);
#line 1926 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 640 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 640 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_created (self, dir, info);
#line 1935 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info) {
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 645 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_dir));
#line 645 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (old_dir_info));
#line 645 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_dir));
#line 645 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_dir_info));
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = old_dir;
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_dir_info;
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = new_dir;
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_dir_info;
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_internal_notify_directory_moved (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL, NULL);
#line 1964 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved_data_free (gpointer _data) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData, _data_);
#line 1983 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_async_internal_notify_directory_moved);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_async_internal_notify_directory_moved_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->old_dir = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = old_dir_info;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->old_dir_info = _tmp4_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = new_dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->new_dir = _tmp6_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = new_dir_info;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->new_dir_info = _tmp8_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_internal_notify_directory_moved_co (_data_);
#line 2042 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2050 "DirectoryMonitor.c"
}


static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
#line 652 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 2059 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = _user_data_;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_res_ = _res_;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_internal_notify_directory_moved_co (_data_);
#line 2073 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_async_internal_notify_directory_moved_co_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_async_internal_notify_directory_moved_co (self);
#line 683 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 2082 "DirectoryMonitor.c"
}


static gboolean directory_monitor_async_internal_notify_directory_moved_co (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_) {
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 2091 "DirectoryMonitor.c"
		goto _state_0;
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 2095 "DirectoryMonitor.c"
		goto _state_1;
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 2:
#line 2099 "DirectoryMonitor.c"
		goto _state_2;
		default:
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 2104 "DirectoryMonitor.c"
	}
	_state_0:
#line 652 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 652 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 652 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->file_children = _data_->_tmp0_;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_children = _data_->_tmp1_;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = _data_->self->priv->files;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = _data_->old_dir;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = _data_->file_children;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = _data_->dir_children;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = 0;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = directory_monitor_file_info_map_get_children (_data_->_tmp2_, _data_->_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->count = _data_->_tmp6_;
#line 655 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = 0;
#line 655 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = _data_->count;
#line 655 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp7_ > 0) {
#line 2147 "DirectoryMonitor.c"
		{
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = NULL;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = _data_->dir_children;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = NULL;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_list = _data_->_tmp9_;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = NULL;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = _data_->_dir_child_list;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = 0;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = 0;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_size = _data_->_tmp12_;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_index = -1;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = 0;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = _data_->_dir_child_index;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_dir_child_index = _data_->_tmp13_ + 1;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = 0;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = _data_->_dir_child_index;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = 0;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = _data_->_dir_child_size;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 2195 "DirectoryMonitor.c"
				}
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = NULL;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = _data_->_dir_child_list;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = 0;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = _data_->_dir_child_index;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = NULL;
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp17_);
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->dir_child = (GFile*) _data_->_tmp18_;
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = NULL;
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = _data_->self->priv->files;
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp20_ = NULL;
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp20_ = _data_->dir_child;
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp21_ = NULL;
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp21_ = directory_monitor_file_info_map_get_info (_data_->_tmp19_, _data_->_tmp20_);
#line 660 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->dir_info = _data_->_tmp21_;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp22_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp22_ = _data_->dir_info;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp22_ == NULL) {
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp23_ = NULL;
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp23_ = _data_->dir_child;
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp24_ = NULL;
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp24_ = g_file_get_path (_data_->_tmp23_);
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp25_ = NULL;
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp25_ = _data_->_tmp24_;
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					g_warning ("DirectoryMonitor.vala:662: Unable to retrieve directory-moved info for" \
" %s", _data_->_tmp25_);
#line 662 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_data_->_tmp25_);
#line 664 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->dir_info);
#line 664 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->dir_child);
#line 664 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					continue;
#line 2253 "DirectoryMonitor.c"
				}
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = _data_->dir_child;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = _data_->dir_info;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = _data_->new_dir;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = _data_->dir_child;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = g_file_get_basename (_data_->_tmp29_);
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = _data_->_tmp30_;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = g_file_get_child (_data_->_tmp28_, _data_->_tmp31_);
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = _data_->_tmp32_;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp34_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp34_ = _data_->dir_info;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 1;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_internal_notify_directory_moved (_data_->self, _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp33_, _data_->_tmp34_, directory_monitor_async_internal_notify_directory_moved_ready, _data_);
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 2297 "DirectoryMonitor.c"
				_state_1:
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_internal_notify_directory_moved_finish (_data_->self, _data_->_res_);
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->_tmp33_);
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_data_->_tmp31_);
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->dir_info);
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->dir_child);
#line 2309 "DirectoryMonitor.c"
			}
#line 659 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_dir_child_list);
#line 2313 "DirectoryMonitor.c"
		}
		{
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp35_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp35_ = _data_->file_children;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp36_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp36_ = _g_object_ref0 (_data_->_tmp35_);
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_list = _data_->_tmp36_;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp37_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp37_ = _data_->_file_child_list;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp38_ = 0;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp38_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp39_ = 0;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp39_ = _data_->_tmp38_;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_size = _data_->_tmp39_;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_index = -1;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp40_ = 0;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp40_ = _data_->_file_child_index;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_file_child_index = _data_->_tmp40_ + 1;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp41_ = 0;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp41_ = _data_->_file_child_index;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp42_ = 0;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp42_ = _data_->_file_child_size;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp41_ < _data_->_tmp42_)) {
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 2362 "DirectoryMonitor.c"
				}
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp43_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp43_ = _data_->_file_child_list;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp44_ = 0;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp44_ = _data_->_file_child_index;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp45_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp45_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp44_);
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->file_child = (GFile*) _data_->_tmp45_;
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp46_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp46_ = _data_->self->priv->files;
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp47_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp47_ = _data_->file_child;
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp48_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp48_ = directory_monitor_file_info_map_get_info (_data_->_tmp46_, _data_->_tmp47_);
#line 673 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->file_info = _data_->_tmp48_;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp49_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp49_ = _data_->file_info;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp49_ == NULL) {
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp50_ = NULL;
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp50_ = _data_->file_child;
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp51_ = NULL;
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp51_ = g_file_get_path (_data_->_tmp50_);
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp52_ = NULL;
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp52_ = _data_->_tmp51_;
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					g_warning ("DirectoryMonitor.vala:675: Unable to retrieve directory-moved info for" \
" %s", _data_->_tmp52_);
#line 675 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_data_->_tmp52_);
#line 677 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->file_info);
#line 677 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->file_child);
#line 677 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					continue;
#line 2420 "DirectoryMonitor.c"
				}
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = _data_->file_child;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = _data_->new_dir;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = _data_->file_child;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = g_file_get_basename (_data_->_tmp55_);
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp57_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp57_ = _data_->_tmp56_;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp58_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp58_ = g_file_get_child (_data_->_tmp54_, _data_->_tmp57_);
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp59_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp59_ = _data_->_tmp58_;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp60_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp60_ = _data_->file_info;
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_internal_notify_file_moved (_data_->self, _data_->_tmp53_, _data_->_tmp59_, _data_->_tmp60_);
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->_tmp59_);
#line 680 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_data_->_tmp57_);
#line 683 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_async_internal_notify_directory_moved_co_gsource_func, _data_, NULL);
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 2;
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 2466 "DirectoryMonitor.c"
				_state_2:
				;
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->file_info);
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->file_child);
#line 2473 "DirectoryMonitor.c"
			}
#line 672 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_file_child_list);
#line 2477 "DirectoryMonitor.c"
		}
	}
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp61_ = NULL;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp61_ = _data_->self->priv->files;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp62_ = NULL;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp62_ = _data_->old_dir;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_file_info_map_remove (_data_->_tmp61_, _data_->_tmp62_, NULL);
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp63_ = NULL;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp63_ = _data_->self->priv->files;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp64_ = NULL;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp64_ = _data_->new_dir;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp65_ = NULL;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp65_ = _data_->new_dir_info;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp66_ = FALSE;
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp66_ = directory_monitor_file_info_map_update (_data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_);
#line 692 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->updated = _data_->_tmp66_;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_data_->updated, "updated");
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp67_ = NULL;
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp67_ = _data_->old_dir;
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp68_ = NULL;
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp68_ = _data_->old_dir_info;
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_remove_monitor (_data_->self, _data_->_tmp67_, _data_->_tmp68_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp69_ = NULL;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp69_ = _data_->new_dir;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp70_ = NULL;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp70_ = _data_->new_dir_info;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_add_monitor (_data_->self, _data_->_tmp69_, _data_->_tmp70_);
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp71_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp71_ = _data_->old_dir;
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp72_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp72_ = _data_->new_dir;
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp73_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp73_ = _data_->new_dir_info;
#line 699 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_moved (_data_->self, _data_->_tmp71_, _data_->_tmp72_, _data_->_tmp73_);
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_children);
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->file_children);
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2552 "DirectoryMonitor.c"
	} else {
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2556 "DirectoryMonitor.c"
	}
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 650 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 2562 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFileInfo* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 702 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_dir));
#line 702 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_dir));
#line 702 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_dir_info));
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = old_dir;
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_dir;
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_strdup_printf ("directory moved: %s -> %s", _tmp2_, _tmp5_);
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = _tmp6_;
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp7_);
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp7_);
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp5_);
#line 703 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = old_dir;
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = new_dir;
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = new_dir_info;
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-moved", _tmp8_, _tmp9_, _tmp10_);
#line 706 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = old_dir;
#line 706 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = self->priv->root;
#line 706 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = g_file_equal (_tmp11_, _tmp12_);
#line 706 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp13_) {
#line 2627 "DirectoryMonitor.c"
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFileInfo* _tmp16_ = NULL;
#line 707 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = old_dir;
#line 707 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = new_dir;
#line 707 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = new_dir_info;
#line 707 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_root_moved (self, _tmp14_, _tmp15_, _tmp16_);
#line 2639 "DirectoryMonitor.c"
	}
}


void directory_monitor_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info) {
#line 702 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 702 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_moved (self, old_dir, new_dir, new_dir_info);
#line 2649 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_altered (DirectoryMonitor* self, GFile* dir) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory altered: %s", _tmp2_);
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 712 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 712 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-altered", _tmp5_);
#line 2682 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_altered (DirectoryMonitor* self, GFile* dir) {
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_altered (self, dir);
#line 2691 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 715 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 715 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp3_;
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 719 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = dir;
#line 719 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = info;
#line 719 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_alteration_completed (self, _tmp4_, _tmp5_);
#line 2727 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory alteration completed: %s", _tmp2_);
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 724 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 724 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 724 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-alteration-completed", _tmp5_, _tmp6_);
#line 2765 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_alteration_completed (self, dir, info);
#line 2774 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory attributes altered: %s", _tmp2_);
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 729 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 729 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-attributes-altered", _tmp5_);
#line 2807 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir) {
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_attributes_altered (self, dir);
#line 2816 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_deleted (DirectoryMonitor* self, GFile* dir) {
	GFileInfo* info = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
#line 732 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 732 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 733 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 733 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 733 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_get_info (_tmp0_, _tmp1_);
#line 733 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	info = _tmp2_;
#line 734 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (info != NULL, "info != null");
#line 737 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = dir;
#line 737 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_remove_monitor (self, _tmp3_, info);
#line 739 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = dir;
#line 739 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_notify_directory_deleted (self, _tmp4_, FALSE, NULL, NULL);
#line 732 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (info);
#line 2851 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted_data_free (gpointer _data) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorAsyncNotifyDirectoryDeletedData, _data_);
#line 2864 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted (DirectoryMonitor* self, GFile* dir, gboolean already_removed, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorAsyncNotifyDirectoryDeletedData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_async_notify_directory_deleted);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_async_notify_directory_deleted_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = already_removed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->already_removed = _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_notify_directory_deleted_co (_data_);
#line 2898 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2906 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = _user_data_;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_res_ = _res_;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_notify_directory_deleted_co (_data_);
#line 2920 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_async_notify_directory_deleted_co_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_async_notify_directory_deleted_co (self);
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 2929 "DirectoryMonitor.c"
}


static gboolean directory_monitor_async_notify_directory_deleted_co (DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_) {
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 2938 "DirectoryMonitor.c"
		goto _state_0;
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 2942 "DirectoryMonitor.c"
		goto _state_1;
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 2:
#line 2946 "DirectoryMonitor.c"
		goto _state_2;
		default:
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 2951 "DirectoryMonitor.c"
	}
	_state_0:
#line 750 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 750 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 750 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->file_children = _data_->_tmp0_;
#line 751 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 751 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 751 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_children = _data_->_tmp1_;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = NULL;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = _data_->self->priv->files;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = NULL;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = _data_->dir;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = NULL;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = _data_->file_children;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = NULL;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = _data_->dir_children;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = 0;
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = directory_monitor_file_info_map_get_children (_data_->_tmp2_, _data_->_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 752 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->count = _data_->_tmp6_;
#line 753 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = 0;
#line 753 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = _data_->count;
#line 753 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp7_ > 0) {
#line 2994 "DirectoryMonitor.c"
		{
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = _data_->dir_children;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_list = _data_->_tmp9_;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = _data_->_dir_child_list;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = 0;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = 0;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_size = _data_->_tmp12_;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_index = -1;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = 0;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = _data_->_dir_child_index;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_dir_child_index = _data_->_tmp13_ + 1;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = 0;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = _data_->_dir_child_index;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = 0;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = _data_->_dir_child_size;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 3042 "DirectoryMonitor.c"
				}
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = _data_->_dir_child_list;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = 0;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = _data_->_dir_child_index;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp17_);
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->dir_child = (GFile*) _data_->_tmp18_;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = NULL;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = _data_->dir_child;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 1;
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_notify_directory_deleted (_data_->self, _data_->_tmp19_, FALSE, directory_monitor_async_notify_directory_deleted_ready, _data_);
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 3068 "DirectoryMonitor.c"
				_state_1:
#line 762 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_notify_directory_deleted_finish (_data_->self, _data_->_res_);
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->dir_child);
#line 3074 "DirectoryMonitor.c"
			}
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_dir_child_list);
#line 3078 "DirectoryMonitor.c"
		}
		{
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = _data_->file_children;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_list = _data_->_tmp21_;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp22_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp22_ = _data_->_file_child_list;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp23_ = 0;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp23_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp24_ = 0;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp24_ = _data_->_tmp23_;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_size = _data_->_tmp24_;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_index = -1;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp25_ = 0;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp25_ = _data_->_file_child_index;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_file_child_index = _data_->_tmp25_ + 1;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = 0;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = _data_->_file_child_index;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = 0;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = _data_->_file_child_size;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp26_ < _data_->_tmp27_)) {
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 3127 "DirectoryMonitor.c"
				}
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = _data_->_file_child_list;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = 0;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = _data_->_file_child_index;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp28_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp29_);
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->file_child = (GFile*) _data_->_tmp30_;
#line 767 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = NULL;
#line 767 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = _data_->self->priv->files;
#line 767 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = NULL;
#line 767 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = _data_->file_child;
#line 767 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_file_info_map_remove (_data_->_tmp31_, _data_->_tmp32_, NULL);
#line 769 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = _data_->file_child;
#line 769 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_notify_file_deleted (_data_->self, _data_->_tmp33_);
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_async_notify_directory_deleted_co_gsource_func, _data_, NULL);
#line 772 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 2;
#line 772 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 3165 "DirectoryMonitor.c"
				_state_2:
				;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->file_child);
#line 3170 "DirectoryMonitor.c"
			}
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_file_child_list);
#line 3174 "DirectoryMonitor.c"
		}
	}
#line 776 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp34_ = FALSE;
#line 776 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp34_ = _data_->already_removed;
#line 776 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_data_->_tmp34_) {
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = NULL;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = _data_->self->priv->files;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp36_ = NULL;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp36_ = _data_->dir;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove (_data_->_tmp35_, _data_->_tmp36_, NULL);
#line 3193 "DirectoryMonitor.c"
	}
#line 779 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = NULL;
#line 779 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = _data_->dir;
#line 779 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_deleted (_data_->self, _data_->_tmp37_);
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_children);
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->file_children);
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3209 "DirectoryMonitor.c"
	} else {
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3213 "DirectoryMonitor.c"
	}
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 742 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 3219 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_deleted (DirectoryMonitor* self, GFile* dir) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 782 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory deleted: %s", _tmp2_);
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 783 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 784 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 784 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-deleted", _tmp5_);
#line 786 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = dir;
#line 786 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = self->priv->root;
#line 786 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = g_file_equal (_tmp6_, _tmp7_);
#line 786 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp8_) {
#line 3263 "DirectoryMonitor.c"
		GFile* _tmp9_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = dir;
#line 787 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_root_deleted (self, _tmp9_);
#line 3269 "DirectoryMonitor.c"
	}
}


void directory_monitor_notify_directory_deleted (DirectoryMonitor* self, GFile* dir) {
#line 782 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 782 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_deleted (self, dir);
#line 3279 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_closed (DirectoryMonitor* self) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("monitoring of %s closed", _tmp2_);
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 791 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 792 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "closed");
#line 3307 "DirectoryMonitor.c"
}


void directory_monitor_notify_closed (DirectoryMonitor* self) {
#line 790 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 790 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_closed (self);
#line 3316 "DirectoryMonitor.c"
}


GFile* directory_monitor_get_root (DirectoryMonitor* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 795 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 796 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 796 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 796 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp1_;
#line 796 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3334 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_in_root (DirectoryMonitor* self, GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 799 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 799 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 800 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 800 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->root;
#line 800 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
#line 800 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp2_;
#line 800 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3357 "DirectoryMonitor.c"
}


gboolean directory_monitor_has_started (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 803 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 804 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->started;
#line 804 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp0_;
#line 804 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3372 "DirectoryMonitor.c"
}


void directory_monitor_start_discovery (DirectoryMonitor* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
#line 807 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 808 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->started;
#line 808 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (!_tmp0_, "!started");
#line 810 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->has_discovery_started = TRUE;
#line 811 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->started = TRUE;
#line 813 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_discovery_started (self);
#line 816 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->outstanding_exploration_dirs = 1;
#line 817 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->root;
#line 817 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_async (self, _tmp1_, NULL, TRUE, NULL, NULL);
#line 3397 "DirectoryMonitor.c"
}


static void directory_monitor_real_close (DirectoryMonitor* self) {
	GCancellable* _tmp0_ = NULL;
	GeeHashMap* _tmp12_ = NULL;
#line 824 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->cancellable;
#line 824 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_cancellable_cancel (_tmp0_);
#line 3408 "DirectoryMonitor.c"
	{
		GeeIterator* _monitor_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = self->priv->monitors;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = _tmp5_;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp4_);
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_monitor_it = _tmp6_;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 3435 "DirectoryMonitor.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			GFileMonitor* monitor = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			GFileMonitor* _tmp11_ = NULL;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = _monitor_it;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp8_) {
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 3450 "DirectoryMonitor.c"
			}
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = _monitor_it;
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			monitor = (GFileMonitor*) _tmp10_;
#line 828 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = monitor;
#line 828 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_cancel_monitor (self, _tmp11_);
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (monitor);
#line 3464 "DirectoryMonitor.c"
		}
#line 827 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_monitor_it);
#line 3468 "DirectoryMonitor.c"
	}
#line 830 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = self->priv->monitors;
#line 830 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 832 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_closed (self);
#line 3476 "DirectoryMonitor.c"
}


void directory_monitor_close (DirectoryMonitor* self) {
#line 822 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 822 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->close (self);
#line 3485 "DirectoryMonitor.c"
}


static DirectoryMonitorFType directory_monitor_get_ftype (GFileInfo* info) {
	DirectoryMonitorFType result = 0;
	GFileType file_type = 0;
	GFileInfo* _tmp0_ = NULL;
	GFileType _tmp1_ = 0;
	GFileType _tmp2_ = 0;
#line 835 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), 0);
#line 836 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 836 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_info_get_file_type (_tmp0_);
#line 836 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	file_type = _tmp1_;
#line 837 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = file_type;
#line 837 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp2_) {
#line 837 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_TYPE_REGULAR:
#line 3509 "DirectoryMonitor.c"
		{
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_FTYPE_FILE;
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 3515 "DirectoryMonitor.c"
		}
#line 837 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_TYPE_DIRECTORY:
#line 3519 "DirectoryMonitor.c"
		{
#line 842 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_FTYPE_DIRECTORY;
#line 842 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 3525 "DirectoryMonitor.c"
		}
		default:
		{
			GFileType _tmp3_ = 0;
			GEnumValue* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp3_ = file_type;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp4_ = g_enum_get_value (g_type_class_ref (g_file_type_get_type ()), _tmp3_);
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = g_strdup_printf ("query_ftype: Unknown file type %s", (_tmp4_ != NULL) ? _tmp4_->value_name : NULL);
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = _tmp5_;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_mdbg (_tmp6_);
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp6_);
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_FTYPE_UNSUPPORTED;
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 3549 "DirectoryMonitor.c"
		}
	}
}


static void directory_monitor_explore_async_data_free (gpointer _data) {
	DirectoryMonitorExploreAsyncData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorExploreAsyncData, _data_);
#line 3566 "DirectoryMonitor.c"
}


static void directory_monitor_explore_async (DirectoryMonitor* self, GFile* dir, GFileInfo* dir_info, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorExploreAsyncData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorExploreAsyncData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_explore_async);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_explore_async_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = dir_info;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_info = _tmp4_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = in_discovery;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->in_discovery = _tmp5_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_async_co (_data_);
#line 3610 "DirectoryMonitor.c"
}


static void directory_monitor_explore_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorExploreAsyncData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3618 "DirectoryMonitor.c"
}


static void directory_monitor_explore_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DirectoryMonitorExploreAsyncData* _data_;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = _user_data_;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_res_ = _res_;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_async_co (_data_);
#line 3632 "DirectoryMonitor.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3639 "DirectoryMonitor.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_list_free (self);
#line 3648 "DirectoryMonitor.c"
}


static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = file_hash ((GFile*) v);
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3657 "DirectoryMonitor.c"
}


static gboolean directory_monitor_explore_async_co (DirectoryMonitorExploreAsyncData* _data_) {
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 3666 "DirectoryMonitor.c"
		goto _state_0;
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 3670 "DirectoryMonitor.c"
		goto _state_1;
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 2:
#line 3674 "DirectoryMonitor.c"
		goto _state_2;
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 3:
#line 3678 "DirectoryMonitor.c"
		goto _state_3;
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 4:
#line 3682 "DirectoryMonitor.c"
		goto _state_4;
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 5:
#line 3686 "DirectoryMonitor.c"
		goto _state_5;
		default:
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 3691 "DirectoryMonitor.c"
	}
	_state_0:
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = _data_->self->priv->files;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = _data_->dir;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = NULL;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = _data_->dir_info;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = FALSE;
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = directory_monitor_file_info_map_contains (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
#line 851 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp3_) {
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = NULL;
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = _data_->dir;
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp5_ = NULL;
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp5_ = g_file_get_path (_data_->_tmp4_);
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp6_ = NULL;
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:852: Directory loop detected at %s, not explorin" \
"g", _data_->_tmp6_);
#line 852 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp6_);
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp7_ = FALSE;
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp7_ = _data_->in_discovery;
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp7_);
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3738 "DirectoryMonitor.c"
		} else {
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3742 "DirectoryMonitor.c"
		}
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 3748 "DirectoryMonitor.c"
	}
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp8_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp8_ = _data_->dir_info;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp9_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->local_dir_info = _data_->_tmp9_;
#line 861 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp10_ = NULL;
#line 861 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp10_ = _data_->local_dir_info;
#line 861 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp10_ == NULL) {
#line 3766 "DirectoryMonitor.c"
		{
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = _data_->dir;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = _data_->self->priv->cancellable;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_state_ = 1;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_query_info_async (_data_->_tmp12_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_DIR_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp13_, directory_monitor_explore_async_ready, _data_);
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return FALSE;
#line 3782 "DirectoryMonitor.c"
			_state_1:
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = g_file_query_info_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = _data_->_tmp14_;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3792 "DirectoryMonitor.c"
				goto __catch480_g_error;
			}
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = _data_->_tmp11_;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->local_dir_info);
#line 863 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->local_dir_info = _data_->_tmp15_;
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp11_);
#line 3807 "DirectoryMonitor.c"
		}
		goto __finally480;
		__catch480_g_error:
		{
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->err = _data_->_inner_error_;
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_inner_error_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = _data_->dir;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp17_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp17_ = g_file_get_path (_data_->_tmp16_);
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp18_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp18_ = _data_->_tmp17_;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp19_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp19_ = _data_->err;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = _data_->_tmp19_->message;
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_warning ("DirectoryMonitor.vala:866: Unable to retrieve info on %s: %s", _data_->_tmp18_, _data_->_tmp20_);
#line 866 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_data_->_tmp18_);
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = FALSE;
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = _data_->in_discovery;
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp21_);
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_error_free0 (_data_->err);
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->local_dir_info);
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_data_->_state_ == 0) {
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3854 "DirectoryMonitor.c"
			} else {
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3858 "DirectoryMonitor.c"
			}
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_object_unref (_data_->_async_result);
#line 870 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return FALSE;
#line 3864 "DirectoryMonitor.c"
		}
		__finally480:
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->local_dir_info);
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_clear_error (&_data_->_inner_error_);
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return FALSE;
#line 3877 "DirectoryMonitor.c"
		}
	}
#line 874 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp22_ = NULL;
#line 874 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp22_ = _data_->local_dir_info;
#line 874 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp23_ = FALSE;
#line 874 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp23_ = g_file_info_get_is_hidden (_data_->_tmp22_);
#line 874 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp23_) {
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp24_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp24_ = _data_->dir;
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp25_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp25_ = g_file_get_path (_data_->_tmp24_);
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp26_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:875: Ignoring hidden directory %s", _data_->_tmp26_);
#line 875 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp26_);
#line 877 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp27_ = FALSE;
#line 877 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp27_ = _data_->in_discovery;
#line 877 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp27_);
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3918 "DirectoryMonitor.c"
		} else {
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3922 "DirectoryMonitor.c"
		}
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 3928 "DirectoryMonitor.c"
	}
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp28_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp28_ = _data_->local_dir_info;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp29_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp29_ = get_file_info_id (_data_->_tmp28_);
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp30_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp30_ = _data_->_tmp29_;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp31_ = FALSE;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp31_ = _data_->_tmp30_ == NULL;
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_data_->_tmp30_);
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp31_) {
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp32_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp32_ = _data_->local_dir_info;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp33_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp33_ = _data_->dir;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp34_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp34_ = g_file_get_uri (_data_->_tmp33_);
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = _data_->_tmp34_;
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_file_info_set_attribute_string (_data_->_tmp32_, G_FILE_ATTRIBUTE_ID_FILE, _data_->_tmp35_);
#line 885 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp35_);
#line 3970 "DirectoryMonitor.c"
	}
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp36_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp36_ = _data_->local_dir_info;
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = 0;
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = g_file_info_get_file_type (_data_->_tmp36_);
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp37_ != G_FILE_TYPE_DIRECTORY) {
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp38_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp38_ = _ ("Unable to monitor %s: Not a directory (%s)");
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp39_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp39_ = _data_->dir;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp40_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp40_ = g_file_get_path (_data_->_tmp39_);
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp41_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp42_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp42_ = _data_->local_dir_info;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp43_ = 0;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp43_ = g_file_info_get_file_type (_data_->_tmp42_);
#line 892 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		memset (&_data_->_tmp44_, 0, sizeof (GEnumValue*));
#line 892 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp44_ = g_enum_get_value (g_type_class_ref (g_file_type_get_type ()), _data_->_tmp43_);
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp45_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp45_ = g_strdup_printf (_data_->_tmp38_, _data_->_tmp41_, (_data_->_tmp44_ != NULL) ? _data_->_tmp44_->value_name : NULL);
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp46_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp46_ = _data_->_tmp45_;
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_discovery_failed (_data_->self, _data_->_tmp46_);
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp46_);
#line 891 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp41_);
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp47_ = FALSE;
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp47_ = _data_->in_discovery;
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp47_);
#line 896 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 896 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 896 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4036 "DirectoryMonitor.c"
		} else {
#line 896 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4040 "DirectoryMonitor.c"
		}
#line 896 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 896 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4046 "DirectoryMonitor.c"
	}
#line 903 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_map = NULL;
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->file_map = NULL;
#line 4052 "DirectoryMonitor.c"
	{
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp48_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp48_ = _data_->dir;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp49_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp49_ = _data_->self->priv->cancellable;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_state_ = 2;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_file_enumerate_children_async (_data_->_tmp48_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp49_, directory_monitor_explore_async_ready, _data_);
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4068 "DirectoryMonitor.c"
		_state_2:
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp50_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp50_ = g_file_enumerate_children_finish (_data_->_tmp48_, _data_->_res_, &_data_->_inner_error_);
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->enumerator = _data_->_tmp50_;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 4078 "DirectoryMonitor.c"
			goto __catch481_g_error;
		}
		{
#line 909 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp51_ = TRUE;
#line 909 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 909 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!_data_->_tmp51_) {
#line 4088 "DirectoryMonitor.c"
				}
#line 909 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp51_ = FALSE;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp52_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp52_ = _data_->enumerator;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = _data_->self->priv->cancellable;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 3;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_file_enumerator_next_files_async (_data_->_tmp52_, 10, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp53_, directory_monitor_explore_async_ready, _data_);
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 4106 "DirectoryMonitor.c"
				_state_3:
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = g_file_enumerator_next_files_finish (_data_->_tmp52_, _data_->_res_, &_data_->_inner_error_);
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->infos = _data_->_tmp54_;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->enumerator);
#line 4118 "DirectoryMonitor.c"
					goto __catch481_g_error;
				}
#line 912 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = NULL;
#line 912 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = _data_->infos;
#line 912 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp55_ == NULL) {
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					__g_list_free__g_object_unref0_0 (_data_->infos);
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 4131 "DirectoryMonitor.c"
				}
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = _data_->infos;
#line 4137 "DirectoryMonitor.c"
				{
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->info_collection = _data_->_tmp56_;
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_data_->_tmp57_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_data_->_tmp57_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_data_->info = _data_->_tmp57_;
#line 4149 "DirectoryMonitor.c"
						{
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp58_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp58_ = _data_->info;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp59_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp59_ = get_file_info_id (_data_->_tmp58_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp60_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp60_ = _data_->_tmp59_;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp61_ = FALSE;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp61_ = _data_->_tmp60_ == NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_g_free0 (_data_->_tmp60_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							if (_data_->_tmp61_) {
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp62_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp62_ = _data_->info;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp63_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp63_ = _data_->dir;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp64_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp64_ = g_file_get_uri (_data_->_tmp63_);
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp65_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp65_ = _data_->_tmp64_;
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								g_file_info_set_attribute_string (_data_->_tmp62_, G_FILE_ATTRIBUTE_ID_FILE, _data_->_tmp65_);
#line 917 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_free0 (_data_->_tmp65_);
#line 4191 "DirectoryMonitor.c"
							}
#line 921 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp66_ = NULL;
#line 921 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp66_ = _data_->info;
#line 921 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp67_ = FALSE;
#line 921 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp67_ = g_file_info_get_is_hidden (_data_->_tmp66_);
#line 921 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							if (_data_->_tmp67_) {
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp68_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp68_ = _data_->dir;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp69_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp69_ = _data_->info;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp70_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp70_ = g_file_info_get_name (_data_->_tmp69_);
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp71_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp71_ = g_file_get_child (_data_->_tmp68_, _data_->_tmp70_);
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp72_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp72_ = _data_->_tmp71_;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp73_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp73_ = g_file_get_path (_data_->_tmp72_);
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp74_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp74_ = _data_->_tmp73_;
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								g_warning ("DirectoryMonitor.vala:922: Skipping hidden file/directory %s", _data_->_tmp74_);
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_free0 (_data_->_tmp74_);
#line 922 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_object_unref0 (_data_->_tmp72_);
#line 925 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_object_unref0 (_data_->info);
#line 925 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								continue;
#line 4241 "DirectoryMonitor.c"
							}
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp75_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp75_ = _data_->info;
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp76_ = FALSE;
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp76_ = directory_monitor_is_file_symlink_supported (_data_->_tmp75_);
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							if (!_data_->_tmp76_) {
#line 930 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_object_unref0 (_data_->info);
#line 930 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								continue;
#line 4257 "DirectoryMonitor.c"
							}
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp77_ = NULL;
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp77_ = _data_->info;
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp78_ = 0;
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp78_ = g_file_info_get_file_type (_data_->_tmp77_);
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							switch (_data_->_tmp78_) {
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								case G_FILE_TYPE_REGULAR:
#line 4271 "DirectoryMonitor.c"
								{
#line 934 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp79_ = NULL;
#line 934 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp79_ = _data_->file_map;
#line 934 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									if (_data_->_tmp79_ == NULL) {
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp80_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp80_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_g_object_unref0 (_data_->file_map);
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->file_map = _data_->_tmp80_;
#line 4287 "DirectoryMonitor.c"
									}
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp81_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp81_ = _data_->file_map;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp82_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp82_ = _data_->dir;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp83_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp83_ = _data_->info;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp84_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp84_ = g_file_info_get_name (_data_->_tmp83_);
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp85_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp85_ = g_file_get_child (_data_->_tmp82_, _data_->_tmp84_);
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp86_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp86_ = _data_->_tmp85_;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp87_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp87_ = _data_->info;
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp81_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp86_, _data_->_tmp87_);
#line 937 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_g_object_unref0 (_data_->_tmp86_);
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									break;
#line 4323 "DirectoryMonitor.c"
								}
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								case G_FILE_TYPE_DIRECTORY:
#line 4327 "DirectoryMonitor.c"
								{
#line 941 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp88_ = NULL;
#line 941 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp88_ = _data_->dir_map;
#line 941 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									if (_data_->_tmp88_ == NULL) {
#line 942 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp89_ = NULL;
#line 942 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp89_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 942 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_g_object_unref0 (_data_->dir_map);
#line 942 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->dir_map = _data_->_tmp89_;
#line 4343 "DirectoryMonitor.c"
									}
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp90_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp90_ = _data_->dir_map;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp91_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp91_ = _data_->dir;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp92_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp92_ = _data_->info;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp93_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp93_ = g_file_info_get_name (_data_->_tmp92_);
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp94_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp94_ = g_file_get_child (_data_->_tmp91_, _data_->_tmp93_);
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp95_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp95_ = _data_->_tmp94_;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp96_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp96_ = _data_->info;
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp90_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp95_, _data_->_tmp96_);
#line 944 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_g_object_unref0 (_data_->_tmp95_);
#line 945 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									break;
#line 4379 "DirectoryMonitor.c"
								}
								default:
								{
#line 949 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									break;
#line 4385 "DirectoryMonitor.c"
								}
							}
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_g_object_unref0 (_data_->info);
#line 4390 "DirectoryMonitor.c"
						}
					}
				}
#line 909 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				__g_list_free__g_object_unref0_0 (_data_->infos);
#line 4396 "DirectoryMonitor.c"
			}
		}
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->enumerator);
#line 4401 "DirectoryMonitor.c"
	}
	goto __finally481;
	__catch481_g_error:
	{
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->err2 = _data_->_inner_error_;
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_inner_error_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp97_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp97_ = _data_->dir;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp98_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp98_ = g_file_get_path (_data_->_tmp97_);
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp99_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp99_ = _data_->_tmp98_;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp100_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp100_ = _data_->err2;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp101_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp101_ = _data_->_tmp100_->message;
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:954: Aborted directory traversal of %s: %s", _data_->_tmp99_, _data_->_tmp101_);
#line 954 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp99_);
#line 956 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp102_ = FALSE;
#line 956 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp102_ = _data_->in_discovery;
#line 956 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp102_);
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (_data_->err2);
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->file_map);
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->dir_map);
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4452 "DirectoryMonitor.c"
		} else {
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4456 "DirectoryMonitor.c"
		}
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 958 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4462 "DirectoryMonitor.c"
	}
	__finally481:
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->file_map);
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->dir_map);
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_data_->_inner_error_);
#line 906 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4479 "DirectoryMonitor.c"
	}
#line 962 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp103_ = FALSE;
#line 962 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp103_ = _data_->in_discovery;
#line 962 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp103_) {
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp104_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp104_ = _data_->dir;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp105_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp105_ = _data_->local_dir_info;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_directory_discovered (_data_->self, _data_->_tmp104_, _data_->_tmp105_);
#line 4497 "DirectoryMonitor.c"
	} else {
#line 965 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp106_ = NULL;
#line 965 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp106_ = _data_->dir;
#line 965 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp107_ = NULL;
#line 965 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp107_ = _data_->local_dir_info;
#line 965 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_directory_created (_data_->self, _data_->_tmp106_, _data_->_tmp107_);
#line 4509 "DirectoryMonitor.c"
	}
#line 969 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp108_ = NULL;
#line 969 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp108_ = _data_->dir;
#line 969 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp109_ = NULL;
#line 969 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp109_ = _data_->local_dir_info;
#line 969 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_add_monitor (_data_->self, _data_->_tmp108_, _data_->_tmp109_);
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp110_ = NULL;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp110_ = _data_->file_map;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp110_ != NULL) {
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp111_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp111_ = _data_->file_map;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp112_ = FALSE;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp112_ = _data_->in_discovery;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_state_ = 4;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_directory_files (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp111_, GEE_TYPE_MAP, GeeMap), _data_->_tmp112_, directory_monitor_explore_async_ready, _data_);
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4541 "DirectoryMonitor.c"
		_state_4:
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_directory_files_finish (_data_->self, _data_->_res_);
#line 4545 "DirectoryMonitor.c"
	}
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp114_ = FALSE;
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp114_ = _data_->self->priv->recurse;
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp114_) {
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp115_ = NULL;
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp115_ = _data_->dir_map;
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp113_ = _data_->_tmp115_ != NULL;
#line 4559 "DirectoryMonitor.c"
	} else {
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp113_ = FALSE;
#line 4563 "DirectoryMonitor.c"
	}
#line 976 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp113_) {
#line 4567 "DirectoryMonitor.c"
		{
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp116_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp116_ = _data_->dir_map;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp117_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp117_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp116_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp118_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp118_ = _data_->_tmp117_;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp119_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp119_ = _data_->_tmp118_;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp120_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp120_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp119_, GEE_TYPE_ITERABLE, GeeIterable));
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp121_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp121_ = _data_->_tmp120_;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp119_);
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_subdir_it = _data_->_tmp121_;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp122_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp122_ = _data_->_subdir_it;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp123_ = FALSE;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp123_ = gee_iterator_next (_data_->_tmp122_);
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!_data_->_tmp123_) {
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 4611 "DirectoryMonitor.c"
				}
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp124_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp124_ = _data_->_subdir_it;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp125_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp125_ = gee_iterator_get (_data_->_tmp124_);
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->subdir = (GFile*) _data_->_tmp125_;
#line 978 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp126_ = 0;
#line 978 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp126_ = _data_->self->priv->outstanding_exploration_dirs;
#line 978 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->self->priv->outstanding_exploration_dirs = _data_->_tmp126_ + 1;
#line 978 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp127_ = 0;
#line 978 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp127_ = _data_->self->priv->outstanding_exploration_dirs;
#line 978 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp127_ > DIRECTORY_MONITOR_MAX_EXPLORATION_DIRS) {
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp128_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp128_ = _data_->subdir;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp129_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp129_ = _data_->dir_map;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp130_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp130_ = _data_->subdir;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp131_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp131_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp129_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp130_);
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp132_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp132_ = (GFileInfo*) _data_->_tmp131_;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp133_ = FALSE;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp133_ = _data_->in_discovery;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_state_ = 5;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_async (_data_->self, _data_->_tmp128_, _data_->_tmp132_, _data_->_tmp133_, directory_monitor_explore_async_ready, _data_);
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					return FALSE;
#line 4665 "DirectoryMonitor.c"
					_state_5:
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_finish (_data_->self, _data_->_res_);
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->_tmp132_);
#line 4671 "DirectoryMonitor.c"
				} else {
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp134_ = NULL;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp134_ = _data_->subdir;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp135_ = NULL;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp135_ = _data_->dir_map;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp136_ = NULL;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp136_ = _data_->subdir;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp137_ = NULL;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp137_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp135_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp136_);
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp138_ = NULL;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp138_ = (GFileInfo*) _data_->_tmp137_;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp139_ = FALSE;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp139_ = _data_->in_discovery;
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_async (_data_->self, _data_->_tmp134_, _data_->_tmp138_, _data_->_tmp139_, NULL, NULL);
#line 981 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->_tmp138_);
#line 4701 "DirectoryMonitor.c"
				}
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->subdir);
#line 4705 "DirectoryMonitor.c"
			}
#line 977 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_subdir_it);
#line 4709 "DirectoryMonitor.c"
		}
	}
#line 985 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp140_ = FALSE;
#line 985 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp140_ = _data_->in_discovery;
#line 985 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp140_);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->file_map);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_map);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->local_dir_info);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4728 "DirectoryMonitor.c"
	} else {
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4732 "DirectoryMonitor.c"
	}
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 4738 "DirectoryMonitor.c"
}


static void directory_monitor_notify_directory_files_data_free (gpointer _data) {
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->map);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorNotifyDirectoryFilesData, _data_);
#line 4751 "DirectoryMonitor.c"
}


static void directory_monitor_notify_directory_files (DirectoryMonitor* self, GeeMap* map, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorNotifyDirectoryFilesData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_notify_directory_files);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_notify_directory_files_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = map;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->map);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->map = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = in_discovery;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->in_discovery = _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_files_co (_data_);
#line 4785 "DirectoryMonitor.c"
}


static void directory_monitor_notify_directory_files_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 4793 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_notify_directory_files_co_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_notify_directory_files_co (self);
#line 996 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 4802 "DirectoryMonitor.c"
}


static gboolean directory_monitor_notify_directory_files_co (DirectoryMonitorNotifyDirectoryFilesData* _data_) {
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 4811 "DirectoryMonitor.c"
		goto _state_0;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 4815 "DirectoryMonitor.c"
		goto _state_1;
		default:
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 4820 "DirectoryMonitor.c"
	}
	_state_0:
#line 989 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 989 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = _data_->map;
#line 989 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 989 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = gee_map_map_iterator (_data_->_tmp0_);
#line 989 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->iter = _data_->_tmp1_;
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	while (TRUE) {
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp2_ = NULL;
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp2_ = _data_->iter;
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp3_ = FALSE;
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp3_ = gee_map_iterator_next (_data_->_tmp2_);
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (!_data_->_tmp3_) {
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 4847 "DirectoryMonitor.c"
		}
#line 991 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = FALSE;
#line 991 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = _data_->in_discovery;
#line 991 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_tmp4_) {
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp5_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp5_ = _data_->iter;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp6_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp6_ = gee_map_iterator_get_key (_data_->_tmp5_);
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp7_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp7_ = (GFile*) _data_->_tmp6_;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = _data_->iter;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = gee_map_iterator_get_value (_data_->_tmp8_);
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = (GFileInfo*) _data_->_tmp9_;
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_internal_notify_file_discovered (_data_->self, _data_->_tmp7_, _data_->_tmp10_);
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp10_);
#line 992 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp7_);
#line 4885 "DirectoryMonitor.c"
		} else {
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = _data_->iter;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = gee_map_iterator_get_key (_data_->_tmp11_);
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = (GFile*) _data_->_tmp12_;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = _data_->iter;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = gee_map_iterator_get_value (_data_->_tmp14_);
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = (GFileInfo*) _data_->_tmp15_;
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_internal_notify_file_created (_data_->self, _data_->_tmp13_, _data_->_tmp16_);
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp16_);
#line 994 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp13_);
#line 4917 "DirectoryMonitor.c"
		}
#line 996 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_notify_directory_files_co_gsource_func, _data_, NULL);
#line 997 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_state_ = 1;
#line 997 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4925 "DirectoryMonitor.c"
		_state_1:
		;
	}
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->iter);
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4935 "DirectoryMonitor.c"
	} else {
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4939 "DirectoryMonitor.c"
	}
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 4945 "DirectoryMonitor.c"
}


static void directory_monitor_explore_directory_completed (DirectoryMonitor* self, gboolean in_discovery) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 1003 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1004 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->outstanding_exploration_dirs;
#line 1004 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp0_ > 0, "outstanding_exploration_dirs > 0");
#line 1005 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->outstanding_exploration_dirs;
#line 1005 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->outstanding_exploration_dirs = _tmp1_ - 1;
#line 1007 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = in_discovery;
#line 1007 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp3_) {
#line 4968 "DirectoryMonitor.c"
		gint _tmp4_ = 0;
#line 1007 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = self->priv->outstanding_exploration_dirs;
#line 1007 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp4_ == 0;
#line 4974 "DirectoryMonitor.c"
	} else {
#line 1007 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = FALSE;
#line 4978 "DirectoryMonitor.c"
	}
#line 1007 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_) {
#line 1008 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_discovery_completed (self);
#line 4984 "DirectoryMonitor.c"
	}
}


static void _directory_monitor_on_monitor_notification_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 1036 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_on_monitor_notification ((DirectoryMonitor*) self, file, other_file, event_type);
#line 4992 "DirectoryMonitor.c"
}


static gboolean directory_monitor_add_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* id = NULL;
	DirectoryMonitorFileInfoMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GFileMonitor* monitor = NULL;
	GeeHashMap* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GFileMonitor* _tmp21_ = NULL;
	GFileMonitor* _tmp22_ = NULL;
	GFile* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 1014 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1014 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (dir), FALSE);
#line 1014 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1015 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->monitoring;
#line 1015 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp0_) {
#line 1016 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1016 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5033 "DirectoryMonitor.c"
	}
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->files;
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = dir;
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = info;
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_get_id (_tmp1_, _tmp2_, _tmp3_);
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp4_;
#line 1019 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = id;
#line 1019 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp5_ == NULL) {
#line 1020 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1020 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1020 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5055 "DirectoryMonitor.c"
	}
#line 1023 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = self->priv->monitors;
#line 1023 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = id;
#line 1023 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 1023 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp8_) {
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5071 "DirectoryMonitor.c"
	}
#line 1026 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	monitor = NULL;
#line 5075 "DirectoryMonitor.c"
	{
		GFileMonitor* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileMonitor* _tmp11_ = NULL;
		GFileMonitor* _tmp12_ = NULL;
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = dir;
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = g_file_monitor_directory (_tmp10_, DIRECTORY_MONITOR_FILE_MONITOR_FLAGS, NULL, &_inner_error_);
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp11_;
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5089 "DirectoryMonitor.c"
			goto __catch482_g_error;
		}
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = _tmp9_;
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = NULL;
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1028 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		monitor = _tmp12_;
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp9_);
#line 5102 "DirectoryMonitor.c"
	}
	goto __finally482;
	__catch482_g_error:
	{
		GError* err = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		err = _inner_error_;
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_inner_error_ = NULL;
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = dir;
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _tmp14_;
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = err;
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = _tmp16_->message;
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:1030: Unable to monitor %s: %s", _tmp15_, _tmp17_);
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp15_);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (err);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5141 "DirectoryMonitor.c"
	}
	__finally482:
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5146 "DirectoryMonitor.c"
		gboolean _tmp18_ = FALSE;
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1027 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return _tmp18_;
#line 5158 "DirectoryMonitor.c"
	}
#line 1035 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = self->priv->monitors;
#line 1035 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp20_ = id;
#line 1035 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp21_ = monitor;
#line 1035 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_, _tmp21_);
#line 1036 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp22_ = monitor;
#line 1036 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_connect_object (_tmp22_, "changed", (GCallback) _directory_monitor_on_monitor_notification_g_file_monitor_changed, self, 0);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp23_ = dir;
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp24_ = g_file_get_path (_tmp23_);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp25_ = _tmp24_;
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp26_ = g_strdup_printf ("Added monitor for %s", _tmp25_);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp27_ = _tmp26_;
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp27_);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp27_);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp25_);
#line 1040 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 1040 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (monitor);
#line 1040 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 1040 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 5196 "DirectoryMonitor.c"
}


static gboolean directory_monitor_remove_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* id = NULL;
	DirectoryMonitorFileInfoMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GFileMonitor* monitor = NULL;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gpointer _tmp8_ = NULL;
	GFileMonitor* _tmp9_ = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GFileMonitor* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
#line 1044 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1044 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (dir), FALSE);
#line 1044 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1045 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->monitoring;
#line 1045 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp0_) {
#line 1046 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1046 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5239 "DirectoryMonitor.c"
	}
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->files;
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = dir;
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = info;
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_get_id (_tmp1_, _tmp2_, _tmp3_);
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp4_;
#line 1049 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = id;
#line 1049 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp5_ == NULL) {
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5261 "DirectoryMonitor.c"
	}
#line 1052 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = self->priv->monitors;
#line 1052 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = id;
#line 1052 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 1052 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	monitor = (GFileMonitor*) _tmp8_;
#line 1053 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = monitor;
#line 1053 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp9_ == NULL) {
#line 1054 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1054 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1054 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1054 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5283 "DirectoryMonitor.c"
	}
#line 1056 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = self->priv->monitors;
#line 1056 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = id;
#line 1056 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, NULL);
#line 1056 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	removed = _tmp12_;
#line 1057 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = removed;
#line 1057 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp13_, "removed");
#line 1059 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = monitor;
#line 1059 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_cancel_monitor (self, _tmp14_);
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp15_ = dir;
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = g_file_get_path (_tmp15_);
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp17_ = _tmp16_;
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = g_strdup_printf ("Removed monitor for %s", _tmp17_);
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = _tmp18_;
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp19_);
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp19_);
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp17_);
#line 1063 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 1063 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (monitor);
#line 1063 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 1063 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 5325 "DirectoryMonitor.c"
}


static void directory_monitor_cancel_monitor (DirectoryMonitor* self, GFileMonitor* monitor) {
	GFileMonitor* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GFileMonitor* _tmp2_ = NULL;
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_MONITOR (monitor));
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = monitor;
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp1_, NULL, FALSE);
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _directory_monitor_on_monitor_notification_g_file_monitor_changed, self);
#line 1068 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = monitor;
#line 1068 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_file_monitor_cancel (_tmp2_);
#line 5347 "DirectoryMonitor.c"
}


static void _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 1088 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_on_completed ((DirectoryMonitorQueryInfoQueueElement*) self, source_object, res);
#line 1088 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_unref (self);
#line 5356 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_check_for_expired_delete_events_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_check_for_expired_delete_events ((DirectoryMonitor*) self);
#line 1097 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 5365 "DirectoryMonitor.c"
}


static void directory_monitor_on_monitor_notification (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileMonitorEvent _tmp5_ = 0;
	GEnumValue* _tmp6_;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	DirectoryMonitorQueryInfoQueueElement* query_info = NULL;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GFileMonitorEvent _tmp14_ = 0;
	DirectoryMonitorQueryInfoQueueElement* _tmp15_ = NULL;
	GeeQueue* _tmp16_ = NULL;
	DirectoryMonitorQueryInfoQueueElement* _tmp17_ = NULL;
	GFileMonitorEvent _tmp18_ = 0;
#line 1071 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1071 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1071 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((other_file == NULL) || G_IS_FILE (other_file));
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = other_file;
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp1_ != NULL) {
#line 5397 "DirectoryMonitor.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = other_file;
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp3_;
#line 5408 "DirectoryMonitor.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = g_strdup ("(none)");
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1073 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp4_;
#line 5417 "DirectoryMonitor.c"
	}
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = event;
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp5_);
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = file;
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = _tmp8_;
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = g_strdup_printf ("NOTIFY %s: file=%s other_file=%s", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL, _tmp9_, _tmp0_);
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = _tmp10_;
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp11_);
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp11_);
#line 1072 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp9_);
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = file;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = other_file;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = event;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp15_ = directory_monitor_query_info_queue_element_new (self, _tmp12_, _tmp13_, _tmp14_);
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	query_info = _tmp15_;
#line 1083 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = self->priv->query_info_queue;
#line 1083 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp17_ = query_info;
#line 1083 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_queue_offer (_tmp16_, _tmp17_);
#line 1085 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = event;
#line 1085 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp18_) {
#line 1085 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CREATED:
#line 1085 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 5463 "DirectoryMonitor.c"
		{
			GFile* _tmp19_ = NULL;
			GCancellable* _tmp20_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp21_ = NULL;
#line 1088 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp19_ = file;
#line 1088 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp20_ = self->priv->cancellable;
#line 1088 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp21_ = query_info;
#line 1088 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_query_info_async (_tmp19_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _tmp20_, _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback, directory_monitor_query_info_queue_element_ref (_tmp21_));
#line 1090 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5478 "DirectoryMonitor.c"
		}
#line 1085 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_DELETED:
#line 5482 "DirectoryMonitor.c"
		{
			guint _tmp22_ = 0U;
#line 1096 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp22_ = self->priv->delete_timer_id;
#line 1096 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp22_ == ((guint) 0)) {
#line 5489 "DirectoryMonitor.c"
				guint _tmp23_ = 0U;
#line 1097 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp23_ = g_timeout_add_full (G_PRIORITY_DEFAULT, DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC / 2, _directory_monitor_check_for_expired_delete_events_gsource_func, g_object_ref (self), g_object_unref);
#line 1097 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				self->priv->delete_timer_id = _tmp23_;
#line 5495 "DirectoryMonitor.c"
			}
#line 1098 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5499 "DirectoryMonitor.c"
		}
#line 1085 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_MOVED:
#line 5503 "DirectoryMonitor.c"
		{
			GFile* _tmp24_ = NULL;
#line 1103 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp24_ = other_file;
#line 1103 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp24_ != NULL) {
#line 5510 "DirectoryMonitor.c"
				GFile* _tmp25_ = NULL;
				GCancellable* _tmp26_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp27_ = NULL;
#line 1104 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp25_ = other_file;
#line 1104 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp26_ = self->priv->cancellable;
#line 1104 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp27_ = query_info;
#line 1104 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_file_query_info_async (_tmp25_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _tmp26_, _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback, directory_monitor_query_info_queue_element_ref (_tmp27_));
#line 5522 "DirectoryMonitor.c"
			} else {
				GeeQueue* _tmp28_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp29_ = NULL;
#line 1107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_warning ("DirectoryMonitor.vala:1107: Unable to process MOVED event: no other_fi" \
"le");
#line 1108 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp28_ = self->priv->query_info_queue;
#line 1108 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp29_ = query_info;
#line 1108 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection), _tmp29_);
#line 5534 "DirectoryMonitor.c"
			}
#line 1110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5538 "DirectoryMonitor.c"
		}
		default:
		{
			DirectoryMonitorQueryInfoQueueElement* _tmp30_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp31_ = NULL;
#line 1114 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp30_ = query_info;
#line 1114 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp30_->completed = TRUE;
#line 1115 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp31_ = query_info;
#line 1115 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_process_query_queue (self, _tmp31_);
#line 1116 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5554 "DirectoryMonitor.c"
		}
	}
#line 1071 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_directory_monitor_query_info_queue_element_unref0 (query_info);
#line 1071 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp0_);
#line 5561 "DirectoryMonitor.c"
}


static void directory_monitor_process_query_queue (DirectoryMonitor* self, DirectoryMonitorQueryInfoQueueElement* query_info) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	DirectoryMonitorQueryInfoQueueElement* _tmp2_ = NULL;
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((query_info == NULL) || DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT (query_info));
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = query_info;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ != NULL) {
#line 5577 "DirectoryMonitor.c"
		DirectoryMonitorQueryInfoQueueElement* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = query_info;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = _tmp3_->info;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 5586 "DirectoryMonitor.c"
	} else {
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = FALSE;
#line 5590 "DirectoryMonitor.c"
	}
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp1_) {
#line 5594 "DirectoryMonitor.c"
		DirectoryMonitorQueryInfoQueueElement* _tmp5_ = NULL;
		GFileMonitorEvent _tmp6_ = 0;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = query_info;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = _tmp5_->event;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp6_ == G_FILE_MONITOR_EVENT_CREATED;
#line 5603 "DirectoryMonitor.c"
	} else {
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = FALSE;
#line 5607 "DirectoryMonitor.c"
	}
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp0_) {
#line 5611 "DirectoryMonitor.c"
		GFile* match = NULL;
		DirectoryMonitorFileInfoMap* _tmp7_ = NULL;
		DirectoryMonitorQueryInfoQueueElement* _tmp8_ = NULL;
		GFileInfo* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = self->priv->files;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = query_info;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp8_->info;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = directory_monitor_file_info_map_find_match (_tmp7_, _tmp9_);
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		match = _tmp10_;
#line 1127 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = match;
#line 1127 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_tmp11_ != NULL) {
#line 5632 "DirectoryMonitor.c"
			gboolean matched = FALSE;
			gboolean _tmp48_ = FALSE;
#line 1128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			matched = FALSE;
#line 5637 "DirectoryMonitor.c"
			{
				GeeIterator* _enqueued_it = NULL;
				GeeQueue* _tmp12_ = NULL;
				GeeIterator* _tmp13_ = NULL;
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = self->priv->query_info_queue;
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_enqueued_it = _tmp13_;
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				while (TRUE) {
#line 5650 "DirectoryMonitor.c"
					GeeIterator* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					DirectoryMonitorQueryInfoQueueElement* enqueued = NULL;
					GeeIterator* _tmp16_ = NULL;
					gpointer _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					DirectoryMonitorQueryInfoQueueElement* _tmp20_ = NULL;
					GFileMonitorEvent _tmp21_ = 0;
					DirectoryMonitorQueryInfoQueueElement* _tmp28_ = NULL;
					GFile* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp32_ = NULL;
					GFile* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp38_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp39_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp40_ = NULL;
					GFile* _tmp41_ = NULL;
					GFile* _tmp42_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp43_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp44_ = NULL;
					GFileInfo* _tmp45_ = NULL;
					GFileInfo* _tmp46_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp47_ = NULL;
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp14_ = _enqueued_it;
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp15_ = gee_iterator_next (_tmp14_);
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (!_tmp15_) {
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						break;
#line 5688 "DirectoryMonitor.c"
					}
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp16_ = _enqueued_it;
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp17_ = gee_iterator_get (_tmp16_);
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					enqueued = (DirectoryMonitorQueryInfoQueueElement*) _tmp17_;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp20_ = enqueued;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp21_ = _tmp20_->event;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp21_ != G_FILE_MONITOR_EVENT_DELETED) {
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp19_ = TRUE;
#line 5704 "DirectoryMonitor.c"
					} else {
						DirectoryMonitorQueryInfoQueueElement* _tmp22_ = NULL;
						gboolean _tmp23_ = FALSE;
#line 1131 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp22_ = enqueued;
#line 1131 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp23_ = _tmp22_->completed;
#line 1131 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp19_ = _tmp23_;
#line 5714 "DirectoryMonitor.c"
					}
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp19_) {
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp18_ = TRUE;
#line 5720 "DirectoryMonitor.c"
					} else {
						GFile* _tmp24_ = NULL;
						DirectoryMonitorQueryInfoQueueElement* _tmp25_ = NULL;
						GFile* _tmp26_ = NULL;
						gboolean _tmp27_ = FALSE;
#line 1132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp24_ = match;
#line 1132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp25_ = enqueued;
#line 1132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp26_ = _tmp25_->file;
#line 1132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp27_ = g_file_equal (_tmp24_, _tmp26_);
#line 1132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp18_ = !_tmp27_;
#line 5736 "DirectoryMonitor.c"
					}
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp18_) {
#line 1133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_directory_monitor_query_info_queue_element_unref0 (enqueued);
#line 1133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						continue;
#line 5744 "DirectoryMonitor.c"
					}
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp28_ = query_info;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp29_ = _tmp28_->file;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp30_ = g_file_get_path (_tmp29_);
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp31_ = _tmp30_;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp32_ = enqueued;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp33_ = _tmp32_->file;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp34_ = g_file_get_path (_tmp33_);
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp35_ = _tmp34_;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp36_ = g_strdup_printf ("Matching CREATED %s to DELETED %s for MOVED", _tmp31_, _tmp35_);
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp37_ = _tmp36_;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_mdbg (_tmp37_);
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_tmp37_);
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_tmp35_);
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_tmp31_);
#line 1139 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp38_ = enqueued;
#line 1139 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp38_->event = G_FILE_MONITOR_EVENT_MOVED;
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp39_ = enqueued;
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp40_ = query_info;
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp41_ = _tmp40_->file;
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp42_ = _g_object_ref0 (_tmp41_);
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_tmp39_->other_file);
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp39_->other_file = _tmp42_;
#line 1141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp43_ = enqueued;
#line 1141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp44_ = query_info;
#line 1141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp45_ = _tmp44_->info;
#line 1141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp46_ = _g_object_ref0 (_tmp45_);
#line 1141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_tmp43_->info);
#line 1141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp43_->info = _tmp46_;
#line 1142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp47_ = enqueued;
#line 1142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp47_->completed = TRUE;
#line 1144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					matched = TRUE;
#line 1146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_directory_monitor_query_info_queue_element_unref0 (enqueued);
#line 1146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 5812 "DirectoryMonitor.c"
				}
#line 1129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_enqueued_it);
#line 5816 "DirectoryMonitor.c"
			}
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp48_ = matched;
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp48_) {
#line 5822 "DirectoryMonitor.c"
				GeeQueue* _tmp49_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp50_ = NULL;
#line 1150 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp49_ = self->priv->query_info_queue;
#line 1150 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp50_ = query_info;
#line 1150 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), _tmp50_);
#line 5831 "DirectoryMonitor.c"
			}
		}
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (match);
#line 5836 "DirectoryMonitor.c"
	}
	{
		gboolean _tmp51_ = FALSE;
#line 1155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp51_ = TRUE;
#line 1155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 5844 "DirectoryMonitor.c"
			DirectoryMonitorQueryInfoQueueElement* next = NULL;
			GeeQueue* _tmp52_ = NULL;
			gpointer _tmp53_ = NULL;
			gboolean _tmp54_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp55_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* n = NULL;
			GeeQueue* _tmp58_ = NULL;
			gpointer _tmp59_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp60_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp61_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp62_ = NULL;
			guint _tmp63_ = 0U;
			DirectoryMonitorQueryInfoQueueElement* _tmp64_ = NULL;
			GFileMonitorEvent _tmp65_ = 0;
			GEnumValue* _tmp66_;
			DirectoryMonitorQueryInfoQueueElement* _tmp67_ = NULL;
			GFile* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp73_ = NULL;
			GError* _tmp74_ = NULL;
			gboolean _tmp87_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp88_ = NULL;
			GFileInfo* _tmp89_ = NULL;
			gboolean _tmp103_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp104_ = NULL;
			GFileInfo* _tmp105_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp118_ = NULL;
			GFile* _tmp119_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp120_ = NULL;
			GFile* _tmp121_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp122_ = NULL;
			GFileInfo* _tmp123_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp124_ = NULL;
			GFileMonitorEvent _tmp125_ = 0;
#line 1155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp51_) {
#line 5884 "DirectoryMonitor.c"
			}
#line 1155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp51_ = FALSE;
#line 1157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp52_ = self->priv->query_info_queue;
#line 1157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp53_ = gee_queue_peek (_tmp52_);
#line 1157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			next = (DirectoryMonitorQueryInfoQueueElement*) _tmp53_;
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp55_ = next;
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp55_ == NULL) {
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp54_ = TRUE;
#line 5900 "DirectoryMonitor.c"
			} else {
				DirectoryMonitorQueryInfoQueueElement* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp56_ = next;
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp57_ = _tmp56_->completed;
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp54_ = !_tmp57_;
#line 5910 "DirectoryMonitor.c"
			}
#line 1158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp54_) {
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 5918 "DirectoryMonitor.c"
			}
#line 1162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp58_ = self->priv->query_info_queue;
#line 1162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp59_ = gee_queue_poll (_tmp58_);
#line 1162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			n = (DirectoryMonitorQueryInfoQueueElement*) _tmp59_;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp60_ = next;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp61_ = n;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp60_ == _tmp61_, "next == n");
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp62_ = next;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp63_ = _tmp62_->position;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp64_ = next;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp65_ = _tmp64_->event;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp66_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp65_);
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp67_ = next;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp68_ = _tmp67_->file;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp69_ = g_file_get_path (_tmp68_);
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp70_ = _tmp69_;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp71_ = g_strdup_printf ("Completed info query %u for %s on %s", _tmp63_, (_tmp66_ != NULL) ? _tmp66_->value_name : NULL, _tmp70_);
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp72_ = _tmp71_;
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_mdbg (_tmp72_);
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp72_);
#line 1165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp70_);
#line 1168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp73_ = next;
#line 1168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp74_ = _tmp73_->err;
#line 1168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp74_ != NULL) {
#line 5966 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp75_ = NULL;
				GFile* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp79_ = NULL;
				GFileMonitorEvent _tmp80_ = 0;
				GEnumValue* _tmp81_;
				DirectoryMonitorQueryInfoQueueElement* _tmp82_ = NULL;
				GError* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_ = NULL;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp75_ = next;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp76_ = _tmp75_->file;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp77_ = g_file_get_path (_tmp76_);
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp78_ = _tmp77_;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp79_ = next;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp80_ = _tmp79_->event;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp81_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp80_);
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp82_ = next;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp83_ = _tmp82_->err;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp84_ = _tmp83_->message;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp85_ = g_strdup_printf ("Unable to retrieve file information for %s, dropping %s: %s", _tmp78_, (_tmp81_ != NULL) ? _tmp81_->value_name : NULL, _tmp84_);
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp86_ = _tmp85_;
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp86_);
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp86_);
#line 1169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp78_);
#line 1172 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (n);
#line 1172 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1172 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 6015 "DirectoryMonitor.c"
			}
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp88_ = next;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp89_ = _tmp88_->info;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp89_ != NULL) {
#line 6023 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp90_ = NULL;
				GFileInfo* _tmp91_ = NULL;
				gchar* _tmp92_ = NULL;
				gchar* _tmp93_ = NULL;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp90_ = next;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp91_ = _tmp90_->info;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp92_ = get_file_info_id (_tmp91_);
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp93_ = _tmp92_;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp87_ = _tmp93_ == NULL;
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp93_);
#line 6040 "DirectoryMonitor.c"
			} else {
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp87_ = FALSE;
#line 6044 "DirectoryMonitor.c"
			}
#line 1176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp87_) {
#line 6048 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp94_ = NULL;
				GFile* _tmp95_ = NULL;
				gchar* _tmp96_ = NULL;
				gchar* _tmp97_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp98_ = NULL;
				GFileMonitorEvent _tmp99_ = 0;
				GEnumValue* _tmp100_;
				gchar* _tmp101_ = NULL;
				gchar* _tmp102_ = NULL;
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp94_ = next;
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp95_ = _tmp94_->file;
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp96_ = g_file_get_path (_tmp95_);
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp97_ = _tmp96_;
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp98_ = next;
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp99_ = _tmp98_->event;
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp100_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp99_);
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp101_ = g_strdup_printf ("Unable to retrieve file ID for %s, dropping %s", _tmp97_, (_tmp100_ != NULL) ? _tmp100_->value_name : NULL);
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp102_ = _tmp101_;
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp102_);
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp102_);
#line 1177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp97_);
#line 1180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (n);
#line 1180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 6088 "DirectoryMonitor.c"
			}
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp104_ = next;
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp105_ = _tmp104_->info;
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp105_ != NULL) {
#line 6096 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp106_ = NULL;
				GFileInfo* _tmp107_ = NULL;
				gboolean _tmp108_ = FALSE;
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp106_ = next;
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp107_ = _tmp106_->info;
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp108_ = directory_monitor_is_file_symlink_supported (_tmp107_);
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp103_ = !_tmp108_;
#line 6108 "DirectoryMonitor.c"
			} else {
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp103_ = FALSE;
#line 6112 "DirectoryMonitor.c"
			}
#line 1184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp103_) {
#line 6116 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp109_ = NULL;
				GFile* _tmp110_ = NULL;
				gchar* _tmp111_ = NULL;
				gchar* _tmp112_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp113_ = NULL;
				GFileMonitorEvent _tmp114_ = 0;
				GEnumValue* _tmp115_;
				gchar* _tmp116_ = NULL;
				gchar* _tmp117_ = NULL;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp109_ = next;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp110_ = _tmp109_->file;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp111_ = g_file_get_path (_tmp110_);
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp112_ = _tmp111_;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp113_ = next;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp114_ = _tmp113_->event;
#line 1186 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp115_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp114_);
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp116_ = g_strdup_printf ("No symlink support for %s, dropping %s", _tmp112_, (_tmp115_ != NULL) ? _tmp115_->value_name : NULL);
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp117_ = _tmp116_;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp117_);
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp117_);
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp112_);
#line 1188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (n);
#line 1188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 6156 "DirectoryMonitor.c"
			}
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp118_ = next;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp119_ = _tmp118_->file;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp120_ = next;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp121_ = _tmp120_->other_file;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp122_ = next;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp123_ = _tmp122_->info;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp124_ = next;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp125_ = _tmp124_->event;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_on_monitor_notification_ready (self, _tmp119_, _tmp121_, _tmp123_, _tmp125_);
#line 1155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_directory_monitor_query_info_queue_element_unref0 (n);
#line 1155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_directory_monitor_query_info_queue_element_unref0 (next);
#line 6180 "DirectoryMonitor.c"
		}
	}
}


static void directory_monitor_on_monitor_notification_ready (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileInfo* info, GFileMonitorEvent event) {
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileMonitorEvent _tmp5_ = 0;
	GEnumValue* _tmp6_;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GFileMonitorEvent _tmp12_ = 0;
#line 1195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((other_file == NULL) || G_IS_FILE (other_file));
#line 1195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = other_file;
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp1_ != NULL) {
#line 6209 "DirectoryMonitor.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = other_file;
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp3_;
#line 6220 "DirectoryMonitor.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = g_strdup ("(null)");
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp4_;
#line 6229 "DirectoryMonitor.c"
	}
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = event;
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp5_);
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = file;
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = _tmp8_;
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = g_strdup_printf ("READY %s: file=%s other_file=%s", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL, _tmp9_, _tmp0_);
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = _tmp10_;
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp11_);
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp11_);
#line 1197 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp9_);
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = event;
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp12_) {
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CREATED:
#line 6257 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp13_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp14_ = NULL;
			DirectoryMonitorFType _tmp15_ = 0;
			DirectoryMonitorFType _tmp16_ = 0;
#line 1204 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = info;
#line 1204 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp13_ != NULL, "info != null");
#line 1206 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp14_ = info;
#line 1206 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp15_ = directory_monitor_get_ftype (_tmp14_);
#line 1206 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp15_;
#line 1207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp16_ = ftype;
#line 1207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp16_) {
#line 1207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6280 "DirectoryMonitor.c"
				{
					GFile* _tmp17_ = NULL;
					GFileInfo* _tmp18_ = NULL;
#line 1209 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp17_ = file;
#line 1209 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp18_ = info;
#line 1209 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_created (self, _tmp17_, _tmp18_);
#line 1210 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6292 "DirectoryMonitor.c"
				}
#line 1207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6296 "DirectoryMonitor.c"
				{
					gint _tmp19_ = 0;
					GFile* _tmp20_ = NULL;
					GFileInfo* _tmp21_ = NULL;
#line 1217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp19_ = self->priv->outstanding_exploration_dirs;
#line 1217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					self->priv->outstanding_exploration_dirs = _tmp19_ + 1;
#line 1218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp20_ = file;
#line 1218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp21_ = info;
#line 1218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_async (self, _tmp20_, _tmp21_, FALSE, NULL, NULL);
#line 1219 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6313 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp22_ = 0;
#line 1222 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp22_ = ftype;
#line 1222 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp22_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6324 "DirectoryMonitor.c"
				}
			}
#line 1225 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6329 "DirectoryMonitor.c"
		}
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CHANGED:
#line 6333 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp23_ = NULL;
			GFileInfo* local_info = NULL;
			GFile* _tmp24_ = NULL;
			GFileInfo* _tmp25_ = NULL;
			GFileInfo* _tmp26_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp32_ = NULL;
			DirectoryMonitorFType _tmp33_ = 0;
			DirectoryMonitorFType _tmp34_ = 0;
#line 1229 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp23_ = info;
#line 1229 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp23_ == NULL, "info == null");
#line 1231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp24_ = file;
#line 1231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp25_ = directory_monitor_get_file_info (self, _tmp24_);
#line 1231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			local_info = _tmp25_;
#line 1232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp26_ = local_info;
#line 1232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp26_ == NULL) {
#line 6358 "DirectoryMonitor.c"
				GFile* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp27_ = file;
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp28_ = g_file_get_path (_tmp27_);
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp29_ = _tmp28_;
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp30_ = g_strdup_printf ("Changed event for unknown file %s", _tmp29_);
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp31_ = _tmp30_;
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp31_);
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp31_);
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp29_);
#line 1235 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (local_info);
#line 1235 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 6384 "DirectoryMonitor.c"
			}
#line 1238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp32_ = local_info;
#line 1238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp33_ = directory_monitor_get_ftype (_tmp32_);
#line 1238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp33_;
#line 1239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp34_ = ftype;
#line 1239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp34_) {
#line 1239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6398 "DirectoryMonitor.c"
				{
					GFile* _tmp35_ = NULL;
#line 1241 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp35_ = file;
#line 1241 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_file_altered (self, _tmp35_);
#line 1242 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6407 "DirectoryMonitor.c"
				}
#line 1239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6411 "DirectoryMonitor.c"
				{
					GFile* _tmp36_ = NULL;
#line 1245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp36_ = file;
#line 1245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_directory_altered (self, _tmp36_);
#line 1246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6420 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp37_ = 0;
#line 1249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp37_ = ftype;
#line 1249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp37_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1250 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6431 "DirectoryMonitor.c"
				}
			}
#line 1252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 1252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6438 "DirectoryMonitor.c"
		}
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 6442 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp38_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp39_ = NULL;
			DirectoryMonitorFType _tmp40_ = 0;
			DirectoryMonitorFType _tmp41_ = 0;
#line 1255 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp38_ = info;
#line 1255 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp38_ != NULL, "info != null");
#line 1257 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp39_ = info;
#line 1257 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp40_ = directory_monitor_get_ftype (_tmp39_);
#line 1257 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp40_;
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp41_ = ftype;
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp41_) {
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6465 "DirectoryMonitor.c"
				{
					GFile* _tmp42_ = NULL;
					GFileInfo* _tmp43_ = NULL;
#line 1260 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp42_ = file;
#line 1260 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp43_ = info;
#line 1260 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_alteration_completed (self, _tmp42_, _tmp43_);
#line 1261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6477 "DirectoryMonitor.c"
				}
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6481 "DirectoryMonitor.c"
				{
					GFile* _tmp44_ = NULL;
					GFileInfo* _tmp45_ = NULL;
#line 1264 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp44_ = file;
#line 1264 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp45_ = info;
#line 1264 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_directory_alteration_completed (self, _tmp44_, _tmp45_);
#line 1265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6493 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp46_ = 0;
#line 1268 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp46_ = ftype;
#line 1268 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp46_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6504 "DirectoryMonitor.c"
				}
			}
#line 1271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6509 "DirectoryMonitor.c"
		}
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_MOVED:
#line 6513 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp47_ = NULL;
			GFile* _tmp48_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp49_ = NULL;
			DirectoryMonitorFType _tmp50_ = 0;
			DirectoryMonitorFType _tmp51_ = 0;
#line 1274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp47_ = info;
#line 1274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp47_ != NULL, "info != null");
#line 1275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp48_ = other_file;
#line 1275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp48_ != NULL, "other_file != null");
#line 1279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp49_ = info;
#line 1279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp50_ = directory_monitor_get_ftype (_tmp49_);
#line 1279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp50_;
#line 1280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp51_ = ftype;
#line 1280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp51_) {
#line 1280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6541 "DirectoryMonitor.c"
				{
					GFile* _tmp52_ = NULL;
					GFile* _tmp53_ = NULL;
					GFileInfo* _tmp54_ = NULL;
#line 1282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp52_ = file;
#line 1282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp53_ = other_file;
#line 1282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp54_ = info;
#line 1282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_moved (self, _tmp52_, _tmp53_, _tmp54_);
#line 1283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6556 "DirectoryMonitor.c"
				}
#line 1280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6560 "DirectoryMonitor.c"
				{
					GFileInfo* old_dir_info = NULL;
					DirectoryMonitorFileInfoMap* _tmp55_ = NULL;
					GFile* _tmp56_ = NULL;
					GFileInfo* _tmp57_ = NULL;
					GFileInfo* _tmp58_ = NULL;
					GFile* _tmp62_ = NULL;
					GFileInfo* _tmp63_ = NULL;
					GFile* _tmp64_ = NULL;
					GFileInfo* _tmp65_ = NULL;
#line 1287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp55_ = self->priv->files;
#line 1287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp56_ = file;
#line 1287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp57_ = directory_monitor_file_info_map_get_info (_tmp55_, _tmp56_);
#line 1287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					old_dir_info = _tmp57_;
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp58_ = old_dir_info;
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp58_ == NULL) {
#line 6583 "DirectoryMonitor.c"
						GFile* _tmp59_ = NULL;
						gchar* _tmp60_ = NULL;
						gchar* _tmp61_ = NULL;
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp59_ = file;
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp60_ = g_file_get_path (_tmp59_);
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp61_ = _tmp60_;
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						g_warning ("DirectoryMonitor.vala:1289: Directory moved event for unknown file %s", _tmp61_);
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_g_free0 (_tmp61_);
#line 1291 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_g_object_unref0 (old_dir_info);
#line 1291 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						break;
#line 6601 "DirectoryMonitor.c"
					}
#line 1294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp62_ = file;
#line 1294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp63_ = old_dir_info;
#line 1294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp64_ = other_file;
#line 1294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp65_ = info;
#line 1294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_directory_moved (self, _tmp62_, _tmp63_, _tmp64_, _tmp65_);
#line 1295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (old_dir_info);
#line 1295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6617 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp66_ = 0;
#line 1298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp66_ = ftype;
#line 1298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp66_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6628 "DirectoryMonitor.c"
				}
			}
#line 1301 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6633 "DirectoryMonitor.c"
		}
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_DELETED:
#line 6637 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp67_ = NULL;
			GFileInfo* local_info = NULL;
			GFile* _tmp68_ = NULL;
			GFileInfo* _tmp69_ = NULL;
			GFileInfo* _tmp70_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp74_ = NULL;
			DirectoryMonitorFType _tmp75_ = 0;
			DirectoryMonitorFType _tmp76_ = 0;
#line 1304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp67_ = info;
#line 1304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp67_ == NULL, "info == null");
#line 1306 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp68_ = file;
#line 1306 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp69_ = directory_monitor_get_file_info (self, _tmp68_);
#line 1306 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			local_info = _tmp69_;
#line 1307 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp70_ = local_info;
#line 1307 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp70_ == NULL) {
#line 6662 "DirectoryMonitor.c"
				GFile* _tmp71_ = NULL;
				gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp71_ = file;
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp72_ = g_file_get_path (_tmp71_);
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp73_ = _tmp72_;
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_warning ("DirectoryMonitor.vala:1308: Deleted event for unknown file %s", _tmp73_);
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp73_);
#line 1310 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (local_info);
#line 1310 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 6680 "DirectoryMonitor.c"
			}
#line 1313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp74_ = local_info;
#line 1313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp75_ = directory_monitor_get_ftype (_tmp74_);
#line 1313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp75_;
#line 1314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp76_ = ftype;
#line 1314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp76_) {
#line 1314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6694 "DirectoryMonitor.c"
				{
					GFile* _tmp77_ = NULL;
#line 1316 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp77_ = file;
#line 1316 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_deleted (self, _tmp77_);
#line 1317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6703 "DirectoryMonitor.c"
				}
#line 1314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6707 "DirectoryMonitor.c"
				{
					GFile* _tmp78_ = NULL;
#line 1320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp78_ = file;
#line 1320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_directory_deleted (self, _tmp78_);
#line 1321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6716 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp79_ = 0;
#line 1324 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp79_ = ftype;
#line 1324 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp79_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1325 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6727 "DirectoryMonitor.c"
				}
			}
#line 1327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 1327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6734 "DirectoryMonitor.c"
		}
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
#line 6738 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp80_ = NULL;
			GFileInfo* local_info = NULL;
			GFile* _tmp81_ = NULL;
			GFileInfo* _tmp82_ = NULL;
			GFileInfo* _tmp83_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp87_ = NULL;
			DirectoryMonitorFType _tmp88_ = 0;
			DirectoryMonitorFType _tmp89_ = 0;
#line 1331 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp80_ = info;
#line 1331 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp80_ == NULL, "info == null");
#line 1333 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp81_ = file;
#line 1333 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp82_ = directory_monitor_get_file_info (self, _tmp81_);
#line 1333 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			local_info = _tmp82_;
#line 1334 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp83_ = local_info;
#line 1334 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp83_ == NULL) {
#line 6763 "DirectoryMonitor.c"
				GFile* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_ = NULL;
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp84_ = file;
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp85_ = g_file_get_path (_tmp84_);
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp86_ = _tmp85_;
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_warning ("DirectoryMonitor.vala:1335: Attribute changed event for unknown file %" \
"s", _tmp86_);
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp86_);
#line 1337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (local_info);
#line 1337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 6781 "DirectoryMonitor.c"
			}
#line 1340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp87_ = local_info;
#line 1340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp88_ = directory_monitor_get_ftype (_tmp87_);
#line 1340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp88_;
#line 1341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp89_ = ftype;
#line 1341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp89_) {
#line 1341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6795 "DirectoryMonitor.c"
				{
					GFile* _tmp90_ = NULL;
#line 1343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp90_ = file;
#line 1343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_file_attributes_altered (self, _tmp90_);
#line 1344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6804 "DirectoryMonitor.c"
				}
#line 1341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6808 "DirectoryMonitor.c"
				{
					GFile* _tmp91_ = NULL;
#line 1347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp91_ = file;
#line 1347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_directory_attributes_altered (self, _tmp91_);
#line 1348 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6817 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp92_ = 0;
#line 1351 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp92_ = ftype;
#line 1351 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp92_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1352 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6828 "DirectoryMonitor.c"
				}
			}
#line 1354 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 1354 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6835 "DirectoryMonitor.c"
		}
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_PRE_UNMOUNT:
#line 1202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_UNMOUNTED:
#line 6841 "DirectoryMonitor.c"
		{
#line 1359 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6845 "DirectoryMonitor.c"
		}
		default:
		{
			GFileMonitorEvent _tmp93_ = 0;
			GEnumValue* _tmp94_;
#line 1362 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp93_ = event;
#line 1362 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp94_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp93_);
#line 1362 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_warning ("DirectoryMonitor.vala:1362: Unknown directory monitor event %s", (_tmp94_ != NULL) ? _tmp94_->value_name : NULL);
#line 1363 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6859 "DirectoryMonitor.c"
		}
	}
#line 1195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp0_);
#line 6864 "DirectoryMonitor.c"
}


static gboolean directory_monitor_is_file_create_move (DirectoryMonitor* self, GFile* file, GFileInfo* info, GFile** old_file, GFileInfo** old_file_info) {
	GFile* _vala_old_file = NULL;
	GFileInfo* _vala_old_file_info = NULL;
	gboolean result = FALSE;
	GFile* match = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->parent_moved;
#line 1372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 1372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_find_match (_tmp0_, _tmp1_);
#line 1372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match = _tmp2_;
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = match;
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp3_ != NULL) {
#line 6895 "DirectoryMonitor.c"
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		DirectoryMonitorFileInfoMap* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFileInfo* _tmp8_ = NULL;
		DirectoryMonitorFileInfoMap* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileInfo* _tmp11_ = NULL;
#line 1374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = match;
#line 1374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 1374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file);
#line 1374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_old_file = _tmp5_;
#line 1375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = self->priv->parent_moved;
#line 1375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = match;
#line 1375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = directory_monitor_file_info_map_get_info (_tmp6_, _tmp7_);
#line 1375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file_info);
#line 1375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_old_file_info = _tmp8_;
#line 1377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = self->priv->parent_moved;
#line 1377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = match;
#line 1377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = info;
#line 1377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove (_tmp9_, _tmp10_, _tmp11_);
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = TRUE;
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (match);
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (old_file) {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*old_file = _vala_old_file;
#line 6938 "DirectoryMonitor.c"
		} else {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_old_file);
#line 6942 "DirectoryMonitor.c"
		}
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (old_file_info) {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*old_file_info = _vala_old_file_info;
#line 6948 "DirectoryMonitor.c"
		} else {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_old_file_info);
#line 6952 "DirectoryMonitor.c"
		}
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 6956 "DirectoryMonitor.c"
	}
#line 1382 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_vala_old_file);
#line 1382 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_old_file = NULL;
#line 1383 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_vala_old_file_info);
#line 1383 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_old_file_info = NULL;
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = FALSE;
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (match);
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old_file) {
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*old_file = _vala_old_file;
#line 6974 "DirectoryMonitor.c"
	} else {
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file);
#line 6978 "DirectoryMonitor.c"
	}
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old_file_info) {
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*old_file_info = _vala_old_file_info;
#line 6984 "DirectoryMonitor.c"
	} else {
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file_info);
#line 6988 "DirectoryMonitor.c"
	}
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 6992 "DirectoryMonitor.c"
}


static gboolean directory_monitor_check_for_expired_delete_events (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gulong expiration = 0UL;
	gulong _tmp0_ = 0UL;
	gboolean any_deleted = FALSE;
	gboolean any_expired = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
#line 1388 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1389 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = now_ms ();
#line 1389 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	expiration = _tmp0_ - DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC;
#line 1391 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	any_deleted = FALSE;
#line 1392 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	any_expired = FALSE;
#line 7014 "DirectoryMonitor.c"
	{
		GeeIterator* _element_it = NULL;
		GeeQueue* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = self->priv->query_info_queue;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_element_it = _tmp2_;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 7027 "DirectoryMonitor.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* element = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp7_ = NULL;
			GFileMonitorEvent _tmp8_ = 0;
			DirectoryMonitorQueryInfoQueueElement* _tmp9_ = NULL;
			gulong _tmp10_ = 0UL;
			gulong _tmp11_ = 0UL;
			DirectoryMonitorQueryInfoQueueElement* _tmp12_ = NULL;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp3_ = _element_it;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp4_) {
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 7047 "DirectoryMonitor.c"
			}
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = _element_it;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			element = (DirectoryMonitorQueryInfoQueueElement*) _tmp6_;
#line 1394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = element;
#line 1394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = _tmp7_->event;
#line 1394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp8_ != G_FILE_MONITOR_EVENT_DELETED) {
#line 1395 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (element);
#line 1395 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 7065 "DirectoryMonitor.c"
			}
#line 1397 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			any_deleted = TRUE;
#line 1399 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = element;
#line 1399 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = _tmp9_->time_created_msec;
#line 1399 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = expiration;
#line 1399 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp10_ > _tmp11_) {
#line 1400 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (element);
#line 1400 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 7081 "DirectoryMonitor.c"
			}
#line 1403 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp12_ = element;
#line 1403 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp12_->completed = TRUE;
#line 1404 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			any_expired = TRUE;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_directory_monitor_query_info_queue_element_unref0 (element);
#line 7091 "DirectoryMonitor.c"
		}
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_element_it);
#line 7095 "DirectoryMonitor.c"
	}
#line 1407 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = any_expired;
#line 1407 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp13_) {
#line 1408 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_process_query_queue (self, NULL);
#line 7103 "DirectoryMonitor.c"
	}
#line 1410 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = any_deleted;
#line 1410 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp14_) {
#line 1411 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		self->priv->delete_timer_id = (guint) 0;
#line 7111 "DirectoryMonitor.c"
	}
#line 1413 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = any_deleted;
#line 1413 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7117 "DirectoryMonitor.c"
}


GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self, GFile* file) {
	GFileInfo* result = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
#line 1417 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 1417 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_get_info (_tmp0_, _tmp1_);
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp2_;
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7140 "DirectoryMonitor.c"
}


GeeCollection* directory_monitor_get_files (DirectoryMonitor* self) {
	GeeCollection* result = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 1423 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 1424 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 1424 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = directory_monitor_file_info_map_get_all (_tmp0_);
#line 1424 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp1_;
#line 1424 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7158 "DirectoryMonitor.c"
}


GFileInfo* directory_monitor_query_file_info (DirectoryMonitor* self, GFile* file) {
	GFileInfo* result = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
#line 1430 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 1430 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 1431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 1431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = self->priv->cancellable;
#line 1431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_query_info (_tmp0_, _tmp1_, _tmp2_);
#line 1431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp3_;
#line 1431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7184 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_file_symlink_supported (GFileInfo* info) {
	gboolean result = FALSE;
	GFileInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	DirectoryMonitorFType ftype = 0;
	GFileInfo* _tmp2_ = NULL;
	DirectoryMonitorFType _tmp3_ = 0;
	DirectoryMonitorFType _tmp4_ = 0;
#line 1441 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 1442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_info_get_is_symlink (_tmp0_);
#line 1442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp1_) {
#line 1443 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = TRUE;
#line 1443 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 7208 "DirectoryMonitor.c"
	}
#line 1445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 1445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_get_ftype (_tmp2_);
#line 1445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	ftype = _tmp3_;
#line 1446 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = ftype;
#line 1446 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp4_) {
#line 1446 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 7222 "DirectoryMonitor.c"
		{
#line 1448 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_SUPPORT_DIR_SYMLINKS;
#line 1448 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7228 "DirectoryMonitor.c"
		}
#line 1446 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case DIRECTORY_MONITOR_FTYPE_FILE:
#line 7232 "DirectoryMonitor.c"
		{
#line 1451 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_SUPPORT_FILE_SYMLINKS;
#line 1451 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7238 "DirectoryMonitor.c"
		}
		default:
		{
			DirectoryMonitorFType _tmp5_ = 0;
#line 1454 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = ftype;
#line 1454 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp5_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1456 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = FALSE;
#line 1456 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7251 "DirectoryMonitor.c"
		}
	}
}


static void directory_monitor_real_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
#line 386 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_root));
#line 386 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_root));
#line 386 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_root_info));
#line 7264 "DirectoryMonitor.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (n_param_values == 4);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = closure->data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 7283 "DirectoryMonitor.c"
	} else {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = closure->data;
#line 7289 "DirectoryMonitor.c"
	}
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
#line 7295 "DirectoryMonitor.c"
}


static void directory_monitor_real_root_deleted (DirectoryMonitor* self, GFile* root) {
#line 394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (root));
#line 7302 "DirectoryMonitor.c"
}


static void directory_monitor_real_discovery_started (DirectoryMonitor* self) {
}


static void directory_monitor_real_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 400 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 400 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7315 "DirectoryMonitor.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (n_param_values == 3);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = closure->data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 7334 "DirectoryMonitor.c"
	} else {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = closure->data;
#line 7340 "DirectoryMonitor.c"
	}
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 7346 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 403 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 403 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7355 "DirectoryMonitor.c"
}


static void directory_monitor_real_discovery_failed (DirectoryMonitor* self, const gchar* reason) {
#line 408 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (reason != NULL);
#line 7362 "DirectoryMonitor.c"
}


static void directory_monitor_real_discovery_completed (DirectoryMonitor* self) {
#line 412 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->has_discovery_started = FALSE;
#line 413 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg ("discovery completed");
#line 7371 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 416 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 416 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7380 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
#line 419 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 419 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 419 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_file_info));
#line 7391 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_altered (DirectoryMonitor* self, GFile* file) {
#line 423 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 7398 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 428 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 428 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7407 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_attributes_altered (DirectoryMonitor* self, GFile* file) {
#line 431 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 7414 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_deleted (DirectoryMonitor* self, GFile* file) {
#line 434 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 7421 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 438 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 438 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7430 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info) {
#line 442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_dir));
#line 442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_dir));
#line 442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_dir_info));
#line 7441 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_altered (DirectoryMonitor* self, GFile* dir) {
#line 446 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 7448 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 451 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 451 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7457 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_attributes_altered (DirectoryMonitor* self, GFile* dir) {
#line 454 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 7464 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_deleted (DirectoryMonitor* self, GFile* dir) {
#line 458 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 7471 "DirectoryMonitor.c"
}


static void directory_monitor_real_closed (DirectoryMonitor* self) {
}


static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_construct (GType object_type, DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	DirectoryMonitorQueryInfoQueueElement* self = NULL;
	DirectoryMonitor* _tmp0_ = NULL;
	DirectoryMonitor* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileMonitorEvent _tmp6_ = 0;
	guint _tmp7_ = 0U;
	gulong _tmp8_ = 0UL;
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (owner), NULL);
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((other_file == NULL) || G_IS_FILE (other_file), NULL);
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = (DirectoryMonitorQueryInfoQueueElement*) g_type_create_instance (object_type);
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = owner;
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->owner);
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->owner = _tmp1_;
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = file;
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->file);
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->file = _tmp3_;
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = other_file;
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->other_file);
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->other_file = _tmp5_;
#line 101 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = event;
#line 101 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->event = _tmp6_;
#line 102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = directory_monitor_query_info_queue_element_current;
#line 102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_current = _tmp7_ + 1;
#line 102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->position = _tmp7_;
#line 103 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = now_ms ();
#line 103 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->time_created_msec = _tmp8_;
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self;
#line 7538 "DirectoryMonitor.c"
}


static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_new (DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event) {
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return directory_monitor_query_info_queue_element_construct (DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, owner, file, other_file, event);
#line 7545 "DirectoryMonitor.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self ? g_error_copy (self) : NULL;
#line 7552 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_on_completed (DirectoryMonitorQueryInfoQueueElement* self, GObject* source, GAsyncResult* aresult) {
	GFile* source_file = NULL;
	GObject* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DirectoryMonitor* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT (self));
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((source == NULL) || G_IS_OBJECT (source));
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_ASYNC_RESULT (aresult));
#line 107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = source;
#line 107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_file_get_type (), GFile));
#line 107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	source_file = _tmp1_;
#line 7574 "DirectoryMonitor.c"
	{
		GFileInfo* _tmp2_ = NULL;
		GAsyncResult* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
		GFileInfo* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = aresult;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = g_file_query_info_finish (source_file, _tmp3_, &_inner_error_);
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp4_;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7592 "DirectoryMonitor.c"
			goto __catch483_g_error;
		}
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _tmp2_;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = NULL;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (self->info);
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		self->info = _tmp5_;
#line 112 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = self->info;
#line 112 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = get_file_info_id (_tmp6_);
#line 112 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = _tmp7_;
#line 112 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp8_ == NULL;
#line 112 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp8_);
#line 112 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_tmp9_) {
#line 7615 "DirectoryMonitor.c"
			GFileInfo* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = self->info;
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = self->file;
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp12_ = g_file_get_uri (_tmp11_);
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = _tmp12_;
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_info_set_attribute_string (_tmp10_, G_FILE_ATTRIBUTE_ID_FILE, _tmp13_);
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp13_);
#line 7632 "DirectoryMonitor.c"
		}
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 7636 "DirectoryMonitor.c"
	}
	goto __finally483;
	__catch483_g_error:
	{
		GError* err = NULL;
		GError* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		err = _inner_error_;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_inner_error_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = err;
#line 117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _g_error_copy0 (_tmp14_);
#line 117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (self->err);
#line 117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		self->err = _tmp15_;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (err);
#line 7658 "DirectoryMonitor.c"
	}
	__finally483:
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (source_file);
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return;
#line 7671 "DirectoryMonitor.c"
	}
#line 121 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->completed = TRUE;
#line 124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = self->owner;
#line 124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_process_query_queue (_tmp16_, self);
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (source_file);
#line 7681 "DirectoryMonitor.c"
}


static void directory_monitor_value_query_info_queue_element_init (GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 7688 "DirectoryMonitor.c"
}


static void directory_monitor_value_query_info_queue_element_free_value (GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_unref (value->data[0].v_pointer);
#line 7697 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_query_info_queue_element_copy_value (const GValue* src_value, GValue* dest_value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = directory_monitor_query_info_queue_element_ref (src_value->data[0].v_pointer);
#line 7707 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7711 "DirectoryMonitor.c"
	}
}


static gpointer directory_monitor_value_query_info_queue_element_peek_pointer (const GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 7719 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_query_info_queue_element_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 7726 "DirectoryMonitor.c"
		DirectoryMonitorQueryInfoQueueElement* object;
		object = collect_values[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7733 "DirectoryMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7737 "DirectoryMonitor.c"
		}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = directory_monitor_query_info_queue_element_ref (object);
#line 7741 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 7745 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 7749 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_query_info_queue_element_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DirectoryMonitorQueryInfoQueueElement** object_p;
	object_p = collect_values[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!object_p) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7760 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = NULL;
#line 7766 "DirectoryMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 7770 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = directory_monitor_query_info_queue_element_ref (value->data[0].v_pointer);
#line 7774 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 7778 "DirectoryMonitor.c"
}


static GParamSpec* directory_monitor_param_spec_query_info_queue_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DirectoryMonitorParamSpecQueryInfoQueueElement* spec;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT), NULL);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 7792 "DirectoryMonitor.c"
}


static gpointer directory_monitor_value_get_query_info_queue_element (const GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT), NULL);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 7801 "DirectoryMonitor.c"
}


static void directory_monitor_value_set_query_info_queue_element (GValue* value, gpointer v_object) {
	DirectoryMonitorQueryInfoQueueElement* old;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_ref (value->data[0].v_pointer);
#line 7821 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 7825 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_unref (old);
#line 7831 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_take_query_info_queue_element (GValue* value, gpointer v_object) {
	DirectoryMonitorQueryInfoQueueElement* old;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 7850 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 7854 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_unref (old);
#line 7860 "DirectoryMonitor.c"
	}
}


static void directory_monitor_query_info_queue_element_class_init (DirectoryMonitorQueryInfoQueueElementClass * klass) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_parent_class = g_type_class_peek_parent (klass);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorQueryInfoQueueElementClass *) klass)->finalize = directory_monitor_query_info_queue_element_finalize;
#line 7870 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_instance_init (DirectoryMonitorQueryInfoQueueElement * self) {
#line 92 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->info = NULL;
#line 93 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->err = NULL;
#line 94 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->completed = FALSE;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->ref_count = 1;
#line 7883 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_finalize (DirectoryMonitorQueryInfoQueueElement* obj) {
	DirectoryMonitorQueryInfoQueueElement * self;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElement);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_handlers_destroy (self);
#line 86 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->owner);
#line 87 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->file);
#line 88 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->other_file);
#line 92 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->info);
#line 93 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_error_free0 (self->err);
#line 7903 "DirectoryMonitor.c"
}


static GType directory_monitor_query_info_queue_element_get_type (void) {
	static volatile gsize directory_monitor_query_info_queue_element_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_query_info_queue_element_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { directory_monitor_value_query_info_queue_element_init, directory_monitor_value_query_info_queue_element_free_value, directory_monitor_value_query_info_queue_element_copy_value, directory_monitor_value_query_info_queue_element_peek_pointer, "p", directory_monitor_value_query_info_queue_element_collect_value, "p", directory_monitor_value_query_info_queue_element_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorQueryInfoQueueElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_query_info_queue_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitorQueryInfoQueueElement), 0, (GInstanceInitFunc) directory_monitor_query_info_queue_element_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType directory_monitor_query_info_queue_element_type_id;
		directory_monitor_query_info_queue_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DirectoryMonitorQueryInfoQueueElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&directory_monitor_query_info_queue_element_type_id__volatile, directory_monitor_query_info_queue_element_type_id);
	}
	return directory_monitor_query_info_queue_element_type_id__volatile;
}


static gpointer directory_monitor_query_info_queue_element_ref (gpointer instance) {
	DirectoryMonitorQueryInfoQueueElement* self;
	self = instance;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return instance;
#line 7928 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_unref (gpointer instance) {
	DirectoryMonitorQueryInfoQueueElement* self;
	self = instance;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_GET_CLASS (self)->finalize (self);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7941 "DirectoryMonitor.c"
	}
}


static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_construct (GType object_type) {
	DirectoryMonitorFileInfoMap* self = NULL;
#line 138 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = (DirectoryMonitorFileInfoMap*) g_type_create_instance (object_type);
#line 138 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self;
#line 7952 "DirectoryMonitor.c"
}


static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_new (void) {
#line 138 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return directory_monitor_file_info_map_construct (DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP);
#line 7959 "DirectoryMonitor.c"
}


static gboolean directory_monitor_file_info_map_normalize_file (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info, GFile** normalized, gchar** id) {
	GFile* _vala_normalized = NULL;
	gchar* _vala_id = NULL;
	gboolean result = FALSE;
	GFileInfo* local_info = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gchar* file_id = NULL;
	GFileInfo* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GFile* known_file = NULL;
	GeeHashMap* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	GFile* _tmp19_ = NULL;
#line 141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), FALSE);
#line 144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	local_info = _tmp1_;
#line 145 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = local_info;
#line 145 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ == NULL) {
#line 8000 "DirectoryMonitor.c"
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = self->priv->map;
#line 146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (local_info);
#line 146 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		local_info = (GFileInfo*) _tmp5_;
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = local_info;
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_tmp6_ == NULL) {
#line 148 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_normalized);
#line 148 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_normalized = NULL;
#line 149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_vala_id);
#line 149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_id = NULL;
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = FALSE;
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (normalized) {
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				*normalized = _vala_normalized;
#line 8035 "DirectoryMonitor.c"
			} else {
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_vala_normalized);
#line 8039 "DirectoryMonitor.c"
			}
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (id) {
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				*id = _vala_id;
#line 8045 "DirectoryMonitor.c"
			} else {
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_vala_id);
#line 8049 "DirectoryMonitor.c"
			}
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 8053 "DirectoryMonitor.c"
		}
	}
#line 155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = local_info;
#line 155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = get_file_info_id (_tmp7_);
#line 155 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	file_id = _tmp8_;
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = file_id;
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp9_ == NULL) {
#line 157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_normalized);
#line 157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_normalized = NULL;
#line 158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_vala_id);
#line 158 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_id = NULL;
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (file_id);
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (local_info);
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (normalized) {
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*normalized = _vala_normalized;
#line 8084 "DirectoryMonitor.c"
		} else {
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_normalized);
#line 8088 "DirectoryMonitor.c"
		}
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (id) {
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*id = _vala_id;
#line 8094 "DirectoryMonitor.c"
		} else {
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_vala_id);
#line 8098 "DirectoryMonitor.c"
		}
#line 160 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8102 "DirectoryMonitor.c"
	}
#line 163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = self->priv->id_map;
#line 163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = file_id;
#line 163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_);
#line 163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	known_file = (GFile*) _tmp12_;
#line 165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = file_id;
#line 165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = g_strdup ((const gchar*) _tmp13_);
#line 165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_vala_id);
#line 165 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_id = _tmp14_;
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = known_file;
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp16_ != NULL) {
#line 8124 "DirectoryMonitor.c"
		GFile* _tmp17_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = known_file;
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _tmp17_;
#line 8130 "DirectoryMonitor.c"
	} else {
		GFile* _tmp18_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp18_ = file;
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _tmp18_;
#line 8137 "DirectoryMonitor.c"
	}
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = _g_object_ref0 (_tmp15_);
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_vala_normalized);
#line 166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_normalized = _tmp19_;
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (known_file);
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (file_id);
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (local_info);
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (normalized) {
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*normalized = _vala_normalized;
#line 8157 "DirectoryMonitor.c"
	} else {
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_normalized);
#line 8161 "DirectoryMonitor.c"
	}
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (id) {
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*id = _vala_id;
#line 8167 "DirectoryMonitor.c"
	} else {
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_vala_id);
#line 8171 "DirectoryMonitor.c"
	}
#line 168 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8175 "DirectoryMonitor.c"
}


static gboolean directory_monitor_file_info_map_update (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* existing_id = NULL;
	GFileInfo* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp18_ = NULL;
	GFileInfo* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeHashMap* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	GFileInfo* _tmp25_ = NULL;
	GeeHashMap* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 173 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->map;
#line 173 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 173 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 173 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_) {
#line 8216 "DirectoryMonitor.c"
		gboolean removed = FALSE;
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = self->priv->map;
#line 174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
#line 174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		removed = _tmp5_;
#line 175 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = removed;
#line 175 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp6_, "removed");
#line 8234 "DirectoryMonitor.c"
	}
#line 179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = info;
#line 179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = get_file_info_id (_tmp7_);
#line 179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	existing_id = _tmp8_;
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = existing_id;
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp10_ != NULL) {
#line 8246 "DirectoryMonitor.c"
		GeeHashMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = self->priv->id_map;
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = existing_id;
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_);
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp13_;
#line 8258 "DirectoryMonitor.c"
	} else {
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = FALSE;
#line 8262 "DirectoryMonitor.c"
	}
#line 180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp9_) {
#line 8266 "DirectoryMonitor.c"
		gboolean removed = FALSE;
		GeeHashMap* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
#line 181 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = self->priv->id_map;
#line 181 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = existing_id;
#line 181 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_, NULL);
#line 181 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		removed = _tmp16_;
#line 182 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = removed;
#line 182 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp17_, "removed");
#line 8284 "DirectoryMonitor.c"
	}
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = file;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = info;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp22_ = directory_monitor_file_info_map_normalize_file (self, _tmp18_, _tmp19_, &_tmp20_, &_tmp21_);
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp20_;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp21_;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp22_) {
#line 188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (existing_id);
#line 188 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8312 "DirectoryMonitor.c"
	}
#line 190 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp23_ = self->priv->map;
#line 190 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp24_ = normalized;
#line 190 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp25_ = info;
#line 190 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_, _tmp25_);
#line 191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp26_ = self->priv->id_map;
#line 191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp27_ = id;
#line 191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp28_ = normalized;
#line 191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, _tmp28_);
#line 193 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 193 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 193 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 193 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (existing_id);
#line 193 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8340 "DirectoryMonitor.c"
}


static gboolean directory_monitor_file_info_map_remove (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), FALSE);
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_normalize_file (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp3_;
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp4_) {
#line 200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8387 "DirectoryMonitor.c"
	}
#line 202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = self->priv->map;
#line 202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = normalized;
#line 202 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_, NULL);
#line 203 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = self->priv->id_map;
#line 203 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = id;
#line 203 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, NULL);
#line 205 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 205 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 205 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 205 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8409 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_remove_all (DirectoryMonitorFileInfoMap* self, GeeCollection* files) {
#line 210 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self));
#line 210 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (files));
#line 8418 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = files;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp1_;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 8431 "DirectoryMonitor.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp2_ = _file_it;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp3_) {
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 8446 "DirectoryMonitor.c"
			}
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp4_ = _file_it;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp5_;
#line 212 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = file;
#line 212 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_file_info_map_remove (self, _tmp6_, NULL);
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (file);
#line 8460 "DirectoryMonitor.c"
		}
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 8464 "DirectoryMonitor.c"
	}
}


static gboolean directory_monitor_file_info_map_contains (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), FALSE);
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_normalize_file (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp2_;
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp3_;
#line 218 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp4_) {
#line 219 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 219 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 219 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 219 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8511 "DirectoryMonitor.c"
	}
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = self->priv->id_map;
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = id;
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp7_;
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 221 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8527 "DirectoryMonitor.c"
}


static gchar* directory_monitor_file_info_map_get_id (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gchar* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 224 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 224 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 224 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), NULL);
#line 226 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 226 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp0_ != NULL) {
#line 8550 "DirectoryMonitor.c"
		GFileInfo* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = info;
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = get_file_info_id (_tmp1_);
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = _tmp2_;
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8561 "DirectoryMonitor.c"
	}
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = file;
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = directory_monitor_file_info_map_normalize_file (self, _tmp3_, NULL, &_tmp4_, &_tmp5_);
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp4_;
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp5_;
#line 231 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp6_) {
#line 232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8585 "DirectoryMonitor.c"
	}
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = id;
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8593 "DirectoryMonitor.c"
}


static GeeCollection* directory_monitor_file_info_map_get_all (DirectoryMonitorFileInfoMap* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->map;
#line 238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 238 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8614 "DirectoryMonitor.c"
}


static GFileInfo* directory_monitor_file_info_map_get_info (DirectoryMonitorFileInfoMap* self, GFile* file) {
	GFileInfo* result = NULL;
	GFileInfo* info = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeHashMap* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 241 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 243 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->map;
#line 243 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 243 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 243 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	info = (GFileInfo*) _tmp2_;
#line 244 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = info;
#line 244 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp3_ != NULL) {
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = info;
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8654 "DirectoryMonitor.c"
	}
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = file;
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = directory_monitor_file_info_map_normalize_file (self, _tmp4_, NULL, &_tmp5_, &_tmp6_);
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp5_;
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp6_;
#line 249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp7_) {
#line 250 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 250 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 250 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 250 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 250 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8680 "DirectoryMonitor.c"
	}
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = self->priv->map;
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = normalized;
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_);
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = (GFileInfo*) _tmp10_;
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (info);
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8698 "DirectoryMonitor.c"
}


static GFileInfo* directory_monitor_file_info_map_query_info (DirectoryMonitorFileInfoMap* self, GFile* file, GCancellable* cancellable) {
	GFileInfo* result = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gchar* id = NULL;
	GFileInfo* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GFile* normalized = NULL;
	GeeHashMap* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gpointer _tmp25_ = NULL;
	GFile* _tmp26_ = NULL;
	GeeHashMap* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	gpointer _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
#line 255 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 255 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 255 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), NULL);
#line 256 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 256 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = directory_monitor_file_info_map_get_info (self, _tmp0_);
#line 256 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	info = _tmp1_;
#line 257 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 257 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ != NULL) {
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = info;
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8744 "DirectoryMonitor.c"
	}
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = cancellable;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_ID_FILE, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, _tmp5_, &_inner_error_);
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp6_;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8762 "DirectoryMonitor.c"
			goto __catch484_g_error;
		}
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = _tmp3_;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		info = _tmp7_;
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 8775 "DirectoryMonitor.c"
	}
	goto __finally484;
	__catch484_g_error:
	{
		GError* err = NULL;
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		err = _inner_error_;
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_inner_error_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = file;
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = _tmp9_;
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = err;
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = _tmp11_->message;
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:265: Unable to query file ID of %s: %s", _tmp10_, _tmp12_);
#line 265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp10_);
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (err);
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8812 "DirectoryMonitor.c"
	}
	__finally484:
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return NULL;
#line 8825 "DirectoryMonitor.c"
	}
#line 270 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = info;
#line 270 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = directory_monitor_is_file_symlink_supported (_tmp13_);
#line 270 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp14_) {
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8839 "DirectoryMonitor.c"
	}
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp15_ = info;
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = g_file_info_get_attribute_string (_tmp15_, G_FILE_ATTRIBUTE_ID_FILE);
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp17_;
#line 274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = id;
#line 274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp18_ == NULL) {
#line 8853 "DirectoryMonitor.c"
		GFileInfo* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp19_ = info;
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp20_ = file;
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp21_ = g_file_get_uri (_tmp20_);
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp22_ = _tmp21_;
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_file_info_set_attribute_string (_tmp19_, G_FILE_ATTRIBUTE_ID_FILE, _tmp22_);
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp22_);
#line 8870 "DirectoryMonitor.c"
	}
#line 279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp23_ = self->priv->id_map;
#line 279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp24_ = id;
#line 279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp25_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_);
#line 279 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = (GFile*) _tmp25_;
#line 280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp26_ = normalized;
#line 280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp26_ == NULL) {
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8894 "DirectoryMonitor.c"
	}
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp27_ = self->priv->map;
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp28_ = file;
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp29_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp28_);
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = (GFileInfo*) _tmp29_;
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (info);
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8912 "DirectoryMonitor.c"
}


static GFile* directory_monitor_file_info_map_find_match (DirectoryMonitorFileInfoMap* self, GFileInfo* match) {
	GFile* result = NULL;
	gchar* match_id = NULL;
	GFileInfo* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint64 match_size = 0LL;
	GFileInfo* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	GTimeVal match_time = {0};
	GFileInfo* _tmp5_ = NULL;
	GTimeVal _tmp6_ = {0};
#line 286 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 286 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (match), NULL);
#line 287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = match;
#line 287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = get_file_info_id (_tmp0_);
#line 287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match_id = _tmp1_;
#line 288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = match_id;
#line 288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ == NULL) {
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (match_id);
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8948 "DirectoryMonitor.c"
	}
#line 292 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = match;
#line 292 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_info_get_size (_tmp3_);
#line 292 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match_size = _tmp4_;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = match;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_file_info_get_modification_time (_tmp5_, &_tmp6_);
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match_time = _tmp6_;
#line 8962 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeSet* _tmp9_ = NULL;
		GeeSet* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
		GeeIterator* _tmp12_ = NULL;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = self->priv->map;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp8_;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = _tmp9_;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = _tmp11_;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp10_);
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp12_;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 8989 "DirectoryMonitor.c"
			GeeIterator* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp15_ = NULL;
			gpointer _tmp16_ = NULL;
			GFileInfo* info = NULL;
			GeeHashMap* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			GFileInfo* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gint64 _tmp25_ = 0LL;
			GFileInfo* _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			GTimeVal time = {0};
			GFileInfo* _tmp28_ = NULL;
			GTimeVal _tmp29_ = {0};
			GTimeVal _tmp30_ = {0};
			glong _tmp31_ = 0L;
			GTimeVal _tmp32_ = {0};
			glong _tmp33_ = 0L;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = _file_it;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp14_ = gee_iterator_next (_tmp13_);
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp14_) {
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 9022 "DirectoryMonitor.c"
			}
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp15_ = _file_it;
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp16_ = gee_iterator_get (_tmp15_);
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp16_;
#line 296 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp17_ = self->priv->map;
#line 296 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp18_ = file;
#line 296 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
#line 296 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			info = (GFileInfo*) _tmp19_;
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp20_ = info;
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp21_ = get_file_info_id (_tmp20_);
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp22_ = _tmp21_;
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp23_ = match_id;
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp24_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp22_);
#line 299 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp24_) {
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				result = file;
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (info);
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_file_it);
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (match_id);
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return result;
#line 9062 "DirectoryMonitor.c"
			}
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp25_ = match_size;
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp26_ = info;
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp27_ = g_file_info_get_size (_tmp26_);
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp25_ != _tmp27_) {
#line 304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (info);
#line 304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (file);
#line 304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 9078 "DirectoryMonitor.c"
			}
#line 306 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp28_ = info;
#line 306 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_info_get_modification_time (_tmp28_, &_tmp29_);
#line 306 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			time = _tmp29_;
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp30_ = time;
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp31_ = _tmp30_.tv_sec;
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp32_ = match_time;
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp33_ = _tmp32_.tv_sec;
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp31_ != _tmp33_) {
#line 309 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (info);
#line 309 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (file);
#line 309 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 9102 "DirectoryMonitor.c"
			}
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = file;
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (info);
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_file_it);
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (match_id);
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 9114 "DirectoryMonitor.c"
		}
#line 295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 9118 "DirectoryMonitor.c"
	}
#line 314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = NULL;
#line 314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (match_id);
#line 314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 9126 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_remove_descendents (DirectoryMonitorFileInfoMap* self, GFile* root, DirectoryMonitorFileInfoMap* descendents) {
	GeeArrayList* pruned = NULL;
	GeeArrayList* _tmp28_ = NULL;
#line 317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self));
#line 317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (root));
#line 317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (descendents));
#line 318 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	pruned = NULL;
#line 9141 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = self->priv->map;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp1_;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _tmp4_;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp5_;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 9168 "DirectoryMonitor.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			GFile* parent = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = _file_it;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp7_) {
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 9185 "DirectoryMonitor.c"
			}
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = _file_it;
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp9_;
#line 320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = file;
#line 320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = g_file_get_parent (_tmp10_);
#line 320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			parent = _tmp11_;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 9201 "DirectoryMonitor.c"
				GFile* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				GFile* _tmp26_ = NULL;
				GFile* _tmp27_ = NULL;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = parent;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_tmp12_ != NULL)) {
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9214 "DirectoryMonitor.c"
				}
#line 322 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp13_ = parent;
#line 322 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp14_ = root;
#line 322 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp15_ = g_file_equal (_tmp13_, _tmp14_);
#line 322 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_tmp15_) {
#line 9224 "DirectoryMonitor.c"
					GeeArrayList* _tmp16_ = NULL;
					GeeArrayList* _tmp18_ = NULL;
					GFile* _tmp19_ = NULL;
					DirectoryMonitorFileInfoMap* _tmp20_ = NULL;
					GFile* _tmp21_ = NULL;
					GeeHashMap* _tmp22_ = NULL;
					GFile* _tmp23_ = NULL;
					gpointer _tmp24_ = NULL;
					GFileInfo* _tmp25_ = NULL;
#line 323 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp16_ = pruned;
#line 323 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp16_ == NULL) {
#line 9238 "DirectoryMonitor.c"
						GeeArrayList* _tmp17_ = NULL;
#line 324 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp17_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 324 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_g_object_unref0 (pruned);
#line 324 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						pruned = _tmp17_;
#line 9246 "DirectoryMonitor.c"
					}
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp18_ = pruned;
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp19_ = file;
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp19_);
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp20_ = descendents;
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp21_ = file;
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp22_ = self->priv->map;
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp23_ = file;
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp24_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp23_);
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp25_ = (GFileInfo*) _tmp24_;
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_file_info_map_update (_tmp20_, _tmp21_, _tmp25_);
#line 327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_tmp25_);
#line 329 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9272 "DirectoryMonitor.c"
				}
#line 332 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp26_ = parent;
#line 332 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp27_ = g_file_get_parent (_tmp26_);
#line 332 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (parent);
#line 332 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				parent = _tmp27_;
#line 9282 "DirectoryMonitor.c"
			}
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (parent);
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (file);
#line 9288 "DirectoryMonitor.c"
		}
#line 319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 9292 "DirectoryMonitor.c"
	}
#line 336 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp28_ = pruned;
#line 336 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp28_ != NULL) {
#line 9298 "DirectoryMonitor.c"
		GeeArrayList* _tmp29_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp29_ = pruned;
#line 337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove_all (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
#line 9304 "DirectoryMonitor.c"
	}
#line 317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (pruned);
#line 9308 "DirectoryMonitor.c"
}


static gint directory_monitor_file_info_map_get_children (DirectoryMonitorFileInfoMap* self, GFile* root, GeeCollection* files, GeeCollection* dirs) {
	gint result = 0;
	gint count = 0;
#line 342 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), 0);
#line 342 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (root), 0);
#line 342 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (files), 0);
#line 342 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (dirs), 0);
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	count = 0;
#line 9325 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = self->priv->map;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp1_;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _tmp4_;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp5_;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 9352 "DirectoryMonitor.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			GFile* parent = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			GFile* _tmp13_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GeeHashMap* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			GFileInfo* _tmp20_ = NULL;
			DirectoryMonitorFType _tmp21_ = 0;
			DirectoryMonitorFType _tmp22_ = 0;
			DirectoryMonitorFType _tmp23_ = 0;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = _file_it;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp7_) {
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 9379 "DirectoryMonitor.c"
			}
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = _file_it;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp9_;
#line 345 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = file;
#line 345 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = g_file_get_parent (_tmp10_);
#line 345 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			parent = _tmp11_;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = parent;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp13_ == NULL) {
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = TRUE;
#line 9399 "DirectoryMonitor.c"
			} else {
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp14_ = parent;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp15_ = root;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp16_ = g_file_equal (_tmp14_, _tmp15_);
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = !_tmp16_;
#line 9412 "DirectoryMonitor.c"
			}
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp12_) {
#line 347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (parent);
#line 347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (file);
#line 347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 9422 "DirectoryMonitor.c"
			}
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp17_ = self->priv->map;
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp18_ = file;
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp20_ = (GFileInfo*) _tmp19_;
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp21_ = directory_monitor_get_ftype (_tmp20_);
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp22_ = _tmp21_;
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_tmp20_);
#line 349 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp22_;
#line 350 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp23_ = ftype;
#line 350 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp23_) {
#line 350 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 9446 "DirectoryMonitor.c"
				{
					GeeCollection* _tmp24_ = NULL;
					GFile* _tmp25_ = NULL;
					gint _tmp26_ = 0;
#line 352 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp24_ = files;
#line 352 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp25_ = file;
#line 352 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					gee_collection_add (_tmp24_, _tmp25_);
#line 353 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp26_ = count;
#line 353 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					count = _tmp26_ + 1;
#line 354 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9463 "DirectoryMonitor.c"
				}
#line 350 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 9467 "DirectoryMonitor.c"
				{
					GeeCollection* _tmp27_ = NULL;
					GFile* _tmp28_ = NULL;
					gint _tmp29_ = 0;
#line 357 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp27_ = dirs;
#line 357 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp28_ = file;
#line 357 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					gee_collection_add (_tmp27_, _tmp28_);
#line 358 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp29_ = count;
#line 358 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					count = _tmp29_ + 1;
#line 359 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9484 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp30_ = 0;
#line 362 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp30_ = ftype;
#line 362 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp30_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 363 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9495 "DirectoryMonitor.c"
				}
			}
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (parent);
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (file);
#line 9502 "DirectoryMonitor.c"
		}
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 9506 "DirectoryMonitor.c"
	}
#line 367 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = count;
#line 367 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 9512 "DirectoryMonitor.c"
}


static void directory_monitor_value_file_info_map_init (GValue* value) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 9519 "DirectoryMonitor.c"
}


static void directory_monitor_value_file_info_map_free_value (GValue* value) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (value->data[0].v_pointer) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_unref (value->data[0].v_pointer);
#line 9528 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_file_info_map_copy_value (const GValue* src_value, GValue* dest_value) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = directory_monitor_file_info_map_ref (src_value->data[0].v_pointer);
#line 9538 "DirectoryMonitor.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9542 "DirectoryMonitor.c"
	}
}


static gpointer directory_monitor_value_file_info_map_peek_pointer (const GValue* value) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 9550 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_file_info_map_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 9557 "DirectoryMonitor.c"
		DirectoryMonitorFileInfoMap* object;
		object = collect_values[0].v_pointer;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9564 "DirectoryMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9568 "DirectoryMonitor.c"
		}
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = directory_monitor_file_info_map_ref (object);
#line 9572 "DirectoryMonitor.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 9576 "DirectoryMonitor.c"
	}
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 9580 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_file_info_map_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DirectoryMonitorFileInfoMap** object_p;
	object_p = collect_values[0].v_pointer;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!object_p) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9591 "DirectoryMonitor.c"
	}
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = NULL;
#line 9597 "DirectoryMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 9601 "DirectoryMonitor.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = directory_monitor_file_info_map_ref (value->data[0].v_pointer);
#line 9605 "DirectoryMonitor.c"
	}
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 9609 "DirectoryMonitor.c"
}


static GParamSpec* directory_monitor_param_spec_file_info_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DirectoryMonitorParamSpecFileInfoMap* spec;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP), NULL);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 9623 "DirectoryMonitor.c"
}


static gpointer directory_monitor_value_get_file_info_map (const GValue* value) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP), NULL);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 9632 "DirectoryMonitor.c"
}


static void directory_monitor_value_set_file_info_map (GValue* value, gpointer v_object) {
	DirectoryMonitorFileInfoMap* old;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_ref (value->data[0].v_pointer);
#line 9652 "DirectoryMonitor.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 9656 "DirectoryMonitor.c"
	}
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_unref (old);
#line 9662 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_take_file_info_map (GValue* value, gpointer v_object) {
	DirectoryMonitorFileInfoMap* old;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 9681 "DirectoryMonitor.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 9685 "DirectoryMonitor.c"
	}
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_unref (old);
#line 9691 "DirectoryMonitor.c"
	}
}


static void directory_monitor_file_info_map_class_init (DirectoryMonitorFileInfoMapClass * klass) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_file_info_map_parent_class = g_type_class_peek_parent (klass);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorFileInfoMapClass *) klass)->finalize = directory_monitor_file_info_map_finalize;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_type_class_add_private (klass, sizeof (DirectoryMonitorFileInfoMapPrivate));
#line 9703 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_instance_init (DirectoryMonitorFileInfoMap * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv = DIRECTORY_MONITOR_FILE_INFO_MAP_GET_PRIVATE (self);
#line 133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->map = _tmp0_;
#line 135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
#line 135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->id_map = _tmp1_;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->ref_count = 1;
#line 9722 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_finalize (DirectoryMonitorFileInfoMap* obj) {
	DirectoryMonitorFileInfoMap * self;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMap);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_handlers_destroy (self);
#line 133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->map);
#line 135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->id_map);
#line 9736 "DirectoryMonitor.c"
}


static GType directory_monitor_file_info_map_get_type (void) {
	static volatile gsize directory_monitor_file_info_map_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_file_info_map_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { directory_monitor_value_file_info_map_init, directory_monitor_value_file_info_map_free_value, directory_monitor_value_file_info_map_copy_value, directory_monitor_value_file_info_map_peek_pointer, "p", directory_monitor_value_file_info_map_collect_value, "p", directory_monitor_value_file_info_map_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorFileInfoMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_file_info_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitorFileInfoMap), 0, (GInstanceInitFunc) directory_monitor_file_info_map_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType directory_monitor_file_info_map_type_id;
		directory_monitor_file_info_map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DirectoryMonitorFileInfoMap", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&directory_monitor_file_info_map_type_id__volatile, directory_monitor_file_info_map_type_id);
	}
	return directory_monitor_file_info_map_type_id__volatile;
}


static gpointer directory_monitor_file_info_map_ref (gpointer instance) {
	DirectoryMonitorFileInfoMap* self;
	self = instance;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return instance;
#line 9761 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_unref (gpointer instance) {
	DirectoryMonitorFileInfoMap* self;
	self = instance;
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		DIRECTORY_MONITOR_FILE_INFO_MAP_GET_CLASS (self)->finalize (self);
#line 132 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9774 "DirectoryMonitor.c"
	}
}


static void directory_monitor_class_init (DirectoryMonitorClass * klass) {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_parent_class = g_type_class_peek_parent (klass);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_type_class_add_private (klass, sizeof (DirectoryMonitorPrivate));
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_root_deleted = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_root_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_root_moved = (void (*)(DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_root_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_discovery_started = (void (*)(DirectoryMonitor*)) directory_monitor_real_notify_discovery_started;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->internal_notify_file_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_internal_notify_file_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->internal_notify_directory_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_internal_notify_directory_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_discovery_failed = (void (*)(DirectoryMonitor*, const gchar*)) directory_monitor_real_notify_discovery_failed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_discovery_completed = (void (*)(DirectoryMonitor*)) directory_monitor_real_notify_discovery_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_created = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_moved = (void (*)(DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_alteration_completed = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_attributes_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_deleted = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_created = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_moved = (void (*)(DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_alteration_completed = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_attributes_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_deleted = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_closed = (void (*)(DirectoryMonitor*)) directory_monitor_real_notify_closed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->close = (void (*)(DirectoryMonitor*)) directory_monitor_real_close;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->root_moved = directory_monitor_real_root_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->root_deleted = directory_monitor_real_root_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_started = directory_monitor_real_discovery_started;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_discovered = directory_monitor_real_file_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_discovered = directory_monitor_real_directory_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_failed = directory_monitor_real_discovery_failed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_completed = directory_monitor_real_discovery_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_created = directory_monitor_real_file_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_moved = directory_monitor_real_file_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_altered = directory_monitor_real_file_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_alteration_completed = directory_monitor_real_file_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_attributes_altered = directory_monitor_real_file_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_deleted = directory_monitor_real_file_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_created = directory_monitor_real_directory_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_moved = directory_monitor_real_directory_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_altered = directory_monitor_real_directory_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_alteration_completed = directory_monitor_real_directory_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_attributes_altered = directory_monitor_real_directory_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_deleted = directory_monitor_real_directory_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->closed = directory_monitor_real_closed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = directory_monitor_finalize;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("root_moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, root_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("root_deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, root_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("discovery_started", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_started), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_discovered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_discovered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_discovered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_discovered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("discovery_failed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_failed), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("discovery_completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_completed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_created", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_created), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_alteration_completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_alteration_completed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_attributes_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_attributes_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_created", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_created), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_alteration_completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_alteration_completed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_attributes_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_attributes_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("closed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, closed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 9912 "DirectoryMonitor.c"
}


static void directory_monitor_instance_init (DirectoryMonitor * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	DirectoryMonitorFileInfoMap* _tmp2_ = NULL;
	DirectoryMonitorFileInfoMap* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv = DIRECTORY_MONITOR_GET_PRIVATE (self);
#line 374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->monitors = _tmp0_;
#line 375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = gee_linked_list_new (DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, (GBoxedCopyFunc) directory_monitor_query_info_queue_element_ref, (GDestroyNotify) directory_monitor_query_info_queue_element_unref, NULL, NULL, NULL);
#line 375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->query_info_queue = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_QUEUE, GeeQueue);
#line 377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_new ();
#line 377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->files = _tmp2_;
#line 378 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_new ();
#line 378 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->parent_moved = _tmp3_;
#line 379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_cancellable_new ();
#line 379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->cancellable = _tmp4_;
#line 380 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->outstanding_exploration_dirs = 0;
#line 381 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->started = FALSE;
#line 382 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->has_discovery_started = FALSE;
#line 383 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->delete_timer_id = (guint) 0;
#line 9952 "DirectoryMonitor.c"
}


static void directory_monitor_finalize (GObject* obj) {
	DirectoryMonitor * self;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECTORY_MONITOR, DirectoryMonitor);
#line 371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->root);
#line 374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->monitors);
#line 375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->query_info_queue);
#line 377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_directory_monitor_file_info_map_unref0 (self->priv->files);
#line 378 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_directory_monitor_file_info_map_unref0 (self->priv->parent_moved);
#line 379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_OBJECT_CLASS (directory_monitor_parent_class)->finalize (obj);
#line 9974 "DirectoryMonitor.c"
}


GType directory_monitor_get_type (void) {
	static volatile gsize directory_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitor), 0, (GInstanceInitFunc) directory_monitor_instance_init, NULL };
		GType directory_monitor_type_id;
		directory_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "DirectoryMonitor", &g_define_type_info, 0);
		g_once_init_leave (&directory_monitor_type_id__volatile, directory_monitor_type_id);
	}
	return directory_monitor_type_id__volatile;
}



