/* Orientation.c generated by valac 0.34.7, the Vala compiler
 * generated from Orientation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};



GType orientation_get_type (void) G_GNUC_CONST;
gchar* orientation_to_string (Orientation self);
Orientation orientation_rotate_clockwise (Orientation self);
Orientation orientation_rotate_counterclockwise (Orientation self);
Orientation orientation_flip_top_to_bottom (Orientation self);
Orientation orientation_flip_left_to_right (Orientation self);
GType rotation_get_type (void) G_GNUC_CONST;
Orientation orientation_perform (Orientation self, Rotation rotation);
Rotation* orientation_to_rotations (Orientation self, int* result_length1);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void orientation_rotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
void dimensions_init (Dimensions *self, gint width, gint height);
void orientation_derotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self, GdkPixbuf* pixbuf);
void orientation_rotate_point (Orientation self, Dimensions* space, GdkPoint* point, GdkPoint* result);
gboolean dimensions_has_area (Dimensions *self);
void orientation_derotate_point (Orientation self, Dimensions* space, GdkPoint* point, GdkPoint* result);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void orientation_rotate_box (Orientation self, Dimensions* space, Box* box, Box* result);
void box_get_points (Box *self, GdkPoint* top_left, GdkPoint* bottom_right);
void box_from_points (GdkPoint* corner1, GdkPoint* corner2, Box* result);
void orientation_derotate_box (Orientation self, Dimensions* space, Box* box, Box* result);
GdkPixbuf* rotation_perform (Rotation self, GdkPixbuf* pixbuf);
Rotation rotation_opposite (Rotation self);


gchar* orientation_to_string (Orientation self) {
	gchar* result = NULL;
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 104 "Orientation.c"
		{
			gchar* _tmp0_ = NULL;
#line 22 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = g_strdup ("top-left");
#line 22 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 113 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 117 "Orientation.c"
		{
			gchar* _tmp1_ = NULL;
#line 25 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = g_strdup ("top-right");
#line 25 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 25 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 126 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 130 "Orientation.c"
		{
			gchar* _tmp2_ = NULL;
#line 28 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = g_strdup ("bottom-right");
#line 28 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp2_;
#line 28 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 139 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 143 "Orientation.c"
		{
			gchar* _tmp3_ = NULL;
#line 31 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = g_strdup ("bottom-left");
#line 31 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 31 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 152 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 156 "Orientation.c"
		{
			gchar* _tmp4_ = NULL;
#line 34 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = g_strdup ("left-top");
#line 34 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp4_;
#line 34 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 165 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 169 "Orientation.c"
		{
			gchar* _tmp5_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = g_strdup ("right-top");
#line 37 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp5_;
#line 37 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 178 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 182 "Orientation.c"
		{
			gchar* _tmp6_ = NULL;
#line 40 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = g_strdup ("right-bottom");
#line 40 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp6_;
#line 40 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 191 "Orientation.c"
		}
#line 20 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 195 "Orientation.c"
		{
			gchar* _tmp7_ = NULL;
#line 43 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = g_strdup ("left-bottom");
#line 43 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp7_;
#line 43 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 204 "Orientation.c"
		}
		default:
		{
			gchar* _tmp8_ = NULL;
#line 46 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = g_strdup_printf ("unknown orientation %d", (gint) self);
#line 46 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp8_;
#line 46 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 215 "Orientation.c"
		}
	}
}


Orientation orientation_rotate_clockwise (Orientation self) {
	Orientation result = 0;
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 227 "Orientation.c"
		{
#line 53 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 53 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 233 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 237 "Orientation.c"
		{
#line 56 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 56 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 243 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 247 "Orientation.c"
		{
#line 59 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 59 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 253 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 257 "Orientation.c"
		{
#line 62 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 62 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 263 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 267 "Orientation.c"
		{
#line 65 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 65 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 273 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 277 "Orientation.c"
		{
#line 68 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 68 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 283 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 287 "Orientation.c"
		{
#line 71 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 71 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 293 "Orientation.c"
		}
#line 51 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 297 "Orientation.c"
		{
#line 74 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 74 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 303 "Orientation.c"
		}
		default:
		{
#line 77 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:77: rotate_clockwise: %d", (gint) self);
#line 309 "Orientation.c"
		}
	}
}


Orientation orientation_rotate_counterclockwise (Orientation self) {
	Orientation result = 0;
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 321 "Orientation.c"
		{
#line 84 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 84 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 327 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 331 "Orientation.c"
		{
#line 87 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 87 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 337 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 341 "Orientation.c"
		{
#line 90 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 90 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 347 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 351 "Orientation.c"
		{
#line 93 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 93 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 357 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 361 "Orientation.c"
		{
#line 96 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 96 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 367 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 371 "Orientation.c"
		{
#line 99 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 99 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 377 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 381 "Orientation.c"
		{
#line 102 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 102 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 387 "Orientation.c"
		}
#line 82 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 391 "Orientation.c"
		{
#line 105 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 105 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 397 "Orientation.c"
		}
		default:
		{
#line 108 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:108: rotate_counterclockwise: %d", (gint) self);
#line 403 "Orientation.c"
		}
	}
}


Orientation orientation_flip_top_to_bottom (Orientation self) {
	Orientation result = 0;
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 415 "Orientation.c"
		{
#line 115 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 115 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 421 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 425 "Orientation.c"
		{
#line 118 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 118 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 431 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 435 "Orientation.c"
		{
#line 121 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 121 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 441 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 445 "Orientation.c"
		{
#line 124 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 124 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 451 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 455 "Orientation.c"
		{
#line 127 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 127 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 461 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 465 "Orientation.c"
		{
#line 130 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 130 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 471 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 475 "Orientation.c"
		{
#line 133 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 133 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 481 "Orientation.c"
		}
#line 113 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 485 "Orientation.c"
		{
#line 136 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 136 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 491 "Orientation.c"
		}
		default:
		{
#line 139 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:139: flip_top_to_bottom: %d", (gint) self);
#line 497 "Orientation.c"
		}
	}
}


Orientation orientation_flip_left_to_right (Orientation self) {
	Orientation result = 0;
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 509 "Orientation.c"
		{
#line 146 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_RIGHT;
#line 146 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 515 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 519 "Orientation.c"
		{
#line 149 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_TOP_LEFT;
#line 149 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 525 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 529 "Orientation.c"
		{
#line 152 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_LEFT;
#line 152 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 535 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 539 "Orientation.c"
		{
#line 155 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_BOTTOM_RIGHT;
#line 155 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 545 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 549 "Orientation.c"
		{
#line 158 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_TOP;
#line 158 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 555 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 559 "Orientation.c"
		{
#line 161 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_TOP;
#line 161 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 565 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 569 "Orientation.c"
		{
#line 164 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_LEFT_BOTTOM;
#line 164 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 575 "Orientation.c"
		}
#line 144 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 579 "Orientation.c"
		{
#line 167 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ORIENTATION_RIGHT_BOTTOM;
#line 167 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 585 "Orientation.c"
		}
		default:
		{
#line 170 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:170: flip_left_to_right: %d", (gint) self);
#line 591 "Orientation.c"
		}
	}
}


Orientation orientation_perform (Orientation self, Rotation rotation) {
	Orientation result = 0;
	Rotation _tmp0_ = 0;
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp0_ = rotation;
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (_tmp0_) {
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_CLOCKWISE:
#line 606 "Orientation.c"
		{
			Orientation _tmp1_ = 0;
#line 177 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = orientation_rotate_clockwise (self);
#line 177 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 177 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 615 "Orientation.c"
		}
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_COUNTERCLOCKWISE:
#line 619 "Orientation.c"
		{
			Orientation _tmp2_ = 0;
#line 180 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = orientation_rotate_counterclockwise (self);
#line 180 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp2_;
#line 180 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 628 "Orientation.c"
		}
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_MIRROR:
#line 632 "Orientation.c"
		{
			Orientation _tmp3_ = 0;
#line 183 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = orientation_flip_left_to_right (self);
#line 183 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 183 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 641 "Orientation.c"
		}
#line 175 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_UPSIDE_DOWN:
#line 645 "Orientation.c"
		{
			Orientation _tmp4_ = 0;
#line 186 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = orientation_flip_top_to_bottom (self);
#line 186 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp4_;
#line 186 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 654 "Orientation.c"
		}
		default:
		{
			Rotation _tmp5_ = 0;
#line 189 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = rotation;
#line 189 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:189: perform: %d", (gint) _tmp5_);
#line 663 "Orientation.c"
		}
	}
}


Rotation* orientation_to_rotations (Orientation self, int* result_length1) {
	Rotation* result = NULL;
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 675 "Orientation.c"
		{
			Rotation* _tmp0_ = NULL;
			Rotation* _tmp1_ = NULL;
			gint _tmp1__length1 = 0;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = g_new0 (Rotation, 0);
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = _tmp0_;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1__length1 = 0;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp1__length1;
#line 690 "Orientation.c"
			}
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 197 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 696 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 700 "Orientation.c"
		{
			Rotation* _tmp2_ = NULL;
			Rotation* _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = g_new0 (Rotation, 1);
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_[0] = ROTATION_MIRROR;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = _tmp2_;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3__length1 = 1;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp3__length1;
#line 717 "Orientation.c"
			}
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 200 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 723 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 727 "Orientation.c"
		{
			Rotation* _tmp4_ = NULL;
			Rotation* _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = g_new0 (Rotation, 1);
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_[0] = ROTATION_UPSIDE_DOWN;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = _tmp4_;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5__length1 = 1;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp5__length1;
#line 744 "Orientation.c"
			}
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp5_;
#line 203 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 750 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 754 "Orientation.c"
		{
			Rotation* _tmp6_ = NULL;
			Rotation* _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = g_new0 (Rotation, 2);
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_[0] = ROTATION_MIRROR;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_[1] = ROTATION_UPSIDE_DOWN;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = _tmp6_;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7__length1 = 2;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp7__length1;
#line 773 "Orientation.c"
			}
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp7_;
#line 207 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 779 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 783 "Orientation.c"
		{
			Rotation* _tmp8_ = NULL;
			Rotation* _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = g_new0 (Rotation, 2);
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_[0] = ROTATION_COUNTERCLOCKWISE;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_[1] = ROTATION_UPSIDE_DOWN;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9_ = _tmp8_;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9__length1 = 2;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp9__length1;
#line 802 "Orientation.c"
			}
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp9_;
#line 210 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 808 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 812 "Orientation.c"
		{
			Rotation* _tmp10_ = NULL;
			Rotation* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_ = g_new0 (Rotation, 1);
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_[0] = ROTATION_CLOCKWISE;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11_ = _tmp10_;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11__length1 = 1;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp11__length1;
#line 829 "Orientation.c"
			}
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp11_;
#line 213 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 835 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 839 "Orientation.c"
		{
			Rotation* _tmp12_ = NULL;
			Rotation* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_ = g_new0 (Rotation, 2);
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_[0] = ROTATION_CLOCKWISE;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_[1] = ROTATION_UPSIDE_DOWN;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = _tmp12_;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13__length1 = 2;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp13__length1;
#line 858 "Orientation.c"
			}
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp13_;
#line 216 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 864 "Orientation.c"
		}
#line 194 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 868 "Orientation.c"
		{
			Rotation* _tmp14_ = NULL;
			Rotation* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = g_new0 (Rotation, 1);
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_[0] = ROTATION_COUNTERCLOCKWISE;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = _tmp14_;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15__length1 = 1;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			if (result_length1) {
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
				*result_length1 = _tmp15__length1;
#line 885 "Orientation.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp15_;
#line 219 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 891 "Orientation.c"
		}
		default:
		{
#line 222 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:222: to_rotations: %d", (gint) self);
#line 897 "Orientation.c"
		}
	}
}


void orientation_rotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result) {
#line 226 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (dim != NULL);
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 916 "Orientation.c"
		{
			Dimensions _tmp0_ = {0};
#line 233 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = *dim;
#line 233 "/home/jens/Source/shotwell/src/Orientation.vala"
			*result = _tmp0_;
#line 233 "/home/jens/Source/shotwell/src/Orientation.vala"
			return;
#line 925 "Orientation.c"
		}
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 227 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 935 "Orientation.c"
		{
			Dimensions _tmp1_ = {0};
			gint _tmp2_ = 0;
			Dimensions _tmp3_ = {0};
			gint _tmp4_ = 0;
			Dimensions _tmp5_ = {0};
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = *dim;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = _tmp1_.height;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = *dim;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = _tmp3_.width;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			*result = _tmp5_;
#line 240 "/home/jens/Source/shotwell/src/Orientation.vala"
			return;
#line 956 "Orientation.c"
		}
		default:
		{
#line 243 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:243: rotate_dimensions: %d", (gint) self);
#line 962 "Orientation.c"
		}
	}
}


void orientation_derotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result) {
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
#line 247 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (dim != NULL);
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp0_ = *dim;
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_rotate_dimensions (self, &_tmp0_, &_tmp1_);
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = _tmp1_;
#line 248 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 981 "Orientation.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
	return self ? g_object_ref (self) : NULL;
#line 988 "Orientation.c"
}


GdkPixbuf* orientation_rotate_pixbuf (Orientation self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* rotated = NULL;
#line 251 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 1001 "Orientation.c"
		{
			GdkPixbuf* _tmp0_ = NULL;
			GdkPixbuf* _tmp1_ = NULL;
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = pixbuf;
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = _g_object_ref0 (_tmp0_);
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 256 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp1_;
#line 257 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1015 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 1019 "Orientation.c"
		{
			GdkPixbuf* _tmp2_ = NULL;
			GdkPixbuf* _tmp3_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = pixbuf;
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = gdk_pixbuf_flip (_tmp2_, TRUE);
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 261 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp3_;
#line 262 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1033 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 1037 "Orientation.c"
		{
			GdkPixbuf* _tmp4_ = NULL;
			GdkPixbuf* _tmp5_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = pixbuf;
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = gdk_pixbuf_rotate_simple (_tmp4_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 265 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp5_;
#line 266 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1051 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 1055 "Orientation.c"
		{
			GdkPixbuf* _tmp6_ = NULL;
			GdkPixbuf* _tmp7_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = pixbuf;
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = gdk_pixbuf_flip (_tmp6_, FALSE);
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 270 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp7_;
#line 271 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1069 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 1073 "Orientation.c"
		{
			GdkPixbuf* _tmp8_ = NULL;
			GdkPixbuf* _tmp9_ = NULL;
			GdkPixbuf* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = pixbuf;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9_ = gdk_pixbuf_rotate_simple (_tmp8_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_ = _tmp9_;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11_ = gdk_pixbuf_flip (_tmp10_, FALSE);
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp11_;
#line 274 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (_tmp10_);
#line 275 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1095 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 1099 "Orientation.c"
		{
			GdkPixbuf* _tmp12_ = NULL;
			GdkPixbuf* _tmp13_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_ = pixbuf;
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = gdk_pixbuf_rotate_simple (_tmp12_, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 278 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp13_;
#line 279 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1113 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 1117 "Orientation.c"
		{
			GdkPixbuf* _tmp14_ = NULL;
			GdkPixbuf* _tmp15_ = NULL;
			GdkPixbuf* _tmp16_ = NULL;
			GdkPixbuf* _tmp17_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = pixbuf;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = gdk_pixbuf_rotate_simple (_tmp14_, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp16_ = _tmp15_;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp17_ = gdk_pixbuf_flip (_tmp16_, FALSE);
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp17_;
#line 282 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (_tmp16_);
#line 283 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1139 "Orientation.c"
		}
#line 253 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 1143 "Orientation.c"
		{
			GdkPixbuf* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp18_ = pixbuf;
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp19_ = gdk_pixbuf_rotate_simple (_tmp18_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			_g_object_unref0 (rotated);
#line 286 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp19_;
#line 287 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1157 "Orientation.c"
		}
		default:
		{
#line 290 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:290: rotate_pixbuf: %d", (gint) self);
#line 1163 "Orientation.c"
		}
	}
#line 293 "/home/jens/Source/shotwell/src/Orientation.vala"
	result = rotated;
#line 293 "/home/jens/Source/shotwell/src/Orientation.vala"
	return result;
#line 1170 "Orientation.c"
}


void orientation_rotate_point (Orientation self, Dimensions* space, GdkPoint* point, GdkPoint* result) {
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	GdkPoint _tmp7_ = {0};
	gint _tmp8_ = 0;
	GdkPoint _tmp9_ = {0};
	gint _tmp10_ = 0;
	Dimensions _tmp11_ = {0};
	gint _tmp12_ = 0;
	GdkPoint rotated = {0};
#line 297 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 297 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (point != NULL);
#line 298 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp0_ = dimensions_has_area (space);
#line 298 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp0_, "space.has_area()");
#line 299 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp1_ = *point;
#line 299 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp2_ = _tmp1_.x;
#line 299 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp2_ >= 0, "point.x >= 0");
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp3_ = *point;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp4_ = _tmp3_.x;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp5_ = *space;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp6_ = _tmp5_.width;
#line 300 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp4_ < _tmp6_, "point.x < space.width");
#line 301 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp7_ = *point;
#line 301 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp8_ = _tmp7_.y;
#line 301 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp8_ >= 0, "point.y >= 0");
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp9_ = *point;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp10_ = _tmp9_.y;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp11_ = *space;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp12_ = _tmp11_.height;
#line 302 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp10_ < _tmp12_, "point.y < space.height");
#line 304 "/home/jens/Source/shotwell/src/Orientation.vala"
	memset (&rotated, 0, sizeof (GdkPoint));
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 1235 "Orientation.c"
		{
			GdkPoint _tmp13_ = {0};
#line 309 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = *point;
#line 309 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated = _tmp13_;
#line 310 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1244 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 1248 "Orientation.c"
		{
			Dimensions _tmp14_ = {0};
			gint _tmp15_ = 0;
			GdkPoint _tmp16_ = {0};
			gint _tmp17_ = 0;
			GdkPoint _tmp18_ = {0};
			gint _tmp19_ = 0;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = *space;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = _tmp14_.width;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp16_ = *point;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp17_ = _tmp16_.x;
#line 314 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp15_ - _tmp17_) - 1;
#line 315 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp18_ = *point;
#line 315 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp19_ = _tmp18_.y;
#line 315 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = _tmp19_;
#line 316 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1274 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 1278 "Orientation.c"
		{
			Dimensions _tmp20_ = {0};
			gint _tmp21_ = 0;
			GdkPoint _tmp22_ = {0};
			gint _tmp23_ = 0;
			Dimensions _tmp24_ = {0};
			gint _tmp25_ = 0;
			GdkPoint _tmp26_ = {0};
			gint _tmp27_ = 0;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp20_ = *space;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp21_ = _tmp20_.width;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp22_ = *point;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp23_ = _tmp22_.x;
#line 320 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp21_ - _tmp23_) - 1;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp24_ = *space;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp25_ = _tmp24_.height;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp26_ = *point;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp27_ = _tmp26_.y;
#line 321 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp25_ - _tmp27_) - 1;
#line 322 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1310 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 1314 "Orientation.c"
		{
			GdkPoint _tmp28_ = {0};
			gint _tmp29_ = 0;
			Dimensions _tmp30_ = {0};
			gint _tmp31_ = 0;
			GdkPoint _tmp32_ = {0};
			gint _tmp33_ = 0;
#line 326 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp28_ = *point;
#line 326 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp29_ = _tmp28_.x;
#line 326 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = _tmp29_;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp30_ = *space;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp31_ = _tmp30_.height;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp32_ = *point;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp33_ = _tmp32_.y;
#line 327 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp31_ - _tmp33_) - 1;
#line 328 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1340 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 1344 "Orientation.c"
		{
			GdkPoint _tmp34_ = {0};
			gint _tmp35_ = 0;
			GdkPoint _tmp36_ = {0};
			gint _tmp37_ = 0;
#line 332 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp34_ = *point;
#line 332 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp35_ = _tmp34_.y;
#line 332 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = _tmp35_;
#line 333 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp36_ = *point;
#line 333 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp37_ = _tmp36_.x;
#line 333 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = _tmp37_;
#line 334 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1364 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 1368 "Orientation.c"
		{
			Dimensions _tmp38_ = {0};
			gint _tmp39_ = 0;
			GdkPoint _tmp40_ = {0};
			gint _tmp41_ = 0;
			GdkPoint _tmp42_ = {0};
			gint _tmp43_ = 0;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp38_ = *space;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp39_ = _tmp38_.height;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp40_ = *point;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp41_ = _tmp40_.y;
#line 338 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp39_ - _tmp41_) - 1;
#line 339 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp42_ = *point;
#line 339 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp43_ = _tmp42_.x;
#line 339 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = _tmp43_;
#line 340 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1394 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 1398 "Orientation.c"
		{
			Dimensions _tmp44_ = {0};
			gint _tmp45_ = 0;
			GdkPoint _tmp46_ = {0};
			gint _tmp47_ = 0;
			Dimensions _tmp48_ = {0};
			gint _tmp49_ = 0;
			GdkPoint _tmp50_ = {0};
			gint _tmp51_ = 0;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp44_ = *space;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp45_ = _tmp44_.height;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp46_ = *point;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp47_ = _tmp46_.y;
#line 344 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = (_tmp45_ - _tmp47_) - 1;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp48_ = *space;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp49_ = _tmp48_.width;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp50_ = *point;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp51_ = _tmp50_.x;
#line 345 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp49_ - _tmp51_) - 1;
#line 346 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1430 "Orientation.c"
		}
#line 306 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 1434 "Orientation.c"
		{
			GdkPoint _tmp52_ = {0};
			gint _tmp53_ = 0;
			Dimensions _tmp54_ = {0};
			gint _tmp55_ = 0;
			GdkPoint _tmp56_ = {0};
			gint _tmp57_ = 0;
#line 350 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp52_ = *point;
#line 350 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp53_ = _tmp52_.y;
#line 350 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.x = _tmp53_;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp54_ = *space;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp55_ = _tmp54_.width;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp56_ = *point;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp57_ = _tmp56_.x;
#line 351 "/home/jens/Source/shotwell/src/Orientation.vala"
			rotated.y = (_tmp55_ - _tmp57_) - 1;
#line 352 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1460 "Orientation.c"
		}
		default:
		{
#line 355 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:355: rotate_point: %d", (gint) self);
#line 1466 "Orientation.c"
		}
	}
#line 358 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = rotated;
#line 358 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1473 "Orientation.c"
}


void orientation_derotate_point (Orientation self, Dimensions* space, GdkPoint* point, GdkPoint* result) {
	gboolean _tmp0_ = FALSE;
	GdkPoint derotated = {0};
#line 362 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 362 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (point != NULL);
#line 363 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp0_ = dimensions_has_area (space);
#line 363 "/home/jens/Source/shotwell/src/Orientation.vala"
	_vala_assert (_tmp0_, "space.has_area()");
#line 365 "/home/jens/Source/shotwell/src/Orientation.vala"
	memset (&derotated, 0, sizeof (GdkPoint));
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_LEFT:
#line 1494 "Orientation.c"
		{
			GdkPoint _tmp1_ = {0};
#line 370 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = *point;
#line 370 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated = _tmp1_;
#line 371 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1503 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_TOP_RIGHT:
#line 1507 "Orientation.c"
		{
			Dimensions _tmp2_ = {0};
			gint _tmp3_ = 0;
			GdkPoint _tmp4_ = {0};
			gint _tmp5_ = 0;
			GdkPoint _tmp6_ = {0};
			gint _tmp7_ = 0;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = *space;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = _tmp2_.width;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = *point;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = _tmp4_.x;
#line 375 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp3_ - _tmp5_) - 1;
#line 376 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = *point;
#line 376 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = _tmp6_.y;
#line 376 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = _tmp7_;
#line 377 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1533 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_RIGHT:
#line 1537 "Orientation.c"
		{
			Dimensions _tmp8_ = {0};
			gint _tmp9_ = 0;
			GdkPoint _tmp10_ = {0};
			gint _tmp11_ = 0;
			Dimensions _tmp12_ = {0};
			gint _tmp13_ = 0;
			GdkPoint _tmp14_ = {0};
			gint _tmp15_ = 0;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp8_ = *space;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp9_ = _tmp8_.width;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp10_ = *point;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp11_ = _tmp10_.x;
#line 381 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp9_ - _tmp11_) - 1;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp12_ = *space;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp13_ = _tmp12_.height;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp14_ = *point;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp15_ = _tmp14_.y;
#line 382 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp13_ - _tmp15_) - 1;
#line 383 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1569 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_BOTTOM_LEFT:
#line 1573 "Orientation.c"
		{
			GdkPoint _tmp16_ = {0};
			gint _tmp17_ = 0;
			Dimensions _tmp18_ = {0};
			gint _tmp19_ = 0;
			GdkPoint _tmp20_ = {0};
			gint _tmp21_ = 0;
#line 387 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp16_ = *point;
#line 387 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp17_ = _tmp16_.x;
#line 387 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = _tmp17_;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp18_ = *space;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp19_ = _tmp18_.height;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp20_ = *point;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp21_ = _tmp20_.y;
#line 388 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp19_ - _tmp21_) - 1;
#line 389 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1599 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_TOP:
#line 1603 "Orientation.c"
		{
			GdkPoint _tmp22_ = {0};
			gint _tmp23_ = 0;
			GdkPoint _tmp24_ = {0};
			gint _tmp25_ = 0;
#line 393 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp22_ = *point;
#line 393 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp23_ = _tmp22_.y;
#line 393 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = _tmp23_;
#line 394 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp24_ = *point;
#line 394 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp25_ = _tmp24_.x;
#line 394 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = _tmp25_;
#line 395 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1623 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_TOP:
#line 1627 "Orientation.c"
		{
			GdkPoint _tmp26_ = {0};
			gint _tmp27_ = 0;
			Dimensions _tmp28_ = {0};
			gint _tmp29_ = 0;
			GdkPoint _tmp30_ = {0};
			gint _tmp31_ = 0;
#line 399 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp26_ = *point;
#line 399 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp27_ = _tmp26_.y;
#line 399 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = _tmp27_;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp28_ = *space;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp29_ = _tmp28_.height;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp30_ = *point;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp31_ = _tmp30_.x;
#line 400 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp29_ - _tmp31_) - 1;
#line 401 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1653 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_RIGHT_BOTTOM:
#line 1657 "Orientation.c"
		{
			Dimensions _tmp32_ = {0};
			gint _tmp33_ = 0;
			GdkPoint _tmp34_ = {0};
			gint _tmp35_ = 0;
			Dimensions _tmp36_ = {0};
			gint _tmp37_ = 0;
			GdkPoint _tmp38_ = {0};
			gint _tmp39_ = 0;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp32_ = *space;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp33_ = _tmp32_.width;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp34_ = *point;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp35_ = _tmp34_.y;
#line 405 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp33_ - _tmp35_) - 1;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp36_ = *space;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp37_ = _tmp36_.height;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp38_ = *point;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp39_ = _tmp38_.x;
#line 406 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = (_tmp37_ - _tmp39_) - 1;
#line 407 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1689 "Orientation.c"
		}
#line 367 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ORIENTATION_LEFT_BOTTOM:
#line 1693 "Orientation.c"
		{
			Dimensions _tmp40_ = {0};
			gint _tmp41_ = 0;
			GdkPoint _tmp42_ = {0};
			gint _tmp43_ = 0;
			GdkPoint _tmp44_ = {0};
			gint _tmp45_ = 0;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp40_ = *space;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp41_ = _tmp40_.width;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp42_ = *point;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp43_ = _tmp42_.y;
#line 411 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.x = (_tmp41_ - _tmp43_) - 1;
#line 412 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp44_ = *point;
#line 412 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp45_ = _tmp44_.x;
#line 412 "/home/jens/Source/shotwell/src/Orientation.vala"
			derotated.y = _tmp45_;
#line 413 "/home/jens/Source/shotwell/src/Orientation.vala"
			break;
#line 1719 "Orientation.c"
		}
		default:
		{
#line 416 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:416: rotate_point: %d", (gint) self);
#line 1725 "Orientation.c"
		}
	}
#line 419 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = derotated;
#line 419 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1732 "Orientation.c"
}


void orientation_rotate_box (Orientation self, Dimensions* space, Box* box, Box* result) {
	GdkPoint top_left = {0};
	GdkPoint bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GdkPoint _tmp7_ = {0};
	gint _tmp8_ = 0;
	Dimensions _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GdkPoint _tmp12_ = {0};
	gint _tmp13_ = 0;
	Dimensions _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GdkPoint _tmp17_ = {0};
	gint _tmp18_ = 0;
	Dimensions _tmp19_ = {0};
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	Dimensions _tmp22_ = {0};
	GdkPoint _tmp23_ = {0};
	GdkPoint _tmp24_ = {0};
	Dimensions _tmp25_ = {0};
	GdkPoint _tmp26_ = {0};
	GdkPoint _tmp27_ = {0};
	GdkPoint _tmp28_ = {0};
	GdkPoint _tmp29_ = {0};
	Box _tmp30_ = {0};
#line 423 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 423 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (box != NULL);
#line 425 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_get_points (box, &_tmp0_, &_tmp1_);
#line 425 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp0_;
#line 425 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp1_;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp2_ = top_left;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp3_ = _tmp2_.x;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp4_ = *space;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp5_ = _tmp4_.width;
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp6_ = CLAMP (_tmp3_, 0, _tmp5_ - 1);
#line 427 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left.x = _tmp6_;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp7_ = top_left;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp8_ = _tmp7_.y;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp9_ = *space;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp10_ = _tmp9_.height;
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp11_ = CLAMP (_tmp8_, 0, _tmp10_ - 1);
#line 428 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left.y = _tmp11_;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp12_ = bottom_right;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp13_ = _tmp12_.x;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp14_ = *space;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp15_ = _tmp14_.width;
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp16_ = CLAMP (_tmp13_, 0, _tmp15_ - 1);
#line 430 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right.x = _tmp16_;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp17_ = bottom_right;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp18_ = _tmp17_.y;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp19_ = *space;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp20_ = _tmp19_.height;
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp21_ = CLAMP (_tmp18_, 0, _tmp20_ - 1);
#line 431 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right.y = _tmp21_;
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp22_ = *space;
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp23_ = top_left;
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_rotate_point (self, &_tmp22_, &_tmp23_, &_tmp24_);
#line 433 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp24_;
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp25_ = *space;
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp26_ = bottom_right;
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_rotate_point (self, &_tmp25_, &_tmp26_, &_tmp27_);
#line 434 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp27_;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp28_ = top_left;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp29_ = bottom_right;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_from_points (&_tmp28_, &_tmp29_, &_tmp30_);
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = _tmp30_;
#line 436 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1854 "Orientation.c"
}


void orientation_derotate_box (Orientation self, Dimensions* space, Box* box, Box* result) {
	GdkPoint top_left = {0};
	GdkPoint bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	GdkPoint _tmp3_ = {0};
	GdkPoint _tmp4_ = {0};
	Dimensions _tmp5_ = {0};
	GdkPoint _tmp6_ = {0};
	GdkPoint _tmp7_ = {0};
	GdkPoint _tmp8_ = {0};
	GdkPoint _tmp9_ = {0};
	Box _tmp10_ = {0};
#line 440 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (space != NULL);
#line 440 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_if_fail (box != NULL);
#line 442 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_get_points (box, &_tmp0_, &_tmp1_);
#line 442 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp0_;
#line 442 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp1_;
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp2_ = *space;
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp3_ = top_left;
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_derotate_point (self, &_tmp2_, &_tmp3_, &_tmp4_);
#line 444 "/home/jens/Source/shotwell/src/Orientation.vala"
	top_left = _tmp4_;
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp5_ = *space;
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp6_ = bottom_right;
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	orientation_derotate_point (self, &_tmp5_, &_tmp6_, &_tmp7_);
#line 445 "/home/jens/Source/shotwell/src/Orientation.vala"
	bottom_right = _tmp7_;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp8_ = top_left;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	_tmp9_ = bottom_right;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	box_from_points (&_tmp8_, &_tmp9_, &_tmp10_);
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	*result = _tmp10_;
#line 447 "/home/jens/Source/shotwell/src/Orientation.vala"
	return;
#line 1908 "Orientation.c"
}


GType orientation_get_type (void) {
	static volatile gsize orientation_type_id__volatile = 0;
	if (g_once_init_enter (&orientation_type_id__volatile)) {
		static const GEnumValue values[] = {{ORIENTATION_MIN, "ORIENTATION_MIN", "min"}, {ORIENTATION_TOP_LEFT, "ORIENTATION_TOP_LEFT", "top-left"}, {ORIENTATION_TOP_RIGHT, "ORIENTATION_TOP_RIGHT", "top-right"}, {ORIENTATION_BOTTOM_RIGHT, "ORIENTATION_BOTTOM_RIGHT", "bottom-right"}, {ORIENTATION_BOTTOM_LEFT, "ORIENTATION_BOTTOM_LEFT", "bottom-left"}, {ORIENTATION_LEFT_TOP, "ORIENTATION_LEFT_TOP", "left-top"}, {ORIENTATION_RIGHT_TOP, "ORIENTATION_RIGHT_TOP", "right-top"}, {ORIENTATION_RIGHT_BOTTOM, "ORIENTATION_RIGHT_BOTTOM", "right-bottom"}, {ORIENTATION_LEFT_BOTTOM, "ORIENTATION_LEFT_BOTTOM", "left-bottom"}, {ORIENTATION_MAX, "ORIENTATION_MAX", "max"}, {0, NULL, NULL}};
		GType orientation_type_id;
		orientation_type_id = g_enum_register_static ("Orientation", values);
		g_once_init_leave (&orientation_type_id__volatile, orientation_type_id);
	}
	return orientation_type_id__volatile;
}


GdkPixbuf* rotation_perform (Rotation self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
#line 457 "/home/jens/Source/shotwell/src/Orientation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_CLOCKWISE:
#line 1932 "Orientation.c"
		{
			GdkPixbuf* _tmp0_ = NULL;
			GdkPixbuf* _tmp1_ = NULL;
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp0_ = pixbuf;
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp1_ = gdk_pixbuf_rotate_simple (_tmp0_, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp1_;
#line 460 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1944 "Orientation.c"
		}
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_COUNTERCLOCKWISE:
#line 1948 "Orientation.c"
		{
			GdkPixbuf* _tmp2_ = NULL;
			GdkPixbuf* _tmp3_ = NULL;
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp2_ = pixbuf;
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp3_ = gdk_pixbuf_rotate_simple (_tmp2_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp3_;
#line 463 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1960 "Orientation.c"
		}
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_MIRROR:
#line 1964 "Orientation.c"
		{
			GdkPixbuf* _tmp4_ = NULL;
			GdkPixbuf* _tmp5_ = NULL;
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp4_ = pixbuf;
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp5_ = gdk_pixbuf_flip (_tmp4_, TRUE);
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp5_;
#line 466 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1976 "Orientation.c"
		}
#line 458 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_UPSIDE_DOWN:
#line 1980 "Orientation.c"
		{
			GdkPixbuf* _tmp6_ = NULL;
			GdkPixbuf* _tmp7_ = NULL;
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp6_ = pixbuf;
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			_tmp7_ = gdk_pixbuf_flip (_tmp6_, FALSE);
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = _tmp7_;
#line 469 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 1992 "Orientation.c"
		}
		default:
		{
#line 472 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:472: Unknown rotation: %d", (gint) self);
#line 1998 "Orientation.c"
		}
	}
}


Rotation rotation_opposite (Rotation self) {
	Rotation result = 0;
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
	switch (self) {
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_CLOCKWISE:
#line 2010 "Orientation.c"
		{
#line 479 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ROTATION_COUNTERCLOCKWISE;
#line 479 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2016 "Orientation.c"
		}
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_COUNTERCLOCKWISE:
#line 2020 "Orientation.c"
		{
#line 482 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = ROTATION_CLOCKWISE;
#line 482 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2026 "Orientation.c"
		}
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_MIRROR:
#line 477 "/home/jens/Source/shotwell/src/Orientation.vala"
		case ROTATION_UPSIDE_DOWN:
#line 2032 "Orientation.c"
		{
#line 486 "/home/jens/Source/shotwell/src/Orientation.vala"
			result = self;
#line 486 "/home/jens/Source/shotwell/src/Orientation.vala"
			return result;
#line 2038 "Orientation.c"
		}
		default:
		{
#line 489 "/home/jens/Source/shotwell/src/Orientation.vala"
			g_error ("Orientation.vala:489: Unknown rotation: %d", (gint) self);
#line 2044 "Orientation.c"
		}
	}
}


GType rotation_get_type (void) {
	static volatile gsize rotation_type_id__volatile = 0;
	if (g_once_init_enter (&rotation_type_id__volatile)) {
		static const GEnumValue values[] = {{ROTATION_CLOCKWISE, "ROTATION_CLOCKWISE", "clockwise"}, {ROTATION_COUNTERCLOCKWISE, "ROTATION_COUNTERCLOCKWISE", "counterclockwise"}, {ROTATION_MIRROR, "ROTATION_MIRROR", "mirror"}, {ROTATION_UPSIDE_DOWN, "ROTATION_UPSIDE_DOWN", "upside-down"}, {0, NULL, NULL}};
		GType rotation_type_id;
		rotation_type_id = g_enum_register_static ("Rotation", values);
		g_once_init_leave (&rotation_type_id__volatile, rotation_type_id);
	}
	return rotation_type_id__volatile;
}



