/* page-view.c generated by valac 0.34.6, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPageView ParamSpecPageView;

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

struct _PageView {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GTypeClass parent_class;
	void (*finalize) (PageView *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PageViewPrivate {
	Page* _page;
	GdkPixbuf* image;
	gboolean selected_;
	gint border_width;
	gboolean update_image;
	ScanDirection scan_direction;
	gint scan_line;
	gint width_;
	gint height_;
	gint _x_offset;
	gint _y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	GdkCursorType _cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

struct _ParamSpecPageView {
	GParamSpec parent_instance;
};


static gpointer page_view_parent_class = NULL;

GType crop_location_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page_view (GValue* value, gpointer v_object);
void value_take_page_view (GValue* value, gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define PAGE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE_VIEW, PageViewPrivate))
enum  {
	PAGE_VIEW_DUMMY_PROPERTY
};
Page* page_view_get_page (PageView* self);
static void page_view_page_pixels_changed_cb (PageView* self, Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void page_view_page_size_changed_cb (PageView* self, Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self, Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self, Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type, Page* page);
static void page_view_set_page (PageView* self, Page* value);
static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample);
static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1);
ScanDirection page_get_scan_direction (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
gint page_get_rowstride (Page* self);
static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset);
static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gboolean page_get_has_data (Page* self);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static void page_view_update_page_view (PageView* self);
gint page_get_scan_line (Page* self);
static gint page_view_page_to_screen_x (PageView* self, gint x);
static gint page_view_page_to_screen_y (PageView* self, gint y);
static gint page_view_screen_to_page_x (PageView* self, gint x);
static gint page_view_screen_to_page_y (PageView* self, gint y);
static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y);
gboolean page_get_has_crop (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
const gchar* page_get_crop_name (Page* self);
void page_view_button_press (PageView* self, gint x, gint y);
void page_view_motion (PageView* self, gint x, gint y);
static void page_view_set_cursor (PageView* self, GdkCursorType value);
void page_move_crop (Page* self, gint x, gint y);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_view_button_release (PageView* self, gint x, gint y);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
gboolean page_get_is_scanning (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
void page_view_render (PageView* self, cairo_t* context);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_y_offset (PageView* self);
gboolean page_view_get_selected (PageView* self);
void page_view_set_selected (PageView* self, gboolean value);
void page_view_set_x_offset (PageView* self, gint value);
void page_view_set_y_offset (PageView* self, gint value);
GdkCursorType page_view_get_cursor (PageView* self);
gint page_view_get_width (PageView* self);
void page_view_set_width (PageView* self, gint value);
gint page_view_get_height (PageView* self);
void page_view_set_height (PageView* self, gint value);
static void page_view_finalize (PageView* obj);


GType crop_location_get_type (void) {
	static volatile gsize crop_location_type_id__volatile = 0;
	if (g_once_init_enter (&crop_location_type_id__volatile)) {
		static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
		GType crop_location_type_id;
		crop_location_type_id = g_enum_register_static ("CropLocation", values);
		g_once_init_leave (&crop_location_type_id__volatile, crop_location_type_id);
	}
	return crop_location_type_id__volatile;
}


static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_pixels_changed_cb ((PageView*) self, _sender);
#line 222 "page-view.c"
}


static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_size_changed_cb ((PageView*) self, _sender);
#line 229 "page-view.c"
}


static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
#line 236 "page-view.c"
}


static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self) {
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
#line 243 "page-view.c"
}


static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_scan_direction_changed_cb ((PageView*) self, _sender);
#line 250 "page-view.c"
}


PageView* page_view_construct (GType object_type, Page* page) {
	PageView* self = NULL;
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self = (PageView*) g_type_create_instance (object_type);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_set_page (self, _tmp0_);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page;
#line 88 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp1_, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp2_, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp3_, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp4_, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = page;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_connect (_tmp5_, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return self;
#line 292 "page-view.c"
}


PageView* page_view_new (Page* page) {
#line 85 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return page_view_construct (TYPE_PAGE_VIEW, page);
#line 299 "page-view.c"
}


static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample) {
	guchar result = '\0';
#line 104 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 107 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (guchar) 0xFF;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 311 "page-view.c"
}


static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1) {
	Page* _tmp0_ = NULL;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
	gint depth = 0;
	Page* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint n_channels = 0;
	Page* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	guchar* pixels = NULL;
	Page* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	guchar* _tmp31_ = NULL;
	gint pixels_length1 = 0;
	gint _pixels_size_ = 0;
	gint offset = 0;
	Page* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gboolean _tmp36_ = FALSE;
	gint _tmp37_ = 0;
	guchar* _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	guchar* _tmp106_ = NULL;
	gint _tmp106__length1 = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	gint _tmp109_ = 0;
	gint _tmp110_ = 0;
	gint _tmp111_ = 0;
	guchar _tmp112_ = '\0';
	guchar _tmp113_ = '\0';
	guchar* _tmp114_ = NULL;
	gint _tmp114__length1 = 0;
	guchar* _tmp115_ = NULL;
	gint _tmp115__length1 = 0;
	gint _tmp116_ = 0;
	gint _tmp117_ = 0;
	gint _tmp118_ = 0;
	gint _tmp119_ = 0;
	gint _tmp120_ = 0;
	guchar _tmp121_ = '\0';
	guchar _tmp122_ = '\0';
	guchar* _tmp123_ = NULL;
	gint _tmp123__length1 = 0;
	guchar* _tmp124_ = NULL;
	gint _tmp124__length1 = 0;
	gint _tmp125_ = 0;
	gint _tmp126_ = 0;
	gint _tmp127_ = 0;
	gint _tmp128_ = 0;
	gint _tmp129_ = 0;
	guchar _tmp130_ = '\0';
	guchar _tmp131_ = '\0';
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	switch (_tmp2_) {
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 387 "page-view.c"
		{
#line 115 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 391 "page-view.c"
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 395 "page-view.c"
		{
			Page* _tmp3_ = NULL;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			Page* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp3_ = page;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp4_ = page_get_scan_width (_tmp3_);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp5_ = _tmp4_;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp6_ = x;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = (_tmp5_ - _tmp6_) - 1;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp7_ = page;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp8_ = page_get_scan_height (_tmp7_);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp9_ = _tmp8_;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp10_ = y;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			y = (_tmp9_ - _tmp10_) - 1;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 427 "page-view.c"
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 431 "page-view.c"
		{
			gint t = 0;
			gint _tmp11_ = 0;
			Page* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp11_ = x;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			t = _tmp11_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp12_ = page;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp13_ = page_get_scan_width (_tmp12_);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp14_ = _tmp13_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp15_ = y;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = (_tmp14_ - _tmp15_) - 1;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp16_ = t;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			y = _tmp16_;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 460 "page-view.c"
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 464 "page-view.c"
		{
			gint t = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			Page* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp17_ = x;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			t = _tmp17_;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp18_ = y;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = _tmp18_;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp19_ = page;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp20_ = page_get_scan_height (_tmp19_);
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp21_ = _tmp20_;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp22_ = t;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			y = (_tmp21_ - _tmp22_) - 1;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 493 "page-view.c"
		}
		default:
#line 112 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		break;
#line 498 "page-view.c"
	}
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = page;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = page_get_depth (_tmp23_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = _tmp24_;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	depth = _tmp25_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = page;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp27_ = page_get_n_channels (_tmp26_);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp28_ = _tmp27_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	n_channels = _tmp28_;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp29_ = page;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp31_ = page_get_pixels (_tmp29_, &_tmp30_);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	pixels = _tmp31_;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	pixels_length1 = _tmp30_;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_pixels_size_ = pixels_length1;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp32_ = page;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp33_ = page_get_rowstride (_tmp32_);
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp34_ = _tmp33_;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp35_ = y;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	offset = _tmp34_ * _tmp35_;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp37_ = depth;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp37_ == 8) {
#line 540 "page-view.c"
		gint _tmp38_ = 0;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp38_ = n_channels;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = _tmp38_ == 3;
#line 546 "page-view.c"
	} else {
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = FALSE;
#line 550 "page-view.c"
	}
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp36_) {
#line 554 "page-view.c"
		gint o = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		guchar* _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		guchar* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gint _tmp44_ = 0;
		guchar _tmp45_ = '\0';
		guchar _tmp46_ = '\0';
		guchar* _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		guchar* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		gint _tmp49_ = 0;
		guchar _tmp50_ = '\0';
		guchar _tmp51_ = '\0';
		guchar* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		guchar* _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		gint _tmp54_ = 0;
		guchar _tmp55_ = '\0';
		guchar _tmp56_ = '\0';
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp39_ = offset;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp40_ = x;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp41_ = n_channels;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		o = _tmp39_ + (_tmp40_ * _tmp41_);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = pixel;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42__length1 = pixel_length1;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = pixels;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43__length1 = pixels_length1;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44_ = o;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = _tmp43_[_tmp44_];
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_[0] = _tmp45_;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = _tmp42_[0];
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_ = pixel;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47__length1 = pixel_length1;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp48_ = pixels;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp48__length1 = pixels_length1;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp49_ = o;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp50_ = _tmp48_[_tmp49_ + 1];
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_[1] = _tmp50_;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp51_ = _tmp47_[1];
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_ = pixel;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52__length1 = pixel_length1;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53_ = pixels;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53__length1 = pixels_length1;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp54_ = o;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp55_ = _tmp53_[_tmp54_ + 2];
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_[2] = _tmp55_;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = _tmp52_[2];
#line 144 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 638 "page-view.c"
	} else {
		gboolean _tmp57_ = FALSE;
		gint _tmp58_ = 0;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp58_ = depth;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp58_ == 8) {
#line 646 "page-view.c"
			gint _tmp59_ = 0;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp59_ = n_channels;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp57_ = _tmp59_ == 1;
#line 652 "page-view.c"
		} else {
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp57_ = FALSE;
#line 656 "page-view.c"
		}
#line 146 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp57_) {
#line 660 "page-view.c"
			guchar* _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			guchar* _tmp61_ = NULL;
			gint _tmp61__length1 = 0;
			guchar* _tmp62_ = NULL;
			gint _tmp62__length1 = 0;
			guchar* _tmp63_ = NULL;
			gint _tmp63__length1 = 0;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			guchar _tmp66_ = '\0';
			guchar _tmp67_ = '\0';
			guchar _tmp68_ = '\0';
			guchar _tmp69_ = '\0';
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp60_ = pixel;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp60__length1 = pixel_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp61_ = pixel;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp61__length1 = pixel_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62_ = pixel;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62__length1 = pixel_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63_ = pixels;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63__length1 = pixels_length1;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp64_ = offset;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp65_ = x;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp66_ = _tmp63_[_tmp64_ + _tmp65_];
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62_[2] = _tmp66_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp67_ = _tmp62_[2];
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp61_[1] = _tmp67_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp68_ = _tmp61_[1];
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp60_[0] = _tmp68_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp69_ = _tmp60_[0];
#line 149 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return;
#line 711 "page-view.c"
		} else {
			gboolean _tmp70_ = FALSE;
			gint _tmp71_ = 0;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp71_ = depth;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			if (_tmp71_ == 1) {
#line 719 "page-view.c"
				gint _tmp72_ = 0;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp72_ = n_channels;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp70_ = _tmp72_ == 1;
#line 725 "page-view.c"
			} else {
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp70_ = FALSE;
#line 729 "page-view.c"
			}
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			if (_tmp70_) {
#line 733 "page-view.c"
				gint o = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				guchar* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp77_ = 0;
				guchar _tmp78_ = '\0';
				gint _tmp79_ = 0;
				guchar* _tmp80_ = NULL;
				gint _tmp80__length1 = 0;
				guchar* _tmp81_ = NULL;
				gint _tmp81__length1 = 0;
				guchar* _tmp82_ = NULL;
				gint _tmp82__length1 = 0;
				guchar _tmp83_ = '\0';
				guchar _tmp84_ = '\0';
				guchar _tmp85_ = '\0';
#line 155 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp73_ = offset;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp74_ = x;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				o = _tmp73_ + (_tmp74_ / 8);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp76_ = pixels;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp76__length1 = pixels_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp77_ = o;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp78_ = _tmp76_[_tmp77_];
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp79_ = x;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (((gint) (_tmp78_ & (0x80 >> (_tmp79_ % 8)))) != 0) {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp75_ = 0x00;
#line 772 "page-view.c"
				} else {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp75_ = 0xFF;
#line 776 "page-view.c"
				}
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp80_ = pixel;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp80__length1 = pixel_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp81_ = pixel;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp81__length1 = pixel_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp82_ = pixel;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp82__length1 = pixel_length1;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp82_[2] = (guchar) _tmp75_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp83_ = _tmp82_[2];
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp81_[1] = _tmp83_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp84_ = _tmp81_[1];
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp80_[0] = _tmp84_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp85_ = _tmp80_[0];
#line 157 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				return;
#line 804 "page-view.c"
			} else {
				gboolean _tmp86_ = FALSE;
				gint _tmp87_ = 0;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp87_ = depth;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp87_ == 2) {
#line 812 "page-view.c"
					gint _tmp88_ = 0;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp88_ = n_channels;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp86_ = _tmp88_ == 1;
#line 818 "page-view.c"
				} else {
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp86_ = FALSE;
#line 822 "page-view.c"
				}
#line 161 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp86_) {
#line 826 "page-view.c"
					gint block_shift[4] = {0};
					gint _tmp89_[4] = {0};
					gint o = 0;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint sample = 0;
					guchar* _tmp92_ = NULL;
					gint _tmp92__length1 = 0;
					gint _tmp93_ = 0;
					guchar _tmp94_ = '\0';
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
					gint _tmp97_ = 0;
					guchar* _tmp98_ = NULL;
					gint _tmp98__length1 = 0;
					guchar* _tmp99_ = NULL;
					gint _tmp99__length1 = 0;
					guchar* _tmp100_ = NULL;
					gint _tmp100__length1 = 0;
					gint _tmp101_ = 0;
					guchar _tmp102_ = '\0';
					guchar _tmp103_ = '\0';
					guchar _tmp104_ = '\0';
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp89_[0] = 6;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp89_[1] = 4;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp89_[2] = 2;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp89_[3] = 0;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					memcpy (block_shift, _tmp89_, 4 * sizeof (gint));
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp90_ = offset;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp91_ = x;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					o = _tmp90_ + (_tmp91_ / 4);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp92_ = pixels;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp92__length1 = pixels_length1;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp93_ = o;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp94_ = _tmp92_[_tmp93_];
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp95_ = x;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp96_ = block_shift[_tmp95_ % 4];
#line 166 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					sample = (_tmp94_ >> _tmp96_) & 0x3;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp97_ = sample;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					sample = (_tmp97_ * 255) / 3;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp98_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp98__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp99_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp99__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp100_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp100__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp101_ = sample;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp100_[2] = (guchar) _tmp101_;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp102_ = _tmp100_[2];
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp99_[1] = _tmp102_;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp103_ = _tmp99_[1];
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp98_[0] = _tmp103_;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp104_ = _tmp98_[0];
#line 170 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					return;
#line 912 "page-view.c"
				}
			}
		}
	}
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp105_ = pixel;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp105__length1 = pixel_length1;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp106_ = pixels;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp106__length1 = pixels_length1;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp107_ = offset;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp108_ = x;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp109_ = depth;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp110_ = x;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp111_ = n_channels;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp112_ = page_view_get_sample (self, _tmp106_, _tmp106__length1, _tmp107_, _tmp108_, _tmp109_, _tmp110_ * _tmp111_);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp105_[0] = _tmp112_;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp113_ = _tmp105_[0];
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp114_ = pixel;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp114__length1 = pixel_length1;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp115_ = pixels;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp115__length1 = pixels_length1;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp116_ = offset;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp117_ = x;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp118_ = depth;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp119_ = x;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp120_ = n_channels;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp121_ = page_view_get_sample (self, _tmp115_, _tmp115__length1, _tmp116_, _tmp117_, _tmp118_, (_tmp119_ * _tmp120_) + 1);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp114_[1] = _tmp121_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp122_ = _tmp114_[1];
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp123_ = pixel;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp123__length1 = pixel_length1;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp124_ = pixels;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp124__length1 = pixels_length1;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp125_ = offset;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp126_ = x;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp127_ = depth;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp128_ = x;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp129_ = n_channels;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp130_ = page_view_get_sample (self, _tmp124_, _tmp124__length1, _tmp125_, _tmp126_, _tmp127_, (_tmp128_ * _tmp129_) + 2);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp123_[2] = _tmp130_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp131_ = _tmp123_[2];
#line 989 "page-view.c"
}


static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset) {
	gint L = 0;
	gdouble _tmp0_ = 0.0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gint R = 0;
	gdouble _tmp4_ = 0.0;
	gint T = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint B = 0;
	gdouble _tmp9_ = 0.0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gboolean _tmp283_ = FALSE;
	gdouble _tmp284_ = 0.0;
	gint _tmp285_ = 0;
	gboolean _tmp309_ = FALSE;
	gdouble _tmp310_ = 0.0;
	gint _tmp311_ = 0;
	gboolean _tmp335_ = FALSE;
	gdouble _tmp336_ = 0.0;
	gint _tmp337_ = 0;
	gboolean _tmp361_ = FALSE;
	gdouble _tmp362_ = 0.0;
	gint _tmp363_ = 0;
	gdouble scale = 0.0;
	gdouble _tmp387_ = 0.0;
	gdouble _tmp388_ = 0.0;
	gdouble _tmp389_ = 0.0;
	gdouble _tmp390_ = 0.0;
	guchar* _tmp391_ = NULL;
	gint _tmp391__length1 = 0;
	gint _tmp392_ = 0;
	gdouble _tmp393_ = 0.0;
	gdouble _tmp394_ = 0.0;
	guchar _tmp395_ = '\0';
	guchar* _tmp396_ = NULL;
	gint _tmp396__length1 = 0;
	gint _tmp397_ = 0;
	gdouble _tmp398_ = 0.0;
	gdouble _tmp399_ = 0.0;
	guchar _tmp400_ = '\0';
	guchar* _tmp401_ = NULL;
	gint _tmp401__length1 = 0;
	gint _tmp402_ = 0;
	gdouble _tmp403_ = 0.0;
	gdouble _tmp404_ = 0.0;
	guchar _tmp405_ = '\0';
#line 179 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = l;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	L = (gint) _tmp0_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = L;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = l;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (((gdouble) _tmp1_) != _tmp2_) {
#line 1062 "page-view.c"
		gint _tmp3_ = 0;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp3_ = L;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		L = _tmp3_ + 1;
#line 1068 "page-view.c"
	}
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = r;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	R = (gint) _tmp4_;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = t;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	T = (gint) _tmp5_;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = T;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = t;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (((gdouble) _tmp6_) != _tmp7_) {
#line 1084 "page-view.c"
		gint _tmp8_ = 0;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp8_ = T;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		T = _tmp8_ + 1;
#line 1090 "page-view.c"
	}
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = b;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	B = (gint) _tmp9_;
#line 234 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	red = 0.0;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	green = 0.0;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	blue = 0.0;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = r;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = l;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if ((_tmp12_ - _tmp13_) <= 1.0) {
#line 1108 "page-view.c"
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = r;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp15_ = l;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = ((gint) _tmp14_) == ((gint) _tmp15_);
#line 1117 "page-view.c"
	} else {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = FALSE;
#line 1121 "page-view.c"
	}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp11_) {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = TRUE;
#line 1127 "page-view.c"
	} else {
		gboolean _tmp16_ = FALSE;
		gdouble _tmp17_ = 0.0;
		gdouble _tmp18_ = 0.0;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp17_ = b;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp18_ = t;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp17_ - _tmp18_) <= 1.0) {
#line 1138 "page-view.c"
			gdouble _tmp19_ = 0.0;
			gdouble _tmp20_ = 0.0;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp19_ = b;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp20_ = t;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp16_ = ((gint) _tmp19_) == ((gint) _tmp20_);
#line 1147 "page-view.c"
		} else {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp16_ = FALSE;
#line 1151 "page-view.c"
		}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = _tmp16_;
#line 1155 "page-view.c"
	}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp10_) {
#line 1159 "page-view.c"
		gboolean _tmp21_ = FALSE;
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gdouble scale = 0.0;
		gdouble _tmp167_ = 0.0;
		gdouble _tmp168_ = 0.0;
		gdouble _tmp169_ = 0.0;
		gdouble _tmp170_ = 0.0;
		guchar* _tmp171_ = NULL;
		gint _tmp171__length1 = 0;
		gint _tmp172_ = 0;
		gdouble _tmp173_ = 0.0;
		gdouble _tmp174_ = 0.0;
		guchar _tmp175_ = '\0';
		guchar* _tmp176_ = NULL;
		gint _tmp176__length1 = 0;
		gint _tmp177_ = 0;
		gdouble _tmp178_ = 0.0;
		gdouble _tmp179_ = 0.0;
		guchar _tmp180_ = '\0';
		guchar* _tmp181_ = NULL;
		gint _tmp181__length1 = 0;
		gint _tmp182_ = 0;
		gdouble _tmp183_ = 0.0;
		gdouble _tmp184_ = 0.0;
		guchar _tmp185_ = '\0';
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp22_ = l;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp23_ = r;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((gint) _tmp22_) == ((gint) _tmp23_)) {
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp21_ = TRUE;
#line 1196 "page-view.c"
		} else {
			gdouble _tmp24_ = 0.0;
			gdouble _tmp25_ = 0.0;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp24_ = t;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp25_ = b;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp21_ = ((gint) _tmp24_) == ((gint) _tmp25_);
#line 1206 "page-view.c"
		}
#line 250 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp21_) {
#line 1210 "page-view.c"
			guchar p[3] = {0};
			Page* _tmp26_ = NULL;
			gdouble _tmp27_ = 0.0;
			gdouble _tmp28_ = 0.0;
			guchar* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			gint _tmp30_ = 0;
			guchar _tmp31_ = '\0';
			guchar _tmp32_ = '\0';
			guchar* _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint _tmp34_ = 0;
			guchar _tmp35_ = '\0';
			guchar _tmp36_ = '\0';
			guchar* _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp38_ = 0;
			guchar _tmp39_ = '\0';
			guchar _tmp40_ = '\0';
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp26_ = page;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp27_ = l;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp28_ = t;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp26_, (gint) _tmp27_, (gint) _tmp28_, p, 3);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp29_ = output;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp29__length1 = output_length1;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp30_ = offset;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp31_ = p[0];
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp29_[_tmp30_] = _tmp31_;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp32_ = _tmp29_[_tmp30_];
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33_ = output;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33__length1 = output_length1;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp34_ = offset;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp35_ = p[1];
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33_[_tmp34_ + 1] = _tmp35_;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp36_ = _tmp33_[_tmp34_ + 1];
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37_ = output;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37__length1 = output_length1;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp38_ = offset;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp39_ = p[2];
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37_[_tmp38_ + 2] = _tmp39_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp40_ = _tmp37_[_tmp38_ + 2];
#line 257 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return;
#line 1276 "page-view.c"
		}
#line 261 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp41_ = L;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = R;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp41_ > _tmp42_) {
#line 1284 "page-view.c"
			guchar p[3] = {0};
			Page* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gdouble _tmp46_ = 0.0;
			guchar _tmp47_ = '\0';
			gdouble _tmp48_ = 0.0;
			gdouble _tmp49_ = 0.0;
			gint _tmp50_ = 0;
			gdouble _tmp51_ = 0.0;
			gdouble _tmp52_ = 0.0;
			guchar _tmp53_ = '\0';
			gdouble _tmp54_ = 0.0;
			gdouble _tmp55_ = 0.0;
			gint _tmp56_ = 0;
			gdouble _tmp57_ = 0.0;
			gdouble _tmp58_ = 0.0;
			guchar _tmp59_ = '\0';
			gdouble _tmp60_ = 0.0;
			gdouble _tmp61_ = 0.0;
			gint _tmp62_ = 0;
			gdouble _tmp63_ = 0.0;
			Page* _tmp84_ = NULL;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			gdouble _tmp87_ = 0.0;
			guchar _tmp88_ = '\0';
			gdouble _tmp89_ = 0.0;
			gdouble _tmp90_ = 0.0;
			gdouble _tmp91_ = 0.0;
			gint _tmp92_ = 0;
			gdouble _tmp93_ = 0.0;
			guchar _tmp94_ = '\0';
			gdouble _tmp95_ = 0.0;
			gdouble _tmp96_ = 0.0;
			gdouble _tmp97_ = 0.0;
			gint _tmp98_ = 0;
			gdouble _tmp99_ = 0.0;
			guchar _tmp100_ = '\0';
			gdouble _tmp101_ = 0.0;
			gdouble _tmp102_ = 0.0;
			gdouble _tmp103_ = 0.0;
			gint _tmp104_ = 0;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp43_ = page;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp44_ = R;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp45_ = T;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp43_, _tmp44_, _tmp45_ - 1, p, 3);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp46_ = red;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp47_ = p[0];
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp48_ = r;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp49_ = l;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp50_ = T;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp51_ = t;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp46_ + ((_tmp47_ * (_tmp48_ - _tmp49_)) * (_tmp50_ - _tmp51_));
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp52_ = green;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp53_ = p[1];
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp54_ = r;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp55_ = l;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp56_ = T;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp57_ = t;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp52_ + ((_tmp53_ * (_tmp54_ - _tmp55_)) * (_tmp56_ - _tmp57_));
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp58_ = blue;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp59_ = p[2];
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp60_ = r;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp61_ = l;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp62_ = T;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63_ = t;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp58_ + ((_tmp59_ * (_tmp60_ - _tmp61_)) * (_tmp62_ - _tmp63_));
#line 1378 "page-view.c"
			{
				gint y = 0;
				gint _tmp64_ = 0;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp64_ = T;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y = _tmp64_;
#line 1386 "page-view.c"
				{
					gboolean _tmp65_ = FALSE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp65_ = TRUE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					while (TRUE) {
#line 1393 "page-view.c"
						gint _tmp67_ = 0;
						gint _tmp68_ = 0;
						Page* _tmp69_ = NULL;
						gint _tmp70_ = 0;
						gint _tmp71_ = 0;
						gdouble _tmp72_ = 0.0;
						guchar _tmp73_ = '\0';
						gdouble _tmp74_ = 0.0;
						gdouble _tmp75_ = 0.0;
						gdouble _tmp76_ = 0.0;
						guchar _tmp77_ = '\0';
						gdouble _tmp78_ = 0.0;
						gdouble _tmp79_ = 0.0;
						gdouble _tmp80_ = 0.0;
						guchar _tmp81_ = '\0';
						gdouble _tmp82_ = 0.0;
						gdouble _tmp83_ = 0.0;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!_tmp65_) {
#line 1413 "page-view.c"
							gint _tmp66_ = 0;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp66_ = y;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							y = _tmp66_ + 1;
#line 1419 "page-view.c"
						}
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp65_ = FALSE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp67_ = y;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp68_ = B;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!(_tmp67_ < _tmp68_)) {
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							break;
#line 1431 "page-view.c"
						}
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp69_ = page;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp70_ = R;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp71_ = y;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						page_view_get_pixel (self, _tmp69_, _tmp70_, _tmp71_, p, 3);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp72_ = red;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp73_ = p[0];
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp74_ = r;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp75_ = l;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						red = _tmp72_ + (_tmp73_ * (_tmp74_ - _tmp75_));
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp76_ = green;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp77_ = p[1];
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp78_ = r;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp79_ = l;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						green = _tmp76_ + (_tmp77_ * (_tmp78_ - _tmp79_));
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp80_ = blue;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp81_ = p[2];
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp82_ = r;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp83_ = l;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						blue = _tmp80_ + (_tmp81_ * (_tmp82_ - _tmp83_));
#line 1471 "page-view.c"
					}
				}
			}
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp84_ = page;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp85_ = R;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp86_ = B;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp84_, _tmp85_, _tmp86_, p, 3);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp87_ = red;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp88_ = p[0];
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp89_ = r;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp90_ = l;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp91_ = b;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp92_ = B;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp87_ + ((_tmp88_ * (_tmp89_ - _tmp90_)) * (_tmp91_ - _tmp92_));
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp93_ = green;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp94_ = p[1];
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp95_ = r;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp96_ = l;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp97_ = b;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp98_ = B;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp93_ + ((_tmp94_ * (_tmp95_ - _tmp96_)) * (_tmp97_ - _tmp98_));
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp99_ = blue;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp100_ = p[2];
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp101_ = r;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp102_ = l;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp103_ = b;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp104_ = B;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp99_ + ((_tmp100_ * (_tmp101_ - _tmp102_)) * (_tmp103_ - _tmp104_));
#line 1525 "page-view.c"
		} else {
			guchar p[3] = {0};
			Page* _tmp105_ = NULL;
			gint _tmp106_ = 0;
			gint _tmp107_ = 0;
			gdouble _tmp108_ = 0.0;
			guchar _tmp109_ = '\0';
			gdouble _tmp110_ = 0.0;
			gdouble _tmp111_ = 0.0;
			gint _tmp112_ = 0;
			gdouble _tmp113_ = 0.0;
			gdouble _tmp114_ = 0.0;
			guchar _tmp115_ = '\0';
			gdouble _tmp116_ = 0.0;
			gdouble _tmp117_ = 0.0;
			gint _tmp118_ = 0;
			gdouble _tmp119_ = 0.0;
			gdouble _tmp120_ = 0.0;
			guchar _tmp121_ = '\0';
			gdouble _tmp122_ = 0.0;
			gdouble _tmp123_ = 0.0;
			gint _tmp124_ = 0;
			gdouble _tmp125_ = 0.0;
			Page* _tmp146_ = NULL;
			gint _tmp147_ = 0;
			gint _tmp148_ = 0;
			gdouble _tmp149_ = 0.0;
			guchar _tmp150_ = '\0';
			gdouble _tmp151_ = 0.0;
			gdouble _tmp152_ = 0.0;
			gdouble _tmp153_ = 0.0;
			gint _tmp154_ = 0;
			gdouble _tmp155_ = 0.0;
			guchar _tmp156_ = '\0';
			gdouble _tmp157_ = 0.0;
			gdouble _tmp158_ = 0.0;
			gdouble _tmp159_ = 0.0;
			gint _tmp160_ = 0;
			gdouble _tmp161_ = 0.0;
			guchar _tmp162_ = '\0';
			gdouble _tmp163_ = 0.0;
			gdouble _tmp164_ = 0.0;
			gdouble _tmp165_ = 0.0;
			gint _tmp166_ = 0;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp105_ = page;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp106_ = L;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp107_ = B;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp105_, _tmp106_ - 1, _tmp107_, p, 3);
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp108_ = red;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp109_ = p[0];
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp110_ = b;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp111_ = t;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp112_ = L;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp113_ = l;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp108_ + ((_tmp109_ * (_tmp110_ - _tmp111_)) * (_tmp112_ - _tmp113_));
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp114_ = green;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp115_ = p[1];
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp116_ = b;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp117_ = t;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp118_ = L;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp119_ = l;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp114_ + ((_tmp115_ * (_tmp116_ - _tmp117_)) * (_tmp118_ - _tmp119_));
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp120_ = blue;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp121_ = p[2];
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp122_ = b;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp123_ = t;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp124_ = L;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp125_ = l;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp120_ + ((_tmp121_ * (_tmp122_ - _tmp123_)) * (_tmp124_ - _tmp125_));
#line 1620 "page-view.c"
			{
				gint x = 0;
				gint _tmp126_ = 0;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp126_ = L;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x = _tmp126_;
#line 1628 "page-view.c"
				{
					gboolean _tmp127_ = FALSE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp127_ = TRUE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					while (TRUE) {
#line 1635 "page-view.c"
						gint _tmp129_ = 0;
						gint _tmp130_ = 0;
						Page* _tmp131_ = NULL;
						gint _tmp132_ = 0;
						gint _tmp133_ = 0;
						gdouble _tmp134_ = 0.0;
						guchar _tmp135_ = '\0';
						gdouble _tmp136_ = 0.0;
						gdouble _tmp137_ = 0.0;
						gdouble _tmp138_ = 0.0;
						guchar _tmp139_ = '\0';
						gdouble _tmp140_ = 0.0;
						gdouble _tmp141_ = 0.0;
						gdouble _tmp142_ = 0.0;
						guchar _tmp143_ = '\0';
						gdouble _tmp144_ = 0.0;
						gdouble _tmp145_ = 0.0;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!_tmp127_) {
#line 1655 "page-view.c"
							gint _tmp128_ = 0;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp128_ = x;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							x = _tmp128_ + 1;
#line 1661 "page-view.c"
						}
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp127_ = FALSE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp129_ = x;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp130_ = R;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						if (!(_tmp129_ < _tmp130_)) {
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							break;
#line 1673 "page-view.c"
						}
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp131_ = page;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp132_ = x;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp133_ = B;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						page_view_get_pixel (self, _tmp131_, _tmp132_, _tmp133_, p, 3);
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp134_ = red;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp135_ = p[0];
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp136_ = b;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp137_ = t;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						red = _tmp134_ + (_tmp135_ * (_tmp136_ - _tmp137_));
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp138_ = green;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp139_ = p[1];
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp140_ = b;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp141_ = t;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						green = _tmp138_ + (_tmp139_ * (_tmp140_ - _tmp141_));
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp142_ = blue;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp143_ = p[2];
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp144_ = b;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp145_ = t;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						blue = _tmp142_ + (_tmp143_ * (_tmp144_ - _tmp145_));
#line 1713 "page-view.c"
					}
				}
			}
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp146_ = page;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp147_ = R;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp148_ = B;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			page_view_get_pixel (self, _tmp146_, _tmp147_, _tmp148_, p, 3);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp149_ = red;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp150_ = p[0];
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp151_ = b;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp152_ = t;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp153_ = r;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp154_ = R;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			red = _tmp149_ + ((_tmp150_ * (_tmp151_ - _tmp152_)) * (_tmp153_ - _tmp154_));
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp155_ = green;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp156_ = p[1];
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp157_ = b;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp158_ = t;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp159_ = r;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp160_ = R;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			green = _tmp155_ + ((_tmp156_ * (_tmp157_ - _tmp158_)) * (_tmp159_ - _tmp160_));
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp161_ = blue;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp162_ = p[2];
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp163_ = b;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp164_ = t;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp165_ = r;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp166_ = R;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			blue = _tmp161_ + ((_tmp162_ * (_tmp163_ - _tmp164_)) * (_tmp165_ - _tmp166_));
#line 1767 "page-view.c"
		}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp167_ = r;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp168_ = l;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp169_ = b;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp170_ = t;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		scale = 1.0 / ((_tmp167_ - _tmp168_) * (_tmp169_ - _tmp170_));
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp171_ = output;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp171__length1 = output_length1;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp172_ = offset;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp173_ = red;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp174_ = scale;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp171_[_tmp172_] = (guchar) ((_tmp173_ * _tmp174_) + 0.5);
#line 301 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp175_ = _tmp171_[_tmp172_];
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp176_ = output;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp176__length1 = output_length1;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp177_ = offset;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp178_ = green;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp179_ = scale;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp176_[_tmp177_ + 1] = (guchar) ((_tmp178_ * _tmp179_) + 0.5);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp180_ = _tmp176_[_tmp177_ + 1];
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp181_ = output;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp181__length1 = output_length1;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp182_ = offset;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp183_ = blue;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp184_ = scale;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp181_[_tmp182_ + 2] = (guchar) ((_tmp183_ * _tmp184_) + 0.5);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp185_ = _tmp181_[_tmp182_ + 2];
#line 304 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 1823 "page-view.c"
	}
	{
		gint x = 0;
		gint _tmp186_ = 0;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp186_ = L;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp186_;
#line 1832 "page-view.c"
		{
			gboolean _tmp187_ = FALSE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp187_ = TRUE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 1839 "page-view.c"
				gint _tmp189_ = 0;
				gint _tmp190_ = 0;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp187_) {
#line 1844 "page-view.c"
					gint _tmp188_ = 0;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp188_ = x;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = _tmp188_ + 1;
#line 1850 "page-view.c"
				}
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp187_ = FALSE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp189_ = x;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp190_ = R;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp189_ < _tmp190_)) {
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 1862 "page-view.c"
				}
				{
					gint y = 0;
					gint _tmp191_ = 0;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp191_ = T;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = _tmp191_;
#line 1871 "page-view.c"
					{
						gboolean _tmp192_ = FALSE;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp192_ = TRUE;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						while (TRUE) {
#line 1878 "page-view.c"
							gint _tmp194_ = 0;
							gint _tmp195_ = 0;
							guchar p[3] = {0};
							Page* _tmp196_ = NULL;
							gint _tmp197_ = 0;
							gint _tmp198_ = 0;
							gdouble _tmp199_ = 0.0;
							guchar _tmp200_ = '\0';
							gdouble _tmp201_ = 0.0;
							guchar _tmp202_ = '\0';
							gdouble _tmp203_ = 0.0;
							guchar _tmp204_ = '\0';
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!_tmp192_) {
#line 1893 "page-view.c"
								gint _tmp193_ = 0;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp193_ = y;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								y = _tmp193_ + 1;
#line 1899 "page-view.c"
							}
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp192_ = FALSE;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp194_ = y;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp195_ = B;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!(_tmp194_ < _tmp195_)) {
#line 310 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								break;
#line 1911 "page-view.c"
							}
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp196_ = page;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp197_ = x;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp198_ = y;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							page_view_get_pixel (self, _tmp196_, _tmp197_, _tmp198_, p, 3);
#line 314 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp199_ = red;
#line 314 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp200_ = p[0];
#line 314 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							red = _tmp199_ + _tmp200_;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp201_ = green;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp202_ = p[1];
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							green = _tmp201_ + _tmp202_;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp203_ = blue;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp204_ = p[2];
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							blue = _tmp203_ + _tmp204_;
#line 1939 "page-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		gint _tmp205_ = 0;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp205_ = L;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp205_;
#line 1953 "page-view.c"
		{
			gboolean _tmp206_ = FALSE;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp206_ = TRUE;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 1960 "page-view.c"
				gint _tmp208_ = 0;
				gint _tmp209_ = 0;
				gdouble _tmp210_ = 0.0;
				gint _tmp211_ = 0;
				gdouble _tmp227_ = 0.0;
				gint _tmp228_ = 0;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp206_) {
#line 1969 "page-view.c"
					gint _tmp207_ = 0;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp207_ = x;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = _tmp207_ + 1;
#line 1975 "page-view.c"
				}
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp206_ = FALSE;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp208_ = x;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp209_ = R;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp208_ < _tmp209_)) {
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 1987 "page-view.c"
				}
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp210_ = t;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp211_ = T;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp210_ != ((gdouble) _tmp211_)) {
#line 1995 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp212_ = NULL;
					gint _tmp213_ = 0;
					gint _tmp214_ = 0;
					gdouble _tmp215_ = 0.0;
					guchar _tmp216_ = '\0';
					gint _tmp217_ = 0;
					gdouble _tmp218_ = 0.0;
					gdouble _tmp219_ = 0.0;
					guchar _tmp220_ = '\0';
					gint _tmp221_ = 0;
					gdouble _tmp222_ = 0.0;
					gdouble _tmp223_ = 0.0;
					guchar _tmp224_ = '\0';
					gint _tmp225_ = 0;
					gdouble _tmp226_ = 0.0;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp212_ = page;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp213_ = x;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp214_ = T;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp212_, _tmp213_, _tmp214_ - 1, p, 3);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp215_ = red;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp216_ = p[0];
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp217_ = T;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp218_ = t;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp215_ + (_tmp216_ * (_tmp217_ - _tmp218_));
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp219_ = green;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp220_ = p[1];
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp221_ = T;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp222_ = t;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp219_ + (_tmp220_ * (_tmp221_ - _tmp222_));
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp223_ = blue;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp224_ = p[2];
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp225_ = T;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp226_ = t;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp223_ + (_tmp224_ * (_tmp225_ - _tmp226_));
#line 2050 "page-view.c"
				}
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp227_ = b;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp228_ = B;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp227_ != ((gdouble) _tmp228_)) {
#line 2058 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp229_ = NULL;
					gint _tmp230_ = 0;
					gint _tmp231_ = 0;
					gdouble _tmp232_ = 0.0;
					guchar _tmp233_ = '\0';
					gdouble _tmp234_ = 0.0;
					gint _tmp235_ = 0;
					gdouble _tmp236_ = 0.0;
					guchar _tmp237_ = '\0';
					gdouble _tmp238_ = 0.0;
					gint _tmp239_ = 0;
					gdouble _tmp240_ = 0.0;
					guchar _tmp241_ = '\0';
					gdouble _tmp242_ = 0.0;
					gint _tmp243_ = 0;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp229_ = page;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp230_ = x;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp231_ = B;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp229_, _tmp230_, _tmp231_, p, 3);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp232_ = red;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp233_ = p[0];
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp234_ = b;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp235_ = B;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp232_ + (_tmp233_ * (_tmp234_ - _tmp235_));
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp236_ = green;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp237_ = p[1];
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp238_ = b;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp239_ = B;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp236_ + (_tmp237_ * (_tmp238_ - _tmp239_));
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp240_ = blue;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp241_ = p[2];
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp242_ = b;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp243_ = B;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp240_ + (_tmp241_ * (_tmp242_ - _tmp243_));
#line 2113 "page-view.c"
				}
			}
		}
	}
	{
		gint y = 0;
		gint _tmp244_ = 0;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp244_ = T;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		y = _tmp244_;
#line 2125 "page-view.c"
		{
			gboolean _tmp245_ = FALSE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp245_ = TRUE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 2132 "page-view.c"
				gint _tmp247_ = 0;
				gint _tmp248_ = 0;
				gdouble _tmp249_ = 0.0;
				gint _tmp250_ = 0;
				gdouble _tmp266_ = 0.0;
				gint _tmp267_ = 0;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp245_) {
#line 2141 "page-view.c"
					gint _tmp246_ = 0;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp246_ = y;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = _tmp246_ + 1;
#line 2147 "page-view.c"
				}
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp245_ = FALSE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp247_ = y;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp248_ = B;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp247_ < _tmp248_)) {
#line 343 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 2159 "page-view.c"
				}
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp249_ = l;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp250_ = L;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp249_ != ((gdouble) _tmp250_)) {
#line 2167 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp251_ = NULL;
					gint _tmp252_ = 0;
					gint _tmp253_ = 0;
					gdouble _tmp254_ = 0.0;
					guchar _tmp255_ = '\0';
					gint _tmp256_ = 0;
					gdouble _tmp257_ = 0.0;
					gdouble _tmp258_ = 0.0;
					guchar _tmp259_ = '\0';
					gint _tmp260_ = 0;
					gdouble _tmp261_ = 0.0;
					gdouble _tmp262_ = 0.0;
					guchar _tmp263_ = '\0';
					gint _tmp264_ = 0;
					gdouble _tmp265_ = 0.0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp251_ = page;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp252_ = L;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp253_ = y;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp251_, _tmp252_ - 1, _tmp253_, p, 3);
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp254_ = red;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp255_ = p[0];
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp256_ = L;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp257_ = l;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp254_ + (_tmp255_ * (_tmp256_ - _tmp257_));
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp258_ = green;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp259_ = p[1];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp260_ = L;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp261_ = l;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp258_ + (_tmp259_ * (_tmp260_ - _tmp261_));
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp262_ = blue;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp263_ = p[2];
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp264_ = L;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp265_ = l;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp262_ + (_tmp263_ * (_tmp264_ - _tmp265_));
#line 2222 "page-view.c"
				}
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp266_ = r;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp267_ = R;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (_tmp266_ != ((gdouble) _tmp267_)) {
#line 2230 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp268_ = NULL;
					gint _tmp269_ = 0;
					gint _tmp270_ = 0;
					gdouble _tmp271_ = 0.0;
					guchar _tmp272_ = '\0';
					gdouble _tmp273_ = 0.0;
					gint _tmp274_ = 0;
					gdouble _tmp275_ = 0.0;
					guchar _tmp276_ = '\0';
					gdouble _tmp277_ = 0.0;
					gint _tmp278_ = 0;
					gdouble _tmp279_ = 0.0;
					guchar _tmp280_ = '\0';
					gdouble _tmp281_ = 0.0;
					gint _tmp282_ = 0;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp268_ = page;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp269_ = R;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp270_ = y;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					page_view_get_pixel (self, _tmp268_, _tmp269_, _tmp270_, p, 3);
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp271_ = red;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp272_ = p[0];
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp273_ = r;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp274_ = R;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					red = _tmp271_ + (_tmp272_ * (_tmp273_ - _tmp274_));
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp275_ = green;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp276_ = p[1];
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp277_ = r;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp278_ = R;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					green = _tmp275_ + (_tmp276_ * (_tmp277_ - _tmp278_));
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp279_ = blue;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp280_ = p[2];
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp281_ = r;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp282_ = R;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					blue = _tmp279_ + (_tmp280_ * (_tmp281_ - _tmp282_));
#line 2285 "page-view.c"
				}
			}
		}
	}
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp284_ = l;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp285_ = L;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp284_ != ((gdouble) _tmp285_)) {
#line 2296 "page-view.c"
		gdouble _tmp286_ = 0.0;
		gint _tmp287_ = 0;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp286_ = t;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp287_ = T;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp283_ = _tmp286_ != ((gdouble) _tmp287_);
#line 2305 "page-view.c"
	} else {
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp283_ = FALSE;
#line 2309 "page-view.c"
	}
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp283_) {
#line 2313 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp288_ = NULL;
		gint _tmp289_ = 0;
		gint _tmp290_ = 0;
		gdouble _tmp291_ = 0.0;
		guchar _tmp292_ = '\0';
		gint _tmp293_ = 0;
		gdouble _tmp294_ = 0.0;
		gint _tmp295_ = 0;
		gdouble _tmp296_ = 0.0;
		gdouble _tmp297_ = 0.0;
		guchar _tmp298_ = '\0';
		gint _tmp299_ = 0;
		gdouble _tmp300_ = 0.0;
		gint _tmp301_ = 0;
		gdouble _tmp302_ = 0.0;
		gdouble _tmp303_ = 0.0;
		guchar _tmp304_ = '\0';
		gint _tmp305_ = 0;
		gdouble _tmp306_ = 0.0;
		gint _tmp307_ = 0;
		gdouble _tmp308_ = 0.0;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp288_ = page;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp289_ = L;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp290_ = T;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp288_, _tmp289_ - 1, _tmp290_ - 1, p, 3);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp291_ = red;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp292_ = p[0];
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp293_ = L;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp294_ = l;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp295_ = T;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp296_ = t;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp291_ + ((_tmp292_ * (_tmp293_ - _tmp294_)) * (_tmp295_ - _tmp296_));
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp297_ = green;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp298_ = p[1];
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp299_ = L;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp300_ = l;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp301_ = T;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp302_ = t;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp297_ + ((_tmp298_ * (_tmp299_ - _tmp300_)) * (_tmp301_ - _tmp302_));
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp303_ = blue;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp304_ = p[2];
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp305_ = L;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp306_ = l;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp307_ = T;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp308_ = t;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp303_ + ((_tmp304_ * (_tmp305_ - _tmp306_)) * (_tmp307_ - _tmp308_));
#line 2386 "page-view.c"
	}
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp310_ = r;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp311_ = R;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp310_ != ((gdouble) _tmp311_)) {
#line 2394 "page-view.c"
		gdouble _tmp312_ = 0.0;
		gint _tmp313_ = 0;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp312_ = t;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp313_ = T;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp309_ = _tmp312_ != ((gdouble) _tmp313_);
#line 2403 "page-view.c"
	} else {
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp309_ = FALSE;
#line 2407 "page-view.c"
	}
#line 373 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp309_) {
#line 2411 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp314_ = NULL;
		gint _tmp315_ = 0;
		gint _tmp316_ = 0;
		gdouble _tmp317_ = 0.0;
		guchar _tmp318_ = '\0';
		gdouble _tmp319_ = 0.0;
		gint _tmp320_ = 0;
		gint _tmp321_ = 0;
		gdouble _tmp322_ = 0.0;
		gdouble _tmp323_ = 0.0;
		guchar _tmp324_ = '\0';
		gdouble _tmp325_ = 0.0;
		gint _tmp326_ = 0;
		gint _tmp327_ = 0;
		gdouble _tmp328_ = 0.0;
		gdouble _tmp329_ = 0.0;
		guchar _tmp330_ = '\0';
		gdouble _tmp331_ = 0.0;
		gint _tmp332_ = 0;
		gint _tmp333_ = 0;
		gdouble _tmp334_ = 0.0;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp314_ = page;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp315_ = R;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp316_ = T;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp314_, _tmp315_, _tmp316_ - 1, p, 3);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp317_ = red;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp318_ = p[0];
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp319_ = r;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp320_ = R;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp321_ = T;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp322_ = t;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp317_ + ((_tmp318_ * (_tmp319_ - _tmp320_)) * (_tmp321_ - _tmp322_));
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp323_ = green;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp324_ = p[1];
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp325_ = r;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp326_ = R;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp327_ = T;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp328_ = t;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp323_ + ((_tmp324_ * (_tmp325_ - _tmp326_)) * (_tmp327_ - _tmp328_));
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp329_ = blue;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp330_ = p[2];
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp331_ = r;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp332_ = R;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp333_ = T;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp334_ = t;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp329_ + ((_tmp330_ * (_tmp331_ - _tmp332_)) * (_tmp333_ - _tmp334_));
#line 2484 "page-view.c"
	}
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp336_ = r;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp337_ = R;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp336_ != ((gdouble) _tmp337_)) {
#line 2492 "page-view.c"
		gdouble _tmp338_ = 0.0;
		gint _tmp339_ = 0;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp338_ = b;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp339_ = B;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp335_ = _tmp338_ != ((gdouble) _tmp339_);
#line 2501 "page-view.c"
	} else {
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp335_ = FALSE;
#line 2505 "page-view.c"
	}
#line 381 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp335_) {
#line 2509 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp340_ = NULL;
		gint _tmp341_ = 0;
		gint _tmp342_ = 0;
		gdouble _tmp343_ = 0.0;
		guchar _tmp344_ = '\0';
		gdouble _tmp345_ = 0.0;
		gint _tmp346_ = 0;
		gdouble _tmp347_ = 0.0;
		gint _tmp348_ = 0;
		gdouble _tmp349_ = 0.0;
		guchar _tmp350_ = '\0';
		gdouble _tmp351_ = 0.0;
		gint _tmp352_ = 0;
		gdouble _tmp353_ = 0.0;
		gint _tmp354_ = 0;
		gdouble _tmp355_ = 0.0;
		guchar _tmp356_ = '\0';
		gdouble _tmp357_ = 0.0;
		gint _tmp358_ = 0;
		gdouble _tmp359_ = 0.0;
		gint _tmp360_ = 0;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp340_ = page;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp341_ = R;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp342_ = B;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp340_, _tmp341_, _tmp342_, p, 3);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp343_ = red;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp344_ = p[0];
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp345_ = r;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp346_ = R;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp347_ = b;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp348_ = B;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp343_ + ((_tmp344_ * (_tmp345_ - _tmp346_)) * (_tmp347_ - _tmp348_));
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp349_ = green;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp350_ = p[1];
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp351_ = r;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp352_ = R;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp353_ = b;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp354_ = B;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp349_ + ((_tmp350_ * (_tmp351_ - _tmp352_)) * (_tmp353_ - _tmp354_));
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp355_ = blue;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp356_ = p[2];
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp357_ = r;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp358_ = R;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp359_ = b;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp360_ = B;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp355_ + ((_tmp356_ * (_tmp357_ - _tmp358_)) * (_tmp359_ - _tmp360_));
#line 2582 "page-view.c"
	}
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp362_ = l;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp363_ = L;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp362_ != ((gdouble) _tmp363_)) {
#line 2590 "page-view.c"
		gdouble _tmp364_ = 0.0;
		gint _tmp365_ = 0;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp364_ = b;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp365_ = B;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp361_ = _tmp364_ != ((gdouble) _tmp365_);
#line 2599 "page-view.c"
	} else {
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp361_ = FALSE;
#line 2603 "page-view.c"
	}
#line 389 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp361_) {
#line 2607 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp366_ = NULL;
		gint _tmp367_ = 0;
		gint _tmp368_ = 0;
		gdouble _tmp369_ = 0.0;
		guchar _tmp370_ = '\0';
		gint _tmp371_ = 0;
		gdouble _tmp372_ = 0.0;
		gdouble _tmp373_ = 0.0;
		gint _tmp374_ = 0;
		gdouble _tmp375_ = 0.0;
		guchar _tmp376_ = '\0';
		gint _tmp377_ = 0;
		gdouble _tmp378_ = 0.0;
		gdouble _tmp379_ = 0.0;
		gint _tmp380_ = 0;
		gdouble _tmp381_ = 0.0;
		guchar _tmp382_ = '\0';
		gint _tmp383_ = 0;
		gdouble _tmp384_ = 0.0;
		gdouble _tmp385_ = 0.0;
		gint _tmp386_ = 0;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp366_ = page;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp367_ = L;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp368_ = B;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_get_pixel (self, _tmp366_, _tmp367_ - 1, _tmp368_, p, 3);
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp369_ = red;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp370_ = p[0];
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp371_ = L;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp372_ = l;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp373_ = b;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp374_ = B;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		red = _tmp369_ + ((_tmp370_ * (_tmp371_ - _tmp372_)) * (_tmp373_ - _tmp374_));
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp375_ = green;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp376_ = p[1];
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp377_ = L;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp378_ = l;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp379_ = b;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp380_ = B;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		green = _tmp375_ + ((_tmp376_ * (_tmp377_ - _tmp378_)) * (_tmp379_ - _tmp380_));
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp381_ = blue;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp382_ = p[2];
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp383_ = L;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp384_ = l;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp385_ = b;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp386_ = B;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		blue = _tmp381_ + ((_tmp382_ * (_tmp383_ - _tmp384_)) * (_tmp385_ - _tmp386_));
#line 2680 "page-view.c"
	}
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp387_ = r;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp388_ = l;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp389_ = b;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp390_ = t;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	scale = 1.0 / ((_tmp387_ - _tmp388_) * (_tmp389_ - _tmp390_));
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp391_ = output;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp391__length1 = output_length1;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp392_ = offset;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp393_ = red;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp394_ = scale;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp391_[_tmp392_] = (guchar) ((_tmp393_ * _tmp394_) + 0.5);
#line 400 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp395_ = _tmp391_[_tmp392_];
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp396_ = output;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp396__length1 = output_length1;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp397_ = offset;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp398_ = green;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp399_ = scale;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp396_[_tmp397_ + 1] = (guchar) ((_tmp398_ * _tmp399_) + 0.5);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp400_ = _tmp396_[_tmp397_ + 1];
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp401_ = output;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp401__length1 = output_length1;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp402_ = offset;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp403_ = blue;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp404_ = scale;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp401_[_tmp402_ + 2] = (guchar) ((_tmp403_ * _tmp404_) + 0.5);
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp405_ = _tmp401_[_tmp402_ + 2];
#line 2734 "page-view.c"
}


static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line) {
	gint input_width = 0;
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint input_height = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GdkPixbuf* _tmp8_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	GdkPixbuf* _tmp70_ = NULL;
	guchar* output = NULL;
	GdkPixbuf* _tmp71_ = NULL;
	guint8* _tmp72_ = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	gint output_rowstride = 0;
	GdkPixbuf* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint output_n_channels = 0;
	GdkPixbuf* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	Page* _tmp79_ = NULL;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	input_width = _tmp2_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	input_height = _tmp5_;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = *output_image;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == NULL) {
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = TRUE;
#line 2807 "page-view.c"
	} else {
		GdkPixbuf* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = *output_image;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = _tmp10_;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp12_ = output_width;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = _tmp11_ != _tmp12_;
#line 2823 "page-view.c"
	}
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp7_) {
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = TRUE;
#line 2829 "page-view.c"
	} else {
		GdkPixbuf* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp13_ = *output_image;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp15_ = _tmp14_;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp16_ = output_height;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = _tmp15_ != _tmp16_;
#line 2845 "page-view.c"
	}
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp6_) {
#line 2849 "page-view.c"
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		GdkPixbuf* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp17_ = output_width;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp18_ = output_height;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp19_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp17_, _tmp18_);
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_object_unref0 (*output_image);
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*output_image = _tmp19_;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		L = 0;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp20_ = output_width;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		R = _tmp20_ - 1;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		T = 0;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp21_ = output_height;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		B = _tmp21_ - 1;
#line 2877 "page-view.c"
	} else {
		ScanDirection _tmp22_ = 0;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp22_ = scan_direction;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		switch (_tmp22_) {
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 2886 "page-view.c"
			{
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = 0;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp23_ = output_width;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = _tmp23_ - 1;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp24_ = old_scan_line;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp25_ = output_height;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp26_ = input_height;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = (gint) ((((gdouble) _tmp24_) * _tmp25_) / _tmp26_);
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp27_ = scan_line;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp28_ = output_height;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp29_ = input_height;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = (gint) (((((gdouble) _tmp27_) * _tmp28_) / _tmp29_) + 0.5);
#line 439 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 2919 "page-view.c"
			}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 2923 "page-view.c"
			{
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp30_ = old_scan_line;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp31_ = output_width;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp32_ = input_width;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = (gint) ((((gdouble) _tmp30_) * _tmp31_) / _tmp32_);
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp33_ = scan_line;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp34_ = output_width;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp35_ = input_width;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = (gint) (((((gdouble) _tmp33_) * _tmp34_) / _tmp35_) + 0.5);
#line 443 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = 0;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp36_ = output_height;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = _tmp36_ - 1;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 2956 "page-view.c"
			}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 2960 "page-view.c"
			{
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = 0;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp37_ = output_width;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = _tmp37_ - 1;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp38_ = input_height;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp39_ = scan_line;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp40_ = output_height;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp41_ = input_height;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = (gint) ((((gdouble) (_tmp38_ - _tmp39_)) * _tmp40_) / _tmp41_);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp42_ = input_height;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp43_ = old_scan_line;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp44_ = output_height;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp45_ = input_height;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = (gint) (((((gdouble) (_tmp42_ - _tmp43_)) * _tmp44_) / _tmp45_) + 0.5);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 2999 "page-view.c"
			}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 3003 "page-view.c"
			{
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp46_ = input_width;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp47_ = scan_line;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp48_ = output_width;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp49_ = input_width;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = (gint) ((((gdouble) (_tmp46_ - _tmp47_)) * _tmp48_) / _tmp49_);
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp50_ = input_width;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp51_ = old_scan_line;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp52_ = output_width;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp53_ = input_width;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = (gint) (((((gdouble) (_tmp50_ - _tmp51_)) * _tmp52_) / _tmp53_) + 0.5);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = 0;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp54_ = output_height;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = _tmp54_ - 1;
#line 457 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 3042 "page-view.c"
			}
			default:
			{
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				T = 0;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp55_ = T;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				B = _tmp55_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp56_ = B;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				R = _tmp56_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp57_ = R;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				L = _tmp57_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 3065 "page-view.c"
			}
		}
	}
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp58_ = R;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp59_ = output_width;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp58_ >= _tmp59_) {
#line 3075 "page-view.c"
		gint _tmp60_ = 0;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp60_ = output_width;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		R = _tmp60_ - 1;
#line 3081 "page-view.c"
	}
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp61_ = B;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp62_ = output_height;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp61_ >= _tmp62_) {
#line 3089 "page-view.c"
		gint _tmp63_ = 0;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp63_ = output_height;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		B = _tmp63_ - 1;
#line 3095 "page-view.c"
	}
#line 470 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp64_ = L;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp64_ >= 0);
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp65_ = R;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp66_ = output_width;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp65_ < _tmp66_);
#line 472 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp67_ = T;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp67_ >= 0);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp68_ = B;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp69_ = output_height;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp68_ < _tmp69_);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp70_ = *output_image;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (_tmp70_ != NULL);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp71_ = *output_image;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp72_ = gdk_pixbuf_get_pixels (_tmp71_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output = _tmp72_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output_length1 = -1;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_output_size_ = output_length1;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp73_ = *output_image;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp74_ = gdk_pixbuf_get_rowstride (_tmp73_);
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp75_ = _tmp74_;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output_rowstride = _tmp75_;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp76_ = *output_image;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp77_ = gdk_pixbuf_get_n_channels (_tmp76_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp78_ = _tmp77_;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	output_n_channels = _tmp78_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp79_ = page;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp80_ = page_get_has_data (_tmp79_);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp81_ = _tmp80_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!_tmp81_) {
#line 3155 "page-view.c"
		{
			gint x = 0;
			gint _tmp82_ = 0;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp82_ = L;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			x = _tmp82_;
#line 3163 "page-view.c"
			{
				gboolean _tmp83_ = FALSE;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp83_ = TRUE;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				while (TRUE) {
#line 3170 "page-view.c"
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!_tmp83_) {
#line 3175 "page-view.c"
						gint _tmp84_ = 0;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp84_ = x;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						x = _tmp84_ + 1;
#line 3181 "page-view.c"
					}
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp83_ = FALSE;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp85_ = x;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp86_ = R;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!(_tmp85_ <= _tmp86_)) {
#line 482 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						break;
#line 3193 "page-view.c"
					}
					{
						gint y = 0;
						gint _tmp87_ = 0;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp87_ = T;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						y = _tmp87_;
#line 3202 "page-view.c"
						{
							gboolean _tmp88_ = FALSE;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp88_ = TRUE;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							while (TRUE) {
#line 3209 "page-view.c"
								gint _tmp90_ = 0;
								gint _tmp91_ = 0;
								gint o = 0;
								gint _tmp92_ = 0;
								gint _tmp93_ = 0;
								gint _tmp94_ = 0;
								gint _tmp95_ = 0;
								guchar* _tmp96_ = NULL;
								gint _tmp96__length1 = 0;
								gint _tmp97_ = 0;
								guchar* _tmp98_ = NULL;
								gint _tmp98__length1 = 0;
								gint _tmp99_ = 0;
								guchar* _tmp100_ = NULL;
								gint _tmp100__length1 = 0;
								gint _tmp101_ = 0;
								guchar _tmp102_ = '\0';
								guchar _tmp103_ = '\0';
								guchar _tmp104_ = '\0';
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								if (!_tmp88_) {
#line 3231 "page-view.c"
									gint _tmp89_ = 0;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
									_tmp89_ = y;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
									y = _tmp89_ + 1;
#line 3237 "page-view.c"
								}
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp88_ = FALSE;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp90_ = y;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp91_ = B;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								if (!(_tmp90_ <= _tmp91_)) {
#line 483 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
									break;
#line 3249 "page-view.c"
								}
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp92_ = output_rowstride;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp93_ = y;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp94_ = x;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp95_ = output_n_channels;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								o = (_tmp92_ * _tmp93_) + (_tmp94_ * _tmp95_);
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp96_ = output;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp96__length1 = output_length1;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp97_ = o;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp98_ = output;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp98__length1 = output_length1;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp99_ = o;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp100_ = output;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp100__length1 = output_length1;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp101_ = o;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp100_[_tmp101_ + 2] = (guchar) 0xFF;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp102_ = _tmp100_[_tmp101_ + 2];
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp98_[_tmp99_ + 1] = _tmp102_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp103_ = _tmp98_[_tmp99_ + 1];
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp96_[_tmp97_] = _tmp103_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp104_ = _tmp96_[_tmp97_];
#line 3291 "page-view.c"
							}
						}
					}
				}
			}
		}
#line 488 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 3300 "page-view.c"
	}
	{
		gint x = 0;
		gint _tmp105_ = 0;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp105_ = L;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp105_;
#line 3309 "page-view.c"
		{
			gboolean _tmp106_ = FALSE;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp106_ = TRUE;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			while (TRUE) {
#line 3316 "page-view.c"
				gint _tmp108_ = 0;
				gint _tmp109_ = 0;
				gdouble l = 0.0;
				gint _tmp110_ = 0;
				gint _tmp111_ = 0;
				gint _tmp112_ = 0;
				gdouble r = 0.0;
				gint _tmp113_ = 0;
				gint _tmp114_ = 0;
				gint _tmp115_ = 0;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!_tmp106_) {
#line 3329 "page-view.c"
					gint _tmp107_ = 0;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp107_ = x;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = _tmp107_ + 1;
#line 3335 "page-view.c"
				}
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp106_ = FALSE;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp108_ = x;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp109_ = R;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				if (!(_tmp108_ <= _tmp109_)) {
#line 492 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					break;
#line 3347 "page-view.c"
				}
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp110_ = x;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp111_ = input_width;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp112_ = output_width;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				l = (((gdouble) _tmp110_) * _tmp111_) / _tmp112_;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp113_ = x;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp114_ = input_width;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp115_ = output_width;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				r = (((gdouble) (_tmp113_ + 1)) * _tmp114_) / _tmp115_;
#line 3365 "page-view.c"
				{
					gint y = 0;
					gint _tmp116_ = 0;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp116_ = T;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = _tmp116_;
#line 3373 "page-view.c"
					{
						gboolean _tmp117_ = FALSE;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp117_ = TRUE;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						while (TRUE) {
#line 3380 "page-view.c"
							gint _tmp119_ = 0;
							gint _tmp120_ = 0;
							gdouble t = 0.0;
							gint _tmp121_ = 0;
							gint _tmp122_ = 0;
							gint _tmp123_ = 0;
							gdouble b = 0.0;
							gint _tmp124_ = 0;
							gint _tmp125_ = 0;
							gint _tmp126_ = 0;
							Page* _tmp127_ = NULL;
							gdouble _tmp128_ = 0.0;
							gdouble _tmp129_ = 0.0;
							gdouble _tmp130_ = 0.0;
							gdouble _tmp131_ = 0.0;
							guchar* _tmp132_ = NULL;
							gint _tmp132__length1 = 0;
							gint _tmp133_ = 0;
							gint _tmp134_ = 0;
							gint _tmp135_ = 0;
							gint _tmp136_ = 0;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!_tmp117_) {
#line 3404 "page-view.c"
								gint _tmp118_ = 0;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								_tmp118_ = y;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								y = _tmp118_ + 1;
#line 3410 "page-view.c"
							}
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp117_ = FALSE;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp119_ = y;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp120_ = B;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							if (!(_tmp119_ <= _tmp120_)) {
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
								break;
#line 3422 "page-view.c"
							}
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp121_ = y;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp122_ = input_height;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp123_ = output_height;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							t = (((gdouble) _tmp121_) * _tmp122_) / _tmp123_;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp124_ = y;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp125_ = input_height;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp126_ = output_height;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							b = (((gdouble) (_tmp124_ + 1)) * _tmp125_) / _tmp126_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp127_ = page;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp128_ = l;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp129_ = r;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp130_ = t;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp131_ = b;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp132_ = output;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp132__length1 = output_length1;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp133_ = output_rowstride;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp134_ = y;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp135_ = x;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							_tmp136_ = output_n_channels;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
							page_view_set_pixel (self, _tmp127_, _tmp128_, _tmp129_, _tmp130_, _tmp131_, _tmp132_, _tmp132__length1, (_tmp133_ * _tmp134_) + (_tmp135_ * _tmp136_));
#line 3464 "page-view.c"
						}
					}
				}
			}
		}
	}
}


static gint page_view_get_preview_width (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->width_;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3488 "page-view.c"
}


static gint page_view_get_preview_height (PageView* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->height_;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3506 "page-view.c"
}


static void page_view_update_page_view (PageView* self) {
	gboolean _tmp0_ = FALSE;
	gint old_scan_line = 0;
	gint _tmp1_ = 0;
	gint scan_line = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	ScanDirection left_steps = 0;
	ScanDirection _tmp5_ = 0;
	Page* _tmp6_ = NULL;
	ScanDirection _tmp7_ = 0;
	ScanDirection _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	ScanDirection _tmp10_ = 0;
	Page* _tmp12_ = NULL;
	ScanDirection _tmp13_ = 0;
	ScanDirection _tmp14_ = 0;
	Page* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Page* _tmp18_ = NULL;
	ScanDirection _tmp19_ = 0;
	ScanDirection _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->update_image;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!_tmp0_) {
#line 522 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 3545 "page-view.c"
	}
#line 524 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->scan_line;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	old_scan_line = _tmp1_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page_get_scan_line (_tmp2_);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	scan_line = _tmp4_;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = self->priv->scan_direction;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = page_get_scan_direction (_tmp6_);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	left_steps = _tmp5_ - _tmp8_;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = left_steps;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp10_ != 0) {
#line 3573 "page-view.c"
		GdkPixbuf* _tmp11_ = NULL;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = self->priv->image;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = _tmp11_ != NULL;
#line 3579 "page-view.c"
	} else {
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = FALSE;
#line 3583 "page-view.c"
	}
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp9_) {
#line 530 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_object_unref0 (self->priv->image);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->image = NULL;
#line 3591 "page-view.c"
	}
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = page_get_scan_direction (_tmp12_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->scan_direction = _tmp14_;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = self->priv->_page;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = page_view_get_preview_width (self);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = page_view_get_preview_height (self);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = self->priv->_page;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = page_get_scan_direction (_tmp18_);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = _tmp19_;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = old_scan_line;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = scan_line;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_update_preview (self, _tmp15_, &self->priv->image, _tmp16_, _tmp17_, _tmp20_, _tmp21_, _tmp22_);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = FALSE;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = scan_line;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->scan_line = _tmp23_;
#line 3625 "page-view.c"
}


static gint page_view_page_to_screen_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_view_get_preview_width (self);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page_get_width (_tmp2_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp4_) + 0.5);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3652 "page-view.c"
}


static gint page_view_page_to_screen_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = y;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_view_get_preview_height (self);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = _tmp3_;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp4_) + 0.5);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3679 "page-view.c"
}


static gint page_view_screen_to_page_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_width (_tmp1_);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_view_get_preview_width (self);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp3_) / _tmp4_) + 0.5);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3706 "page-view.c"
}


static gint page_view_screen_to_page_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 558 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = y;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_height (_tmp1_);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_view_get_preview_height (self);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp3_) / _tmp4_) + 0.5);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 3733 "page-view.c"
}


static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y) {
	CropLocation result = 0;
	Page* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint cx = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint cy = 0;
	Page* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint cw = 0;
	Page* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint ch = 0;
	Page* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint dx = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint dy = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint dw = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint dh = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint ix = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint iy = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gint _tmp30_ = 0;
	gchar* name = NULL;
	Page* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gint crop_border = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gboolean _tmp47_ = FALSE;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gboolean _tmp52_ = FALSE;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gboolean _tmp58_ = FALSE;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gboolean _tmp64_ = FALSE;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
#line 563 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_get_has_crop (_tmp0_);
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = _tmp1_;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!_tmp2_) {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = 0;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 3829 "page-view.c"
	}
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = self->priv->_page;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = page_get_crop_x (_tmp3_);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = _tmp4_;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cx = _tmp5_;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = page_get_crop_y (_tmp6_);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cy = _tmp8_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = self->priv->_page;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = page_get_crop_width (_tmp9_);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = _tmp10_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cw = _tmp11_;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = page_get_crop_height (_tmp12_);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ch = _tmp14_;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = cx;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = page_view_page_to_screen_x (self, _tmp15_);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dx = _tmp16_;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = cy;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = page_view_page_to_screen_y (self, _tmp17_);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dy = _tmp18_;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = cw;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = page_view_page_to_screen_x (self, _tmp19_);
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dw = _tmp20_;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = ch;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = page_view_page_to_screen_y (self, _tmp21_);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dh = _tmp22_;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = x;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = dx;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ix = _tmp23_ - _tmp24_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = y;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = dy;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	iy = _tmp25_ - _tmp26_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp30_ = ix;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp30_ < 0) {
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = TRUE;
#line 3905 "page-view.c"
	} else {
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp31_ = ix;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp32_ = dw;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp31_ > _tmp32_;
#line 3915 "page-view.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp29_) {
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp28_ = TRUE;
#line 3921 "page-view.c"
	} else {
		gint _tmp33_ = 0;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp33_ = iy;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp28_ = _tmp33_ < 0;
#line 3928 "page-view.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp28_) {
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp27_ = TRUE;
#line 3934 "page-view.c"
	} else {
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp34_ = iy;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp35_ = dh;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp27_ = _tmp34_ > _tmp35_;
#line 3944 "page-view.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp27_) {
#line 580 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_NONE;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 3952 "page-view.c"
	}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp36_ = self->priv->_page;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp37_ = page_get_crop_name (_tmp36_);
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp38_ = _tmp37_;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp39_ = g_strdup (_tmp38_);
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	name = _tmp39_;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp40_ = name;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp40_ != NULL) {
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_MIDDLE;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 3974 "page-view.c"
	}
#line 588 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	crop_border = 20;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp41_ = dw;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp42_ = crop_border;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp41_ < (_tmp42_ * 3)) {
#line 3984 "page-view.c"
		gint _tmp43_ = 0;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = dw;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_border = _tmp43_ / 3;
#line 3990 "page-view.c"
	}
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp44_ = dh;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp45_ = crop_border;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp44_ < (_tmp45_ * 3)) {
#line 3998 "page-view.c"
		gint _tmp46_ = 0;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = dh;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_border = _tmp46_ / 3;
#line 4004 "page-view.c"
	}
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp48_ = ix;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp49_ = crop_border;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp48_ < _tmp49_) {
#line 4012 "page-view.c"
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp50_ = iy;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp51_ = crop_border;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_ = _tmp50_ < _tmp51_;
#line 4021 "page-view.c"
	} else {
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_ = FALSE;
#line 4025 "page-view.c"
	}
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp47_) {
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_TOP_LEFT;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4035 "page-view.c"
	}
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp53_ = ix;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp54_ = dw;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp55_ = crop_border;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp53_ > (_tmp54_ - _tmp55_)) {
#line 4045 "page-view.c"
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = iy;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp57_ = crop_border;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_ = _tmp56_ < _tmp57_;
#line 4054 "page-view.c"
	} else {
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_ = FALSE;
#line 4058 "page-view.c"
	}
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp52_) {
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_TOP_RIGHT;
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4068 "page-view.c"
	}
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp59_ = ix;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp60_ = crop_border;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp59_ < _tmp60_) {
#line 4076 "page-view.c"
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp61_ = iy;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp62_ = dh;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp63_ = crop_border;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp58_ = _tmp61_ > (_tmp62_ - _tmp63_);
#line 4088 "page-view.c"
	} else {
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp58_ = FALSE;
#line 4092 "page-view.c"
	}
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp58_) {
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_LEFT;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4102 "page-view.c"
	}
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp65_ = ix;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp66_ = dw;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp67_ = crop_border;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp65_ > (_tmp66_ - _tmp67_)) {
#line 4112 "page-view.c"
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp68_ = iy;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp69_ = dh;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp70_ = crop_border;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp64_ = _tmp68_ > (_tmp69_ - _tmp70_);
#line 4124 "page-view.c"
	} else {
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp64_ = FALSE;
#line 4128 "page-view.c"
	}
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp64_) {
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_RIGHT;
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4138 "page-view.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp71_ = ix;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp72_ = crop_border;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp71_ < _tmp72_) {
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_LEFT;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4152 "page-view.c"
	}
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp73_ = ix;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp74_ = dw;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp75_ = crop_border;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp73_ > (_tmp74_ - _tmp75_)) {
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_RIGHT;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4168 "page-view.c"
	}
#line 614 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp76_ = iy;
#line 614 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp77_ = crop_border;
#line 614 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp76_ < _tmp77_) {
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_TOP;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4182 "page-view.c"
	}
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp78_ = iy;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp79_ = dh;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp80_ = crop_border;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp78_ > (_tmp79_ - _tmp80_)) {
#line 618 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_g_free0 (name);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return result;
#line 4198 "page-view.c"
	}
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = CROP_LOCATION_MIDDLE;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_g_free0 (name);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 4206 "page-view.c"
}


void page_view_button_press (PageView* self, gint x, gint y) {
	CropLocation location = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropLocation _tmp2_ = 0;
	CropLocation _tmp3_ = 0;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = y;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	location = _tmp2_;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = location;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp3_ != CROP_LOCATION_NONE) {
#line 4230 "page-view.c"
		CropLocation _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		Page* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Page* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		Page* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		Page* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp4_ = location;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->crop_location = _tmp4_;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = x;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_px = (gdouble) _tmp5_;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = y;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_py = (gdouble) _tmp6_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = self->priv->_page;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp8_ = page_get_crop_x (_tmp7_);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp9_ = _tmp8_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_x = _tmp9_;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = self->priv->_page;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = page_get_crop_y (_tmp10_);
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp12_ = _tmp11_;
#line 634 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_y = _tmp12_;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp13_ = self->priv->_page;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp14_ = page_get_crop_width (_tmp13_);
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp15_ = _tmp14_;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_w = _tmp15_;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp16_ = self->priv->_page;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp17_ = page_get_crop_height (_tmp16_);
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp18_ = _tmp17_;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->selected_crop_h = _tmp18_;
#line 4290 "page-view.c"
	}
}


void page_view_motion (PageView* self, gint x, gint y) {
	CropLocation location = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropLocation _tmp2_ = 0;
	GdkCursorType cursor = 0;
	CropLocation _tmp3_ = 0;
	CropLocation _tmp4_ = 0;
	gint pw = 0;
	Page* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint ph = 0;
	Page* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint cw = 0;
	Page* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint ch = 0;
	Page* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint dx = 0;
	gint _tmp18_ = 0;
	gdouble _tmp19_ = 0.0;
	gint _tmp20_ = 0;
	gint dy = 0;
	gint _tmp21_ = 0;
	gdouble _tmp22_ = 0.0;
	gint _tmp23_ = 0;
	gint new_x = 0;
	gint _tmp24_ = 0;
	gint new_y = 0;
	gint _tmp25_ = 0;
	gint new_w = 0;
	gint _tmp26_ = 0;
	gint new_h = 0;
	gint _tmp27_ = 0;
	gint min_size = 0;
	gint _tmp28_ = 0;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	CropLocation _tmp31_ = 0;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	CropLocation _tmp44_ = 0;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	CropLocation _tmp57_ = 0;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	CropLocation _tmp74_ = 0;
	CropLocation _tmp89_ = 0;
	CropLocation _tmp110_ = 0;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_ = FALSE;
	CropLocation _tmp117_ = 0;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_ = FALSE;
	CropLocation _tmp126_ = 0;
	gboolean _tmp133_ = FALSE;
	gboolean _tmp134_ = FALSE;
	CropLocation _tmp135_ = 0;
	gboolean _tmp140_ = FALSE;
	gboolean _tmp141_ = FALSE;
	CropLocation _tmp142_ = 0;
	Page* _tmp147_ = NULL;
	gint _tmp148_ = 0;
	gint _tmp149_ = 0;
	gboolean _tmp150_ = FALSE;
	gint _tmp151_ = 0;
	gint _tmp152_ = 0;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = x;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = y;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	location = _tmp2_;
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = location;
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	switch (_tmp3_) {
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_MIDDLE:
#line 4385 "page-view.c"
		{
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_HAND1;
#line 648 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4391 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_TOP:
#line 4395 "page-view.c"
		{
#line 650 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_TOP_SIDE;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4401 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_BOTTOM:
#line 4405 "page-view.c"
		{
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_BOTTOM_SIDE;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4411 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_LEFT:
#line 4415 "page-view.c"
		{
#line 656 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_LEFT_SIDE;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4421 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_RIGHT:
#line 4425 "page-view.c"
		{
#line 659 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_RIGHT_SIDE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4431 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_TOP_LEFT:
#line 4435 "page-view.c"
		{
#line 662 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_TOP_LEFT_CORNER;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4441 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_TOP_RIGHT:
#line 4445 "page-view.c"
		{
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_TOP_RIGHT_CORNER;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4451 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_LEFT:
#line 4455 "page-view.c"
		{
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_BOTTOM_LEFT_CORNER;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4461 "page-view.c"
		}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_RIGHT:
#line 4465 "page-view.c"
		{
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_BOTTOM_RIGHT_CORNER;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4471 "page-view.c"
		}
		default:
		{
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			cursor = GDK_ARROW;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			break;
#line 4479 "page-view.c"
		}
	}
#line 678 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->crop_location;
#line 678 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp4_ == CROP_LOCATION_NONE) {
#line 4486 "page-view.c"
		GdkCursorType _tmp5_ = 0;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = cursor;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_set_cursor (self, _tmp5_);
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 4494 "page-view.c"
	}
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = page_get_width (_tmp6_);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = _tmp7_;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	pw = _tmp8_;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = self->priv->_page;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = page_get_height (_tmp9_);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = _tmp10_;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ph = _tmp11_;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->_page;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = page_get_crop_width (_tmp12_);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = _tmp13_;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cw = _tmp14_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = self->priv->_page;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = page_get_crop_height (_tmp15_);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = _tmp16_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	ch = _tmp17_;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = x;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = self->priv->selected_crop_px;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = page_view_screen_to_page_x (self, _tmp18_ - ((gint) _tmp19_));
#line 690 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dx = _tmp20_;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = y;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = self->priv->selected_crop_py;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp23_ = page_view_screen_to_page_y (self, _tmp21_ - ((gint) _tmp22_));
#line 691 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	dy = _tmp23_;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = self->priv->selected_crop_x;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_x = _tmp24_;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = self->priv->selected_crop_y;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_y = _tmp25_;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = self->priv->selected_crop_w;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_w = _tmp26_;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp27_ = self->priv->selected_crop_h;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	new_h = _tmp27_;
#line 699 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp28_ = page_view_screen_to_page_x (self, 15);
#line 699 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	min_size = _tmp28_;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp31_ = self->priv->crop_location;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp31_ == CROP_LOCATION_TOP_LEFT) {
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp30_ = TRUE;
#line 4570 "page-view.c"
	} else {
		CropLocation _tmp32_ = 0;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp32_ = self->priv->crop_location;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp30_ = _tmp32_ == CROP_LOCATION_LEFT;
#line 4577 "page-view.c"
	}
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp30_) {
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = TRUE;
#line 4583 "page-view.c"
	} else {
		CropLocation _tmp33_ = 0;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp33_ = self->priv->crop_location;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp33_ == CROP_LOCATION_BOTTOM_LEFT;
#line 4590 "page-view.c"
	}
#line 700 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp29_) {
#line 4594 "page-view.c"
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp34_ = dx;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp35_ = new_w;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = min_size;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp34_ > (_tmp35_ - _tmp36_)) {
#line 4608 "page-view.c"
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp37_ = new_w;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp38_ = min_size;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = _tmp37_ - _tmp38_;
#line 4617 "page-view.c"
		}
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp39_ = new_x;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp40_ = dx;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp39_ + _tmp40_) < 0) {
#line 4625 "page-view.c"
			gint _tmp41_ = 0;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp41_ = new_x;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = -_tmp41_;
#line 4631 "page-view.c"
		}
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp44_ = self->priv->crop_location;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp44_ == CROP_LOCATION_TOP_LEFT) {
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = TRUE;
#line 4640 "page-view.c"
	} else {
		CropLocation _tmp45_ = 0;
#line 710 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = self->priv->crop_location;
#line 710 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = _tmp45_ == CROP_LOCATION_TOP;
#line 4647 "page-view.c"
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp43_) {
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = TRUE;
#line 4653 "page-view.c"
	} else {
		CropLocation _tmp46_ = 0;
#line 711 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp46_ = self->priv->crop_location;
#line 711 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = _tmp46_ == CROP_LOCATION_TOP_RIGHT;
#line 4660 "page-view.c"
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp42_) {
#line 4664 "page-view.c"
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp47_ = dy;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp48_ = new_h;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp49_ = min_size;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp47_ > (_tmp48_ - _tmp49_)) {
#line 4678 "page-view.c"
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp50_ = new_h;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp51_ = min_size;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = _tmp50_ - _tmp51_;
#line 4687 "page-view.c"
		}
#line 715 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp52_ = new_y;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp53_ = dy;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp52_ + _tmp53_) < 0) {
#line 4695 "page-view.c"
			gint _tmp54_ = 0;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp54_ = new_y;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = -_tmp54_;
#line 4701 "page-view.c"
		}
	}
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp57_ = self->priv->crop_location;
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp57_ == CROP_LOCATION_TOP_RIGHT) {
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = TRUE;
#line 4710 "page-view.c"
	} else {
		CropLocation _tmp58_ = 0;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp58_ = self->priv->crop_location;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp56_ = _tmp58_ == CROP_LOCATION_RIGHT;
#line 4717 "page-view.c"
	}
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp56_) {
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp55_ = TRUE;
#line 4723 "page-view.c"
	} else {
		CropLocation _tmp59_ = 0;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp59_ = self->priv->crop_location;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp55_ = _tmp59_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4730 "page-view.c"
	}
#line 719 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp55_) {
#line 4734 "page-view.c"
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp60_ = dx;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp61_ = min_size;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp62_ = new_w;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp60_ < (_tmp61_ - _tmp62_)) {
#line 4750 "page-view.c"
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp63_ = min_size;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp64_ = new_w;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = _tmp63_ - _tmp64_;
#line 4759 "page-view.c"
		}
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp65_ = new_x;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp66_ = new_w;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp67_ = dx;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp68_ = pw;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp65_ + _tmp66_) + _tmp67_) > _tmp68_) {
#line 4771 "page-view.c"
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp69_ = pw;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp70_ = new_x;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp71_ = new_w;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = (_tmp69_ - _tmp70_) - _tmp71_;
#line 4783 "page-view.c"
		}
	}
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp74_ = self->priv->crop_location;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp74_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp73_ = TRUE;
#line 4792 "page-view.c"
	} else {
		CropLocation _tmp75_ = 0;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp75_ = self->priv->crop_location;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp73_ = _tmp75_ == CROP_LOCATION_BOTTOM;
#line 4799 "page-view.c"
	}
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp73_) {
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp72_ = TRUE;
#line 4805 "page-view.c"
	} else {
		CropLocation _tmp76_ = 0;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp76_ = self->priv->crop_location;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp72_ = _tmp76_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4812 "page-view.c"
	}
#line 728 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp72_) {
#line 4816 "page-view.c"
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
		gint _tmp85_ = 0;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp77_ = dy;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp78_ = min_size;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp79_ = new_h;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp77_ < (_tmp78_ - _tmp79_)) {
#line 4832 "page-view.c"
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp80_ = min_size;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp81_ = new_h;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = _tmp80_ - _tmp81_;
#line 4841 "page-view.c"
		}
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp82_ = new_y;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp83_ = new_h;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp84_ = dy;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp85_ = ph;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp82_ + _tmp83_) + _tmp84_) > _tmp85_) {
#line 4853 "page-view.c"
			gint _tmp86_ = 0;
			gint _tmp87_ = 0;
			gint _tmp88_ = 0;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp86_ = ph;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp87_ = new_y;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp88_ = new_h;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = (_tmp86_ - _tmp87_) - _tmp88_;
#line 4865 "page-view.c"
		}
	}
#line 737 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp89_ = self->priv->crop_location;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp89_ == CROP_LOCATION_MIDDLE) {
#line 4872 "page-view.c"
		gint _tmp90_ = 0;
		gint _tmp91_ = 0;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp100_ = 0;
		gint _tmp101_ = 0;
		gint _tmp102_ = 0;
		gint _tmp103_ = 0;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp90_ = new_x;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp91_ = dx;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp92_ = new_w;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp93_ = pw;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp90_ + _tmp91_) + _tmp92_) > _tmp93_) {
#line 4895 "page-view.c"
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp94_ = pw;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp95_ = new_x;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp96_ = new_w;
#line 740 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = (_tmp94_ - _tmp95_) - _tmp96_;
#line 4907 "page-view.c"
		}
#line 741 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp97_ = new_x;
#line 741 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp98_ = dx;
#line 741 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp97_ + _tmp98_) < 0) {
#line 4915 "page-view.c"
			gint _tmp99_ = 0;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp99_ = new_x;
#line 742 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dx = -_tmp99_;
#line 4921 "page-view.c"
		}
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp100_ = new_y;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp101_ = dy;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp102_ = new_h;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp103_ = ph;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (((_tmp100_ + _tmp101_) + _tmp102_) > _tmp103_) {
#line 4933 "page-view.c"
			gint _tmp104_ = 0;
			gint _tmp105_ = 0;
			gint _tmp106_ = 0;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp104_ = ph;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp105_ = new_y;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp106_ = new_h;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = (_tmp104_ - _tmp105_) - _tmp106_;
#line 4945 "page-view.c"
		}
#line 745 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp107_ = new_y;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp108_ = dy;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if ((_tmp107_ + _tmp108_) < 0) {
#line 4953 "page-view.c"
			gint _tmp109_ = 0;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp109_ = new_y;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			dy = -_tmp109_;
#line 4959 "page-view.c"
		}
	}
#line 750 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp110_ = self->priv->crop_location;
#line 750 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp110_ == CROP_LOCATION_MIDDLE) {
#line 4966 "page-view.c"
		gint _tmp111_ = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gint _tmp114_ = 0;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp111_ = new_x;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp112_ = dx;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_x = _tmp111_ + _tmp112_;
#line 753 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp113_ = new_y;
#line 753 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp114_ = dy;
#line 753 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_y = _tmp113_ + _tmp114_;
#line 4983 "page-view.c"
	}
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp117_ = self->priv->crop_location;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp117_ == CROP_LOCATION_TOP_LEFT) {
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp116_ = TRUE;
#line 4991 "page-view.c"
	} else {
		CropLocation _tmp118_ = 0;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp118_ = self->priv->crop_location;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp116_ = _tmp118_ == CROP_LOCATION_LEFT;
#line 4998 "page-view.c"
	}
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp116_) {
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp115_ = TRUE;
#line 5004 "page-view.c"
	} else {
		CropLocation _tmp119_ = 0;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp119_ = self->priv->crop_location;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp115_ = _tmp119_ == CROP_LOCATION_BOTTOM_LEFT;
#line 5011 "page-view.c"
	}
#line 755 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp115_) {
#line 5015 "page-view.c"
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp120_ = new_x;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp121_ = dx;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_x = _tmp120_ + _tmp121_;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp122_ = new_w;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp123_ = dx;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_w = _tmp122_ - _tmp123_;
#line 5032 "page-view.c"
	}
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp126_ = self->priv->crop_location;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp126_ == CROP_LOCATION_TOP_LEFT) {
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp125_ = TRUE;
#line 5040 "page-view.c"
	} else {
		CropLocation _tmp127_ = 0;
#line 763 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp127_ = self->priv->crop_location;
#line 763 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp125_ = _tmp127_ == CROP_LOCATION_TOP;
#line 5047 "page-view.c"
	}
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp125_) {
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp124_ = TRUE;
#line 5053 "page-view.c"
	} else {
		CropLocation _tmp128_ = 0;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp128_ = self->priv->crop_location;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp124_ = _tmp128_ == CROP_LOCATION_TOP_RIGHT;
#line 5060 "page-view.c"
	}
#line 762 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp124_) {
#line 5064 "page-view.c"
		gint _tmp129_ = 0;
		gint _tmp130_ = 0;
		gint _tmp131_ = 0;
		gint _tmp132_ = 0;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp129_ = new_y;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp130_ = dy;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_y = _tmp129_ + _tmp130_;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp131_ = new_h;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp132_ = dy;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_h = _tmp131_ - _tmp132_;
#line 5081 "page-view.c"
	}
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp135_ = self->priv->crop_location;
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp135_ == CROP_LOCATION_TOP_RIGHT) {
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp134_ = TRUE;
#line 5089 "page-view.c"
	} else {
		CropLocation _tmp136_ = 0;
#line 771 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp136_ = self->priv->crop_location;
#line 771 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp134_ = _tmp136_ == CROP_LOCATION_RIGHT;
#line 5096 "page-view.c"
	}
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp134_) {
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp133_ = TRUE;
#line 5102 "page-view.c"
	} else {
		CropLocation _tmp137_ = 0;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp137_ = self->priv->crop_location;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp133_ = _tmp137_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 5109 "page-view.c"
	}
#line 770 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp133_) {
#line 5113 "page-view.c"
		gint _tmp138_ = 0;
		gint _tmp139_ = 0;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp138_ = new_w;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp139_ = dx;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_w = _tmp138_ + _tmp139_;
#line 5122 "page-view.c"
	}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp142_ = self->priv->crop_location;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp142_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp141_ = TRUE;
#line 5130 "page-view.c"
	} else {
		CropLocation _tmp143_ = 0;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp143_ = self->priv->crop_location;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp141_ = _tmp143_ == CROP_LOCATION_BOTTOM;
#line 5137 "page-view.c"
	}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp141_) {
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp140_ = TRUE;
#line 5143 "page-view.c"
	} else {
		CropLocation _tmp144_ = 0;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp144_ = self->priv->crop_location;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp140_ = _tmp144_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 5150 "page-view.c"
	}
#line 774 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp140_) {
#line 5154 "page-view.c"
		gint _tmp145_ = 0;
		gint _tmp146_ = 0;
#line 777 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp145_ = new_h;
#line 777 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp146_ = dy;
#line 777 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		new_h = _tmp145_ + _tmp146_;
#line 5163 "page-view.c"
	}
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp147_ = self->priv->_page;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp148_ = new_x;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp149_ = new_y;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_move_crop (_tmp147_, _tmp148_, _tmp149_);
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp151_ = new_w;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp152_ = cw;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp151_ != _tmp152_) {
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp150_ = TRUE;
#line 5181 "page-view.c"
	} else {
		gint _tmp153_ = 0;
		gint _tmp154_ = 0;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp153_ = new_h;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp154_ = ch;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp150_ = _tmp153_ != _tmp154_;
#line 5191 "page-view.c"
	}
#line 782 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp150_) {
#line 5195 "page-view.c"
		Page* _tmp155_ = NULL;
		gint _tmp156_ = 0;
		gint _tmp157_ = 0;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp155_ = self->priv->_page;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp156_ = new_w;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp157_ = new_h;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_set_custom_crop (_tmp155_, _tmp156_, _tmp157_);
#line 5207 "page-view.c"
	}
}


void page_view_button_release (PageView* self, gint x, gint y) {
#line 786 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 789 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->crop_location = CROP_LOCATION_NONE;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 5219 "page-view.c"
}


static gboolean page_view_animation_cb (PageView* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 793 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 795 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->animate_segment;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->animate_n_segments;
#line 795 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->animate_segment = (_tmp0_ + 1) % _tmp1_;
#line 796 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 797 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = TRUE;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 5241 "page-view.c"
}


static gboolean _page_view_animation_cb_gsource_func (gpointer self) {
	gboolean result;
	result = page_view_animation_cb ((PageView*) self);
#line 813 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 5250 "page-view.c"
}


static void page_view_update_animation (PageView* self) {
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	guint _tmp7_ = 0U;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 800 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_is_scanning (_tmp1_);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp3_) {
#line 5275 "page-view.c"
		Page* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp4_ = self->priv->_page;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = page_get_has_data (_tmp4_);
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp6_ = _tmp5_;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = !_tmp6_;
#line 5287 "page-view.c"
	} else {
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = FALSE;
#line 5291 "page-view.c"
	}
#line 804 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	animate = _tmp0_;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = self->priv->animate_timeout;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	is_animating = _tmp7_ != ((guint) 0);
#line 806 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = animate;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = is_animating;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == _tmp9_) {
#line 807 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 5307 "page-view.c"
	}
#line 809 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = animate;
#line 809 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp10_) {
#line 5313 "page-view.c"
		guint _tmp11_ = 0U;
#line 811 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->animate_segment = 0;
#line 812 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = self->priv->animate_timeout;
#line 812 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp11_ == ((guint) 0)) {
#line 5321 "page-view.c"
			guint _tmp12_ = 0U;
#line 813 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp12_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, page_view_ref (self), page_view_unref);
#line 813 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			self->priv->animate_timeout = _tmp12_;
#line 5327 "page-view.c"
		}
	} else {
		guint _tmp13_ = 0U;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp13_ = self->priv->animate_timeout;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp13_ != ((guint) 0)) {
#line 5335 "page-view.c"
			guint _tmp14_ = 0U;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp14_ = self->priv->animate_timeout;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			g_source_remove (_tmp14_);
#line 5341 "page-view.c"
		}
#line 819 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 5345 "page-view.c"
	}
}


void page_view_render (PageView* self, cairo_t* context) {
	gint w = 0;
	gint _tmp0_ = 0;
	gint h = 0;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	cairo_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_t* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	Page* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp70_ = FALSE;
	Page* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	Page* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 823 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (context != NULL);
#line 825 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_update_animation (self);
#line 826 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_update_page_view (self);
#line 828 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = page_view_get_preview_width (self);
#line 828 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	w = _tmp0_;
#line 829 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = page_view_get_preview_height (self);
#line 829 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	h = _tmp1_;
#line 831 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = context;
#line 831 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_set_line_width (_tmp2_, (gdouble) 1);
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = context;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_x_offset;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = self->priv->_y_offset;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_translate (_tmp3_, (gdouble) _tmp4_, (gdouble) _tmp5_);
#line 835 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = context;
#line 835 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_set_source_rgb (_tmp6_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 836 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp7_ = context;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->border_width;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_set_line_width (_tmp7_, (gdouble) _tmp8_);
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = context;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp10_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = self->priv->width_;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp14_ = self->priv->height_;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp15_ = self->priv->border_width;
#line 837 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_rectangle (_tmp9_, ((gdouble) _tmp10_) / 2, ((gdouble) _tmp11_) / 2, (gdouble) (_tmp12_ - _tmp13_), (gdouble) (_tmp14_ - _tmp15_));
#line 841 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp16_ = context;
#line 841 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_stroke (_tmp16_);
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp17_ = context;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp18_ = self->priv->border_width;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp19_ = self->priv->border_width;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_translate (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_);
#line 845 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp20_ = context;
#line 845 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp21_ = self->priv->image;
#line 845 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	gdk_cairo_set_source_pixbuf (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
#line 846 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp22_ = context;
#line 846 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	cairo_paint (_tmp22_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp24_ = self->priv->_page;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp25_ = page_get_is_scanning (_tmp24_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp26_ = _tmp25_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp26_) {
#line 5471 "page-view.c"
		Page* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp27_ = self->priv->_page;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp28_ = page_get_has_data (_tmp27_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp29_ = _tmp28_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp23_ = !_tmp29_;
#line 5483 "page-view.c"
	} else {
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp23_ = FALSE;
#line 5487 "page-view.c"
	}
#line 849 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp23_) {
#line 5491 "page-view.c"
		gdouble outer_radius = 0.0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gdouble arc = 0.0;
		gint _tmp34_ = 0;
		gdouble x = 0.0;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		gdouble _tmp37_ = 0.0;
		gdouble y = 0.0;
		gdouble _tmp38_ = 0.0;
		gdouble _tmp39_ = 0.0;
		gdouble _tmp40_ = 0.0;
		gdouble inner_radius = 0.0;
		gdouble _tmp41_ = 0.0;
		gdouble _tmp42_ = 0.0;
		gdouble _tmp43_ = 0.0;
		gdouble _tmp44_ = 0.0;
		gdouble _tmp45_ = 0.0;
		gdouble offset = 0.0;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp30_ = w;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp31_ = h;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (_tmp30_ > _tmp31_) {
#line 5518 "page-view.c"
			gint _tmp32_ = 0;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp32_ = w;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			outer_radius = 0.15 * _tmp32_;
#line 5524 "page-view.c"
		} else {
			gint _tmp33_ = 0;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp33_ = h;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			outer_radius = 0.15 * _tmp33_;
#line 5531 "page-view.c"
		}
#line 856 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp34_ = self->priv->animate_n_segments;
#line 856 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		arc = G_PI / _tmp34_;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp35_ = outer_radius;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp36_ = arc;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp37_ = sin (_tmp36_);
#line 859 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp35_ * _tmp37_;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp38_ = outer_radius;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp39_ = arc;
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp40_ = cos (_tmp39_);
#line 860 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		y = _tmp38_ * (_tmp40_ - 1.0);
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp41_ = x;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp42_ = x;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp43_ = y;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp44_ = y;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp45_ = sqrt ((_tmp41_ * _tmp42_) + (_tmp43_ * _tmp44_));
#line 861 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		inner_radius = 0.6 * _tmp45_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		offset = 0.0;
#line 5567 "page-view.c"
		{
			gint i = 0;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			i = 0;
#line 5572 "page-view.c"
			{
				gboolean _tmp46_ = FALSE;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp46_ = TRUE;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				while (TRUE) {
#line 5579 "page-view.c"
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gdouble _tmp53_ = 0.0;
					gdouble _tmp54_ = 0.0;
					gdouble _tmp55_ = 0.0;
					gint _tmp56_ = 0;
					gdouble _tmp57_ = 0.0;
					gdouble _tmp58_ = 0.0;
					gdouble _tmp59_ = 0.0;
					cairo_t* _tmp60_ = NULL;
					gdouble _tmp61_ = 0.0;
					gdouble _tmp62_ = 0.0;
					gdouble _tmp63_ = 0.0;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					cairo_t* _tmp68_ = NULL;
					cairo_t* _tmp69_ = NULL;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!_tmp46_) {
#line 5600 "page-view.c"
						gint _tmp47_ = 0;
						gdouble _tmp48_ = 0.0;
						gdouble _tmp49_ = 0.0;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp47_ = i;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						i = _tmp47_ + 1;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp48_ = offset;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp49_ = arc;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						offset = _tmp48_ + (_tmp49_ * 2);
#line 5614 "page-view.c"
					}
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp46_ = FALSE;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp50_ = i;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp51_ = self->priv->animate_n_segments;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (!(_tmp50_ < _tmp51_)) {
#line 864 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						break;
#line 5626 "page-view.c"
					}
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp52_ = w;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp53_ = outer_radius;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp54_ = offset;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp55_ = sin (_tmp54_);
#line 866 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					x = (_tmp52_ / 2) + (_tmp53_ * _tmp55_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp56_ = h;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp57_ = outer_radius;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp58_ = offset;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp59_ = cos (_tmp58_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					y = (_tmp56_ / 2) - (_tmp57_ * _tmp59_);
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp60_ = context;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp61_ = x;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp62_ = y;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp63_ = inner_radius;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					cairo_arc (_tmp60_, _tmp61_, _tmp62_, _tmp63_, (gdouble) 0, 2 * G_PI);
#line 870 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp64_ = i;
#line 870 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp65_ = self->priv->animate_segment;
#line 870 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					if (_tmp64_ == _tmp65_) {
#line 5664 "page-view.c"
						cairo_t* _tmp66_ = NULL;
						cairo_t* _tmp67_ = NULL;
#line 872 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp66_ = context;
#line 872 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						cairo_set_source_rgb (_tmp66_, 0.75, 0.75, 0.75);
#line 873 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						_tmp67_ = context;
#line 873 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
						cairo_fill_preserve (_tmp67_);
#line 5675 "page-view.c"
					}
#line 876 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp68_ = context;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					cairo_set_source_rgb (_tmp68_, 0.5, 0.5, 0.5);
#line 877 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					_tmp69_ = context;
#line 877 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
					cairo_stroke (_tmp69_);
#line 5685 "page-view.c"
				}
			}
		}
	}
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp71_ = self->priv->_page;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp72_ = page_get_is_scanning (_tmp71_);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp73_ = _tmp72_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp73_) {
#line 5698 "page-view.c"
		Page* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp74_ = self->priv->_page;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp75_ = page_get_scan_line (_tmp74_);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp76_ = _tmp75_;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp70_ = _tmp76_ > 0;
#line 5710 "page-view.c"
	} else {
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp70_ = FALSE;
#line 5714 "page-view.c"
	}
#line 882 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp70_) {
#line 5718 "page-view.c"
		gint scan_line = 0;
		Page* _tmp77_ = NULL;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp80_ = NULL;
		ScanDirection _tmp81_ = 0;
		ScanDirection _tmp82_ = 0;
		cairo_t* _tmp110_ = NULL;
		gdouble _tmp111_ = 0.0;
		gdouble _tmp112_ = 0.0;
		cairo_t* _tmp113_ = NULL;
		gdouble _tmp114_ = 0.0;
		gdouble _tmp115_ = 0.0;
		cairo_t* _tmp116_ = NULL;
		cairo_t* _tmp117_ = NULL;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp77_ = self->priv->_page;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp78_ = page_get_scan_line (_tmp77_);
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp79_ = _tmp78_;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		scan_line = _tmp79_;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp80_ = self->priv->_page;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp81_ = page_get_scan_direction (_tmp80_);
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp82_ = _tmp81_;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		switch (_tmp82_) {
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 5757 "page-view.c"
			{
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				gdouble _tmp85_ = 0.0;
				gint _tmp86_ = 0;
				gdouble _tmp87_ = 0.0;
#line 891 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp83_ = scan_line;
#line 891 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp84_ = page_view_page_to_screen_y (self, _tmp83_);
#line 891 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp84_;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = (gdouble) 0;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp85_ = s;
#line 892 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = _tmp85_ + 0.5;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp86_ = w;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = (gdouble) _tmp86_;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp87_ = s;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = _tmp87_ + 0.5;
#line 894 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5786 "page-view.c"
			}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 5790 "page-view.c"
			{
				gint _tmp88_ = 0;
				gint _tmp89_ = 0;
				gint _tmp90_ = 0;
				gdouble _tmp91_ = 0.0;
				gint _tmp92_ = 0;
				gint _tmp93_ = 0;
				gdouble _tmp94_ = 0.0;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp88_ = scan_line;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp89_ = page_view_page_to_screen_y (self, _tmp88_);
#line 896 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp89_;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = (gdouble) 0;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp90_ = h;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp91_ = s;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = (_tmp90_ - _tmp91_) + 0.5;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp92_ = w;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = (gdouble) _tmp92_;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp93_ = h;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp94_ = s;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (_tmp93_ - _tmp94_) + 0.5;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5825 "page-view.c"
			}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 5829 "page-view.c"
			{
				gint _tmp95_ = 0;
				gint _tmp96_ = 0;
				gdouble _tmp97_ = 0.0;
				gdouble _tmp98_ = 0.0;
				gint _tmp99_ = 0;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp95_ = scan_line;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp96_ = page_view_page_to_screen_x (self, _tmp95_);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp96_;
#line 902 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp97_ = s;
#line 902 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = _tmp97_ + 0.5;
#line 902 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = (gdouble) 0;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp98_ = s;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = _tmp98_ + 0.5;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp99_ = h;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (gdouble) _tmp99_;
#line 904 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5858 "page-view.c"
			}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 5862 "page-view.c"
			{
				gint _tmp100_ = 0;
				gint _tmp101_ = 0;
				gint _tmp102_ = 0;
				gdouble _tmp103_ = 0.0;
				gint _tmp104_ = 0;
				gdouble _tmp105_ = 0.0;
				gint _tmp106_ = 0;
#line 906 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp100_ = scan_line;
#line 906 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp101_ = page_view_page_to_screen_x (self, _tmp100_);
#line 906 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				s = (gdouble) _tmp101_;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp102_ = w;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp103_ = s;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = (_tmp102_ - _tmp103_) + 0.5;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = (gdouble) 0;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp104_ = w;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp105_ = s;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = (_tmp104_ - _tmp105_) + 0.5;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp106_ = h;
#line 908 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (gdouble) _tmp106_;
#line 909 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5897 "page-view.c"
			}
			default:
			{
				gdouble _tmp107_ = 0.0;
				gdouble _tmp108_ = 0.0;
				gdouble _tmp109_ = 0.0;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y2 = (gdouble) 0;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp107_ = y2;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x2 = _tmp107_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp108_ = x2;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				y1 = _tmp108_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				_tmp109_ = y1;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				x1 = _tmp109_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
				break;
#line 5920 "page-view.c"
			}
		}
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp110_ = context;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp111_ = x1;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp112_ = y1;
#line 915 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_move_to (_tmp110_, _tmp111_, _tmp112_);
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp113_ = context;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp114_ = x2;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp115_ = y2;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_line_to (_tmp113_, _tmp114_, _tmp115_);
#line 917 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp116_ = context;
#line 917 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgb (_tmp116_, 1.0, 0.0, 0.0);
#line 918 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp117_ = context;
#line 918 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_stroke (_tmp117_);
#line 5947 "page-view.c"
	}
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp118_ = self->priv->_page;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp119_ = page_get_has_crop (_tmp118_);
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp120_ = _tmp119_;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp120_) {
#line 5957 "page-view.c"
		gint x = 0;
		Page* _tmp121_ = NULL;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint y = 0;
		Page* _tmp124_ = NULL;
		gint _tmp125_ = 0;
		gint _tmp126_ = 0;
		gint crop_width = 0;
		Page* _tmp127_ = NULL;
		gint _tmp128_ = 0;
		gint _tmp129_ = 0;
		gint crop_height = 0;
		Page* _tmp130_ = NULL;
		gint _tmp131_ = 0;
		gint _tmp132_ = 0;
		gint dx = 0;
		gint _tmp133_ = 0;
		gint _tmp134_ = 0;
		gint dy = 0;
		gint _tmp135_ = 0;
		gint _tmp136_ = 0;
		gint dw = 0;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		gint dh = 0;
		gint _tmp139_ = 0;
		gint _tmp140_ = 0;
		cairo_t* _tmp141_ = NULL;
		gint _tmp142_ = 0;
		gint _tmp143_ = 0;
		cairo_t* _tmp144_ = NULL;
		cairo_t* _tmp145_ = NULL;
		gint _tmp146_ = 0;
		gint _tmp147_ = 0;
		gint _tmp148_ = 0;
		gint _tmp149_ = 0;
		cairo_t* _tmp150_ = NULL;
		cairo_t* _tmp151_ = NULL;
		cairo_t* _tmp152_ = NULL;
		cairo_t* _tmp153_ = NULL;
		gint _tmp154_ = 0;
		gint _tmp155_ = 0;
		gint _tmp156_ = 0;
		gint _tmp157_ = 0;
		cairo_t* _tmp158_ = NULL;
		cairo_t* _tmp159_ = NULL;
		cairo_t* _tmp160_ = NULL;
		gint _tmp161_ = 0;
		gint _tmp162_ = 0;
		gint _tmp163_ = 0;
		gint _tmp164_ = 0;
		cairo_t* _tmp165_ = NULL;
		cairo_t* _tmp166_ = NULL;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp121_ = self->priv->_page;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp122_ = page_get_crop_x (_tmp121_);
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp123_ = _tmp122_;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		x = _tmp123_;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp124_ = self->priv->_page;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp125_ = page_get_crop_y (_tmp124_);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp126_ = _tmp125_;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		y = _tmp126_;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp127_ = self->priv->_page;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp128_ = page_get_crop_width (_tmp127_);
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp129_ = _tmp128_;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_width = _tmp129_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp130_ = self->priv->_page;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp131_ = page_get_crop_height (_tmp130_);
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp132_ = _tmp131_;
#line 927 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		crop_height = _tmp132_;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp133_ = x;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp134_ = page_view_page_to_screen_x (self, _tmp133_);
#line 929 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dx = _tmp134_;
#line 930 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp135_ = y;
#line 930 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp136_ = page_view_page_to_screen_y (self, _tmp135_);
#line 930 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dy = _tmp136_;
#line 931 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp137_ = crop_width;
#line 931 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp138_ = page_view_page_to_screen_x (self, _tmp137_);
#line 931 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dw = _tmp138_;
#line 932 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp139_ = crop_height;
#line 932 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp140_ = page_view_page_to_screen_y (self, _tmp139_);
#line 932 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dh = _tmp140_;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp141_ = context;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp142_ = w;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp143_ = h;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp141_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp142_, (gdouble) _tmp143_);
#line 936 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp144_ = context;
#line 936 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_new_sub_path (_tmp144_);
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp145_ = context;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp146_ = dx;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp147_ = dy;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp148_ = dw;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp149_ = dh;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp145_, (gdouble) _tmp146_, (gdouble) _tmp147_, (gdouble) _tmp148_, (gdouble) _tmp149_);
#line 938 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp150_ = context;
#line 938 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_fill_rule (_tmp150_, CAIRO_FILL_RULE_EVEN_ODD);
#line 939 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp151_ = context;
#line 939 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgba (_tmp151_, 0.25, 0.25, 0.25, 0.2);
#line 940 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp152_ = context;
#line 940 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_fill (_tmp152_);
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp153_ = context;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp154_ = dx;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp155_ = dy;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp156_ = dw;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp157_ = dh;
#line 943 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp153_, _tmp154_ - 1.5, _tmp155_ - 1.5, (gdouble) (_tmp156_ + 3), (gdouble) (_tmp157_ + 3));
#line 944 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp158_ = context;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgb (_tmp158_, 1.0, 1.0, 1.0);
#line 945 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp159_ = context;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_stroke (_tmp159_);
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp160_ = context;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp161_ = dx;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp162_ = dy;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp163_ = dw;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp164_ = dh;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_rectangle (_tmp160_, _tmp161_ - 0.5, _tmp162_ - 0.5, (gdouble) (_tmp163_ + 1), (gdouble) (_tmp164_ + 1));
#line 947 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp165_ = context;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_set_source_rgb (_tmp165_, 0.0, 0.0, 0.0);
#line 948 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp166_ = context;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		cairo_stroke (_tmp166_);
#line 6144 "page-view.c"
	}
}


static void page_view_page_pixels_changed_cb (PageView* self, Page* p) {
#line 994 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 994 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 997 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 998 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6158 "page-view.c"
}


static void page_view_page_size_changed_cb (PageView* self, Page* p) {
#line 1001 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1001 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1004 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1006 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6173 "page-view.c"
}


static void page_view_page_overlay_changed_cb (PageView* self, Page* p) {
#line 1009 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1009 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6184 "page-view.c"
}


static void page_view_scan_direction_changed_cb (PageView* self, Page* p) {
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6199 "page-view.c"
}


Page* page_view_get_page (PageView* self) {
	Page* result;
	Page* _tmp0_ = NULL;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6214 "page-view.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return self ? page_ref (self) : NULL;
#line 6221 "page-view.c"
}


static void page_view_set_page (PageView* self, Page* value) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = _page_ref0 (_tmp0_);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_page_unref0 (self->priv->_page);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_page = _tmp1_;
#line 6238 "page-view.c"
}


gboolean page_view_get_selected (PageView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->selected_;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6253 "page-view.c"
}


void page_view_set_selected (PageView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp3_) {
#line 6272 "page-view.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp4_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp5_ = _tmp4_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp1_ = _tmp5_;
#line 6281 "page-view.c"
	} else {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp1_ = FALSE;
#line 6285 "page-view.c"
	}
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp1_) {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = TRUE;
#line 6291 "page-view.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp8_ = _tmp7_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (!_tmp8_) {
#line 6302 "page-view.c"
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp9_ = page_view_get_selected (self);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp10_ = _tmp9_;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp6_ = !_tmp10_;
#line 6311 "page-view.c"
		} else {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			_tmp6_ = FALSE;
#line 6315 "page-view.c"
		}
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp0_ = _tmp6_;
#line 6319 "page-view.c"
	}
#line 41 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp0_) {
#line 42 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 6325 "page-view.c"
	}
#line 43 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp11_ = page_view_get_selected (self);
#line 43 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = _tmp11_;
#line 43 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_set_selected (self, _tmp12_);
#line 44 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6335 "page-view.c"
}


gint page_view_get_x_offset (PageView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_x_offset;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6350 "page-view.c"
}


void page_view_set_x_offset (PageView* self, gint value) {
	gint _tmp0_ = 0;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 64 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_x_offset = _tmp0_;
#line 6362 "page-view.c"
}


gint page_view_get_y_offset (PageView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_y_offset;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6377 "page-view.c"
}


void page_view_set_y_offset (PageView* self, gint value) {
	gint _tmp0_ = 0;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_y_offset = _tmp0_;
#line 6389 "page-view.c"
}


GdkCursorType page_view_get_cursor (PageView* self) {
	GdkCursorType result;
	GdkCursorType _tmp0_ = 0;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_cursor;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6404 "page-view.c"
}


static void page_view_set_cursor (PageView* self, GdkCursorType value) {
	GdkCursorType _tmp0_ = 0;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_cursor = _tmp0_;
#line 6416 "page-view.c"
}


gint page_view_get_width (PageView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->width_;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6431 "page-view.c"
}


void page_view_set_width (PageView* self, gint value) {
	gint h = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 955 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_height (_tmp1_);
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = page_get_width (_tmp4_);
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = _tmp5_;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	h = (gint) ((((gdouble) _tmp0_) * _tmp3_) / _tmp6_);
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->width_;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = value;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == _tmp9_) {
#line 6473 "page-view.c"
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = self->priv->height_;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = h;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = _tmp10_ == _tmp11_;
#line 6482 "page-view.c"
	} else {
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = FALSE;
#line 6486 "page-view.c"
	}
#line 959 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp7_) {
#line 960 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 6492 "page-view.c"
	}
#line 962 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = value;
#line 962 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->width_ = _tmp12_;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = h;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->height_ = _tmp13_;
#line 966 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 968 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 969 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6508 "page-view.c"
}


gint page_view_get_height (PageView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 975 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->height_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	result = _tmp0_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return result;
#line 6523 "page-view.c"
}


void page_view_set_height (PageView* self, gint value) {
	gint w = 0;
	gint _tmp0_ = 0;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 976 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = value;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp1_ = self->priv->_page;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = page_get_width (_tmp1_);
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp3_ = _tmp2_;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp5_ = page_get_height (_tmp4_);
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = _tmp5_;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	w = (gint) ((((gdouble) _tmp0_) * _tmp3_) / _tmp6_);
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->width_;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp9_ = w;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp8_ == _tmp9_) {
#line 6565 "page-view.c"
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp10_ = self->priv->height_;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp11_ = value;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = _tmp10_ == _tmp11_;
#line 6574 "page-view.c"
	} else {
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		_tmp7_ = FALSE;
#line 6578 "page-view.c"
	}
#line 980 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (_tmp7_) {
#line 981 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return;
#line 6584 "page-view.c"
	}
#line 983 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp12_ = w;
#line 983 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->width_ = _tmp12_;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp13_ = value;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->height_ = _tmp13_;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 989 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 990 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6600 "page-view.c"
}


static void value_page_view_init (GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	value->data[0].v_pointer = NULL;
#line 6607 "page-view.c"
}


static void value_page_view_free_value (GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_unref (value->data[0].v_pointer);
#line 6616 "page-view.c"
	}
}


static void value_page_view_copy_value (const GValue* src_value, GValue* dest_value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dest_value->data[0].v_pointer = page_view_ref (src_value->data[0].v_pointer);
#line 6626 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6630 "page-view.c"
	}
}


static gpointer value_page_view_peek_pointer (const GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return value->data[0].v_pointer;
#line 6638 "page-view.c"
}


static gchar* value_page_view_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (collect_values[0].v_pointer) {
#line 6645 "page-view.c"
		PageView* object;
		object = collect_values[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6652 "page-view.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6656 "page-view.c"
		}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = page_view_ref (object);
#line 6660 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6664 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return NULL;
#line 6668 "page-view.c"
}


static gchar* value_page_view_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PageView** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!object_p) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6679 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*object_p = NULL;
#line 6685 "page-view.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*object_p = value->data[0].v_pointer;
#line 6689 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		*object_p = page_view_ref (value->data[0].v_pointer);
#line 6693 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return NULL;
#line 6697 "page-view.c"
}


GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPageView* spec;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return G_PARAM_SPEC (spec);
#line 6711 "page-view.c"
}


gpointer value_get_page_view (const GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return value->data[0].v_pointer;
#line 6720 "page-view.c"
}


void value_set_page_view (GValue* value, gpointer v_object) {
	PageView* old;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_ref (value->data[0].v_pointer);
#line 6740 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6744 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_unref (old);
#line 6750 "page-view.c"
	}
}


void value_take_page_view (GValue* value, gpointer v_object) {
	PageView* old;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 6769 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6773 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		page_view_unref (old);
#line 6779 "page-view.c"
	}
}


static void page_view_class_init (PageViewClass * klass) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	page_view_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	((PageViewClass *) klass)->finalize = page_view_finalize;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_type_class_add_private (klass, sizeof (PageViewPrivate));
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_new ("size_changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6795 "page-view.c"
}


static void page_view_instance_init (PageView * self) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv = PAGE_VIEW_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->image = NULL;
#line 35 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->selected_ = FALSE;
#line 48 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->border_width = 1;
#line 51 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 76 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->_cursor = GDK_ARROW;
#line 78 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->priv->animate_n_segments = 7;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self->ref_count = 1;
#line 6816 "page-view.c"
}


static void page_view_finalize (PageView* obj) {
	PageView * self;
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	Page* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	Page* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_destroy (self);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp0_ = self->priv->_page;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp2_ = self->priv->_page;
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 98 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp4_ = self->priv->_page;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp6_ = self->priv->_page;
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_tmp8_ = self->priv->_page;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_page_unref0 (self->priv->_page);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	_g_object_unref0 (self->priv->image);
#line 6870 "page-view.c"
}


GType page_view_get_type (void) {
	static volatile gsize page_view_type_id__volatile = 0;
	if (g_once_init_enter (&page_view_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_view_init, value_page_view_free_value, value_page_view_copy_value, value_page_view_peek_pointer, "p", value_page_view_collect_value, "p", value_page_view_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_view_type_id;
		page_view_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PageView", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_view_type_id__volatile, page_view_type_id);
	}
	return page_view_type_id__volatile;
}


gpointer page_view_ref (gpointer instance) {
	PageView* self;
	self = instance;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	return instance;
#line 6895 "page-view.c"
}


void page_view_unref (gpointer instance) {
	PageView* self;
	self = instance;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		PAGE_VIEW_GET_CLASS (self)->finalize (self);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/page-view.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6908 "page-view.c"
	}
}



