/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import com.google.analytics.tracking.android.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

class MetaModel {
    private Map<String, MetaInfo> mMetaInfos = new HashMap<String, MetaInfo>();

    MetaModel() {
    }

    MetaInfo getMetaInfo(String key) {
        if (key.startsWith("&")) {
            return new MetaInfo(key.substring(1), null, null);
        }
        String tmpKey = key;
        if (key.contains("*")) {
            tmpKey = key.substring(0, key.indexOf("*"));
        }
        return this.mMetaInfos.get(tmpKey);
    }

    public void addField(String key, String urlParam, String defaultValue, Formatter formatter) {
        this.mMetaInfos.put(key, new MetaInfo(urlParam, defaultValue, formatter));
    }

    public static class MetaInfo {
        private final String mUrlParam;
        private final String mDefaultValue;
        private final Formatter mFormatter;

        public MetaInfo(String urlParam, String defaultValue, Formatter formatter) {
            this.mUrlParam = urlParam;
            this.mDefaultValue = defaultValue;
            this.mFormatter = formatter;
        }

        public String getUrlParam(String actualKey) {
            if (actualKey.contains("*")) {
                String param = this.mUrlParam;
                int slot = 0;
                String[] splits = actualKey.split("\\*");
                if (splits.length > 1) {
                    try {
                        slot = Integer.parseInt(splits[1]);
                    }
                    catch (NumberFormatException e) {
                        Log.w("Unable to parse slot for url parameter " + param);
                        return null;
                    }
                    return param + slot;
                }
                return null;
            }
            return this.mUrlParam;
        }

        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        public Formatter getFormatter() {
            return this.mFormatter;
        }

        @VisibleForTesting
        String getUrlParam() {
            return this.mUrlParam;
        }
    }

    public static interface Formatter {
        public String format(String var1);
    }
}

