/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import java.io.PrintStream;
import net.sf.picard.PicardException;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.picard.io.IoUtil;

public class BasicFastqWriter
implements FastqWriter {
    private final String path;
    private final PrintStream writer;

    public BasicFastqWriter(File file) {
        this(file, new PrintStream(IoUtil.openFileForWriting(file)));
    }

    private BasicFastqWriter(File file, PrintStream writer) {
        this.path = file != null ? file.getAbsolutePath() : "";
        this.writer = writer;
    }

    public BasicFastqWriter(PrintStream writer) {
        this(null, writer);
    }

    @Override
    public void write(FastqRecord rec) {
        this.writer.print("@");
        this.writer.println(rec.getReadHeader());
        this.writer.println(rec.getReadString());
        this.writer.print("+");
        this.writer.println(rec.getBaseQualityHeader() == null ? "" : rec.getBaseQualityHeader());
        this.writer.println(rec.getBaseQualityString());
        if (this.writer.checkError()) {
            throw new PicardException("Error in writing fastq file " + this.path);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

