/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.IntervalFilter;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.util.Interval;
import net.sf.picard.util.SamRecordIntervalIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;

public class SamRecordIntervalIteratorFactory {
    public CloseableIterator<SAMRecord> makeSamRecordIntervalIterator(SAMFileReader samReader, List<Interval> uniqueIntervals, boolean useIndex) {
        IntervalFilter intervalFilter = new IntervalFilter(uniqueIntervals, samReader.getFileHeader());
        if (!samReader.hasIndex() || !useIndex) {
            int stopAfterPosition;
            int stopAfterSequence;
            if (uniqueIntervals.isEmpty()) {
                stopAfterSequence = -1;
                stopAfterPosition = -1;
            } else {
                Interval lastInterval = uniqueIntervals.get(uniqueIntervals.size() - 1);
                stopAfterSequence = samReader.getFileHeader().getSequenceIndex(lastInterval.getSequence());
                stopAfterPosition = lastInterval.getEnd();
            }
            return new StopAfterFilteringIterator((Iterator)samReader.iterator(), intervalFilter, stopAfterSequence, stopAfterPosition);
        }
        return new FilteringIterator((Iterator<SAMRecord>)((Object)new SamRecordIntervalIterator(samReader, uniqueIntervals)), intervalFilter);
    }

    private class StopAfterFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final int stopAfterSequence;
        private final int stopAfterPosition;
        private final Iterator<SAMRecord> iterator;
        private final SamRecordFilter filter;
        private SAMRecord next = null;

        private StopAfterFilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter filter, int stopAfterSequence, int stopAfterPosition) {
            this.stopAfterSequence = stopAfterSequence;
            this.stopAfterPosition = stopAfterPosition;
            this.iterator = iterator;
            this.filter = filter;
            this.next = this.getNextRecord();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public SAMRecord next() {
            if (this.next == null) {
                throw new NoSuchElementException("Iterator has no more elements.");
            }
            SAMRecord result = this.next;
            this.next = this.getNextRecord();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove() not supported by FilteringIterator");
        }

        public void close() {
            CloserUtil.close(this.iterator);
        }

        protected SAMRecord getNextRecord() {
            while (this.iterator.hasNext()) {
                SAMRecord record = this.iterator.next();
                if (record.getReferenceIndex() == -1) {
                    return null;
                }
                if (record.getReferenceIndex() > this.stopAfterSequence) {
                    return null;
                }
                if (record.getReferenceIndex() == this.stopAfterSequence && record.getAlignmentStart() > this.stopAfterPosition) {
                    return null;
                }
                if (this.filter.filterOut(record)) continue;
                return record;
            }
            return null;
        }
    }
}

