/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import org.fest.reflect.method.Invoker;
import org.fest.reflect.method.MethodParameterTypes;
import org.fest.reflect.method.MethodReturnType;
import org.fest.reflect.method.MethodReturnTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodName {
    private final String name;

    public static MethodName startMethodAccess(String name) {
        MethodName.validateIsNotNullOrEmpty(name);
        return new MethodName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the method to access should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the method to access should not be empty");
        }
    }

    private MethodName(String name) {
        this.name = name;
    }

    public <T> MethodReturnType<T> withReturnType(Class<T> type) {
        return MethodReturnType.newReturnType(this.name, type);
    }

    public <T> MethodReturnTypeRef<T> withReturnType(TypeRef<T> type) {
        return MethodReturnTypeRef.newReturnTypeRef(this.name, type);
    }

    public MethodParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return MethodParameterTypes.newParameterTypes(this.name, parameterTypes);
    }

    public Invoker<Void> in(Object target) {
        return Invoker.newInvoker(this.name, target, new Class[0]);
    }
}

