/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.sam.SimplifyingSAMFileWriter;
import org.broadinstitute.gatk.utils.text.XReadLines;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class SliceBams
extends CommandLineProgram {
    private static final Log log = Log.getInstance(SliceBams.class);
    @Usage
    public String USAGE = "Merges multiple SAM/BAM files into one BAM overlapping chr:start-stop interval .\n";
    @Option(shortName="I", doc="List of input BAM files")
    public File INPUT_LIST;
    @Option(shortName="O", doc="SAM or BAM file to write merged result to")
    public File OUTPUT;
    @Option(shortName="L", doc="Location to include")
    public String SLICE;
    private static final int PROGRESS_INTERVAL = 1000000;

    public static void main(String[] argv) {
        System.exit(new SliceBams().instanceMain(argv));
    }

    private List<File> parseInputFiles(File list) {
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (String fileName : new XReadLines(list).readLines()) {
                files.add(new File(fileName));
            }
            return files;
        }
        catch (FileNotFoundException e) {
            throw new PicardException("Couldn't read input list", (Throwable)e);
        }
    }

    private SAMFileWriter createOutputBAM(List<File> inputBAMs) {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        log.info(new Object[]{"Reading headers"});
        int fileCounter = 1;
        for (File inFile : inputBAMs) {
            IOUtil.assertFileIsReadable((File)inFile);
            SAMFileReader inReader = new SAMFileReader(inFile, null);
            SAMFileHeader inHeader = inReader.getFileHeader();
            log.info(new Object[]{"  Reading header from file " + inFile + " " + fileCounter++ + " of " + inputBAMs.size()});
            headers.add(inHeader);
            inReader.close();
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, true);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(headerMerger.getMergedHeader(), false, this.OUTPUT);
        return new SimplifyingSAMFileWriter(out);
    }

    protected int doWork() {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)true);
        List<File> inputBAMs = this.parseInputFiles(this.INPUT_LIST);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMFileWriter out = this.createOutputBAM(inputBAMs);
        GenomeLocParser glParser = new GenomeLocParser(out.getFileHeader().getSequenceDictionary());
        GenomeLoc loc = glParser.parseGenomeLoc(this.SLICE);
        log.info(new Object[]{"Reading BAM records"});
        long numRecords = 1L;
        int fileCounter = 1;
        for (File inFile : inputBAMs) {
            IOUtil.assertFileIsReadable((File)inFile);
            log.info(new Object[]{"  Reading file " + inFile + " " + fileCounter++ + " of " + inputBAMs.size()});
            SAMFileReader reader = new SAMFileReader(inFile);
            SAMRecordIterator iterator = reader.queryOverlapping(loc.getContig(), loc.getStart(), loc.getStop());
            while (iterator.hasNext()) {
                SAMRecord record = (SAMRecord)iterator.next();
                out.addAlignment(record);
                if (numRecords % 1000000L != 0L) continue;
                log.info(new Object[]{numRecords + " records read."});
            }
            reader.close();
        }
        log.info(new Object[]{"Finished reading inputs."});
        log.info(new Object[]{"Sorting final output file."});
        out.close();
        return 0;
    }
}

