/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GolombRiceIntegerCodec
extends AbstractBitCodec<Integer> {
    private int m;
    private int log2m;
    private long mask;
    private boolean quotientBit = false;
    private int offset = 0;

    public GolombRiceIntegerCodec(int log2m) {
        this(0, log2m);
    }

    public GolombRiceIntegerCodec(int offset, int log2m) {
        this(offset, log2m, false);
    }

    public GolombRiceIntegerCodec(int offset, int log2m, boolean quotientBit) {
        this.log2m = log2m;
        this.m = 1 << log2m;
        this.quotientBit = quotientBit;
        this.offset = offset;
        this.mask = ~(-1 << log2m);
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        int unary = 0;
        while (bis.readBit() == this.quotientBit) {
            ++unary;
        }
        int remainder = bis.readBits(this.log2m);
        int result = unary * this.m + remainder;
        return result - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        long newValue = value + this.offset;
        long quotient = newValue >>> this.log2m;
        if (quotient > Integer.MAX_VALUE) {
            for (long i = 0L; i < quotient; ++i) {
                bos.write(this.quotientBit);
            }
        } else if (quotient > 0L) {
            int qi = (int)quotient;
            for (int i = 0; i < qi; ++i) {
                bos.write(this.quotientBit);
            }
        }
        bos.write(!this.quotientBit);
        long remainder = newValue & this.mask;
        long reminderMask = 1 << this.log2m - 1;
        for (int i = this.log2m - 1; i >= 0; --i) {
            long b = remainder & reminderMask;
            bos.write(b != 0L);
            reminderMask >>>= 1;
        }
        long bits = quotient + 1L + (long)this.log2m;
        return bits;
    }

    @Override
    public final long numberOfBits(Integer value) {
        return (value + this.offset) / this.m + 1 + this.log2m;
    }

    public int getLog2m() {
        return this.log2m;
    }

    public void setLog2m(int log2m) {
        this.log2m = log2m;
        this.m = 1 << log2m;
    }

    public boolean isQuotientBit() {
        return this.quotientBit;
    }

    public void setQuotientBit(boolean quotientBit) {
        this.quotientBit = quotientBit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

