/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GolombRiceIntegerCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombRiceIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.GOLOMB_RICE;
    private int offset;
    private int m;

    public GolombRiceIntegerEncoding() {
    }

    public GolombRiceIntegerEncoding(int m) {
        this.m = m;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset, int m) {
        GolombRiceIntegerEncoding e = new GolombRiceIntegerEncoding();
        e.offset = offset;
        e.m = m;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, buf);
        ByteBufferUtils.writeUnsignedITF8(this.m, buf);
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.offset = ByteBufferUtils.readUnsignedITF8(buf);
        this.m = ByteBufferUtils.readUnsignedITF8(buf);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new GolombRiceIntegerCodec(this.offset, this.m, true);
    }
}

