/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.fastq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Template {
    public byte[] name;
    public Segment segment;
    private int hashCode;
    public byte size = 0;
    public long counter = 0L;

    public Template(byte[] name) {
        this.name = name;
        this.calculateHashCode();
    }

    public void append(byte[] bases, byte[] scores) {
        Segment appendix = new Segment(bases, scores);
        Segment lastSegment = this.getLastSegment();
        if (lastSegment == null) {
            this.segment = appendix;
        } else {
            lastSegment.next = appendix;
            appendix.prev = lastSegment;
        }
        this.size = (byte)(this.size + 1);
    }

    public void prepend(byte[] bases, byte[] scores) {
        Segment appendix = new Segment(bases, scores);
        Segment firstSegment = this.getFirstSegment();
        if (firstSegment == null) {
            this.segment = appendix;
        } else {
            firstSegment.prev = appendix;
            appendix.next = firstSegment;
        }
        this.size = (byte)(this.size + 1);
    }

    public Segment getLastSegment() {
        if (this.segment == null) {
            return null;
        }
        Segment last = this.segment;
        while (last.next != null) {
            last = last.next;
        }
        return last;
    }

    public Segment getFirstSegment() {
        if (this.segment == null) {
            return null;
        }
        Segment first = this.segment;
        while (first.prev != null) {
            first = first.prev;
        }
        return first;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Template) {
            return Arrays.equals(this.name, ((Template)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        for (int i = 0; i < 4 && i < this.name.length; ++i) {
            this.hashCode <<= 8;
            this.hashCode |= this.name[this.name.length - 1 - i];
        }
        return 0;
    }

    public static void main(String[] args) {
        int max = 4;
        ArrayList<byte[]> list = new ArrayList<byte[]>(max * 2);
        for (int i = 0; i < max; ++i) {
            list.add(String.valueOf(i).getBytes());
            list.add(String.valueOf(i).getBytes());
        }
        Collections.shuffle(list);
        final AtomicInteger counter = new AtomicInteger(0);
        TemplateAssembler a = new TemplateAssembler(4 * max){

            @Override
            protected void templateComplete(Template t) {
                System.out.println("template complete: " + new String(t.name));
                counter.incrementAndGet();
            }

            @Override
            protected boolean isComplete(Template t) {
                return t.size > 1;
            }

            @Override
            protected void giveupIncomplete(List<Template> list) {
                System.out.println("Giving up on: " + list.size());
                for (Template t : list) {
                    System.out.println(new String(t.name));
                }
            }
        };
        for (byte[] name : list) {
            a.addSegment(name, "A".getBytes(), "Q".getBytes());
        }
        System.out.println("Finishing, complete=" + counter.get());
        a.finish();
    }

    public static abstract class TemplateAssembler {
        public TemplateHash hash = new TemplateHash();
        private int maxHashMapSize;

        public TemplateAssembler(int maxHashMapSize) {
            this.maxHashMapSize = maxHashMapSize;
        }

        protected abstract boolean isComplete(Template var1);

        protected abstract void templateComplete(Template var1);

        protected abstract void giveupIncomplete(List<Template> var1);

        public void addSegment(byte[] name, byte[] bases, byte[] scores) {
            System.out.println("Template.TemplateAssembler.addSegment()");
            System.out.println(this.hash.map.size());
            Template t = this.hash.add(name, bases, scores);
            System.out.println(this.hash.map.size());
            if (this.isComplete(t)) {
                System.out.println("complete");
                this.hash.remove(t.name);
                this.templateComplete(t);
            } else {
                List<Template> list;
                System.out.println("incomplete");
                if (this.hash.map.size() > this.maxHashMapSize && !(list = this.hash.purgeUpto((this.hash.counter - this.hash.min) / 2L + this.hash.min + 1L)).isEmpty()) {
                    this.giveupIncomplete(list);
                }
            }
            System.out.println(this.hash.map.size());
        }

        public void finish() {
            List<Template> list = this.hash.purgeUpto(this.hash.counter + 1L);
            if (!list.isEmpty()) {
                this.giveupIncomplete(list);
            }
        }
    }

    public static class TemplateHash {
        private HashMap<ByteArrayHashWrapper, Template> map = new HashMap();
        public long counter = 0L;
        public long min = 0L;
        private ByteArrayHashWrapper tmpRemoveWrapper = new ByteArrayHashWrapper(new byte[0]);

        public Template add(byte[] name, byte[] bases, byte[] scores) {
            ByteArrayHashWrapper w = new ByteArrayHashWrapper(name);
            Template t = this.map.get(w);
            if (t == null) {
                t = new Template(name);
                t.counter = ++this.counter;
                this.map.put(w, t);
            }
            t.append(bases, scores);
            return t;
        }

        public List<Template> purgeUpto(long max) {
            LinkedList<Template> list = new LinkedList<Template>();
            for (Template t : this.map.values()) {
                if (t.counter >= max) continue;
                list.add(t);
            }
            for (Template t : list) {
                this.remove(t.name);
            }
            return list;
        }

        public void remove(byte[] name) {
            this.tmpRemoveWrapper.setArray(name);
            this.map.remove(this.tmpRemoveWrapper);
        }

        public int size() {
            return this.map.size();
        }
    }

    public static class ByteArrayHashWrapper {
        private byte[] array;
        private int hashcode;

        public ByteArrayHashWrapper(byte[] array) {
            this.setArray(array);
        }

        public void setArray(byte[] array) {
            this.array = array;
            this.calculateHashCode();
        }

        protected int calculateHashCode() {
            for (int i = 0; i < 4 && i < this.array.length; ++i) {
                this.hashcode <<= 8;
                this.hashcode |= this.array[this.array.length - 1 - i];
            }
            return 0;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.array, ((ByteArrayHashWrapper)obj).array);
        }
    }

    public static class Segment {
        public byte[] bases;
        public byte[] scores;
        public Segment prev;
        public Segment next;

        public Segment(byte[] bases, byte[] scores) {
            this.bases = bases;
            this.scores = scores;
        }
    }
}

