/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import java.util.Arrays;

public class RefMaskUtils {
    public static final byte[] bases = new byte[]{65, 67, 71, 84};
    public static final byte[] base2index = new byte[256];
    public static int minHits;

    public static final int getBaseCount(byte mask, byte base) {
        return 3 & mask >>> 2 * base2index[base];
    }

    public static final byte addReadBase(byte mask, byte readBase, byte refBase) {
        int baseMask = 0;
        switch (readBase) {
            case 65: 
            case 97: {
                baseMask = 3;
                break;
            }
            case 67: 
            case 99: {
                baseMask = 12;
                break;
            }
            case 71: 
            case 103: {
                baseMask = 48;
                break;
            }
            case 84: 
            case 116: {
                baseMask = -64;
                break;
            }
            default: {
                return mask;
            }
        }
        int count = RefMaskUtils.getBaseCount(mask, readBase);
        if (count < 3) {
            mask = (byte)(mask & ~baseMask);
            mask = (byte)(mask | ++count << 2 * base2index[readBase]);
        }
        return mask;
    }

    public static final boolean shouldStore(byte mask, byte refBase) {
        for (byte base : bases) {
            if (base == refBase || RefMaskUtils.getBaseCount(mask, base) < minHits) continue;
            return true;
        }
        return false;
    }

    public static final int getBaseCount(short mask, byte base) {
        return 0xF & mask >>> 4 * base2index[base];
    }

    public static final short addReadBase(short mask, byte readBase, byte refBase) {
        int baseMask = 0;
        switch (readBase) {
            case 65: 
            case 97: {
                baseMask = 15;
                break;
            }
            case 67: 
            case 99: {
                baseMask = 240;
                break;
            }
            case 71: 
            case 103: {
                baseMask = 3840;
                break;
            }
            case 84: 
            case 116: {
                baseMask = -4096;
                break;
            }
            default: {
                return mask;
            }
        }
        int count = RefMaskUtils.getBaseCount(mask, readBase);
        if (count < 15) {
            mask = (short)(mask & ~baseMask);
            mask = (short)(mask | ++count << 4 * base2index[readBase]);
        }
        return mask;
    }

    private static final int minCoverageEstimate(short mask) {
        int coverage = 0xF & mask;
        coverage += 0xF & mask >>> 4;
        coverage += 0xF & mask >>> 8;
        return coverage += 0xF & mask >>> 12;
    }

    public static final boolean shouldStore(short mask, byte refBase) {
        if (RefMaskUtils.minCoverageEstimate(mask) > 10) {
            return false;
        }
        int[] counts = new int[3];
        int i = 0;
        for (byte base : bases) {
            if (base == refBase) continue;
            counts[i] = RefMaskUtils.getBaseCount(mask, base);
            if (counts[i] >= minHits) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        Arrays.fill(base2index, (byte)-1);
        RefMaskUtils.base2index[65] = 0;
        RefMaskUtils.base2index[97] = 0;
        RefMaskUtils.base2index[67] = 1;
        RefMaskUtils.base2index[99] = 1;
        RefMaskUtils.base2index[71] = 2;
        RefMaskUtils.base2index[103] = 2;
        RefMaskUtils.base2index[84] = 3;
        RefMaskUtils.base2index[116] = 3;
        minHits = 2;
    }

    public static class RefMask {
        private short[] mask;
        private int minHits;

        public RefMask(int len, int minHits) {
            this.mask = new short[len];
            Arrays.fill(this.mask, (short)0);
            this.minHits = minHits;
        }

        public void addReadBase(int pos, byte readBase, byte refBase) {
            this.mask[pos] = RefMaskUtils.addReadBase(this.mask[pos], readBase, refBase);
        }

        public boolean shouldStore(int pos, byte refBase) {
            short maskAtPos = this.mask[pos];
            if (maskAtPos == 0) {
                return false;
            }
            if (RefMaskUtils.minCoverageEstimate(maskAtPos) > 10) {
                return false;
            }
            int[] counts = new int[3];
            int i = 0;
            for (byte base : bases) {
                if (base == refBase) continue;
                counts[i] = RefMaskUtils.getBaseCount(maskAtPos, base);
                if (counts[i] >= this.minHits) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int getMinHits() {
            return this.minHits;
        }

        public void setMinHits(int minHits) {
            this.minHits = minHits;
        }
    }
}

