/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.haplotype;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.haplotype.HaplotypeLDCalculator;
import org.broadinstitute.gatk.utils.haplotype.MergeVariantsAcrossHaplotypes;

public class LDMerger
extends MergeVariantsAcrossHaplotypes {
    private static final Logger logger = Logger.getLogger(LDMerger.class);
    private final boolean DEBUG;
    private final int minSamplesToMergeSNPs;
    private final int minSamplesToMergeOtherEvents;
    protected static final int MAX_DISTANCE_BETWEEN_SNPS_TO_MERGE = 6;
    protected static final int MAX_DISTANCE_BETWEEN_OTHER_EVENTS_TO_MERGE = 25;
    protected static final double MERGE_EVENTS_PROB_PHASED_THRESHOLD = 0.99;

    public LDMerger(boolean DEBUG, int minSamplesToMergeSNPs, int minSamplesToMergeOtherEvents) {
        this.DEBUG = DEBUG;
        this.minSamplesToMergeSNPs = minSamplesToMergeSNPs;
        this.minSamplesToMergeOtherEvents = minSamplesToMergeOtherEvents;
    }

    protected LDMerger() {
        this(false, 1, 1);
    }

    @Override
    public boolean merge(List<Haplotype> haplotypes, Map<String, PerReadAlleleLikelihoodMap> haplotypeReadMap, TreeSet<Integer> startPosKeySet, byte[] ref, GenomeLoc refLoc) {
        if (haplotypes == null) {
            throw new IllegalArgumentException("haplotypes cannot be null");
        }
        if (haplotypeReadMap == null) {
            throw new IllegalArgumentException("haplotypeReadMap cannot be null");
        }
        if (startPosKeySet == null) {
            throw new IllegalArgumentException("startPosKeySet cannot be null");
        }
        if (ref == null) {
            throw new IllegalArgumentException("ref cannot be null");
        }
        if (refLoc == null) {
            throw new IllegalArgumentException("refLoc cannot be null");
        }
        if (refLoc.size() != ref.length) {
            throw new IllegalArgumentException("refLoc size " + refLoc.size() + " != ref.length " + ref.length + " at " + refLoc);
        }
        if (startPosKeySet.size() <= 1) {
            return false;
        }
        int nSamples = haplotypeReadMap.keySet().size();
        HaplotypeLDCalculator r2Calculator = new HaplotypeLDCalculator(haplotypes, haplotypeReadMap);
        boolean somethingWasMerged = false;
        boolean mapWasUpdated = true;
        while (mapWasUpdated) {
            mapWasUpdated = this.mergeConsecutiveEventsBasedOnLDOnce(haplotypes, r2Calculator, nSamples, startPosKeySet, ref, refLoc);
            somethingWasMerged |= mapWasUpdated;
        }
        return somethingWasMerged;
    }

    protected boolean mergeConsecutiveEventsBasedOnLDOnce(List<Haplotype> haplotypes, HaplotypeLDCalculator ldCalculator, int nSamples, TreeSet<Integer> startPosKeySet, byte[] ref, GenomeLoc refLoc) {
        Iterator<Integer> iter = startPosKeySet.iterator();
        int thisStart = iter.next();
        while (iter.hasNext()) {
            int nextStart = iter.next();
            LDMergeData toMerge = this.getPairOfEventsToMerge(haplotypes, thisStart, nextStart);
            if (toMerge.canBeMerged(nSamples)) {
                double pPhased = ldCalculator.computeProbOfBeingPhased(toMerge.firstVC, toMerge.secondVC);
                if (this.DEBUG) {
                    logger.info((Object)("Found consecutive biallelic events with R^2 = " + String.format("%.4f", pPhased)));
                    logger.info((Object)("-- " + toMerge.firstVC));
                    logger.info((Object)("-- " + toMerge.secondVC));
                }
                if (pPhased > 0.99) {
                    VariantContext mergedVC = this.createMergedVariantContext(toMerge.firstVC, toMerge.secondVC, ref, refLoc);
                    this.replaceVariantContextsInMap(haplotypes, startPosKeySet, mergedVC, toMerge.firstVC, toMerge.secondVC);
                    return true;
                }
            }
            thisStart = nextStart;
        }
        return false;
    }

    private LDMergeData getPairOfEventsToMerge(List<Haplotype> haplotypes, int thisStart, int nextStart) {
        LDMergeData mergeData = new LDMergeData();
        for (Haplotype h : haplotypes) {
            VariantContext nextHapVC;
            VariantContext thisHapVC = (VariantContext)h.getEventMap().get(thisStart);
            if (thisHapVC != null && !thisHapVC.isSymbolic()) {
                if (mergeData.firstVC == null) {
                    mergeData.firstVC = thisHapVC;
                } else if (!thisHapVC.hasSameAllelesAs(mergeData.firstVC)) {
                    return mergeData.cantBeMerged();
                }
            }
            if ((nextHapVC = (VariantContext)h.getEventMap().get(nextStart)) == null || nextHapVC.isSymbolic()) continue;
            if (mergeData.secondVC == null) {
                mergeData.secondVC = nextHapVC;
                continue;
            }
            if (nextHapVC.hasSameAllelesAs(mergeData.secondVC)) continue;
            return mergeData.cantBeMerged();
        }
        if (mergeData.firstVC != null && mergeData.secondVC != null && mergeData.firstVC.getEnd() >= mergeData.secondVC.getStart()) {
            return mergeData.cantBeMerged();
        }
        return mergeData;
    }

    protected VariantContext createMergedVariantContext(VariantContext thisVC, VariantContext nextVC, byte[] ref, GenomeLoc refLoc) {
        int iii;
        int locus;
        int thisStart = thisVC.getStart();
        int nextStart = nextVC.getStart();
        byte[] refBases = new byte[]{};
        byte[] altBases = new byte[]{};
        refBases = ArrayUtils.addAll((byte[])refBases, (byte[])thisVC.getReference().getBases());
        altBases = ArrayUtils.addAll((byte[])altBases, (byte[])thisVC.getAlternateAllele(0).getBases());
        for (locus = thisStart + refBases.length; locus < nextStart; ++locus) {
            byte refByte = ref[locus - refLoc.getStart()];
            refBases = ArrayUtils.add((byte[])refBases, (byte)refByte);
            altBases = ArrayUtils.add((byte[])altBases, (byte)refByte);
        }
        refBases = ArrayUtils.addAll((byte[])refBases, (byte[])ArrayUtils.subarray((byte[])nextVC.getReference().getBases(), (int)(locus > nextStart ? 1 : 0), (int)nextVC.getReference().getBases().length));
        altBases = ArrayUtils.addAll((byte[])altBases, (byte[])nextVC.getAlternateAllele(0).getBases());
        if (refBases.length == altBases.length) {
            for (iii = 0; iii < refBases.length && refBases[iii] == altBases[iii]; ++iii) {
            }
            if (iii == refBases.length) {
                return null;
            }
        }
        Allele refAllele = Allele.create((byte[])ArrayUtils.subarray((byte[])refBases, (int)iii, (int)refBases.length), (boolean)true);
        Allele altAllele = Allele.create((byte[])ArrayUtils.subarray((byte[])altBases, (int)iii, (int)altBases.length), (boolean)false);
        return new VariantContextBuilder("merged", thisVC.getChr(), (long)(thisVC.getStart() + iii), (long)nextVC.getEnd(), Arrays.asList(refAllele, altAllele)).make();
    }

    private void replaceVariantContextsInMap(List<Haplotype> haplotypes, TreeSet<Integer> startPosKeySet, VariantContext replacement, VariantContext update1, VariantContext update2) {
        for (Haplotype h : haplotypes) {
            boolean shouldAdd = h.getEventMap().containsKey(update1.getStart()) && h.getEventMap().containsKey(update2.getStart());
            h.getEventMap().remove(update1.getStart());
            h.getEventMap().remove(update2.getStart());
            if (!shouldAdd || replacement == null) continue;
            h.getEventMap().addVC(replacement, false);
        }
        startPosKeySet.remove(update1.getStart());
        startPosKeySet.remove(update2.getStart());
        if (replacement != null) {
            startPosKeySet.add(replacement.getStart());
        }
    }

    private class LDMergeData {
        VariantContext firstVC = null;
        VariantContext secondVC = null;
        boolean canBeMerged = true;

        private LDMergeData() {
        }

        public LDMergeData cantBeMerged() {
            this.canBeMerged = false;
            return this;
        }

        public boolean canBeMerged(int nSamples) {
            if (!this.canBeMerged || this.firstVC == null || this.secondVC == null) {
                return false;
            }
            int distance = this.secondVC.getStart() - this.firstVC.getEnd();
            if (this.firstVC.isSNP() && this.secondVC.isSNP()) {
                return nSamples >= LDMerger.this.minSamplesToMergeSNPs && distance <= 6;
            }
            return nSamples >= LDMerger.this.minSamplesToMergeOtherEvents && distance <= 25;
        }
    }
}

