/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import proguard.classfile.ClassPool;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;

public class ManifestRewriter
extends DataEntryRewriter {
    public ManifestRewriter(ClassPool classPool, Charset charset, DataEntryWriter dataEntryWriter) {
        super(classPool, charset, dataEntryWriter);
    }

    @Override
    protected void copyData(Reader reader, Writer writer) throws IOException {
        super.copyData(new SplitLineReader(reader), new SplitLineWriter(writer));
    }

    private static class SplitLineWriter
    extends FilterWriter {
        private int counter = 0;

        public SplitLineWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void write(int n) throws IOException {
            if (n == 10) {
                this.counter = 0;
            } else if (this.counter == 70) {
                super.write(10);
                super.write(32);
                this.counter = 2;
            } else {
                ++this.counter;
            }
            super.write(n);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.write(cArray[n + i]);
            }
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            this.write(string.toCharArray(), n, n2);
        }
    }

    private static class SplitLineReader
    extends FilterReader {
        private static final int NONE = -2;
        private int bufferedCharacter = -2;

        public SplitLineReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n;
            do {
                int n2 = this.bufferedCharacter != -2 ? this.bufferedCharacter : super.read();
                this.bufferedCharacter = -2;
                if (n2 != 10 && n2 != 13) {
                    return n2;
                }
                n = super.read();
                if (n != 10 && n != 13 || n2 == n) continue;
                n = super.read();
            } while (n == 32);
            this.bufferedCharacter = n;
            return 10;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            while (n4 < n2 && (n3 = this.read()) != -1) {
                cArray[n + n4++] = (char)n3;
            }
            return n4;
        }

        @Override
        public long skip(long l) throws IOException {
            int n;
            int n2 = 0;
            while ((long)n2 < l && (n = this.read()) != -1) {
                ++n2;
            }
            return n2;
        }
    }
}

