// the interface the engine uses to run the gameplay module
#ifndef STANDALONE
namespace entities
{
    extern int triggertime(extentity &e);
    extern void editent(int i);
    extern void readent(stream *g, int mtype, int mver, char *gid, int gver, int id);
    extern void writeent(stream *g, int id);
    extern void remapents(vector<int> &idxs);
    extern void initents(stream *g, int mtype, int mver, char *gid, int gver);
    extern float dropheight(extentity &e);
    extern void fixentity(int n, bool recurse = true, bool create = false);
    extern bool cansee(int n);
    extern const char *findname(int type);
    extern int findtype(char *type);
    extern bool maylink(int type, int ver = 0);
    extern bool canlink(int index, int node, bool msg = false);
    extern bool linkents(int index, int node, bool add = true, bool local = true, bool toggle = true);
    extern extentity *newent();
    extern void deleteent(extentity *e);
    extern void clearents();
    extern vector<extentity *> &getents();
    extern int lastent(int type);
    extern void drawparticles();
}

namespace client
{
    extern void gamedisconnect(int clean);
    extern void parsepacketclient(int chan, packetbuf &p);
    extern void gameconnect(bool _remote);
    extern bool allowedittoggle(bool edit);
    extern void edittoggled(bool edit);
    extern void writeclientinfo(stream *f);
    extern void toserver(int flags, char *text);
    extern void editvar(ident *id, bool local);
    extern void edittrigger(const selinfo &sel, int op, int arg1 = 0, int arg2 = 0, int arg3 = 0);
    extern void changemap(const char *name);
    extern int waiting(bool state = true);
    extern void connectattempt(const char *name, int port, const char *password, const ENetAddress &address);
    extern void connectfail();
    extern int state();
    extern int otherclients();
    extern int servercompare(serverinfo *a, serverinfo *b);
}

namespace hud
{
    extern char *progresstex;
    extern bool hasinput(bool pass = false, bool focus = true);
    extern bool keypress(int code, bool isdown, int cooked);
    extern void drawhud(bool noview = false);
    extern void drawlast();
    extern float motionblur(float scale);
    extern bool getcolour(vec &colour);
    extern void gamemenus();
    extern void update(int w, int h);
    extern bool needminimap();
}

namespace physics
{
    extern int physsteps, physframetime, physinterp;
    extern float gravity, floatspeed, stairheight, floorz, slopez, wallz, stepspeed, liquidfric, liquidscale, sinkfric, floorfric, airfric;
    extern float liquidmerge(physent *d, float from, float to);
    extern bool liquidcheck(physent *d);
    extern float gravityvel(physent *d);
    extern bool isfloating(physent *d);
    extern float movevelocity(physent *d, bool floating = false);
    extern bool issolid(physent *d, physent *e = NULL, bool esc = true, bool impact = true);
    extern bool move(physent *d, vec &dir);
    extern void move(physent *d, int moveres = 10, bool local = true);
    extern bool entinmap(physent *d, bool avoidplayers);
    extern void updatephysstate(physent *d);
    extern bool droptofloor(vec &o, float radius = 1, float height = 1);
    extern bool iscrouching(physent *d);
    extern bool moveplayer(physent *pl, int moveres, bool local, int millis);
    extern void interppos(physent *d);
    extern void updateragdoll(dynent *d, const vec &center, float radius);
    extern bool xcollide(physent *d, const vec &dir, physent *o);
    extern bool xtracecollide(physent *d, const vec &from, const vec &to, float x1, float x2, float y1, float y2, float maxdist, float &dist, physent *o);
    extern void complexboundbox(physent *d);
}

namespace game
{
    extern bool clientoption(char *arg);
    extern void preload();
    extern void updateworld();
    extern void newmap(int size);
    extern void resetmap(bool empty);
    extern void startmap(const char *name, const char *reqname, bool empty = false);
    extern bool allowmove(physent *d);
    extern dynent *iterdynents(int i, bool all = false);
    extern dynent *focusedent(bool force = false);
    extern int numdynents(bool all = false);
    extern vec getpalette(int palette, int index);
    extern void adddynlights();
    extern void particletrack(particle *p, uint type, int &ts, bool lastpass);
    extern void dynlighttrack(physent *owner, vec &o);
    extern bool mousemove(int dx, int dy, int x, int y, int w, int h);
    extern void project(int w, int h);
    extern void recomputecamera(int w, int h);
    extern void loadworld(stream *f, int maptype);
    extern void saveworld(stream *f);
    extern int localplayers();
    extern const char *gametitle();
    extern const char *gametext();
    extern int numanims();
    extern void findanims(const char *pattern, vector<int> &anims);
    extern void render();
    extern void renderavatar(bool early);
    extern void renderplayerpreview(int model, int color, int team, int weap);
    extern bool thirdpersonview(bool viewonly = false);
    extern vec camerapos(physent *d);
    extern void start();
}
#endif
namespace server
{
    extern bool updatecontrols;
    extern void start();
    extern void shutdown();
    extern void ancmsgft(int cn, int snd, int conlevel, const char *s, ...);
    extern void srvmsgft(int cn, int conlevel, const char *s, ...);
    extern void srvmsgf(int cn, const char *s, ...);
    extern void srvoutf(const char *s, ...);
    extern bool serveroption(char *arg);
    extern void *newinfo();
    extern void deleteinfo(void *ci);
    extern int numclients(int exclude = -1, bool nospec = false, int aitype = -1);
    extern int reserveclients();
    extern int numchannels();
    extern void clientdisconnect(int n, bool local = false, int reason = DISC_NONE);
    extern int clientconnect(int n, uint ip, bool local = false);
    extern bool allowbroadcast(int n);
    extern int peerowner(int n);
    extern void recordpacket(int chan, void *data, int len);
    extern void parsepacket(int sender, int chan, packetbuf &p);
    extern bool sendpackets(bool force = false);
    extern void queryreply(ucharbuf &req, ucharbuf &p);
    extern void serverupdate();
    extern const char *gameid();
    extern int getver(int n = 0);
    extern const char *pickmap(const char *suggest = NULL);
    extern const char *choosemap(const char *suggest = NULL, int mode = -1, int muts = -1, int force = 0);
    extern void changemap(const char *name = NULL, int mode = -1, int muts = -1);
    extern bool canload(const char *type);
    extern bool rewritecommand(ident *id, tagval *args, int numargs);
    extern void disconnectedmaster();
    extern void processmasterinput(const char *cmd, int cmdlen, const char *args);
}
