/* Copyright (C) 2012 Wildfire Games.
 * This file is part of 0 A.D.
 *
 * 0 A.D. is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * 0 A.D. is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 0 A.D.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "precompiled.h"

#include "ICmpTechnologyManager.h"

#include "simulation2/system/InterfaceScripted.h"
#include "simulation2/scripting/ScriptComponent.h"

BEGIN_INTERFACE_WRAPPER(TechnologyManager)
END_INTERFACE_WRAPPER(TechnologyManager)

class CCmpTechnologyManagerScripted : public ICmpTechnologyManager
{
public:
	DEFAULT_SCRIPT_WRAPPER(TechnologyManagerScripted)

	virtual fixed ApplyModifications(std::wstring valueName, fixed currentValue, entity_id_t entity)
	{
		return m_Script.Call<fixed>("ApplyModifications", valueName, currentValue, entity);
	}

	virtual u32 ApplyModifications(std::wstring valueName, u32 currentValue, entity_id_t entity)
	{
		return m_Script.Call<u32>("ApplyModifications", valueName, currentValue, entity);
	}
};

REGISTER_COMPONENT_SCRIPT_WRAPPER(TechnologyManagerScripted)
