/* AbiSource
 * 
 * Copyright (C) 2011 Volodymyr Rudyj <vladimir.rudoy@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef IE_IMP_EPUB_SNIFFER_H_
#define IE_IMP_EPUB_SNIFFER_H_

#include <gsf/gsf-infile-zip.h>
#include <gsf/gsf-infile.h>
#include <gsf/gsf-libxml.h>

#include "ie_imp.h"
#include "ie_imp_EPUB.h"

class IE_Imp_EPUB_Sniffer: public IE_ImpSniffer
{
public:
    IE_Imp_EPUB_Sniffer();

    virtual ~IE_Imp_EPUB_Sniffer();

    virtual const IE_SuffixConfidence * getSuffixConfidence();

    virtual const IE_MimeConfidence * getMimeConfidence();

    virtual UT_Confidence_t recognizeContents(GsfInput * input);

    virtual UT_Error constructImporter(PD_Document * pDocument, IE_Imp ** ppie);

    virtual bool getDlgLabels(const char ** szDesc, const char ** szSuffixList,
            IEFileType * ft);
};

#endif /* IE_IMP_EPUB_SNIFFER_H_ */
