package main

import (
	"sort"
	"testing"
)

func TestDropAmbiguousPkgs(t *testing.T) {
	pkgs := []string{
		"bar",
		"baz:arm64",
		"foo",
		"foo:amd64",
		"foo:i386",
	}
	want := []string{
		"bar",
		"baz:arm64",
		"foo:amd64",
		"foo:i386",
	}
	got := dropAmbiguousPkgs(pkgs)
	sort.StringSlice(got).Sort()

	// TODO: use cmp.Diff instead.
	equal := len(got) == len(want)
	if equal {
		for i := range len(got) {
			if got[i] != want[i] {
				equal = false
				break
			}
		}
	}

	if !equal {
		t.Errorf("dropAmbiguousPkgs(%#v) =\n     %#v\nwant %#v", pkgs, got, want)
	}
}
